% h1 example: the BAN modified version of CCITT X.509 (3) [after Spore]
%   Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
%   This file is part of h1.
%
%   h1 is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2, or (at your option)
%   any later version.
%
%   h1 is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with h1; see the file COPYING.  If not, write to
%   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% run 'cpp -P x509.timed.p >x509.p'

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).

#define PHASE(s) s##_old
#include "x509.phase.p"
#undef PHASE

cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).

cnf(intruder_knows_all_previous_session_keys,axiom,
  (knows_current(key(sym,session_old(A,B,Na))))).
cnf(intruder_knows_all_previous_noncea,axiom,
    (knows_current(noncea_old(A,B)))).
cnf(intruder_knows_all_previous_nonceb,axiom,
    (knows_current(nonceb_old(A,B,Na,Xa,Ya)))).

cnf(intruder_knows_all_previous_xa,axiom,
  (knows_current(xa_old(A,B)))).
cnf(intruder_knows_all_previous_ya,axiom,
  (knows_current(ya_old(A,B)))).
cnf(intruder_knows_all_previous_xb,axiom,
  (knows_current(xb_old(A,B,Na,Xa,Ya)))).
cnf(intruder_knows_all_previous_yb,axiom,
  (knows_current(yb_old(A,B,Na,Xa,Ya)))).

#define PHASE(s) s##_current
#include "x509.phase.p"
#undef PHASE

cnf(intruder_knows_ya_as_seen_by_alice,axiom,
  (~alice_data_current(alice,Xa,Ya,Xb,Yb)
  | ~knows_current(Ya))).
cnf(intruder_knows_yb_as_seen_by_alice,axiom,
  (~alice_data_current(alice,Xa,Ya,Xb,Yb)
  | ~knows_current(Yb))).
cnf(intruder_knows_ya_as_seen_by_bob,axiom,
  (~bob_data_current(bob,Xb,Yb,Xa,Ya)
  | ~knows_current(Ya))).
cnf(intruder_knows_yb_as_seen_by_bob,axiom,
  (~bob_data_current(bob,Xb,Yb,Xa,Ya)
  | ~knows_current(Yb))).
