(* [sigd] Signature definition. *)

Inductive term : Set :=
    alice : term
  | bob : term
  | cons : term -> term -> term
  | crypt : term -> term -> term
  | i : term
  | key : term -> term -> term
  | nil : term
  | noncea_current : term -> term -> term
  | noncea_old : term -> term -> term
  | nonceb_current : term -> term -> term -> term -> term -> term
  | nonceb_old : term -> term -> term -> term -> term -> term
  | prv : term
  | pub : term
  | s : term -> term
  | server : term
  | session_old : term -> term -> term -> term
  | sym : term
  | xa_current : term -> term -> term
  | xa_old : term -> term -> term
  | xb_current : term -> term -> term -> term -> term -> term
  | xb_old : term -> term -> term -> term -> term -> term
  | ya_current : term -> term -> term
  | ya_old : term -> term -> term
  | yb_current : term -> term -> term -> term -> term -> term
  | yb_old : term -> term -> term -> term -> term -> term
.

(* [modd] Model definition. *)

Inductive auto___type_10 : term -> Prop :=
    trans___type_10_1 : forall X:term, auto___type_10 X
with auto___type_11 : term -> Prop :=
    trans___type_11_1 : forall X:term, auto___type_11 X
with auto___type_9 : term -> Prop :=
    trans___type_9_1 : forall X:term, auto___type_9 X
with auto___type_7 : term -> Prop :=
    trans___type_7_1 : forall X:term, auto___type_7 X
with auto___type_8 : term -> Prop :=
    trans___type_8_1 : forall X:term, auto___type_8 X
with auto___def_60 : term -> Prop :=
    trans___def_60_crypt_1 : forall X1 X2:term, auto___def_61 X1 -> auto___def_11 X2 -> auto___def_60 (crypt X1 X2)
with auto___def_33 : term -> Prop :=
    trans___def_33_cons_1 : forall X1 X2:term, auto___def_34 X1 -> auto___def_25 X2 -> auto___def_33 (cons X1 X2)
with auto___def_59 : term -> Prop :=
    trans___def_59_cons_1 : forall X1 X2:term, auto___def_60 X1 -> auto___def_9 X2 -> auto___def_59 (cons X1 X2)
with auto_alice_data_old : term -> term -> term -> term -> term -> Prop :=
    trans_alice_data_old_1 : forall X1 X2 X3 X4 X5:term, auto_alice_data_old X1 X2 X3 X4 X5
with auto___type_4 : term -> Prop :=
    trans___type_4_i_1 : auto___type_4 i
  | trans___type_4_server_1 : auto___type_4 server
  | trans___type_4_bob_1 : auto___type_4 bob
  | trans___type_4_alice_1 : auto___type_4 alice
with auto___def_94 : term -> Prop :=
    trans___def_94_ya_current_1 : forall X1 X2:term, auto_agent X1 -> auto___type_13 X1 -> auto_agent X2 -> auto___type_12 X2 -> auto___def_94 (ya_current X1 X2)
with auto___def_19 : term -> Prop :=
    trans___def_19_key_1 : forall X1 X2:term, auto___def_20 X1 -> auto_agent X2 -> auto___def_19 (key X1 X2)
with auto___def_77 : term -> Prop :=
    trans___def_77_cons_1 : forall X1 X2:term, auto___type_14 X1 -> auto___def_78 X2 -> auto___def_77 (cons X1 X2)
with auto___def_43 : term -> Prop :=
    trans___def_43_cons_1 : forall X1 X2:term, auto_agent X1 -> auto___type_3 X1 -> auto___def_28 X2 -> auto___def_43 (cons X1 X2)
with auto___def_39 : term -> term -> term -> term -> term -> Prop :=
    trans___def_39_1 : forall X1 X2 X3 X4 X5:term, auto___type_4 X1 -> auto_agent X1 -> auto_agent X2 -> auto___type_3 X2 -> auto___def_28 X3 -> auto___def_35 X4 -> auto___def_32 X5 -> auto___def_39 X1 X2 X3 X4 X5
with auto___def_16 : term -> Prop :=
    trans___def_16_cons_1 : forall X1 X2:term, auto___def_17 X1 -> auto___def_9 X2 -> auto___def_16 (cons X1 X2)
with auto___def_12 : term -> Prop :=
    trans___def_12_noncea_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_12 (noncea_old X1 X2)
with auto_agent : term -> Prop :=
    trans_agent_i_1 : auto_agent i
  | trans_agent_server_1 : auto_agent server
  | trans_agent_bob_1 : auto_agent bob
  | trans_agent_alice_1 : auto_agent alice
with auto___def_92 : term -> Prop :=
    trans___def_92_prv_1 : auto___def_92 prv
with auto___def_20 : term -> Prop :=
    trans___def_20_pub_1 : auto___def_20 pub
with auto___def_26 : term -> Prop :=
    trans___def_26_cons_1 : forall X1 X2:term, auto___def_28 X1 -> auto___def_29 X2 -> auto___def_26 (cons X1 X2)
with auto___def_7 : term -> Prop :=
    trans___def_7_cons_1 : forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> auto___def_7 (cons X1 X2)
with auto___def_67 : term -> Prop :=
    trans___def_67_crypt_1 : forall X1 X2:term, auto___def_68 X1 -> auto___def_19 X2 -> auto___def_67 (crypt X1 X2)
with auto___def_81 : term -> Prop :=
    trans___def_81_crypt_1 : forall X1 X2:term, auto___def_82 X1 -> auto___def_83 X2 -> auto___def_81 (crypt X1 X2)
with auto___def_76 : term -> Prop :=
    trans___def_76_cons_1 : forall X1 X2:term, auto___type_13 X1 -> auto___def_77 X2 -> auto___def_76 (cons X1 X2)
with auto___def_14 : term -> Prop :=
    trans___def_14_cons_1 : forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_14 (cons X1 X2)
with auto___def_70 : term -> Prop :=
    trans___def_70_cons_1 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_70 (cons X1 X2)
with auto___def_82 : term -> Prop :=
    trans___def_82_yb_current_1 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_82 (yb_current X1 X2 X3 X4 X5)
  | trans___def_82_yb_current_2 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_82 (yb_current X1 X2 X3 X4 X5)
with auto___def_29 : term -> Prop :=
    trans___def_29_cons_1 : forall X1 X2:term, auto___type_4 X1 -> auto___def_30 X2 -> auto___def_29 (cons X1 X2)
with auto___def_88 : term -> Prop :=
    trans___def_88_crypt_1 : forall X1 X2:term, auto___def_90 X1 -> auto___def_91 X2 -> auto___def_88 (crypt X1 X2)
with auto___def_80 : term -> Prop :=
    trans___def_80_cons_1 : forall X1 X2:term, auto___def_81 X1 -> auto___def_72 X2 -> auto___def_80 (cons X1 X2)
with auto___def_84 : term -> Prop :=
    trans___def_84_pub_1 : auto___def_84 pub
with auto___def_58 : term -> Prop :=
    trans___def_58_session_old_1 : forall X1 X2 X3:term, auto___def_58 (session_old X1 X2 X3)
with auto___def_93 : term -> Prop :=
    trans___def_93_xa_current_1 : forall X1 X2:term, auto_agent X1 -> auto___type_13 X1 -> auto_agent X2 -> auto___type_12 X2 -> auto___def_93 (xa_current X1 X2)
with auto___def_27 : term -> Prop :=
    trans___def_27_key_1 : forall X1 X2:term, auto___def_38 X1 -> auto___type_3 X2 -> auto___def_27 (key X1 X2)
with auto___def_15 : term -> Prop :=
    trans___def_15_xa_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_15 (xa_old X1 X2)
with auto___def_79 : term -> Prop :=
    trans___def_79_xb_current_1 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_79 (xb_current X1 X2 X3 X4 X5)
  | trans___def_79_xb_current_2 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_79 (xb_current X1 X2 X3 X4 X5)
with auto___def_61 : term -> Prop :=
    trans___def_61_cons_1 : forall X1 X2:term, auto___def_62 X1 -> auto___def_63 X2 -> auto___def_61 (cons X1 X2)
with auto___def_78 : term -> Prop :=
    trans___def_78_cons_1 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___def_78 (cons X1 X2)
with auto___def_18 : term -> Prop :=
    trans___def_18_ya_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_18 (ya_old X1 X2)
with auto___def_31 : term -> Prop :=
    trans___def_31_cons_1 : forall X1 X2:term, auto___def_32 X1 -> auto___def_33 X2 -> auto___def_31 (cons X1 X2)
with auto___def_46 : term -> Prop :=
    trans___def_46_xa_old_1 : forall X1 X2:term, auto___def_46 (xa_old X1 X2)
with auto_knows_old : term -> Prop :=
    trans_knows_old_s_1 : forall X1:term, auto_knows_old X1 -> auto_knows_old (s X1)
  | trans_knows_old_nil_1 : auto_knows_old nil
  | trans_knows_old_i_1 : auto_knows_old i
  | trans_knows_old_cons_1 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (cons X1 X2)
  | trans_knows_old_server_1 : auto_knows_old server
  | trans_knows_old_bob_1 : auto_knows_old bob
  | trans_knows_old_alice_1 : auto_knows_old alice
  | trans_knows_old_crypt_1 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_2 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_3 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_knows_old (crypt X1 X2)
  | trans_knows_old_crypt_4 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old (crypt X1 X2)
with auto___type_1 : term -> Prop :=
    trans___type_1_i_1 : auto___type_1 i
  | trans___type_1_server_1 : auto___type_1 server
  | trans___type_1_bob_1 : auto___type_1 bob
  | trans___type_1_alice_1 : auto___type_1 alice
with auto___def_13 : term -> Prop :=
    trans___def_13_cons_1 : forall X1 X2:term, auto___type_2 X1 -> auto___def_14 X2 -> auto___def_13 (cons X1 X2)
with auto___def_44 : term -> Prop :=
    trans___def_44_key_1 : forall X1 X2:term, auto___def_45 X1 -> auto___type_6 X2 -> auto___def_44 (key X1 X2)
with auto___def_48 : term -> term -> term -> term -> term -> Prop :=
    trans___def_48_1 : forall X1 X2 X3 X4 X5:term, auto___def_48 X1 X2 X3 X4 X5
with auto___type_13 : term -> Prop :=
    trans___type_13_i_1 : auto___type_13 i
  | trans___type_13_server_1 : auto___type_13 server
  | trans___type_13_bob_1 : auto___type_13 bob
  | trans___type_13_alice_1 : auto___type_13 alice
with auto___type_16 : term -> Prop :=
    trans___type_16_xb_current_1 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_16 (xb_current X1 X2 X3 X4 X5)
  | trans___type_16_xb_current_2 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_16 (xb_current X1 X2 X3 X4 X5)
with auto___def_52 : term -> Prop :=
    trans___def_52_session_old_1 : forall X1 X2 X3:term, auto___def_52 (session_old X1 X2 X3)
with auto___def_55 : term -> term -> Prop :=
    trans___def_55_1 : forall X1 X2:term, auto_agent X1 -> auto___def_61 X2 -> auto___def_55 X1 X2
  | trans___def_55_2 : forall X1 X2:term, auto___type_15 X1 -> auto___def_90 X2 -> auto___def_55 X1 X2
  | trans___def_55_3 : forall X1 X2:term, auto___type_12 X1 -> auto___def_73 X2 -> auto___def_55 X1 X2
  | trans___def_55_4 : forall X1 X2:term, auto___type_6 X1 -> auto___def_43 X2 -> auto___def_55 X1 X2
  | trans___def_55_5 : forall X1 X2:term, auto_agent X1 -> auto___def_10 X2 -> auto___def_55 X1 X2
  | trans___def_55_6 : forall X1 X2:term, auto___type_3 X1 -> auto___def_26 X2 -> auto___def_55 X1 X2
with auto___def_24 : term -> Prop :=
    trans___def_24_crypt_1 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_24 (crypt X1 X2)
with auto___type_15 : term -> Prop :=
    trans___type_15_i_1 : auto___type_15 i
  | trans___type_15_server_1 : auto___type_15 server
  | trans___type_15_bob_1 : auto___type_15 bob
  | trans___type_15_alice_1 : auto___type_15 alice
with auto_knows_current : term -> Prop :=
    trans_knows_current_s_1 : forall X1:term, auto_knows_current X1 -> auto_knows_current (s X1)
  | trans_knows_current_ya_old_1 : forall X1 X2:term, auto_knows_current (ya_old X1 X2)
  | trans_knows_current_nil_1 : auto_knows_current nil
  | trans_knows_current_i_1 : auto_knows_current i
  | trans_knows_current_xa_old_1 : forall X1 X2:term, auto_knows_current (xa_old X1 X2)
  | trans_knows_current_cons_1 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (cons X1 X2)
  | trans_knows_current_server_1 : auto_knows_current server
  | trans_knows_current_noncea_old_1 : forall X1 X2:term, auto_knows_current (noncea_old X1 X2)
  | trans_knows_current_bob_1 : auto_knows_current bob
  | trans_knows_current_alice_1 : auto_knows_current alice
  | trans_knows_current_nonceb_old_1 : forall X1 X2 X3 X4 X5:term, auto_knows_current (nonceb_old X1 X2 X3 X4 X5)
  | trans_knows_current_xb_old_1 : forall X1 X2 X3 X4 X5:term, auto_knows_current (xb_old X1 X2 X3 X4 X5)
  | trans_knows_current_yb_old_1 : forall X1 X2 X3 X4 X5:term, auto_knows_current (yb_old X1 X2 X3 X4 X5)
  | trans_knows_current_crypt_1 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_2 : forall X1 X2:term, auto___def_90 X1 -> auto___def_91 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_3 : forall X1 X2:term, auto___def_73 X1 -> auto___def_74 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_4 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_5 : forall X1 X2:term, auto___def_61 X1 -> auto___def_11 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_6 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_crypt_7 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current (crypt X1 X2)
  | trans_knows_current_key_1 : forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto_knows_current (key X1 X2)
with auto___def_23 : term -> Prop :=
    trans___def_23_cons_1 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_23 (cons X1 X2)
with auto___def_50 : term -> Prop :=
    trans___def_50_yb_old_1 : forall X1 X2 X3 X4 X5:term, auto___def_50 (yb_old X1 X2 X3 X4 X5)
with auto___type_2 : term -> Prop :=
    trans___type_2_i_1 : auto___type_2 i
  | trans___type_2_server_1 : auto___type_2 server
  | trans___type_2_bob_1 : auto___type_2 bob
  | trans___type_2_alice_1 : auto___type_2 alice
with auto___def_25 : term -> Prop :=
    trans___def_25_nil_1 : auto___def_25 nil
with auto___type_3 : term -> Prop :=
    trans___type_3_i_1 : auto___type_3 i
  | trans___type_3_server_1 : auto___type_3 server
  | trans___type_3_bob_1 : auto___type_3 bob
  | trans___type_3_alice_1 : auto___type_3 alice
with auto___def_83 : term -> Prop :=
    trans___def_83_key_1 : forall X1 X2:term, auto___def_84 X1 -> auto___type_13 X2 -> auto___def_83 (key X1 X2)
with auto___def_89 : term -> Prop :=
    trans___def_89_nil_1 : auto___def_89 nil
with auto___def_91 : term -> Prop :=
    trans___def_91_key_1 : forall X1 X2:term, auto___def_92 X1 -> auto___type_15 X2 -> auto___def_91 (key X1 X2)
with auto___def_47 : term -> Prop :=
    trans___def_47_ya_old_1 : forall X1 X2:term, auto___def_47 (ya_old X1 X2)
with auto___def_3 : term -> term -> Prop :=
    trans___def_3_1 : forall X1 X2:term, auto___type_6 X1 -> auto___def_43 X2 -> auto___def_3 X1 X2
  | trans___def_3_2 : forall X1 X2:term, auto_agent X1 -> auto___def_10 X2 -> auto___def_3 X1 X2
  | trans___def_3_3 : forall X1 X2:term, auto___type_3 X1 -> auto___def_26 X2 -> auto___def_3 X1 X2
with auto___def_86 : term -> term -> term -> term -> term -> Prop :=
    trans___def_86_1 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_13 X1 -> auto_agent X2 -> auto___type_12 X2 -> auto___def_75 X3 -> auto___def_82 X4 -> auto___def_79 X5 -> auto___def_86 X1 X2 X3 X4 X5
with auto___def_90 : term -> Prop :=
    trans___def_90_cons_1 : forall X1 X2:term, auto_agent X1 -> auto___type_12 X1 -> auto___def_75 X2 -> auto___def_90 (cons X1 X2)
with auto___type_17 : term -> Prop :=
    trans___type_17_yb_current_1 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_17 (yb_current X1 X2 X3 X4 X5)
  | trans___type_17_yb_current_2 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_17 (yb_current X1 X2 X3 X4 X5)
with auto___def_22 : term -> term -> term -> term -> term -> Prop :=
    trans___def_22_1 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_12 X5 -> auto___def_22 X1 X2 X3 X4 X5
with auto___def_8 : term -> Prop :=
    trans___def_8_crypt_1 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_8 (crypt X1 X2)
with auto___def_21 : term -> Prop :=
    trans___def_21_prv_1 : auto___def_21 prv
with auto___def_51 : term -> Prop :=
    trans___def_51_sym_1 : auto___def_51 sym
with auto___def_49 : term -> Prop :=
    trans___def_49_xb_old_1 : forall X1 X2 X3 X4 X5:term, auto___def_49 (xb_old X1 X2 X3 X4 X5)
with auto___def_87 : term -> Prop :=
    trans___def_87_cons_1 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___def_87 (cons X1 X2)
with auto___def_17 : term -> Prop :=
    trans___def_17_crypt_1 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_17 (crypt X1 X2)
with auto___def_57 : term -> term -> Prop :=
    trans___def_57_1 : forall X1 X2:term, auto_knows_current X1 -> auto___def_52 X2 -> auto___def_57 X1 X2
with auto___def_45 : term -> Prop :=
    trans___def_45_prv_1 : auto___def_45 prv
with auto___def_85 : term -> Prop :=
    trans___def_85_prv_1 : auto___def_85 prv
with auto___type_6 : term -> Prop :=
    trans___type_6_i_1 : auto___type_6 i
  | trans___type_6_server_1 : auto___type_6 server
  | trans___type_6_bob_1 : auto___type_6 bob
  | trans___type_6_alice_1 : auto___type_6 alice
with auto___def_38 : term -> Prop :=
    trans___def_38_prv_1 : auto___def_38 prv
with auto___def_9 : term -> Prop :=
    trans___def_9_nil_1 : auto___def_9 nil
with auto___type_12 : term -> Prop :=
    trans___type_12_i_1 : auto___type_12 i
  | trans___type_12_server_1 : auto___type_12 server
  | trans___type_12_bob_1 : auto___type_12 bob
  | trans___type_12_alice_1 : auto___type_12 alice
with auto___def_36 : term -> Prop :=
    trans___def_36_key_1 : forall X1 X2:term, auto___def_37 X1 -> auto___type_4 X2 -> auto___def_36 (key X1 X2)
with auto___def_40 : term -> Prop :=
    trans___def_40_cons_1 : forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> auto___def_40 (cons X1 X2)
with auto___def_11 : term -> Prop :=
    trans___def_11_key_1 : forall X1 X2:term, auto___def_21 X1 -> auto_agent X2 -> auto___def_11 (key X1 X2)
with auto___def_75 : term -> Prop :=
    trans___def_75_nonceb_current_1 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_75 (nonceb_current X1 X2 X3 X4 X5)
  | trans___def_75_nonceb_current_2 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_75 (nonceb_current X1 X2 X3 X4 X5)
with auto___def_69 : term -> term -> term -> term -> term -> Prop :=
    trans___def_69_1 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___def_62 X5 -> auto___def_69 X1 X2 X3 X4 X5
  | trans___def_69_2 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_12 X5 -> auto___def_69 X1 X2 X3 X4 X5
with auto___type_5 : term -> Prop :=
    trans___type_5_noncea_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_5 (noncea_old X1 X2)
with auto_bob_data_old : term -> term -> term -> term -> term -> Prop :=
    trans_bob_data_old_1 : forall X1 X2 X3 X4 X5:term, auto_bob_data_old X1 X2 X3 X4 X5
with auto___def_64 : term -> Prop :=
    trans___def_64_cons_1 : forall X1 X2:term, auto___def_65 X1 -> auto___def_66 X2 -> auto___def_64 (cons X1 X2)
with auto___def_30 : term -> Prop :=
    trans___def_30_cons_1 : forall X1 X2:term, auto___type_5 X1 -> auto___def_31 X2 -> auto___def_30 (cons X1 X2)
with auto_alice_data_current : term -> term -> term -> term -> term -> Prop :=
    trans_alice_data_current_1 : forall X1 X2 X3 X4 X5:term, auto___type_15 X1 -> auto___def_93 X2 -> auto___def_94 X3 -> auto___type_16 X4 -> auto___type_17 X5 -> auto_alice_data_current X1 X2 X3 X4 X5
with auto___def_72 : term -> Prop :=
    trans___def_72_nil_1 : auto___def_72 nil
with auto___def_42 : term -> Prop :=
    trans___def_42_nil_1 : auto___def_42 nil
with auto___def_32 : term -> Prop :=
    trans___def_32_xb_old_1 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_32 (xb_old X1 X2 X3 X4 X5)
with auto___def_37 : term -> Prop :=
    trans___def_37_pub_1 : auto___def_37 pub
with auto___def_62 : term -> Prop :=
    trans___def_62_noncea_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_62 (noncea_current X1 X2)
with auto___def_66 : term -> Prop :=
    trans___def_66_cons_1 : forall X1 X2:term, auto___def_67 X1 -> auto___def_9 X2 -> auto___def_66 (cons X1 X2)
with auto___def_34 : term -> Prop :=
    trans___def_34_crypt_1 : forall X1 X2:term, auto___def_35 X1 -> auto___def_36 X2 -> auto___def_34 (crypt X1 X2)
with auto___def_68 : term -> Prop :=
    trans___def_68_ya_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_68 (ya_current X1 X2)
with auto___def_65 : term -> Prop :=
    trans___def_65_xa_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___def_65 (xa_current X1 X2)
with auto___def_74 : term -> Prop :=
    trans___def_74_key_1 : forall X1 X2:term, auto___def_85 X1 -> auto___type_12 X2 -> auto___def_74 (key X1 X2)
with auto___def_28 : term -> Prop :=
    trans___def_28_nonceb_old_1 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_28 (nonceb_old X1 X2 X3 X4 X5)
with auto___def_41 : term -> Prop :=
    trans___def_41_crypt_1 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_41 (crypt X1 X2)
with auto___def_10 : term -> Prop :=
    trans___def_10_cons_1 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_10 (cons X1 X2)
with auto___def_71 : term -> Prop :=
    trans___def_71_crypt_1 : forall X1 X2:term, auto___def_73 X1 -> auto___def_74 X2 -> auto___def_71 (crypt X1 X2)
with auto___def_35 : term -> Prop :=
    trans___def_35_yb_old_1 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_35 (yb_old X1 X2 X3 X4 X5)
with auto___def_63 : term -> Prop :=
    trans___def_63_cons_1 : forall X1 X2:term, auto___type_2 X1 -> auto___def_64 X2 -> auto___def_63 (cons X1 X2)
with auto___type_14 : term -> Prop :=
    trans___type_14_noncea_old_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_14 (noncea_old X1 X2)
  | trans___type_14_noncea_current_1 : forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_14 (noncea_current X1 X2)
with auto___def_73 : term -> Prop :=
    trans___def_73_cons_1 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___def_73 (cons X1 X2)
with auto___def_56 : term -> Prop :=
with auto___def_96 : term -> Prop :=
with auto___def_54 : term -> Prop :=
with auto___def_97 : term -> Prop :=
with auto___type_19 : term -> Prop :=
with auto___type_20 : term -> Prop :=
with auto___def_53 : term -> term -> Prop :=
with auto___type_18 : term -> Prop :=
with auto___def_95 : term -> term -> term -> term -> term -> Prop :=
with auto___def_4 : term -> Prop :=
with auto___def_6 : term -> Prop :=
with auto___def_2 : term -> Prop :=
with auto___def_1 : term -> term -> Prop :=
with auto___query__intruder_knows_yb_as_seen_by_alice : Prop :=
with auto_bob_data_current : term -> term -> term -> term -> term -> Prop :=
with auto___query__intruder_knows_yb_as_seen_by_bob : Prop :=
with auto___query__intruder_knows_ya_as_seen_by_bob : Prop :=
with auto___def_5 : term -> term -> Prop :=
with auto___query__intruder_knows_ya_as_seen_by_alice : Prop :=
.

(* [defp] Proofs that all definitions hold. *)


Remark rem_1 : forall X1 X2 X3 X4 X5:term, auto___def_39 X1 X2 X3 X4 X5 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1.
  tauto.
Qed.

Remark rem_2 : forall X1 X2 X3 X4 X5:term, auto___def_39 X1 X2 X3 X4 X5 -> auto___def_47 (ya_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1.
  case (rem_1 X1 X2 X3 X4 X5 A1). clear  A1. intros. apply trans___def_47_ya_old_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_3 : forall X1:term, auto___def_24 X1 -> auto___def_24 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_4 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_24 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_24 X1). tauto. exact (rem_3 X1).
Qed.

Remark rem_5 : forall X2:term, auto___def_25 X2 -> auto___def_25 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_6 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_5 X2).
Qed.

Remark rem_7 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> (auto___def_24 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_24 X1). 2:apply (rem_4 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_6 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_8 : forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto___def_23 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_7 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_23_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_9 : forall X1 X2:term, auto___def_25 X2 -> auto___def_24 X1 -> auto___def_23 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_24 X1 -> auto___def_25 X2 -> auto___def_23 (cons X1 X2)). tauto. exact (rem_8 X1 X2).
Qed.

Remark rem_10 : True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
   tauto.
Qed.

Remark rem_11 : auto___def_38 prv. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_38_prv_1;  tauto.
 tauto.
Qed.

Inductive or_0 : Prop :=
.

Remark rem_12 : auto___def_38 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_13 : auto___def_38 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_12 H);  intros.
Qed.

Remark rem_14 : forall X1 X2:term, auto___def_26 X1 -> auto___def_38 sym -> auto___type_3 X2 -> auto___def_5 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_38 sym -> False). tauto.
  exact (rem_13).
Qed.

Remark rem_15 : forall X1 X2:term, auto___def_38 sym -> auto___type_3 X2 -> auto___def_26 X1 -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 X1 -> auto___def_38 sym -> auto___type_3 X2 -> auto___def_5 X1 X2). tauto. exact (rem_14 X1 X2).
Qed.

Inductive or_1(H1:Prop) : Prop :=
    or_1_intro_1 : H1 -> (or_1 H1)
.

Remark rem_16 : forall X1 X2:term, auto___def_27 (key X1 X2) -> or_1
    (auto___def_38 X1 /\ auto___type_3 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_17 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_16 sym X2 H);  intros.
  apply (rem_15 X1 X2);  tauto.
Qed.

Remark rem_18 : auto___def_45 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_19 : auto___def_45 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_18 H);  intros.
Qed.

Remark rem_20 : forall X1 X2:term, auto___def_43 X1 -> auto___def_45 sym -> auto___type_6 X2 -> auto___def_5 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_45 sym -> False). tauto.
  exact (rem_19).
Qed.

Remark rem_21 : forall X1 X2:term, auto___def_45 sym -> auto___type_6 X2 -> auto___def_43 X1 -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_45 sym -> auto___type_6 X2 -> auto___def_5 X1 X2). tauto. exact (rem_20 X1 X2).
Qed.

Remark rem_22 : forall X1 X2:term, auto___def_44 (key X1 X2) -> or_1
    (auto___def_45 X1 /\ auto___type_6 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_23 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_22 sym X2 H);  intros.
  apply (rem_21 X1 X2);  tauto.
Qed.

Remark rem_24 : auto___def_21 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_25 : auto___def_21 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_24 H);  intros.
Qed.

Remark rem_26 : forall X1 X2:term, auto___def_10 X1 -> auto___def_21 sym -> auto_agent X2 -> auto___def_5 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 sym -> False). tauto.
  exact (rem_25).
Qed.

Remark rem_27 : forall X1 X2:term, auto___def_21 sym -> auto_agent X2 -> auto___def_10 X1 -> auto___def_5 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_21 sym -> auto_agent X2 -> auto___def_5 X1 X2). tauto. exact (rem_26 X1 X2).
Qed.

Remark rem_28 : forall X1 X2:term, auto___def_11 (key X1 X2) -> or_1
    (auto___def_21 X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_29 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_28 sym X2 H);  intros.
  apply (rem_27 X1 X2);  tauto.
Qed.

Remark rem_30 : forall X1 X2:term, auto_knows_old (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_31 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old (key sym X2) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_30 sym X2 H);  intros.
Qed.

Inductive or_4(H1 H2 H3 H4:Prop) : Prop :=
    or_4_intro_1 : H1 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_2 : H2 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_3 : H3 -> (or_4 H1 H2 H3 H4)
  | or_4_intro_4 : H4 -> (or_4 H1 H2 H3 H4)
.

Remark rem_32 : forall X1 X2:term, auto_knows_old (crypt X1 X2) -> or_4
    (auto___def_26 X1 /\ auto___def_27 X2)
    (auto___def_43 X1 /\ auto___def_44 X2)
    (auto___def_10 X1 /\ auto___def_11 X2)
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_4_intro_1; tauto.
  intros. apply or_4_intro_2; tauto.
  intros. apply or_4_intro_3; tauto.
  intros. apply or_4_intro_4; tauto.
Qed.

Remark rem_33 : forall X1 X2:term, auto_knows_old (crypt X1 (key sym X2)) -> auto___def_5 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_32 X1 (key sym X2) H);  intros.
  apply (rem_17 X1 X2);  tauto.
  apply (rem_23 X1 X2);  tauto.
  apply (rem_29 X1 X2);  tauto.
  apply (rem_31 X1 X2);  tauto.
Qed.

Remark rem_34 : forall X1:term, auto___def_82 X1 -> auto___def_82 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_35 : forall X1 X2:term, auto___def_82 X1 -> auto___def_83 X2 -> auto___def_82 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_82 X1 -> auto___def_82 X1). tauto. exact (rem_34 X1).
Qed.

Remark rem_36 : forall X2:term, auto___def_83 X2 -> auto___def_83 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_37 : forall X1 X2:term, auto___def_82 X1 -> auto___def_83 X2 -> auto___def_83 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_83 X2 -> auto___def_83 X2). tauto. exact (rem_36 X2).
Qed.

Remark rem_38 : forall X1 X2:term, auto___def_82 X1 -> auto___def_83 X2 -> (auto___def_82 X1 /\ auto___def_83 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_82 X1). 2:apply (rem_35 X1 X2);  assumption.
  cut (auto___def_83 X2). 2:apply (rem_37 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_39 : forall X1 X2:term, auto___def_82 X1 -> auto___def_83 X2 -> auto___def_81 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_38 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_81_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_40 : forall X1 X2:term, auto___def_83 X2 -> auto___def_82 X1 -> auto___def_81 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_82 X1 -> auto___def_83 X2 -> auto___def_81 (crypt X1 X2)). tauto. exact (rem_39 X1 X2).
Qed.

Remark rem_41 : forall X1:term, auto___def_37 X1 -> auto___def_37 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_42 : forall X1 X2:term, auto___def_37 X1 -> auto___type_4 X2 -> auto___def_37 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_37 X1 -> auto___def_37 X1). tauto. exact (rem_41 X1).
Qed.

Remark rem_43 : forall X2:term, auto___type_4 X2 -> auto___type_4 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_44 : forall X1 X2:term, auto___def_37 X1 -> auto___type_4 X2 -> auto___type_4 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 X2 -> auto___type_4 X2). tauto. exact (rem_43 X2).
Qed.

Remark rem_45 : forall X1 X2:term, auto___def_37 X1 -> auto___type_4 X2 -> (auto___def_37 X1 /\ auto___type_4 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_37 X1). 2:apply (rem_42 X1 X2);  assumption.
  cut (auto___type_4 X2). 2:apply (rem_44 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_46 : forall X1 X2:term, auto___def_37 X1 -> auto___type_4 X2 -> auto___def_36 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_45 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_36_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_47 : forall X1 X2:term, auto___type_4 X2 -> auto___def_37 X1 -> auto___def_36 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_37 X1 -> auto___type_4 X2 -> auto___def_36 (key X1 X2)). tauto. exact (rem_46 X1 X2).
Qed.

Remark rem_48 : forall X1:term, auto___def_65 X1 -> auto___def_65 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_49 : forall X1 X2:term, auto___def_65 X1 -> auto___def_66 X2 -> auto___def_65 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_65 X1 -> auto___def_65 X1). tauto. exact (rem_48 X1).
Qed.

Remark rem_50 : forall X2:term, auto___def_66 X2 -> auto___def_66 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_51 : forall X1 X2:term, auto___def_65 X1 -> auto___def_66 X2 -> auto___def_66 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_66 X2 -> auto___def_66 X2). tauto. exact (rem_50 X2).
Qed.

Remark rem_52 : forall X1 X2:term, auto___def_65 X1 -> auto___def_66 X2 -> (auto___def_65 X1 /\ auto___def_66 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_65 X1). 2:apply (rem_49 X1 X2);  assumption.
  cut (auto___def_66 X2). 2:apply (rem_51 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_53 : forall X1 X2:term, auto___def_65 X1 -> auto___def_66 X2 -> auto___def_64 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_52 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_64_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_54 : forall X1 X2:term, auto___def_66 X2 -> auto___def_65 X1 -> auto___def_64 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_65 X1 -> auto___def_66 X2 -> auto___def_64 (cons X1 X2)). tauto. exact (rem_53 X1 X2).
Qed.

Remark rem_55 : forall X1:term, auto___def_21 X1 -> auto___def_21 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_56 : forall X1 X2:term, auto___def_21 X1 -> auto_agent X2 -> auto___def_21 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 X1 -> auto___def_21 X1). tauto. exact (rem_55 X1).
Qed.

Remark rem_57 : forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_58 : forall X1 X2:term, auto___def_21 X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_57 X2).
Qed.

Remark rem_59 : forall X1 X2:term, auto___def_21 X1 -> auto_agent X2 -> (auto___def_21 X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_21 X1). 2:apply (rem_56 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_58 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_60 : forall X1 X2:term, auto___def_21 X1 -> auto_agent X2 -> auto___def_11 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_59 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_11_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_61 : forall X1 X2:term, auto_agent X2 -> auto___def_21 X1 -> auto___def_11 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_21 X1 -> auto_agent X2 -> auto___def_11 (key X1 X2)). tauto. exact (rem_60 X1 X2).
Qed.

Remark rem_62 : forall X1 X2 X3 X4 X5:term, auto___def_39 X2 X3 X4 X5 X1 -> auto___type_7 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_7_1. Qed.

Remark rem_63 : forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_64 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_63 X1).
Qed.

Remark rem_65 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_57 X2).
Qed.

Remark rem_66 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_64 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_65 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_67 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_12 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_66 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_12_noncea_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_68 : forall X1 X2 X3 X4 X5:term, auto___def_95 X1 X2 X3 X4 X5 -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_69 : forall X1 X2 X3 X4 X5:term, auto___def_95 X2 X1 X3 X4 X5 -> auto___type_18 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_68 X2 X1 X3 X4 X5 H);  intros.
Qed.

Remark rem_70 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_2.  tauto.
Defined.

Remark rem_71 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_70 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_i_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_72 : auto_agent i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_73 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent i -> auto___type_2 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_72 H);  intros.
  apply (rem_71 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_74 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_70 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_server_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_75 : auto_agent server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_76 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent server -> auto___type_2 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_75 H);  intros.
  apply (rem_74 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_77 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_70 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_bob_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_78 : auto_agent bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_79 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent bob -> auto___type_2 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_78 H);  intros.
  apply (rem_77 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_80 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto___type_2 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_2.  case (rem_70 epsilon_magent_p__type_2). clear  epsilon_magent_p__type_2. intros. apply trans___type_2_alice_1;  tauto.
 clear  epsilon_magent_p__type_2. tauto.
Defined.

Remark rem_81 : auto_agent alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_82 : (forall X:term, auto_agent X -> auto___type_2 X)
    -> auto_agent alice -> auto___type_2 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_2. intro H. intros.
  elim (rem_81 H);  intros.
  apply (rem_80 epsilon_magent_p__type_2);  tauto.
Defined.

Remark rem_83 : forall X1:term, auto_agent (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_84 : forall X1 X2:term, auto_agent (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_85 : auto_agent nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_86 : forall X1 X2:term, auto_agent (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_87 : forall X1 X2 X3:term, auto_agent (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_88 : forall X1 X2:term, auto_agent (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_89 : auto_agent sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_90 : forall X1 X2:term, auto_agent (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_91 : forall X1 X2 X3 X4 X5:term, auto_agent (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_92 : forall X1 X2:term, auto_agent (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_93 : forall X1 X2 X3 X4 X5:term, auto_agent (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_94 : forall X1 X2:term, auto_agent (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_95 : forall X1 X2:term, auto_agent (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_96 : auto_agent prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_97 : forall X1 X2 X3 X4 X5:term, auto_agent (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_98 : forall X1 X2 X3 X4 X5:term, auto_agent (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_99 : forall X1 X2 X3 X4 X5:term, auto_agent (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_100 : forall X1 X2:term, auto_agent (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_101 : auto_agent pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_102 : forall X1 X2:term, auto_agent (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_103 : forall X1 X2 X3 X4 X5:term, auto_agent (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_104 : forall X1:term, auto_agent X1 -> auto___type_2 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_2 1.
  intro X. case X.
  exact (rem_82 epsilon_magent_p__type_2 ).
  exact (rem_79 epsilon_magent_p__type_2 ).
  intros X1 X2. intro H. elim (rem_88 X1 X2 H).
  intros X1 X2. intro H. elim (rem_100 X1 X2 H).
  exact (rem_73 epsilon_magent_p__type_2 ).
  intros X1 X2. intro H. elim (rem_102 X1 X2 H).
   intro H. elim (rem_85  H).
  intros X1 X2. intro H. elim (rem_95 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_97 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_91 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_96  H).
   intro H. elim (rem_101  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_76 epsilon_magent_p__type_2 ).
  intros X1 X2 X3. intro H. elim (rem_87 X1 X2 X3 H).
   intro H. elim (rem_89  H).
  intros X1 X2. intro H. elim (rem_92 X1 X2 H).
  intros X1 X2. intro H. elim (rem_86 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_103 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_98 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_94 X1 X2 H).
  intros X1 X2. intro H. elim (rem_84 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_93 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_99 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_105 : forall X1 X2:term, auto___type_5 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_106 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_105 X1 X2 H);  intros.
Qed.

Remark rem_107 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_37 pub -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_106 X1 X2 X3 X4 X5).
Qed.

Remark rem_108 : forall X1 X2 X3 X4 X5:term, auto___def_37 pub -> auto___type_4 X1 -> auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_37 pub -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_107 X1 X2 X3 X4 X5).
Qed.

Remark rem_109 : forall X1 X2:term, auto___def_36 (key X1 X2) -> or_1
    (auto___def_37 X1 /\ auto___type_4 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_110 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3. intro H. intros.
  elim (rem_109 pub X1 H);  intros.
  apply (rem_108 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_111 : forall X1 X2 X3 X4 X5:term, auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___def_28 X3 -> auto___def_32 X5 -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_110 X1 X2 X3 X4 X5).
Qed.

Remark rem_112 : forall X1 X2:term, auto___def_34 (crypt X1 X2) -> or_1
    (auto___def_35 X1 /\ auto___def_36 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_113 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_34 (crypt X4 (key pub X1)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_112 X4 (key pub X1) H);  intros.
  apply (rem_111 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_114 : forall X1 X2 X3 X4 X5:term, auto___def_25 nil -> auto___def_28 X3 -> auto___def_32 X5 -> auto___def_34 (crypt X4 (key pub X1)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_32 X5 -> auto___def_34 (crypt X4 (key pub X1)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_113 X1 X2 X3 X4 X5).
Qed.

Remark rem_115 : forall X1 X2 X3 X4 X5:term, auto___def_34 (crypt X4 (key pub X1)) -> auto___def_25 nil -> auto___def_28 X3 -> auto___def_32 X5 -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_25 nil -> auto___def_28 X3 -> auto___def_32 X5 -> auto___def_34 (crypt X4 (key pub X1)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_114 X1 X2 X3 X4 X5).
Qed.

Remark rem_116 : forall X1 X2:term, auto___def_33 (cons X1 X2) -> or_1
    (auto___def_34 X1 /\ auto___def_25 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_117 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_33 (cons (crypt X4 (key pub X1)) nil) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_116 (crypt X4 (key pub X1)) nil H);  intros.
  apply (rem_115 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_118 : forall X1 X2 X3 X4 X5:term, auto___def_32 X5 -> auto___def_33 (cons (crypt X4 (key pub X1)) nil) -> auto___def_28 X3 -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_32 X5 -> auto___def_33 (cons (crypt X4 (key pub X1)) nil) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_117 X1 X2 X3 X4 X5).
Qed.

Remark rem_119 : forall X1 X2:term, auto___def_31 (cons X1 X2) -> or_1
    (auto___def_32 X1 /\ auto___def_33 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_120 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_31 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_119 X5 (cons (crypt X4 (key pub X1)) nil) H);  intros.
  apply (rem_118 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_121 : forall X1 X2 X3 X4 X5:term, auto___type_5 (noncea_current X1 X2) -> auto___def_31 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___def_28 X3 -> auto___type_3 X2 -> auto___type_4 X1 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_31 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_120 X1 X2 X3 X4 X5).
Qed.

Remark rem_122 : forall X1 X2:term, auto___def_30 (cons X1 X2) -> or_1
    (auto___type_5 X1 /\ auto___def_31 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_123 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_30 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_3 X2 -> auto___type_4 X1 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_122 (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)) H);  intros.
  apply (rem_121 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_124 : forall X1 X2 X3 X4 X5:term, auto___type_4 X1 -> auto___def_30 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___def_28 X3 -> auto___type_3 X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_30 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_3 X2 -> auto___type_4 X1 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_123 X1 X2 X3 X4 X5).
Qed.

Remark rem_125 : forall X1 X2:term, auto___def_29 (cons X1 X2) -> or_1
    (auto___type_4 X1 /\ auto___def_30 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_126 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___type_3 X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_125 X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) H);  intros.
  apply (rem_124 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_127 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_38 prv -> auto___type_3 X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___type_3 X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_126 X1 X2 X3 X4 X5).
Qed.

Remark rem_128 : forall X1 X2 X3 X4 X5:term, auto___def_38 prv -> auto___type_3 X2 -> auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_38 prv -> auto___type_3 X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_127 X1 X2 X3 X4 X5).
Qed.

Remark rem_129 : forall X1 X2 X3 X4 X5:term, auto___def_27 (key prv X2) -> auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_16 prv X2 H);  intros.
  apply (rem_128 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_130 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_27 (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_27 (key prv X2) -> auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_129 X1 X2 X3 X4 X5).
Qed.

Remark rem_131 : forall X1 X2:term, auto___def_26 (cons X1 X2) -> or_1
    (auto___def_28 X1 /\ auto___def_29 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_132 : forall X1 X2 X3 X4 X5:term, auto___def_26 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto___def_27 (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_131 X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) H);  intros.
  apply (rem_130 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_133 : forall X1 X2:term, auto___def_75 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_134 : forall X1 X2 X3 X4 X5:term, auto___def_75 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_91 (key prv X2) -> auto___type_12 X3 -> auto_agent X3 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_133 X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) H);  intros.
Qed.

Remark rem_135 : forall X1 X2 X3 X4 X5:term, auto_agent X3 -> auto___type_12 X3 -> auto___def_75 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_91 (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_91 (key prv X2) -> auto___type_12 X3 -> auto_agent X3 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_134 X1 X2 X3 X4 X5).
Qed.

Remark rem_136 : forall X1 X2:term, auto___def_90 (cons X1 X2) -> or_1
    (auto_agent X1 /\ auto___type_12 X1 /\ auto___def_75 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_137 : forall X1 X2 X3 X4 X5:term, auto___def_90 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto___def_91 (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_136 X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) H);  intros.
  apply (rem_135 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_138 : (forall X:term, auto___type_13 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_pagent.  tauto.
Defined.

Remark rem_139 : (forall X:term, auto___type_13 X -> auto_agent X)
    -> auto_agent i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_pagent.  case (rem_138 epsilon_m__type_13_pagent). clear  epsilon_m__type_13_pagent. intros. apply trans_agent_i_1;  tauto.
 clear  epsilon_m__type_13_pagent. tauto.
Defined.

Remark rem_140 : auto___type_13 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_141 : (forall X:term, auto___type_13 X -> auto_agent X)
    -> auto___type_13 i -> auto_agent i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_pagent. intro H. intros.
  elim (rem_140 H);  intros.
  apply (rem_139 epsilon_m__type_13_pagent);  tauto.
Defined.

Remark rem_142 : (forall X:term, auto___type_13 X -> auto_agent X)
    -> auto_agent server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_pagent.  case (rem_138 epsilon_m__type_13_pagent). clear  epsilon_m__type_13_pagent. intros. apply trans_agent_server_1;  tauto.
 clear  epsilon_m__type_13_pagent. tauto.
Defined.

Remark rem_143 : auto___type_13 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_144 : (forall X:term, auto___type_13 X -> auto_agent X)
    -> auto___type_13 server -> auto_agent server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_pagent. intro H. intros.
  elim (rem_143 H);  intros.
  apply (rem_142 epsilon_m__type_13_pagent);  tauto.
Defined.

Remark rem_145 : (forall X:term, auto___type_13 X -> auto_agent X)
    -> auto_agent bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_pagent.  case (rem_138 epsilon_m__type_13_pagent). clear  epsilon_m__type_13_pagent. intros. apply trans_agent_bob_1;  tauto.
 clear  epsilon_m__type_13_pagent. tauto.
Defined.

Remark rem_146 : auto___type_13 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_147 : (forall X:term, auto___type_13 X -> auto_agent X)
    -> auto___type_13 bob -> auto_agent bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_pagent. intro H. intros.
  elim (rem_146 H);  intros.
  apply (rem_145 epsilon_m__type_13_pagent);  tauto.
Defined.

Remark rem_148 : (forall X:term, auto___type_13 X -> auto_agent X)
    -> auto_agent alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_pagent.  case (rem_138 epsilon_m__type_13_pagent). clear  epsilon_m__type_13_pagent. intros. apply trans_agent_alice_1;  tauto.
 clear  epsilon_m__type_13_pagent. tauto.
Defined.

Remark rem_149 : auto___type_13 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_150 : (forall X:term, auto___type_13 X -> auto_agent X)
    -> auto___type_13 alice -> auto_agent alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_pagent. intro H. intros.
  elim (rem_149 H);  intros.
  apply (rem_148 epsilon_m__type_13_pagent);  tauto.
Defined.

Remark rem_151 : forall X1:term, auto___type_13 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_152 : forall X1 X2:term, auto___type_13 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_153 : auto___type_13 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_154 : forall X1 X2:term, auto___type_13 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_155 : forall X1 X2 X3:term, auto___type_13 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_156 : forall X1 X2:term, auto___type_13 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_157 : auto___type_13 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_158 : forall X1 X2:term, auto___type_13 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_159 : forall X1 X2 X3 X4 X5:term, auto___type_13 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_160 : forall X1 X2:term, auto___type_13 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_161 : forall X1 X2 X3 X4 X5:term, auto___type_13 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_162 : forall X1 X2:term, auto___type_13 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_163 : forall X1 X2:term, auto___type_13 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_164 : auto___type_13 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_165 : forall X1 X2 X3 X4 X5:term, auto___type_13 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_166 : forall X1 X2 X3 X4 X5:term, auto___type_13 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_167 : forall X1 X2 X3 X4 X5:term, auto___type_13 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_168 : forall X1 X2:term, auto___type_13 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_169 : auto___type_13 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_170 : forall X1 X2:term, auto___type_13 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_171 : forall X1 X2 X3 X4 X5:term, auto___type_13 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_172 : forall X1:term, auto___type_13 X1 -> auto_agent X1. (* Induct. *)
Proof.
  fix epsilon_m__type_13_pagent 1.
  intro X. case X.
  exact (rem_150 epsilon_m__type_13_pagent ).
  exact (rem_147 epsilon_m__type_13_pagent ).
  intros X1 X2. intro H. elim (rem_156 X1 X2 H).
  intros X1 X2. intro H. elim (rem_168 X1 X2 H).
  exact (rem_141 epsilon_m__type_13_pagent ).
  intros X1 X2. intro H. elim (rem_170 X1 X2 H).
   intro H. elim (rem_153  H).
  intros X1 X2. intro H. elim (rem_163 X1 X2 H).
  intros X1 X2. intro H. elim (rem_158 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_165 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_159 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_164  H).
   intro H. elim (rem_169  H).
  intros X1. intro H. elim (rem_151 X1 H).
  exact (rem_144 epsilon_m__type_13_pagent ).
  intros X1 X2 X3. intro H. elim (rem_155 X1 X2 X3 H).
   intro H. elim (rem_157  H).
  intros X1 X2. intro H. elim (rem_160 X1 X2 H).
  intros X1 X2. intro H. elim (rem_154 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_171 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_166 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_162 X1 X2 H).
  intros X1 X2. intro H. elim (rem_152 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_161 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_167 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_173 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X5 -> auto___def_82 X4 -> auto___def_83 (key pub X1) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_13 X1 -> auto_agent X1). tauto. exact (rem_172 X1).
Qed.

Remark rem_174 : forall X1:term, auto___type_13 X1 -> auto___type_13 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_175 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X5 -> auto___def_82 X4 -> auto___def_83 (key pub X1) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_13 X1 -> auto___type_13 X1). tauto. exact (rem_174 X1).
Qed.

Remark rem_176 : (forall X:term, auto___type_12 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_12_pagent.  tauto.
Defined.

Remark rem_177 : (forall X:term, auto___type_12 X -> auto_agent X)
    -> auto_agent i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_12_pagent.  case (rem_176 epsilon_m__type_12_pagent). clear  epsilon_m__type_12_pagent. intros. apply trans_agent_i_1;  tauto.
 clear  epsilon_m__type_12_pagent. tauto.
Defined.

Remark rem_178 : auto___type_12 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_179 : (forall X:term, auto___type_12 X -> auto_agent X)
    -> auto___type_12 i -> auto_agent i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_pagent. intro H. intros.
  elim (rem_178 H);  intros.
  apply (rem_177 epsilon_m__type_12_pagent);  tauto.
Defined.

Remark rem_180 : (forall X:term, auto___type_12 X -> auto_agent X)
    -> auto_agent server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_12_pagent.  case (rem_176 epsilon_m__type_12_pagent). clear  epsilon_m__type_12_pagent. intros. apply trans_agent_server_1;  tauto.
 clear  epsilon_m__type_12_pagent. tauto.
Defined.

Remark rem_181 : auto___type_12 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_182 : (forall X:term, auto___type_12 X -> auto_agent X)
    -> auto___type_12 server -> auto_agent server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_pagent. intro H. intros.
  elim (rem_181 H);  intros.
  apply (rem_180 epsilon_m__type_12_pagent);  tauto.
Defined.

Remark rem_183 : (forall X:term, auto___type_12 X -> auto_agent X)
    -> auto_agent bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_12_pagent.  case (rem_176 epsilon_m__type_12_pagent). clear  epsilon_m__type_12_pagent. intros. apply trans_agent_bob_1;  tauto.
 clear  epsilon_m__type_12_pagent. tauto.
Defined.

Remark rem_184 : auto___type_12 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_185 : (forall X:term, auto___type_12 X -> auto_agent X)
    -> auto___type_12 bob -> auto_agent bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_pagent. intro H. intros.
  elim (rem_184 H);  intros.
  apply (rem_183 epsilon_m__type_12_pagent);  tauto.
Defined.

Remark rem_186 : (forall X:term, auto___type_12 X -> auto_agent X)
    -> auto_agent alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_12_pagent.  case (rem_176 epsilon_m__type_12_pagent). clear  epsilon_m__type_12_pagent. intros. apply trans_agent_alice_1;  tauto.
 clear  epsilon_m__type_12_pagent. tauto.
Defined.

Remark rem_187 : auto___type_12 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_188 : (forall X:term, auto___type_12 X -> auto_agent X)
    -> auto___type_12 alice -> auto_agent alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_pagent. intro H. intros.
  elim (rem_187 H);  intros.
  apply (rem_186 epsilon_m__type_12_pagent);  tauto.
Defined.

Remark rem_189 : forall X1:term, auto___type_12 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_190 : forall X1 X2:term, auto___type_12 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_191 : auto___type_12 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_192 : forall X1 X2:term, auto___type_12 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_193 : forall X1 X2 X3:term, auto___type_12 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_194 : forall X1 X2:term, auto___type_12 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_195 : auto___type_12 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_196 : forall X1 X2:term, auto___type_12 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_197 : forall X1 X2 X3 X4 X5:term, auto___type_12 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_198 : forall X1 X2:term, auto___type_12 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_199 : forall X1 X2 X3 X4 X5:term, auto___type_12 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_200 : forall X1 X2:term, auto___type_12 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_201 : forall X1 X2:term, auto___type_12 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_202 : auto___type_12 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_203 : forall X1 X2 X3 X4 X5:term, auto___type_12 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_204 : forall X1 X2 X3 X4 X5:term, auto___type_12 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_205 : forall X1 X2 X3 X4 X5:term, auto___type_12 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_206 : forall X1 X2:term, auto___type_12 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_207 : auto___type_12 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_208 : forall X1 X2:term, auto___type_12 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_209 : forall X1 X2 X3 X4 X5:term, auto___type_12 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_210 : forall X2:term, auto___type_12 X2 -> auto_agent X2. (* Induct. *)
Proof.
  fix epsilon_m__type_12_pagent 1.
  intro X. case X.
  exact (rem_188 epsilon_m__type_12_pagent ).
  exact (rem_185 epsilon_m__type_12_pagent ).
  intros X1 X2. intro H. elim (rem_194 X1 X2 H).
  intros X1 X2. intro H. elim (rem_206 X1 X2 H).
  exact (rem_179 epsilon_m__type_12_pagent ).
  intros X1 X2. intro H. elim (rem_208 X1 X2 H).
   intro H. elim (rem_191  H).
  intros X1 X2. intro H. elim (rem_201 X1 X2 H).
  intros X1 X2. intro H. elim (rem_196 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_203 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_197 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_202  H).
   intro H. elim (rem_207  H).
  intros X1. intro H. elim (rem_189 X1 H).
  exact (rem_182 epsilon_m__type_12_pagent ).
  intros X1 X2 X3. intro H. elim (rem_193 X1 X2 X3 H).
   intro H. elim (rem_195  H).
  intros X1 X2. intro H. elim (rem_198 X1 X2 H).
  intros X1 X2. intro H. elim (rem_192 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_209 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_204 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_200 X1 X2 H).
  intros X1 X2. intro H. elim (rem_190 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_199 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_205 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_211 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X5 -> auto___def_82 X4 -> auto___def_83 (key pub X1) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_12 X2 -> auto_agent X2). tauto. exact (rem_210 X2).
Qed.

Remark rem_212 : forall X2:term, auto___type_12 X2 -> auto___type_12 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_213 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X5 -> auto___def_82 X4 -> auto___def_83 (key pub X1) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_212 X2).
Qed.

Remark rem_214 : forall X3:term, auto___def_75 X3 -> auto___def_75 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_215 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X5 -> auto___def_82 X4 -> auto___def_83 (key pub X1) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_75 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X3 -> auto___def_75 X3). tauto. exact (rem_214 X3).
Qed.

Remark rem_216 : forall X4:term, auto___def_82 X4 -> auto___def_82 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_217 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X5 -> auto___def_82 X4 -> auto___def_83 (key pub X1) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_82 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_82 X4 -> auto___def_82 X4). tauto. exact (rem_216 X4).
Qed.

Remark rem_218 : forall X5:term, auto___def_79 X5 -> auto___def_79 X5. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_219 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X5 -> auto___def_82 X4 -> auto___def_83 (key pub X1) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_79 X5. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_79 X5 -> auto___def_79 X5). tauto. exact (rem_218 X5).
Qed.

Remark rem_220 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X5 -> auto___def_82 X4 -> auto___def_83 (key pub X1) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> (auto_agent X1 /\ auto___type_13 X1 /\ auto_agent X2 /\ auto___type_12 X2 /\ auto___def_75 X3 /\ auto___def_82 X4 /\ auto___def_79 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7 A8.
  cut (auto_agent X1). 2:apply (rem_173 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_13 X1). 2:apply (rem_175 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_211 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_213 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_75 X3). 2:apply (rem_215 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_82 X4). 2:apply (rem_217 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_79 X5). 2:apply (rem_219 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_221 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X5 -> auto___def_82 X4 -> auto___def_83 (key pub X1) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7 A8.
  case (rem_220 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7 A8). clear  A1 A2 A3 A4 A5 A6 A7 A8. intros. apply trans___def_86_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7 A8. tauto.
Qed.

Remark rem_222 : forall X1 X2 X3 X4 X5:term, auto___def_82 X4 -> auto___def_83 (key pub X1) -> auto___def_75 X3 -> auto___def_79 X5 -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X3 -> auto___def_79 X5 -> auto___def_82 X4 -> auto___def_83 (key pub X1) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_221 X1 X2 X3 X4 X5).
Qed.

Remark rem_223 : forall X1 X2:term, auto___def_81 (crypt X1 X2) -> or_1
    (auto___def_82 X1 /\ auto___def_83 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_224 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X5 -> auto___def_81 (crypt X4 (key pub X1)) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_223 X4 (key pub X1) H);  intros.
  apply (rem_222 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_225 : forall X1 X2 X3 X4 X5:term, auto___def_72 nil -> auto___def_75 X3 -> auto___def_79 X5 -> auto___def_81 (crypt X4 (key pub X1)) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X3 -> auto___def_79 X5 -> auto___def_81 (crypt X4 (key pub X1)) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_224 X1 X2 X3 X4 X5).
Qed.

Remark rem_226 : forall X1 X2 X3 X4 X5:term, auto___def_81 (crypt X4 (key pub X1)) -> auto___def_72 nil -> auto___def_75 X3 -> auto___def_79 X5 -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_72 nil -> auto___def_75 X3 -> auto___def_79 X5 -> auto___def_81 (crypt X4 (key pub X1)) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_225 X1 X2 X3 X4 X5).
Qed.

Remark rem_227 : forall X1 X2:term, auto___def_80 (cons X1 X2) -> or_1
    (auto___def_81 X1 /\ auto___def_72 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_228 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X5 -> auto___def_80 (cons (crypt X4 (key pub X1)) nil) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_227 (crypt X4 (key pub X1)) nil H);  intros.
  apply (rem_226 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_229 : forall X1 X2 X3 X4 X5:term, auto___def_79 X5 -> auto___def_80 (cons (crypt X4 (key pub X1)) nil) -> auto___def_75 X3 -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X3 -> auto___def_79 X5 -> auto___def_80 (cons (crypt X4 (key pub X1)) nil) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_228 X1 X2 X3 X4 X5).
Qed.

Remark rem_230 : forall X1 X2:term, auto___def_78 (cons X1 X2) -> or_1
    (auto___def_79 X1 /\ auto___def_80 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_231 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_78 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_230 X5 (cons (crypt X4 (key pub X1)) nil) H);  intros.
  apply (rem_229 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_232 : forall X1 X2 X3 X4 X5:term, auto___type_14 (noncea_current X1 X2) -> auto___def_78 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___def_75 X3 -> auto___type_12 X2 -> auto___type_13 X1 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X3 -> auto___def_78 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_12 X2 -> auto___type_13 X1 -> auto___type_14 (noncea_current X1 X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_231 X1 X2 X3 X4 X5).
Qed.

Remark rem_233 : forall X1 X2:term, auto___def_77 (cons X1 X2) -> or_1
    (auto___type_14 X1 /\ auto___def_78 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_234 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_77 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_12 X2 -> auto___type_13 X1 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_233 (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)) H);  intros.
  apply (rem_232 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_235 : forall X1 X2 X3 X4 X5:term, auto___type_13 X1 -> auto___def_77 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___def_75 X3 -> auto___type_12 X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X3 -> auto___def_77 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_12 X2 -> auto___type_13 X1 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_234 X1 X2 X3 X4 X5).
Qed.

Remark rem_236 : forall X1 X2:term, auto___def_76 (cons X1 X2) -> or_1
    (auto___type_13 X1 /\ auto___def_77 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_237 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_76 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___type_12 X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_236 X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) H);  intros.
  apply (rem_235 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_238 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_76 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_85 prv -> auto___type_12 X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X3 -> auto___def_76 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___type_12 X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_237 X1 X2 X3 X4 X5).
Qed.

Remark rem_239 : forall X1 X2 X3 X4 X5:term, auto___def_85 prv -> auto___type_12 X2 -> auto___def_75 X3 -> auto___def_76 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X3 -> auto___def_76 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_85 prv -> auto___type_12 X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_238 X1 X2 X3 X4 X5).
Qed.

Remark rem_240 : forall X1 X2:term, auto___def_74 (key X1 X2) -> or_1
    (auto___def_85 X1 /\ auto___type_12 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_241 : forall X1 X2 X3 X4 X5:term, auto___def_74 (key prv X2) -> auto___def_75 X3 -> auto___def_76 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_240 prv X2 H);  intros.
  apply (rem_239 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_242 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_76 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_74 (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_74 (key prv X2) -> auto___def_75 X3 -> auto___def_76 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_241 X1 X2 X3 X4 X5).
Qed.

Remark rem_243 : forall X1 X2:term, auto___def_73 (cons X1 X2) -> or_1
    (auto___def_75 X1 /\ auto___def_76 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_244 : forall X1 X2 X3 X4 X5:term, auto___def_73 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto___def_74 (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_243 X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) H);  intros.
  apply (rem_242 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_245 : forall X1 X2:term, auto___def_28 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_246 : forall X1 X2 X3 X4 X5:term, auto___def_28 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_44 (key prv X2) -> auto___type_3 X3 -> auto_agent X3 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_245 X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) H);  intros.
Qed.

Remark rem_247 : forall X1 X2 X3 X4 X5:term, auto_agent X3 -> auto___type_3 X3 -> auto___def_28 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_44 (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_44 (key prv X2) -> auto___type_3 X3 -> auto_agent X3 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_246 X1 X2 X3 X4 X5).
Qed.

Remark rem_248 : forall X1 X2:term, auto___def_43 (cons X1 X2) -> or_1
    (auto_agent X1 /\ auto___type_3 X1 /\ auto___def_28 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_249 : forall X1 X2 X3 X4 X5:term, auto___def_43 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto___def_44 (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_248 X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) H);  intros.
  apply (rem_247 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_250 : forall X1 X2:term, auto___def_65 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_251 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 (noncea_current X1 X2) -> auto___def_66 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_250 X1 X2 H);  intros.
Qed.

Remark rem_252 : forall X1 X2 X3 X4 X5:term, auto___def_65 (noncea_current X1 X2) -> auto___def_66 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___def_62 X3 -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X3 -> auto___def_65 (noncea_current X1 X2) -> auto___def_66 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_251 X1 X2 X3 X4 X5).
Qed.

Remark rem_253 : forall X1 X2:term, auto___def_64 (cons X1 X2) -> or_1
    (auto___def_65 X1 /\ auto___def_66 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_254 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_64 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_253 (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)) H);  intros.
  apply (rem_252 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_255 : forall X1 X2 X3 X4 X5:term, auto___type_2 X1 -> auto___def_64 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___def_62 X3 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X3 -> auto___def_64 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_254 X1 X2 X3 X4 X5).
Qed.

Remark rem_256 : forall X1 X2:term, auto___def_63 (cons X1 X2) -> or_1
    (auto___type_2 X1 /\ auto___def_64 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_257 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_63 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_256 X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) H);  intros.
  apply (rem_255 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_258 : forall X1 X2:term, auto___def_61 (cons X1 X2) -> or_1
    (auto___def_62 X1 /\ auto___def_63 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_259 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_258 X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) H);  intros.
  apply (rem_257 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_260 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto___def_61 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_61 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_259 X1 X2 X3 X4 X5).
Qed.

Remark rem_261 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto_agent X2 -> auto___def_61 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_21 prv -> auto___def_61 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_260 X1 X2 X3 X4 X5).
Qed.

Remark rem_262 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key prv X2) -> auto___def_61 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 prv X2 H);  intros.
  apply (rem_261 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_263 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto___def_11 (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key prv X2) -> auto___def_61 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_262 X1 X2 X3 X4 X5).
Qed.

Remark rem_264 : forall X1 X2:term, auto___def_15 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_265 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 (noncea_current X1 X2) -> auto___def_16 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_264 X1 X2 H);  intros.
Qed.

Remark rem_266 : forall X1 X2 X3 X4 X5:term, auto___def_15 (noncea_current X1 X2) -> auto___def_16 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___def_12 X3 -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_15 (noncea_current X1 X2) -> auto___def_16 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_265 X1 X2 X3 X4 X5).
Qed.

Remark rem_267 : forall X1 X2:term, auto___def_14 (cons X1 X2) -> or_1
    (auto___def_15 X1 /\ auto___def_16 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_268 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_14 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_267 (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)) H);  intros.
  apply (rem_266 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_269 : forall X1 X2 X3 X4 X5:term, auto___type_2 X1 -> auto___def_14 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___def_12 X3 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_14 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_268 X1 X2 X3 X4 X5).
Qed.

Remark rem_270 : forall X1 X2:term, auto___def_13 (cons X1 X2) -> or_1
    (auto___type_2 X1 /\ auto___def_14 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_271 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_270 X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) H);  intros.
  apply (rem_269 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_272 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_21 prv -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_271 X1 X2 X3 X4 X5).
Qed.

Remark rem_273 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto_agent X2 -> auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_21 prv -> auto_agent X2 -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_272 X1 X2 X3 X4 X5).
Qed.

Remark rem_274 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key prv X2) -> auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 prv X2 H);  intros.
  apply (rem_273 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_275 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_11 (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key prv X2) -> auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_274 X1 X2 X3 X4 X5).
Qed.

Remark rem_276 : forall X1 X2:term, auto___def_10 (cons X1 X2) -> or_1
    (auto___def_12 X1 /\ auto___def_13 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_277 : forall X1 X2 X3 X4 X5:term, auto___def_10 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto___def_11 (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_276 X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) H);  intros.
  apply (rem_275 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_278 : forall X1 X2 X3:term, auto_knows_current (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_279 : (forall X:term, auto___def_52 X -> auto_knows_current X -> False)
    -> forall X1 X2 X3:term, auto_knows_current (session_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_52_mknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_278 X1 X2 X3 H);  intros.
Defined.

Remark rem_280 : forall X1 X2 X3:term, auto___def_52 (session_old X1 X2 X3) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_281 : (forall X:term, auto___def_52 X -> auto_knows_current X -> False)
    -> forall X1 X2 X3:term, auto___def_52 (session_old X1 X2 X3) -> auto_knows_current (session_old X1 X2 X3) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_52_mknows_current. intros X1 X2 X3. intro H. intros.
  elim (rem_280 X1 X2 X3 H);  intros.
  apply (rem_279 epsilon_m__def_52_mknows_current X1 X2 X3);  tauto.
Defined.

Remark rem_282 : forall X1:term, auto___def_52 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_283 : forall X1 X2:term, auto___def_52 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_284 : auto___def_52 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_285 : auto___def_52 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_286 : forall X1 X2:term, auto___def_52 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_287 : forall X1 X2:term, auto___def_52 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_288 : auto___def_52 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_289 : auto___def_52 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_290 : forall X1 X2:term, auto___def_52 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_291 : auto___def_52 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_292 : auto___def_52 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_293 : forall X1 X2 X3 X4 X5:term, auto___def_52 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_294 : forall X1 X2:term, auto___def_52 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_295 : forall X1 X2 X3 X4 X5:term, auto___def_52 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_296 : forall X1 X2:term, auto___def_52 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_297 : forall X1 X2:term, auto___def_52 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_298 : auto___def_52 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_299 : forall X1 X2 X3 X4 X5:term, auto___def_52 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_300 : forall X1 X2 X3 X4 X5:term, auto___def_52 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_301 : forall X1 X2 X3 X4 X5:term, auto___def_52 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_302 : forall X1 X2:term, auto___def_52 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_303 : auto___def_52 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_304 : forall X1 X2:term, auto___def_52 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_305 : forall X1 X2 X3 X4 X5:term, auto___def_52 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_306 : forall X1:term, auto___def_52 X1 -> auto_knows_current X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_52_mknows_current 1.
  intro X. case X.
   intro H. elim (rem_292  H).
   intro H. elim (rem_291  H).
  intros X1 X2. intro H. elim (rem_287 X1 X2 H).
  intros X1 X2. intro H. elim (rem_302 X1 X2 H).
   intro H. elim (rem_285  H).
  intros X1 X2. intro H. elim (rem_304 X1 X2 H).
   intro H. elim (rem_284  H).
  intros X1 X2. intro H. elim (rem_297 X1 X2 H).
  intros X1 X2. intro H. elim (rem_290 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_299 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_293 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_298  H).
   intro H. elim (rem_303  H).
  intros X1. intro H. elim (rem_282 X1 H).
   intro H. elim (rem_289  H).
  intros X1 X2 X3;  exact (rem_281 epsilon_m__def_52_mknows_current X1 X2 X3).
   intro H. elim (rem_288  H).
  intros X1 X2. intro H. elim (rem_294 X1 X2 H).
  intros X1 X2. intro H. elim (rem_286 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_305 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_300 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_296 X1 X2 H).
  intros X1 X2. intro H. elim (rem_283 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_295 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_301 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_307 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_51 prv -> auto___def_52 X2 -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X2)). tauto.
Qed.

Remark rem_308 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X2 -> auto___def_26 X4 -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___def_51 prv -> auto___def_52 X2 -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_307 X1 X2 X3 X4 X5).
Qed.

Remark rem_309 : forall X1 X2:term, auto_knows_current (key X1 X2) -> or_1
    (auto___def_51 X1 /\ auto___def_52 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_310 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X2 H);  intros.
  apply (rem_308 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_311 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_38 pub -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_310 X1 X2 X3 X4 X5).
Qed.

Remark rem_312 : forall X1 X2 X3 X4 X5:term, auto___def_38 pub -> auto___type_3 X1 -> auto___def_26 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___def_38 pub -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_311 X1 X2 X3 X4 X5).
Qed.

Remark rem_313 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_27 (key pub X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_16 pub X1 H);  intros.
  apply (rem_312 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_314 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X2 -> auto___def_90 X4 -> auto___type_15 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X2)). tauto.
Qed.

Remark rem_315 : forall X1 X2 X3 X4 X5:term, auto___def_90 X4 -> auto___type_15 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X2 H);  intros.
  apply (rem_314 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_316 : forall X1 X2 X3 X4 X5:term, auto___def_90 X4 -> auto___def_92 pub -> auto___type_15 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_90 X4 -> auto___type_15 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_315 X1 X2 X3 X4 X5).
Qed.

Remark rem_317 : forall X1 X2 X3 X4 X5:term, auto___def_92 pub -> auto___type_15 X1 -> auto___def_90 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_90 X4 -> auto___def_92 pub -> auto___type_15 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_316 X1 X2 X3 X4 X5).
Qed.

Remark rem_318 : forall X1 X2:term, auto___def_91 (key X1 X2) -> or_1
    (auto___def_92 X1 /\ auto___type_15 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_319 : forall X1 X2 X3 X4 X5:term, auto___def_90 X4 -> auto___def_91 (key pub X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_318 pub X1 H);  intros.
  apply (rem_317 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_320 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X2 -> auto___def_73 X4 -> auto___type_12 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X2)). tauto.
Qed.

Remark rem_321 : forall X1 X2 X3 X4 X5:term, auto___def_73 X4 -> auto___type_12 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X2 H);  intros.
  apply (rem_320 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_322 : forall X1 X2 X3 X4 X5:term, auto___def_73 X4 -> auto___def_85 pub -> auto___type_12 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_73 X4 -> auto___type_12 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_321 X1 X2 X3 X4 X5).
Qed.

Remark rem_323 : forall X1 X2 X3 X4 X5:term, auto___def_85 pub -> auto___type_12 X1 -> auto___def_73 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_73 X4 -> auto___def_85 pub -> auto___type_12 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_322 X1 X2 X3 X4 X5).
Qed.

Remark rem_324 : forall X1 X2 X3 X4 X5:term, auto___def_73 X4 -> auto___def_74 (key pub X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_240 pub X1 H);  intros.
  apply (rem_323 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_325 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_51 prv -> auto___def_52 X2 -> auto___type_6 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X2)). tauto.
Qed.

Remark rem_326 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X2 -> auto___def_43 X4 -> auto___type_6 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___def_51 prv -> auto___def_52 X2 -> auto___type_6 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_325 X1 X2 X3 X4 X5).
Qed.

Remark rem_327 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___type_6 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X2 H);  intros.
  apply (rem_326 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_328 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_45 pub -> auto___type_6 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___type_6 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_327 X1 X2 X3 X4 X5).
Qed.

Remark rem_329 : forall X1 X2 X3 X4 X5:term, auto___def_45 pub -> auto___type_6 X1 -> auto___def_43 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___def_45 pub -> auto___type_6 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_328 X1 X2 X3 X4 X5).
Qed.

Remark rem_330 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_44 (key pub X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_22 pub X1 H);  intros.
  apply (rem_329 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_331 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X2 -> auto___def_61 X4 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X2)). tauto.
Qed.

Remark rem_332 : forall X1 X2 X3 X4 X5:term, auto___def_61 X4 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X2 H);  intros.
  apply (rem_331 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_333 : forall X1 X2 X3 X4 X5:term, auto___def_21 pub -> auto___def_61 X4 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_61 X4 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_332 X1 X2 X3 X4 X5).
Qed.

Remark rem_334 : forall X1 X2 X3 X4 X5:term, auto___def_21 pub -> auto_agent X1 -> auto___def_61 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_21 pub -> auto___def_61 X4 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_333 X1 X2 X3 X4 X5).
Qed.

Remark rem_335 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key pub X1) -> auto___def_61 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 pub X1 H);  intros.
  apply (rem_334 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_336 : forall X1 X2 X3 X4 X5:term, auto___def_61 X4 -> auto___def_11 (key pub X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key pub X1) -> auto___def_61 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_335 X1 X2 X3 X4 X5).
Qed.

Remark rem_337 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_51 prv -> auto___def_52 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X2)). tauto.
Qed.

Remark rem_338 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X2 -> auto___def_10 X4 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto___def_51 prv -> auto___def_52 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_337 X1 X2 X3 X4 X5).
Qed.

Remark rem_339 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X2 H);  intros.
  apply (rem_338 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_340 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_21 pub -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_339 X1 X2 X3 X4 X5).
Qed.

Remark rem_341 : forall X1 X2 X3 X4 X5:term, auto___def_21 pub -> auto_agent X1 -> auto___def_10 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto___def_21 pub -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_340 X1 X2 X3 X4 X5).
Qed.

Remark rem_342 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_11 (key pub X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_28 pub X1 H);  intros.
  apply (rem_341 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_343 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X5 -> auto_knows_current (key pub X1) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X2)). tauto.
Qed.

Remark rem_344 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (key pub X1) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_309 prv X2 H);  intros.
  apply (rem_343 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_345 : forall X1 X2 X3 X4 X5:term, auto_knows_current X4 -> auto_knows_current (key pub X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (key pub X1) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_344 X1 X2 X3 X4 X5).
Qed.

Inductive or_7(H1 H2 H3 H4 H5 H6 H7:Prop) : Prop :=
    or_7_intro_1 : H1 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_2 : H2 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_3 : H3 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_4 : H4 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_5 : H5 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_6 : H6 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
  | or_7_intro_7 : H7 -> (or_7 H1 H2 H3 H4 H5 H6 H7)
.

Remark rem_346 : forall X1 X2:term, auto_knows_current (crypt X1 X2) -> or_7
    (auto___def_26 X1 /\ auto___def_27 X2)
    (auto___def_90 X1 /\ auto___def_91 X2)
    (auto___def_73 X1 /\ auto___def_74 X2)
    (auto___def_43 X1 /\ auto___def_44 X2)
    (auto___def_61 X1 /\ auto___def_11 X2)
    (auto___def_10 X1 /\ auto___def_11 X2)
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_7_intro_1; tauto.
  intros. apply or_7_intro_2; tauto.
  intros. apply or_7_intro_3; tauto.
  intros. apply or_7_intro_4; tauto.
  intros. apply or_7_intro_5; tauto.
  intros. apply or_7_intro_6; tauto.
  intros. apply or_7_intro_7; tauto.
Qed.

Remark rem_347 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X1)) -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_346 X4 (key pub X1) H);  intros.
  apply (rem_313 X1 X2 X3 X4 X5);  tauto.
  apply (rem_319 X1 X2 X3 X4 X5);  tauto.
  apply (rem_324 X1 X2 X3 X4 X5);  tauto.
  apply (rem_330 X1 X2 X3 X4 X5);  tauto.
  apply (rem_336 X1 X2 X3 X4 X5);  tauto.
  apply (rem_342 X1 X2 X3 X4 X5);  tauto.
  apply (rem_345 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_348 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X1)) -> auto_knows_current (key prv X2) -> auto_knows_current nil -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X1)) -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_347 X1 X2 X3 X4 X5).
Qed.

Remark rem_349 : forall X1 X2 X3 X4 X5:term, auto_knows_current (crypt X4 (key pub X1)) -> auto_knows_current nil -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X1)) -> auto_knows_current (key prv X2) -> auto_knows_current nil -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_348 X1 X2 X3 X4 X5).
Qed.

Remark rem_350 : forall X1 X2:term, auto_knows_current (cons X1 X2) -> or_1
    (auto_knows_current X1 /\ auto_knows_current X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_351 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (cons (crypt X4 (key pub X1)) nil) -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_350 (crypt X4 (key pub X1)) nil H);  intros.
  apply (rem_349 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_352 : forall X1 X2 X3 X4 X5:term, auto_knows_current X5 -> auto_knows_current (cons (crypt X4 (key pub X1)) nil) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (cons (crypt X4 (key pub X1)) nil) -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_351 X1 X2 X3 X4 X5).
Qed.

Remark rem_353 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3. intro H. intros.
  elim (rem_350 X5 (cons (crypt X4 (key pub X1)) nil) H);  intros.
  apply (rem_352 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_354 : forall X1 X2 X3 X4 X5:term, auto_knows_current (noncea_current X1 X2) -> auto_knows_current (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (key prv X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto_knows_current (key prv X2) -> auto_knows_current (noncea_current X1 X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_353 X1 X2 X3 X4 X5).
Qed.

Remark rem_355 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto_knows_current (key prv X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3. intro H. intros.
  elim (rem_350 (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)) H);  intros.
  apply (rem_354 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_356 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (key prv X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto_knows_current (key prv X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_355 X1 X2 X3 X4 X5).
Qed.

Remark rem_357 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current (key prv X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_350 X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) H);  intros.
  apply (rem_356 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_358 : forall X1 X2 X3 X4 X5:term, auto_knows_current X3 -> auto_knows_current (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current X2 -> auto_knows_current (key prv X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X3 -> auto_knows_current (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_current (key prv X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_357 X1 X2 X3 X4 X5).
Qed.

Remark rem_359 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_knows_current (key prv X2) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_350 X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) H);  intros.
  apply (rem_358 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_360 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_knows_current (key prv X2) -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_knows_current (key prv X2) -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_359 X1 X2 X3 X4 X5).
Qed.

Remark rem_361 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current (crypt (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_346 (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2) H);  intros.
  apply (rem_132 X1 X2 X3 X4 X5);  tauto.
  apply (rem_137 X1 X2 X3 X4 X5);  tauto.
  apply (rem_244 X1 X2 X3 X4 X5);  tauto.
  apply (rem_249 X1 X2 X3 X4 X5);  tauto.
  apply (rem_263 X1 X2 X3 X4 X5);  tauto.
  apply (rem_277 X1 X2 X3 X4 X5);  tauto.
  apply (rem_360 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_362 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current (crypt (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) -> auto_knows_current nil -> auto___def_86 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current (crypt (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) -> auto___def_86 X1 X2 X3 X4 X5). tauto.
  exact (rem_361 X1 X2 X3 X4 X5).
Qed.

Remark rem_363 : forall X1 X2 X3 X4 X5:term, auto_knows_current (crypt (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) -> auto_knows_current nil -> auto_knows_current X2 -> auto___def_86 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current (crypt (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) -> auto_knows_current nil -> auto___def_86 X1 X2 X3 X4 X5). tauto. exact (rem_362 X1 X2 X3 X4 X5).
Qed.

Remark rem_364 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current (cons (crypt (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) nil) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_350 (crypt (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) nil H);  intros.
  apply (rem_363 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_365 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons X2 (cons (crypt (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) nil)) -> auto___def_86 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_350 X2 (cons (crypt (cons X3 (cons X1 (cons (noncea_current X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) nil) H);  intros.
  apply (rem_364 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_366 : forall X1:term, auto___def_15 X1 -> auto___def_15 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_367 : forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_15 X1 -> auto___def_15 X1). tauto. exact (rem_366 X1).
Qed.

Remark rem_368 : forall X2:term, auto___def_16 X2 -> auto___def_16 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_369 : forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_16 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_16 X2 -> auto___def_16 X2). tauto. exact (rem_368 X2).
Qed.

Remark rem_370 : forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> (auto___def_15 X1 /\ auto___def_16 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_15 X1). 2:apply (rem_367 X1 X2);  assumption.
  cut (auto___def_16 X2). 2:apply (rem_369 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_371 : forall X1 X2:term, auto___def_15 X1 -> auto___def_16 X2 -> auto___def_14 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_370 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_14_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_372 : forall X1 X2:term, auto___def_16 X2 -> auto___def_15 X1 -> auto___def_14 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_15 X1 -> auto___def_16 X2 -> auto___def_14 (cons X1 X2)). tauto. exact (rem_371 X1 X2).
Qed.

Remark rem_373 : forall X1 X2 X3 X4 X5:term, auto___def_39 X2 X3 X4 X1 X5 -> auto___type_8 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_8_1. Qed.

Remark rem_374 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_65 (xa_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_66 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_65_xa_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_375 : forall X1:term, auto___def_26 X1 -> auto___def_26 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_376 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_26 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_26 X1 -> auto___def_26 X1). tauto. exact (rem_375 X1).
Qed.

Remark rem_377 : forall X2:term, auto___def_27 X2 -> auto___def_27 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_378 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_27 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_27 X2 -> auto___def_27 X2). tauto. exact (rem_377 X2).
Qed.

Remark rem_379 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> (auto___def_26 X1 /\ auto___def_27 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_26 X1). 2:apply (rem_376 X1 X2);  assumption.
  cut (auto___def_27 X2). 2:apply (rem_378 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_380 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_24 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_379 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_24_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_381 : forall X1 X2:term, auto___def_27 X2 -> auto___def_26 X1 -> auto___def_24 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 X1 -> auto___def_27 X2 -> auto___def_24 (crypt X1 X2)). tauto. exact (rem_380 X1 X2).
Qed.

Remark rem_382 : forall X1 X2:term, auto___def_77 X2 -> auto___type_13 X1 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_13 X1 -> auto___type_13 X1). tauto. exact (rem_174 X1).
Qed.

Remark rem_383 : forall X2:term, auto___def_77 X2 -> auto___def_77 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_384 : forall X1 X2:term, auto___def_77 X2 -> auto___type_13 X1 -> auto___def_77 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_77 X2 -> auto___def_77 X2). tauto. exact (rem_383 X2).
Qed.

Remark rem_385 : forall X1 X2:term, auto___def_77 X2 -> auto___type_13 X1 -> (auto___type_13 X1 /\ auto___def_77 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_13 X1). 2:apply (rem_382 X1 X2);  assumption.
  cut (auto___def_77 X2). 2:apply (rem_384 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_386 : forall X1 X2:term, auto___def_77 X2 -> auto___type_13 X1 -> auto___def_76 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_385 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_76_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_387 : forall X1:term, auto___def_12 X1 -> auto___def_12 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_388 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_12 X1). tauto. exact (rem_387 X1).
Qed.

Remark rem_389 : forall X2:term, auto___def_13 X2 -> auto___def_13 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_390 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_13 X2 -> auto___def_13 X2). tauto. exact (rem_389 X2).
Qed.

Remark rem_391 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> (auto___def_12 X1 /\ auto___def_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_12 X1). 2:apply (rem_388 X1 X2);  assumption.
  cut (auto___def_13 X2). 2:apply (rem_390 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_392 : forall X1 X2:term, auto___def_12 X1 -> auto___def_13 X2 -> auto___def_10 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_391 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_10_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_393 : forall X1 X2:term, auto___def_13 X2 -> auto___def_12 X1 -> auto___def_10 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_12 X1 -> auto___def_13 X2 -> auto___def_10 (cons X1 X2)). tauto. exact (rem_392 X1 X2).
Qed.

Remark rem_394 : (forall X:term, auto___type_1 X -> auto___type_4 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_1_p__type_4.  tauto.
Defined.

Remark rem_395 : (forall X:term, auto___type_1 X -> auto___type_4 X)
    -> auto___type_4 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_p__type_4.  case (rem_394 epsilon_m__type_1_p__type_4). clear  epsilon_m__type_1_p__type_4. intros. apply trans___type_4_i_1;  tauto.
 clear  epsilon_m__type_1_p__type_4. tauto.
Defined.

Remark rem_396 : auto___type_1 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_397 : (forall X:term, auto___type_1 X -> auto___type_4 X)
    -> auto___type_1 i -> auto___type_4 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_p__type_4. intro H. intros.
  elim (rem_396 H);  intros.
  apply (rem_395 epsilon_m__type_1_p__type_4);  tauto.
Defined.

Remark rem_398 : (forall X:term, auto___type_1 X -> auto___type_4 X)
    -> auto___type_4 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_p__type_4.  case (rem_394 epsilon_m__type_1_p__type_4). clear  epsilon_m__type_1_p__type_4. intros. apply trans___type_4_server_1;  tauto.
 clear  epsilon_m__type_1_p__type_4. tauto.
Defined.

Remark rem_399 : auto___type_1 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_400 : (forall X:term, auto___type_1 X -> auto___type_4 X)
    -> auto___type_1 server -> auto___type_4 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_p__type_4. intro H. intros.
  elim (rem_399 H);  intros.
  apply (rem_398 epsilon_m__type_1_p__type_4);  tauto.
Defined.

Remark rem_401 : (forall X:term, auto___type_1 X -> auto___type_4 X)
    -> auto___type_4 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_p__type_4.  case (rem_394 epsilon_m__type_1_p__type_4). clear  epsilon_m__type_1_p__type_4. intros. apply trans___type_4_bob_1;  tauto.
 clear  epsilon_m__type_1_p__type_4. tauto.
Defined.

Remark rem_402 : auto___type_1 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_403 : (forall X:term, auto___type_1 X -> auto___type_4 X)
    -> auto___type_1 bob -> auto___type_4 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_p__type_4. intro H. intros.
  elim (rem_402 H);  intros.
  apply (rem_401 epsilon_m__type_1_p__type_4);  tauto.
Defined.

Remark rem_404 : (forall X:term, auto___type_1 X -> auto___type_4 X)
    -> auto___type_4 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_p__type_4.  case (rem_394 epsilon_m__type_1_p__type_4). clear  epsilon_m__type_1_p__type_4. intros. apply trans___type_4_alice_1;  tauto.
 clear  epsilon_m__type_1_p__type_4. tauto.
Defined.

Remark rem_405 : auto___type_1 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_406 : (forall X:term, auto___type_1 X -> auto___type_4 X)
    -> auto___type_1 alice -> auto___type_4 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_p__type_4. intro H. intros.
  elim (rem_405 H);  intros.
  apply (rem_404 epsilon_m__type_1_p__type_4);  tauto.
Defined.

Remark rem_407 : forall X1:term, auto___type_1 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_408 : forall X1 X2:term, auto___type_1 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_409 : auto___type_1 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_410 : forall X1 X2:term, auto___type_1 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_411 : forall X1 X2 X3:term, auto___type_1 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_412 : forall X1 X2:term, auto___type_1 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_413 : auto___type_1 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_414 : forall X1 X2:term, auto___type_1 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_415 : forall X1 X2 X3 X4 X5:term, auto___type_1 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_416 : forall X1 X2:term, auto___type_1 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_417 : forall X1 X2 X3 X4 X5:term, auto___type_1 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_418 : forall X1 X2:term, auto___type_1 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_419 : forall X1 X2:term, auto___type_1 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_420 : auto___type_1 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_421 : forall X1 X2 X3 X4 X5:term, auto___type_1 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_422 : forall X1 X2 X3 X4 X5:term, auto___type_1 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_423 : forall X1 X2 X3 X4 X5:term, auto___type_1 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_424 : forall X1 X2:term, auto___type_1 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_425 : auto___type_1 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_426 : forall X1 X2:term, auto___type_1 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_427 : forall X1 X2 X3 X4 X5:term, auto___type_1 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_428 : forall X1:term, auto___type_1 X1 -> auto___type_4 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_1_p__type_4 1.
  intro X. case X.
  exact (rem_406 epsilon_m__type_1_p__type_4 ).
  exact (rem_403 epsilon_m__type_1_p__type_4 ).
  intros X1 X2. intro H. elim (rem_412 X1 X2 H).
  intros X1 X2. intro H. elim (rem_424 X1 X2 H).
  exact (rem_397 epsilon_m__type_1_p__type_4 ).
  intros X1 X2. intro H. elim (rem_426 X1 X2 H).
   intro H. elim (rem_409  H).
  intros X1 X2. intro H. elim (rem_419 X1 X2 H).
  intros X1 X2. intro H. elim (rem_414 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_421 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_415 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_420  H).
   intro H. elim (rem_425  H).
  intros X1. intro H. elim (rem_407 X1 H).
  exact (rem_400 epsilon_m__type_1_p__type_4 ).
  intros X1 X2 X3. intro H. elim (rem_411 X1 X2 X3 H).
   intro H. elim (rem_413  H).
  intros X1 X2. intro H. elim (rem_416 X1 X2 H).
  intros X1 X2. intro H. elim (rem_410 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_427 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_422 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_418 X1 X2 H).
  intros X1 X2. intro H. elim (rem_408 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_417 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_423 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_429 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_1 X1 -> auto___type_2 X5 -> auto_agent X5 -> auto_agent X1 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_1 X1 -> auto___type_4 X1). tauto. exact (rem_428 X1).
Qed.

Remark rem_430 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_12 X5 -> auto___type_4 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X5 X3 X4 X2.
  cut (auto___def_12 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_1 X1 -> auto___type_2 X5 -> auto_agent X5 -> auto_agent X1 -> auto___type_4 X1). tauto. exact (rem_429 X1 X2 X3 X4 X5).
Qed.

Remark rem_431 : forall X1 X2 X3 X4 X5:term, auto___def_22 X1 X2 X3 X4 X5 -> or_1
    (auto_agent X1 /\ auto___type_1 X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_15 X3 /\ auto___def_18 X4 /\ auto___def_12 X5)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_432 : forall X1 X2 X3 X4 X5:term, auto___def_22 X1 X2 X3 X4 X5 -> auto___type_4 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_431 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_430 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_433 : auto___def_25 nil. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_25_nil_1;  tauto.
 tauto.
Qed.

Remark rem_434 : forall X1:term, auto___type_14 X1 -> auto___type_14 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_435 : forall X1 X2:term, auto___def_78 X2 -> auto___type_14 X1 -> auto___type_14 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_14 X1 -> auto___type_14 X1). tauto. exact (rem_434 X1).
Qed.

Remark rem_436 : forall X2:term, auto___def_78 X2 -> auto___def_78 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_437 : forall X1 X2:term, auto___def_78 X2 -> auto___type_14 X1 -> auto___def_78 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_78 X2 -> auto___def_78 X2). tauto. exact (rem_436 X2).
Qed.

Remark rem_438 : forall X1 X2:term, auto___def_78 X2 -> auto___type_14 X1 -> (auto___type_14 X1 /\ auto___def_78 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_14 X1). 2:apply (rem_435 X1 X2);  assumption.
  cut (auto___def_78 X2). 2:apply (rem_437 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_439 : forall X1 X2:term, auto___def_78 X2 -> auto___type_14 X1 -> auto___def_77 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_438 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_77_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_440 : forall X1:term, auto___def_62 X1 -> auto___def_62 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_441 : forall X1 X2:term, auto___def_62 X1 -> auto___def_63 X2 -> auto___def_62 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_62 X1 -> auto___def_62 X1). tauto. exact (rem_440 X1).
Qed.

Remark rem_442 : forall X2:term, auto___def_63 X2 -> auto___def_63 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_443 : forall X1 X2:term, auto___def_62 X1 -> auto___def_63 X2 -> auto___def_63 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_63 X2 -> auto___def_63 X2). tauto. exact (rem_442 X2).
Qed.

Remark rem_444 : forall X1 X2:term, auto___def_62 X1 -> auto___def_63 X2 -> (auto___def_62 X1 /\ auto___def_63 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_62 X1). 2:apply (rem_441 X1 X2);  assumption.
  cut (auto___def_63 X2). 2:apply (rem_443 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_445 : forall X1 X2:term, auto___def_62 X1 -> auto___def_63 X2 -> auto___def_61 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_444 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_61_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_446 : forall X1 X2:term, auto___def_63 X2 -> auto___def_62 X1 -> auto___def_61 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_62 X1 -> auto___def_63 X2 -> auto___def_61 (cons X1 X2)). tauto. exact (rem_445 X1 X2).
Qed.

Remark rem_447 : (forall X:term, auto___type_13 X -> auto___type_15 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_13_p__type_15.  tauto.
Defined.

Remark rem_448 : (forall X:term, auto___type_13 X -> auto___type_15 X)
    -> auto___type_15 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_15.  case (rem_447 epsilon_m__type_13_p__type_15). clear  epsilon_m__type_13_p__type_15. intros. apply trans___type_15_i_1;  tauto.
 clear  epsilon_m__type_13_p__type_15. tauto.
Defined.

Remark rem_449 : (forall X:term, auto___type_13 X -> auto___type_15 X)
    -> auto___type_13 i -> auto___type_15 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_15. intro H. intros.
  elim (rem_140 H);  intros.
  apply (rem_448 epsilon_m__type_13_p__type_15);  tauto.
Defined.

Remark rem_450 : (forall X:term, auto___type_13 X -> auto___type_15 X)
    -> auto___type_15 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_15.  case (rem_447 epsilon_m__type_13_p__type_15). clear  epsilon_m__type_13_p__type_15. intros. apply trans___type_15_server_1;  tauto.
 clear  epsilon_m__type_13_p__type_15. tauto.
Defined.

Remark rem_451 : (forall X:term, auto___type_13 X -> auto___type_15 X)
    -> auto___type_13 server -> auto___type_15 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_15. intro H. intros.
  elim (rem_143 H);  intros.
  apply (rem_450 epsilon_m__type_13_p__type_15);  tauto.
Defined.

Remark rem_452 : (forall X:term, auto___type_13 X -> auto___type_15 X)
    -> auto___type_15 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_15.  case (rem_447 epsilon_m__type_13_p__type_15). clear  epsilon_m__type_13_p__type_15. intros. apply trans___type_15_bob_1;  tauto.
 clear  epsilon_m__type_13_p__type_15. tauto.
Defined.

Remark rem_453 : (forall X:term, auto___type_13 X -> auto___type_15 X)
    -> auto___type_13 bob -> auto___type_15 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_15. intro H. intros.
  elim (rem_146 H);  intros.
  apply (rem_452 epsilon_m__type_13_p__type_15);  tauto.
Defined.

Remark rem_454 : (forall X:term, auto___type_13 X -> auto___type_15 X)
    -> auto___type_15 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_13_p__type_15.  case (rem_447 epsilon_m__type_13_p__type_15). clear  epsilon_m__type_13_p__type_15. intros. apply trans___type_15_alice_1;  tauto.
 clear  epsilon_m__type_13_p__type_15. tauto.
Defined.

Remark rem_455 : (forall X:term, auto___type_13 X -> auto___type_15 X)
    -> auto___type_13 alice -> auto___type_15 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_13_p__type_15. intro H. intros.
  elim (rem_149 H);  intros.
  apply (rem_454 epsilon_m__type_13_p__type_15);  tauto.
Defined.

Remark rem_456 : forall X1:term, auto___type_13 X1 -> auto___type_15 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_13_p__type_15 1.
  intro X. case X.
  exact (rem_455 epsilon_m__type_13_p__type_15 ).
  exact (rem_453 epsilon_m__type_13_p__type_15 ).
  intros X1 X2. intro H. elim (rem_156 X1 X2 H).
  intros X1 X2. intro H. elim (rem_168 X1 X2 H).
  exact (rem_449 epsilon_m__type_13_p__type_15 ).
  intros X1 X2. intro H. elim (rem_170 X1 X2 H).
   intro H. elim (rem_153  H).
  intros X1 X2. intro H. elim (rem_163 X1 X2 H).
  intros X1 X2. intro H. elim (rem_158 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_165 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_159 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_164  H).
   intro H. elim (rem_169  H).
  intros X1. intro H. elim (rem_151 X1 H).
  exact (rem_451 epsilon_m__type_13_p__type_15 ).
  intros X1 X2 X3. intro H. elim (rem_155 X1 X2 X3 H).
   intro H. elim (rem_157  H).
  intros X1 X2. intro H. elim (rem_160 X1 X2 H).
  intros X1 X2. intro H. elim (rem_154 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_171 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_166 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_162 X1 X2 H).
  intros X1 X2. intro H. elim (rem_152 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_161 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_167 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_457 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_79 X3 -> auto___def_82 X4 -> auto___type_12 X5 -> auto___type_13 X1 -> auto_agent X5 -> auto_agent X1 -> auto___type_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_13 X1 -> auto___type_15 X1). tauto. exact (rem_456 X1).
Qed.

Remark rem_458 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_13 X1 -> auto_agent X2 -> auto___type_12 X2 -> auto___def_75 X3 -> auto___def_82 X4 -> auto___def_79 X5 -> auto___type_15 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X5 X2 X4 X3.
  cut (auto___def_75 X2 -> auto___def_79 X3 -> auto___def_82 X4 -> auto___type_12 X5 -> auto___type_13 X1 -> auto_agent X5 -> auto_agent X1 -> auto___type_15 X1). tauto. exact (rem_457 X1 X2 X3 X4 X5).
Qed.

Remark rem_459 : forall X1 X2 X3 X4 X5:term, auto___def_86 X1 X2 X3 X4 X5 -> or_1
    (auto_agent X1 /\ auto___type_13 X1 /\ auto_agent X2 /\ auto___type_12 X2 /\ auto___def_75 X3 /\ auto___def_82 X4 /\ auto___def_79 X5)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_460 : forall X1 X2 X3 X4 X5:term, auto___def_86 X1 X2 X3 X4 X5 -> auto___type_15 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_459 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_458 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_461 : forall X1:term, auto___type_2 X1 -> auto___type_2 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_462 : forall X1 X2:term, auto___def_64 X2 -> auto___type_2 X1 -> auto___type_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_2 X1 -> auto___type_2 X1). tauto. exact (rem_461 X1).
Qed.

Remark rem_463 : forall X2:term, auto___def_64 X2 -> auto___def_64 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_464 : forall X1 X2:term, auto___def_64 X2 -> auto___type_2 X1 -> auto___def_64 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_64 X2 -> auto___def_64 X2). tauto. exact (rem_463 X2).
Qed.

Remark rem_465 : forall X1 X2:term, auto___def_64 X2 -> auto___type_2 X1 -> (auto___type_2 X1 /\ auto___def_64 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_2 X1). 2:apply (rem_462 X1 X2);  assumption.
  cut (auto___def_64 X2). 2:apply (rem_464 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_466 : forall X1 X2:term, auto___def_64 X2 -> auto___type_2 X1 -> auto___def_63 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_465 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_63_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_467 : auto___def_92 prv. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_92_prv_1;  tauto.
 tauto.
Qed.

Remark rem_468 : forall X1 X2 X3 X4 X5:term, auto___def_48 X2 X1 X3 X4 X5 -> auto___type_9 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_9_1. Qed.

Remark rem_469 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_470 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_469 epsilon_m__def_82_p__type_17 X1).
Defined.

Remark rem_471 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_472 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_471 epsilon_m__def_82_p__type_17 X1).
Defined.

Remark rem_473 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_474 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_473 epsilon_m__def_82_p__type_17 X2).
Defined.

Remark rem_475 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X2:term, auto___type_2 X2 -> auto___type_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_476 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_475 epsilon_m__def_82_p__type_17 X2).
Defined.

Remark rem_477 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X3:term, auto___def_62 X3 -> auto___def_62 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_478 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_62 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X3 -> auto___def_62 X3). tauto. exact (rem_477 epsilon_m__def_82_p__type_17 X3).
Defined.

Remark rem_479 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X4:term, auto___def_65 X4 -> auto___def_65 X4. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_480 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_65 X4. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto___def_65 X4 -> auto___def_65 X4). tauto. exact (rem_479 epsilon_m__def_82_p__type_17 X4).
Defined.

Remark rem_481 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X5:term, auto___def_68 X5 -> auto___def_68 X5. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_482 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_68 X5. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto___def_68 X5 -> auto___def_68 X5). tauto. exact (rem_481 epsilon_m__def_82_p__type_17 X5).
Defined.

Remark rem_483 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> (auto_agent X1 /\ auto_knows_current X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_62 X3 /\ auto___def_65 X4 /\ auto___def_68 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_470 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto_knows_current X1). 2:apply (rem_472 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_474 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_476 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_62 X3). 2:apply (rem_478 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_65 X4). 2:apply (rem_480 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_68 X5). 2:apply (rem_482 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  tauto.
Defined.

Remark rem_484 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_17 (yb_current X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_483 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  epsilon_m__def_82_p__type_17 A1 A2 A3 A4 A5 A6 A7. intros. apply trans___type_17_yb_current_1;  tauto.
 clear  epsilon_m__def_82_p__type_17 A1 A2 A3 A4 A5 A6 A7. tauto.
Defined.

Remark rem_485 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_469 epsilon_m__def_82_p__type_17 X1).
Defined.

Remark rem_486 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1:term, auto___type_1 X1 -> auto___type_1 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_487 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto___type_1 X1 -> auto___type_1 X1). tauto. exact (rem_486 epsilon_m__def_82_p__type_17 X1).
Defined.

Remark rem_488 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_473 epsilon_m__def_82_p__type_17 X2).
Defined.

Remark rem_489 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_475 epsilon_m__def_82_p__type_17 X2).
Defined.

Remark rem_490 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X3:term, auto___def_12 X3 -> auto___def_12 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_491 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_12 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_12 X3). tauto. exact (rem_490 epsilon_m__def_82_p__type_17 X3).
Defined.

Remark rem_492 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X4:term, auto___def_15 X4 -> auto___def_15 X4. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_493 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_15 X4. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto___def_15 X4 -> auto___def_15 X4). tauto. exact (rem_492 epsilon_m__def_82_p__type_17 X4).
Defined.

Remark rem_494 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X5:term, auto___def_18 X5 -> auto___def_18 X5. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_495 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_18 X5. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5.
  cut (auto___def_18 X5 -> auto___def_18 X5). tauto. exact (rem_494 epsilon_m__def_82_p__type_17 X5).
Defined.

Remark rem_496 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> (auto_agent X1 /\ auto___type_1 X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_12 X3 /\ auto___def_15 X4 /\ auto___def_18 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_485 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_1 X1). 2:apply (rem_487 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_488 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_489 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_12 X3). 2:apply (rem_491 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_15 X4). 2:apply (rem_493 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_18 X5). 2:apply (rem_495 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  assumption.
  tauto.
Defined.

Remark rem_497 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_17 (yb_current X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_496 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  epsilon_m__def_82_p__type_17 A1 A2 A3 A4 A5 A6 A7. intros. apply trans___type_17_yb_current_2;  tauto.
 clear  epsilon_m__def_82_p__type_17 A1 A2 A3 A4 A5 A6 A7. tauto.
Defined.

Inductive or_2(H1 H2:Prop) : Prop :=
    or_2_intro_1 : H1 -> (or_2 H1 H2)
  | or_2_intro_2 : H2 -> (or_2 H1 H2)
.

Remark rem_498 : forall X1 X2 X3 X4 X5:term, auto___def_82 (yb_current X1 X2 X3 X4 X5) -> or_2
    (auto_agent X1 /\ auto_knows_current X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_62 X3 /\ auto___def_65 X4 /\ auto___def_68 X5)
    (auto_agent X1 /\ auto___type_1 X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_12 X3 /\ auto___def_15 X4 /\ auto___def_18 X5)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_499 : (forall X:term, auto___def_82 X -> auto___type_17 X)
    -> forall X1 X2 X3 X4 X5:term, auto___def_82 (yb_current X1 X2 X3 X4 X5) -> auto___type_17 (yb_current X1 X2 X3 X4 X5). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_82_p__type_17. intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_498 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_484 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  tauto.
  apply (rem_497 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5);  tauto.
Defined.

Remark rem_500 : forall X1:term, auto___def_82 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_501 : forall X1 X2:term, auto___def_82 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_502 : auto___def_82 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_503 : auto___def_82 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_504 : forall X1 X2:term, auto___def_82 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_505 : forall X1 X2 X3:term, auto___def_82 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_506 : forall X1 X2:term, auto___def_82 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_507 : auto___def_82 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_508 : auto___def_82 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_509 : forall X1 X2:term, auto___def_82 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_510 : auto___def_82 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_511 : auto___def_82 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_512 : forall X1 X2 X3 X4 X5:term, auto___def_82 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_513 : forall X1 X2:term, auto___def_82 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_514 : forall X1 X2:term, auto___def_82 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_515 : forall X1 X2:term, auto___def_82 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_516 : auto___def_82 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_517 : forall X1 X2 X3 X4 X5:term, auto___def_82 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_518 : forall X1 X2 X3 X4 X5:term, auto___def_82 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_519 : forall X1 X2 X3 X4 X5:term, auto___def_82 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_520 : forall X1 X2:term, auto___def_82 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_521 : auto___def_82 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_522 : forall X1 X2:term, auto___def_82 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_523 : forall X1 X2 X3 X4 X5:term, auto___def_82 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_524 : forall X1:term, auto___def_82 X1 -> auto___type_17 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_82_p__type_17 1.
  intro X. case X.
   intro H. elim (rem_511  H).
   intro H. elim (rem_510  H).
  intros X1 X2. intro H. elim (rem_506 X1 X2 H).
  intros X1 X2. intro H. elim (rem_520 X1 X2 H).
   intro H. elim (rem_503  H).
  intros X1 X2. intro H. elim (rem_522 X1 X2 H).
   intro H. elim (rem_502  H).
  intros X1 X2. intro H. elim (rem_515 X1 X2 H).
  intros X1 X2. intro H. elim (rem_509 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_517 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_512 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_516  H).
   intro H. elim (rem_521  H).
  intros X1. intro H. elim (rem_500 X1 H).
   intro H. elim (rem_508  H).
  intros X1 X2 X3. intro H. elim (rem_505 X1 X2 X3 H).
   intro H. elim (rem_507  H).
  intros X1 X2. intro H. elim (rem_513 X1 X2 H).
  intros X1 X2. intro H. elim (rem_504 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_523 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_518 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_514 X1 X2 H).
  intros X1 X2. intro H. elim (rem_501 X1 X2 H).
  intros X1 X2 X3 X4 X5;  exact (rem_499 epsilon_m__def_82_p__type_17 X1 X2 X3 X4 X5).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_519 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_525 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_79 X3 -> auto___def_82 X1 -> auto___type_12 X4 -> auto___type_13 X5 -> auto_agent X5 -> auto_agent X4 -> auto___type_17 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_82 X1 -> auto___type_17 X1). tauto. exact (rem_524 X1).
Qed.

Remark rem_526 : forall X1 X2 X3 X4 X5:term, auto_agent X2 -> auto___type_13 X2 -> auto_agent X3 -> auto___type_12 X3 -> auto___def_75 X4 -> auto___def_82 X1 -> auto___def_79 X5 -> auto___type_17 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X5 X4 X2 X3.
  cut (auto___def_75 X2 -> auto___def_79 X3 -> auto___def_82 X1 -> auto___type_12 X4 -> auto___type_13 X5 -> auto_agent X5 -> auto_agent X4 -> auto___type_17 X1). tauto. exact (rem_525 X1 X2 X3 X4 X5).
Qed.

Remark rem_527 : forall X1 X2 X3 X4 X5:term, auto___def_86 X2 X3 X4 X1 X5 -> auto___type_17 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_459 X2 X3 X4 X1 X5 H);  intros.
  apply (rem_526 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_528 : forall X1:term, auto___def_92 X1 -> auto___def_92 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_529 : forall X1 X2:term, auto___def_92 X1 -> auto___type_15 X2 -> auto___def_92 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_92 X1 -> auto___def_92 X1). tauto. exact (rem_528 X1).
Qed.

Remark rem_530 : forall X2:term, auto___type_15 X2 -> auto___type_15 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_531 : forall X1 X2:term, auto___def_92 X1 -> auto___type_15 X2 -> auto___type_15 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_15 X2 -> auto___type_15 X2). tauto. exact (rem_530 X2).
Qed.

Remark rem_532 : forall X1 X2:term, auto___def_92 X1 -> auto___type_15 X2 -> (auto___def_92 X1 /\ auto___type_15 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_92 X1). 2:apply (rem_529 X1 X2);  assumption.
  cut (auto___type_15 X2). 2:apply (rem_531 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_533 : forall X1 X2:term, auto___def_92 X1 -> auto___type_15 X2 -> auto___def_91 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_532 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_91_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_534 : forall X1 X2:term, auto___type_15 X2 -> auto___def_92 X1 -> auto___def_91 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_92 X1 -> auto___type_15 X2 -> auto___def_91 (key X1 X2)). tauto. exact (rem_533 X1 X2).
Qed.

Remark rem_535 : forall X1:term, auto___def_28 X1 -> auto___def_28 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_536 : forall X1 X2:term, auto___def_28 X1 -> auto___def_29 X2 -> auto___def_28 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_28 X1 -> auto___def_28 X1). tauto. exact (rem_535 X1).
Qed.

Remark rem_537 : forall X2:term, auto___def_29 X2 -> auto___def_29 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_538 : forall X1 X2:term, auto___def_28 X1 -> auto___def_29 X2 -> auto___def_29 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_29 X2 -> auto___def_29 X2). tauto. exact (rem_537 X2).
Qed.

Remark rem_539 : forall X1 X2:term, auto___def_28 X1 -> auto___def_29 X2 -> (auto___def_28 X1 /\ auto___def_29 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_28 X1). 2:apply (rem_536 X1 X2);  assumption.
  cut (auto___def_29 X2). 2:apply (rem_538 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_540 : forall X1 X2:term, auto___def_28 X1 -> auto___def_29 X2 -> auto___def_26 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_539 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_26_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_541 : forall X1 X2:term, auto___def_29 X2 -> auto___def_28 X1 -> auto___def_26 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_28 X1 -> auto___def_29 X2 -> auto___def_26 (cons X1 X2)). tauto. exact (rem_540 X1 X2).
Qed.

Remark rem_542 : forall X1 X2:term, auto___def_32 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_543 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_542 X4 (key pub X2) H);  intros.
Qed.

Remark rem_544 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___def_33 nil -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto.
  exact (rem_543 X1 X2 X3 X4 X5).
Qed.

Remark rem_545 : forall X1 X2 X3 X4 X5:term, auto___def_32 (crypt X4 (key pub X2)) -> auto___def_33 nil -> auto___def_28 X5 -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___def_33 nil -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_544 X1 X2 X3 X4 X5).
Qed.

Remark rem_546 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_31 (cons (crypt X4 (key pub X2)) nil) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_119 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_545 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_547 : forall X1 X2 X3 X4 X5:term, auto___type_5 X3 -> auto___def_31 (cons (crypt X4 (key pub X2)) nil) -> auto___def_28 X5 -> auto___type_3 X1 -> auto___type_4 X2 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_31 (cons (crypt X4 (key pub X2)) nil) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_546 X1 X2 X3 X4 X5).
Qed.

Remark rem_548 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_30 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_122 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_547 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_549 : forall X1 X2 X3 X4 X5:term, auto___type_4 X2 -> auto___def_30 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___def_28 X5 -> auto___type_3 X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_30 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_548 X1 X2 X3 X4 X5).
Qed.

Remark rem_550 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___type_3 X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_125 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_549 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_551 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_38 prv -> auto___type_3 X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___type_3 X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto.
  exact (rem_550 X1 X2 X3 X4 X5).
Qed.

Remark rem_552 : forall X1 X2 X3 X4 X5:term, auto___def_38 prv -> auto___type_3 X1 -> auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_38 prv -> auto___type_3 X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_551 X1 X2 X3 X4 X5).
Qed.

Remark rem_553 : forall X1 X2 X3 X4 X5:term, auto___def_27 (key prv X1) -> auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_16 prv X1 H);  intros.
  apply (rem_552 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_554 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_27 (key prv X1) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_27 (key prv X1) -> auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_553 X1 X2 X3 X4 X5).
Qed.

Remark rem_555 : forall X1 X2 X3 X4 X5:term, auto___def_26 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_27 (key prv X1) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_131 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_554 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_556 : forall X1 X2 X3 X4 X5:term, auto___def_28 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_44 (key prv X1) -> auto___type_3 X5 -> auto_agent X5 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_245 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
Qed.

Remark rem_557 : forall X1 X2 X3 X4 X5:term, auto_agent X5 -> auto___type_3 X5 -> auto___def_28 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_44 (key prv X1) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_44 (key prv X1) -> auto___type_3 X5 -> auto_agent X5 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_556 X1 X2 X3 X4 X5).
Qed.

Remark rem_558 : forall X1 X2 X3 X4 X5:term, auto___def_43 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_44 (key prv X1) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_248 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_557 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_559 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_63 X1).
Qed.

Remark rem_560 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_1.  tauto.
Defined.

Remark rem_561 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_560 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_i_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_562 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent i -> auto___type_1 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_72 H);  intros.
  apply (rem_561 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_563 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_560 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_server_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_564 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent server -> auto___type_1 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_75 H);  intros.
  apply (rem_563 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_565 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_560 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_bob_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_566 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent bob -> auto___type_1 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_78 H);  intros.
  apply (rem_565 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_567 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto___type_1 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_1.  case (rem_560 epsilon_magent_p__type_1). clear  epsilon_magent_p__type_1. intros. apply trans___type_1_alice_1;  tauto.
 clear  epsilon_magent_p__type_1. tauto.
Defined.

Remark rem_568 : (forall X:term, auto_agent X -> auto___type_1 X)
    -> auto_agent alice -> auto___type_1 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_1. intro H. intros.
  elim (rem_81 H);  intros.
  apply (rem_567 epsilon_magent_p__type_1);  tauto.
Defined.

Remark rem_569 : forall X1:term, auto_agent X1 -> auto___type_1 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_1 1.
  intro X. case X.
  exact (rem_568 epsilon_magent_p__type_1 ).
  exact (rem_566 epsilon_magent_p__type_1 ).
  intros X1 X2. intro H. elim (rem_88 X1 X2 H).
  intros X1 X2. intro H. elim (rem_100 X1 X2 H).
  exact (rem_562 epsilon_magent_p__type_1 ).
  intros X1 X2. intro H. elim (rem_102 X1 X2 H).
   intro H. elim (rem_85  H).
  intros X1 X2. intro H. elim (rem_95 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_97 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_91 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_96  H).
   intro H. elim (rem_101  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_564 epsilon_magent_p__type_1 ).
  intros X1 X2 X3. intro H. elim (rem_87 X1 X2 X3 H).
   intro H. elim (rem_89  H).
  intros X1 X2. intro H. elim (rem_92 X1 X2 H).
  intros X1 X2. intro H. elim (rem_86 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_103 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_98 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_94 X1 X2 H).
  intros X1 X2. intro H. elim (rem_84 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_93 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_99 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_570 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___type_1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto___type_1 X1). tauto. exact (rem_569 X1).
Qed.

Remark rem_571 : (forall X:term, auto___type_2 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_pagent.  tauto.
Defined.

Remark rem_572 : (forall X:term, auto___type_2 X -> auto_agent X)
    -> auto_agent i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pagent.  case (rem_571 epsilon_m__type_2_pagent). clear  epsilon_m__type_2_pagent. intros. apply trans_agent_i_1;  tauto.
 clear  epsilon_m__type_2_pagent. tauto.
Defined.

Remark rem_573 : auto___type_2 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_574 : (forall X:term, auto___type_2 X -> auto_agent X)
    -> auto___type_2 i -> auto_agent i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_pagent. intro H. intros.
  elim (rem_573 H);  intros.
  apply (rem_572 epsilon_m__type_2_pagent);  tauto.
Defined.

Remark rem_575 : (forall X:term, auto___type_2 X -> auto_agent X)
    -> auto_agent server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pagent.  case (rem_571 epsilon_m__type_2_pagent). clear  epsilon_m__type_2_pagent. intros. apply trans_agent_server_1;  tauto.
 clear  epsilon_m__type_2_pagent. tauto.
Defined.

Remark rem_576 : auto___type_2 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_577 : (forall X:term, auto___type_2 X -> auto_agent X)
    -> auto___type_2 server -> auto_agent server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_pagent. intro H. intros.
  elim (rem_576 H);  intros.
  apply (rem_575 epsilon_m__type_2_pagent);  tauto.
Defined.

Remark rem_578 : (forall X:term, auto___type_2 X -> auto_agent X)
    -> auto_agent bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pagent.  case (rem_571 epsilon_m__type_2_pagent). clear  epsilon_m__type_2_pagent. intros. apply trans_agent_bob_1;  tauto.
 clear  epsilon_m__type_2_pagent. tauto.
Defined.

Remark rem_579 : auto___type_2 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_580 : (forall X:term, auto___type_2 X -> auto_agent X)
    -> auto___type_2 bob -> auto_agent bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_pagent. intro H. intros.
  elim (rem_579 H);  intros.
  apply (rem_578 epsilon_m__type_2_pagent);  tauto.
Defined.

Remark rem_581 : (forall X:term, auto___type_2 X -> auto_agent X)
    -> auto_agent alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_pagent.  case (rem_571 epsilon_m__type_2_pagent). clear  epsilon_m__type_2_pagent. intros. apply trans_agent_alice_1;  tauto.
 clear  epsilon_m__type_2_pagent. tauto.
Defined.

Remark rem_582 : auto___type_2 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_583 : (forall X:term, auto___type_2 X -> auto_agent X)
    -> auto___type_2 alice -> auto_agent alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_pagent. intro H. intros.
  elim (rem_582 H);  intros.
  apply (rem_581 epsilon_m__type_2_pagent);  tauto.
Defined.

Remark rem_584 : forall X1:term, auto___type_2 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_585 : forall X1 X2:term, auto___type_2 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_586 : auto___type_2 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_587 : forall X1 X2:term, auto___type_2 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_588 : forall X1 X2 X3:term, auto___type_2 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_589 : forall X1 X2:term, auto___type_2 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_590 : auto___type_2 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_591 : forall X1 X2:term, auto___type_2 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_592 : forall X1 X2 X3 X4 X5:term, auto___type_2 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_593 : forall X1 X2:term, auto___type_2 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_594 : forall X1 X2 X3 X4 X5:term, auto___type_2 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_595 : forall X1 X2:term, auto___type_2 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_596 : forall X1 X2:term, auto___type_2 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_597 : auto___type_2 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_598 : forall X1 X2 X3 X4 X5:term, auto___type_2 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_599 : forall X1 X2 X3 X4 X5:term, auto___type_2 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_600 : forall X1 X2 X3 X4 X5:term, auto___type_2 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_601 : forall X1 X2:term, auto___type_2 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_602 : auto___type_2 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_603 : forall X1 X2:term, auto___type_2 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_604 : forall X1 X2 X3 X4 X5:term, auto___type_2 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_605 : forall X2:term, auto___type_2 X2 -> auto_agent X2. (* Induct. *)
Proof.
  fix epsilon_m__type_2_pagent 1.
  intro X. case X.
  exact (rem_583 epsilon_m__type_2_pagent ).
  exact (rem_580 epsilon_m__type_2_pagent ).
  intros X1 X2. intro H. elim (rem_589 X1 X2 H).
  intros X1 X2. intro H. elim (rem_601 X1 X2 H).
  exact (rem_574 epsilon_m__type_2_pagent ).
  intros X1 X2. intro H. elim (rem_603 X1 X2 H).
   intro H. elim (rem_586  H).
  intros X1 X2. intro H. elim (rem_596 X1 X2 H).
  intros X1 X2. intro H. elim (rem_591 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_598 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_592 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_597  H).
   intro H. elim (rem_602  H).
  intros X1. intro H. elim (rem_584 X1 H).
  exact (rem_577 epsilon_m__type_2_pagent ).
  intros X1 X2 X3. intro H. elim (rem_588 X1 X2 X3 H).
   intro H. elim (rem_590  H).
  intros X1 X2. intro H. elim (rem_593 X1 X2 H).
  intros X1 X2. intro H. elim (rem_587 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_604 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_599 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_595 X1 X2 H).
  intros X1 X2. intro H. elim (rem_585 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_594 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_600 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_606 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto_agent X2). tauto. exact (rem_605 X2).
Qed.

Remark rem_607 : forall X2:term, auto___type_2 X2 -> auto___type_2 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_608 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_607 X2).
Qed.

Remark rem_609 : forall X3:term, auto___def_15 X3 -> auto___def_15 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_610 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_15 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_15 X3 -> auto___def_15 X3). tauto. exact (rem_609 X3).
Qed.

Remark rem_611 : forall X4:term, auto___def_18 X4 -> auto___def_18 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_612 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_18 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_18 X4 -> auto___def_18 X4). tauto. exact (rem_611 X4).
Qed.

Remark rem_613 : forall X5:term, auto___def_12 X5 -> auto___def_12 X5. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_614 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_12 X5. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_12 X5). tauto. exact (rem_613 X5).
Qed.

Remark rem_615 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> (auto_agent X1 /\ auto___type_1 X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_15 X3 /\ auto___def_18 X4 /\ auto___def_12 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_559 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_1 X1). 2:apply (rem_570 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_606 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_608 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_15 X3). 2:apply (rem_610 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_18 X4). 2:apply (rem_612 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_12 X5). 2:apply (rem_614 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_616 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_615 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_22_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_617 : forall X1 X2 X3 X4 X5:term, auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___def_12 X5 -> auto___def_15 X3 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_616 X1 X2 X3 X4 X5).
Qed.

Remark rem_618 : forall X1 X2:term, auto___def_17 (crypt X1 X2) -> or_1
    (auto___def_18 X1 /\ auto___def_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_619 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_618 X4 (key pub X2) H);  intros.
  apply (rem_617 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_620 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto.
  exact (rem_619 X1 X2 X3 X4 X5).
Qed.

Remark rem_621 : forall X1 X2 X3 X4 X5:term, auto___def_17 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___def_12 X5 -> auto___def_15 X3 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_620 X1 X2 X3 X4 X5).
Qed.

Remark rem_622 : forall X1 X2:term, auto___def_16 (cons X1 X2) -> or_1
    (auto___def_17 X1 /\ auto___def_9 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_623 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_16 (cons (crypt X4 (key pub X2)) nil) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_622 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_621 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_624 : forall X1 X2 X3 X4 X5:term, auto___def_15 X3 -> auto___def_16 (cons (crypt X4 (key pub X2)) nil) -> auto___def_12 X5 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_16 (cons (crypt X4 (key pub X2)) nil) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_623 X1 X2 X3 X4 X5).
Qed.

Remark rem_625 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_14 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_267 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_624 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_626 : forall X1 X2 X3 X4 X5:term, auto___type_2 X2 -> auto___def_14 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___def_12 X5 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_14 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_625 X1 X2 X3 X4 X5).
Qed.

Remark rem_627 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_270 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_626 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_628 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_21 prv -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto.
  exact (rem_627 X1 X2 X3 X4 X5).
Qed.

Remark rem_629 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto_agent X1 -> auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_21 prv -> auto_agent X1 -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_628 X1 X2 X3 X4 X5).
Qed.

Remark rem_630 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key prv X1) -> auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 prv X1 H);  intros.
  apply (rem_629 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_631 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_11 (key prv X1) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key prv X1) -> auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_630 X1 X2 X3 X4 X5).
Qed.

Remark rem_632 : forall X1 X2 X3 X4 X5:term, auto___def_10 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_11 (key prv X1) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_276 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_631 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_633 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___type_3 X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_30 prv X1 H);  intros.
Qed.

Remark rem_634 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_38 pub -> auto___type_3 X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___type_3 X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5). tauto.
  exact (rem_633 X1 X2 X3 X4 X5).
Qed.

Remark rem_635 : forall X1 X2 X3 X4 X5:term, auto___def_38 pub -> auto___type_3 X2 -> auto___def_26 X4 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___def_38 pub -> auto___type_3 X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_634 X1 X2 X3 X4 X5).
Qed.

Remark rem_636 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_27 (key pub X2) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_16 pub X2 H);  intros.
  apply (rem_635 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_637 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___type_6 X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_30 prv X1 H);  intros.
Qed.

Remark rem_638 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_45 pub -> auto___type_6 X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___type_6 X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5). tauto.
  exact (rem_637 X1 X2 X3 X4 X5).
Qed.

Remark rem_639 : forall X1 X2 X3 X4 X5:term, auto___def_45 pub -> auto___type_6 X2 -> auto___def_43 X4 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___def_45 pub -> auto___type_6 X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_638 X1 X2 X3 X4 X5).
Qed.

Remark rem_640 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_44 (key pub X2) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_22 pub X2 H);  intros.
  apply (rem_639 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_641 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto_agent X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_30 prv X1 H);  intros.
Qed.

Remark rem_642 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_21 pub -> auto_agent X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto_agent X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5). tauto.
  exact (rem_641 X1 X2 X3 X4 X5).
Qed.

Remark rem_643 : forall X1 X2 X3 X4 X5:term, auto___def_21 pub -> auto_agent X2 -> auto___def_10 X4 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto___def_21 pub -> auto_agent X2 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_642 X1 X2 X3 X4 X5).
Qed.

Remark rem_644 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_11 (key pub X2) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_28 pub X2 H);  intros.
  apply (rem_643 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_645 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto_knows_old (key pub X2) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_30 prv X1 H);  intros.
Qed.

Remark rem_646 : forall X1 X2 X3 X4 X5:term, auto_knows_old X4 -> auto_knows_old (key pub X2) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto_knows_old (key pub X2) -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_645 X1 X2 X3 X4 X5).
Qed.

Remark rem_647 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (crypt X4 (key pub X2)) -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_32 X4 (key pub X2) H);  intros.
  apply (rem_636 X1 X2 X3 X4 X5);  tauto.
  apply (rem_640 X1 X2 X3 X4 X5);  tauto.
  apply (rem_644 X1 X2 X3 X4 X5);  tauto.
  apply (rem_646 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_648 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (crypt X4 (key pub X2)) -> auto_knows_old (key prv X1) -> auto_knows_old nil -> auto___def_22 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (crypt X4 (key pub X2)) -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5). tauto.
  exact (rem_647 X1 X2 X3 X4 X5).
Qed.

Remark rem_649 : forall X1 X2 X3 X4 X5:term, auto_knows_old (crypt X4 (key pub X2)) -> auto_knows_old nil -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (crypt X4 (key pub X2)) -> auto_knows_old (key prv X1) -> auto_knows_old nil -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_648 X1 X2 X3 X4 X5).
Qed.

Remark rem_650 : forall X1 X2:term, auto_knows_old (cons X1 X2) -> or_1
    (auto_knows_old X1 /\ auto_knows_old X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_651 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (cons (crypt X4 (key pub X2)) nil) -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_650 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_649 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_652 : forall X1 X2 X3 X4 X5:term, auto_knows_old X3 -> auto_knows_old (cons (crypt X4 (key pub X2)) nil) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (cons (crypt X4 (key pub X2)) nil) -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_651 X1 X2 X3 X4 X5).
Qed.

Remark rem_653 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X5 -> auto_knows_old (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3. intro H. intros.
  elim (rem_650 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_652 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_654 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto_knows_old X1 -> auto_knows_old X5 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X5 -> auto_knows_old (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_653 X1 X2 X3 X4 X5).
Qed.

Remark rem_655 : forall X1 X2 X3 X4 X5:term, auto_knows_old X1 -> auto_knows_old X5 -> auto_knows_old (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_650 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_654 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_656 : forall X1 X2 X3 X4 X5:term, auto_knows_old X5 -> auto_knows_old (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_old X1 -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X1 -> auto_knows_old X5 -> auto_knows_old (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_655 X1 X2 X3 X4 X5).
Qed.

Remark rem_657 : forall X1 X2 X3 X4 X5:term, auto_knows_old X1 -> auto_knows_old (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_650 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_656 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_658 : forall X1 X2 X3 X4 X5:term, auto_knows_old (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_old (key prv X1) -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X1 -> auto_knows_old (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_old (key prv X1) -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_657 X1 X2 X3 X4 X5).
Qed.

Remark rem_659 : forall X1 X2 X3 X4 X5:term, auto_knows_old X1 -> auto_knows_old (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_32 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1) H);  intros.
  apply (rem_555 X1 X2 X3 X4 X5);  tauto.
  apply (rem_558 X1 X2 X3 X4 X5);  tauto.
  apply (rem_632 X1 X2 X3 X4 X5);  tauto.
  apply (rem_658 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_660 : forall X1 X2 X3 X4 X5:term, auto_knows_old X1 -> auto_knows_old (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_old nil -> auto___def_22 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X1 -> auto_knows_old (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_22 X1 X2 X3 X4 X5). tauto.
  exact (rem_659 X1 X2 X3 X4 X5).
Qed.

Remark rem_661 : forall X1 X2 X3 X4 X5:term, auto_knows_old (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_old nil -> auto_knows_old X1 -> auto___def_22 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X1 -> auto_knows_old (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_old nil -> auto___def_22 X1 X2 X3 X4 X5). tauto. exact (rem_660 X1 X2 X3 X4 X5).
Qed.

Remark rem_662 : forall X1 X2 X3 X4 X5:term, auto_knows_old X1 -> auto_knows_old (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_650 (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil H);  intros.
  apply (rem_661 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_663 : forall X1 X2 X3 X4 X5:term, auto_knows_old (cons X1 (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil)) -> auto___def_22 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_650 X1 (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) H);  intros.
  apply (rem_662 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_664 : auto___def_9 nil. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_9_nil_1;  tauto.
 tauto.
Qed.

Remark rem_665 : forall X1:term, auto___def_81 X1 -> auto___def_81 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_666 : forall X1 X2:term, auto___def_72 X2 -> auto___def_81 X1 -> auto___def_81 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_81 X1 -> auto___def_81 X1). tauto. exact (rem_665 X1).
Qed.

Remark rem_667 : forall X2:term, auto___def_72 X2 -> auto___def_72 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_668 : forall X1 X2:term, auto___def_72 X2 -> auto___def_81 X1 -> auto___def_72 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_72 X2 -> auto___def_72 X2). tauto. exact (rem_667 X2).
Qed.

Remark rem_669 : forall X1 X2:term, auto___def_72 X2 -> auto___def_81 X1 -> (auto___def_81 X1 /\ auto___def_72 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_81 X1). 2:apply (rem_666 X1 X2);  assumption.
  cut (auto___def_72 X2). 2:apply (rem_668 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_670 : forall X1 X2:term, auto___def_72 X2 -> auto___def_81 X1 -> auto___def_80 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_669 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_80_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_671 : (forall X:term, auto___type_4 X -> auto___type_6 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_p__type_6.  tauto.
Defined.

Remark rem_672 : (forall X:term, auto___type_4 X -> auto___type_6 X)
    -> auto___type_6 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_p__type_6.  case (rem_671 epsilon_m__type_4_p__type_6). clear  epsilon_m__type_4_p__type_6. intros. apply trans___type_6_i_1;  tauto.
 clear  epsilon_m__type_4_p__type_6. tauto.
Defined.

Remark rem_673 : auto___type_4 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_674 : (forall X:term, auto___type_4 X -> auto___type_6 X)
    -> auto___type_4 i -> auto___type_6 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_p__type_6. intro H. intros.
  elim (rem_673 H);  intros.
  apply (rem_672 epsilon_m__type_4_p__type_6);  tauto.
Defined.

Remark rem_675 : (forall X:term, auto___type_4 X -> auto___type_6 X)
    -> auto___type_6 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_p__type_6.  case (rem_671 epsilon_m__type_4_p__type_6). clear  epsilon_m__type_4_p__type_6. intros. apply trans___type_6_server_1;  tauto.
 clear  epsilon_m__type_4_p__type_6. tauto.
Defined.

Remark rem_676 : auto___type_4 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_677 : (forall X:term, auto___type_4 X -> auto___type_6 X)
    -> auto___type_4 server -> auto___type_6 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_p__type_6. intro H. intros.
  elim (rem_676 H);  intros.
  apply (rem_675 epsilon_m__type_4_p__type_6);  tauto.
Defined.

Remark rem_678 : (forall X:term, auto___type_4 X -> auto___type_6 X)
    -> auto___type_6 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_p__type_6.  case (rem_671 epsilon_m__type_4_p__type_6). clear  epsilon_m__type_4_p__type_6. intros. apply trans___type_6_bob_1;  tauto.
 clear  epsilon_m__type_4_p__type_6. tauto.
Defined.

Remark rem_679 : auto___type_4 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_680 : (forall X:term, auto___type_4 X -> auto___type_6 X)
    -> auto___type_4 bob -> auto___type_6 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_p__type_6. intro H. intros.
  elim (rem_679 H);  intros.
  apply (rem_678 epsilon_m__type_4_p__type_6);  tauto.
Defined.

Remark rem_681 : (forall X:term, auto___type_4 X -> auto___type_6 X)
    -> auto___type_6 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_p__type_6.  case (rem_671 epsilon_m__type_4_p__type_6). clear  epsilon_m__type_4_p__type_6. intros. apply trans___type_6_alice_1;  tauto.
 clear  epsilon_m__type_4_p__type_6. tauto.
Defined.

Remark rem_682 : auto___type_4 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_683 : (forall X:term, auto___type_4 X -> auto___type_6 X)
    -> auto___type_4 alice -> auto___type_6 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_p__type_6. intro H. intros.
  elim (rem_682 H);  intros.
  apply (rem_681 epsilon_m__type_4_p__type_6);  tauto.
Defined.

Remark rem_684 : forall X1:term, auto___type_4 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_685 : forall X1 X2:term, auto___type_4 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_686 : auto___type_4 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_687 : forall X1 X2:term, auto___type_4 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_688 : forall X1 X2 X3:term, auto___type_4 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_689 : forall X1 X2:term, auto___type_4 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_690 : auto___type_4 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_691 : forall X1 X2:term, auto___type_4 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_692 : forall X1 X2 X3 X4 X5:term, auto___type_4 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_693 : forall X1 X2:term, auto___type_4 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_694 : forall X1 X2 X3 X4 X5:term, auto___type_4 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_695 : forall X1 X2:term, auto___type_4 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_696 : forall X1 X2:term, auto___type_4 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_697 : auto___type_4 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_698 : forall X1 X2 X3 X4 X5:term, auto___type_4 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_699 : forall X1 X2 X3 X4 X5:term, auto___type_4 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_700 : forall X1 X2 X3 X4 X5:term, auto___type_4 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_701 : forall X1 X2:term, auto___type_4 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_702 : auto___type_4 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_703 : forall X1 X2:term, auto___type_4 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_704 : forall X1 X2 X3 X4 X5:term, auto___type_4 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_705 : forall X1:term, auto___type_4 X1 -> auto___type_6 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_4_p__type_6 1.
  intro X. case X.
  exact (rem_683 epsilon_m__type_4_p__type_6 ).
  exact (rem_680 epsilon_m__type_4_p__type_6 ).
  intros X1 X2. intro H. elim (rem_689 X1 X2 H).
  intros X1 X2. intro H. elim (rem_701 X1 X2 H).
  exact (rem_674 epsilon_m__type_4_p__type_6 ).
  intros X1 X2. intro H. elim (rem_703 X1 X2 H).
   intro H. elim (rem_686  H).
  intros X1 X2. intro H. elim (rem_696 X1 X2 H).
  intros X1 X2. intro H. elim (rem_691 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_698 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_692 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_697  H).
   intro H. elim (rem_702  H).
  intros X1. intro H. elim (rem_684 X1 H).
  exact (rem_677 epsilon_m__type_4_p__type_6 ).
  intros X1 X2 X3. intro H. elim (rem_688 X1 X2 X3 H).
   intro H. elim (rem_690  H).
  intros X1 X2. intro H. elim (rem_693 X1 X2 H).
  intros X1 X2. intro H. elim (rem_687 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_704 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_699 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_695 X1 X2 H).
  intros X1 X2. intro H. elim (rem_685 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_694 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_700 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_706 : forall X1 X2 X3 X4 X5:term, auto___def_28 X2 -> auto___def_32 X3 -> auto___def_35 X4 -> auto___type_3 X5 -> auto___type_4 X1 -> auto_agent X5 -> auto_agent X1 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_4 X1 -> auto___type_6 X1). tauto. exact (rem_705 X1).
Qed.

Remark rem_707 : forall X1 X2 X3 X4 X5:term, auto___type_4 X1 -> auto_agent X1 -> auto_agent X2 -> auto___type_3 X2 -> auto___def_28 X3 -> auto___def_35 X4 -> auto___def_32 X5 -> auto___type_6 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X5 X2 X4 X3.
  cut (auto___def_28 X2 -> auto___def_32 X3 -> auto___def_35 X4 -> auto___type_3 X5 -> auto___type_4 X1 -> auto_agent X5 -> auto_agent X1 -> auto___type_6 X1). tauto. exact (rem_706 X1 X2 X3 X4 X5).
Qed.

Remark rem_708 : forall X1 X2 X3 X4 X5:term, auto___def_39 X1 X2 X3 X4 X5 -> or_1
    (auto___type_4 X1 /\ auto_agent X1 /\ auto_agent X2 /\ auto___type_3 X2 /\ auto___def_28 X3 /\ auto___def_35 X4 /\ auto___def_32 X5)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_709 : forall X1 X2 X3 X4 X5:term, auto___def_39 X1 X2 X3 X4 X5 -> auto___type_6 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_708 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_707 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_710 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_63 X1).
Qed.

Remark rem_711 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_pknows_current.  tauto.
Defined.

Remark rem_712 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_711 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_713 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_72 H);  intros.
  apply (rem_712 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_714 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_711 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_715 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_75 H);  intros.
  apply (rem_714 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_716 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_711 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_717 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_78 H);  intros.
  apply (rem_716 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_718 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_pknows_current.  case (rem_711 epsilon_magent_pknows_current). clear  epsilon_magent_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_magent_pknows_current. tauto.
Defined.

Remark rem_719 : (forall X:term, auto_agent X -> auto_knows_current X)
    -> auto_agent alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_pknows_current. intro H. intros.
  elim (rem_81 H);  intros.
  apply (rem_718 epsilon_magent_pknows_current);  tauto.
Defined.

Remark rem_720 : forall X1:term, auto_agent X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_magent_pknows_current 1.
  intro X. case X.
  exact (rem_719 epsilon_magent_pknows_current ).
  exact (rem_717 epsilon_magent_pknows_current ).
  intros X1 X2. intro H. elim (rem_88 X1 X2 H).
  intros X1 X2. intro H. elim (rem_100 X1 X2 H).
  exact (rem_713 epsilon_magent_pknows_current ).
  intros X1 X2. intro H. elim (rem_102 X1 X2 H).
   intro H. elim (rem_85  H).
  intros X1 X2. intro H. elim (rem_95 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_97 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_91 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_96  H).
   intro H. elim (rem_101  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_715 epsilon_magent_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_87 X1 X2 X3 H).
   intro H. elim (rem_89  H).
  intros X1 X2. intro H. elim (rem_92 X1 X2 H).
  intros X1 X2. intro H. elim (rem_86 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_103 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_98 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_94 X1 X2 H).
  intros X1 X2. intro H. elim (rem_84 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_93 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_99 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_721 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto_knows_current X1). tauto. exact (rem_720 X1).
Qed.

Remark rem_722 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto_agent X2). tauto. exact (rem_605 X2).
Qed.

Remark rem_723 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_607 X2).
Qed.

Remark rem_724 : forall X3:term, auto___def_62 X3 -> auto___def_62 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_725 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_62 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X3 -> auto___def_62 X3). tauto. exact (rem_724 X3).
Qed.

Remark rem_726 : forall X4:term, auto___def_65 X4 -> auto___def_65 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_727 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_65 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_65 X4 -> auto___def_65 X4). tauto. exact (rem_726 X4).
Qed.

Remark rem_728 : forall X5:term, auto___def_68 X5 -> auto___def_68 X5. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_729 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_68 X5. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_68 X5 -> auto___def_68 X5). tauto. exact (rem_728 X5).
Qed.

Remark rem_730 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> (auto_agent X1 /\ auto_knows_current X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_62 X3 /\ auto___def_65 X4 /\ auto___def_68 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_710 X1 X2 X3 X4 X5);  assumption.
  cut (auto_knows_current X1). 2:apply (rem_721 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_722 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_723 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_62 X3). 2:apply (rem_725 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_65 X4). 2:apply (rem_727 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_68 X5). 2:apply (rem_729 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_731 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_82 (yb_current X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_730 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_82_yb_current_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_732 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_62 X3 -> auto___def_82 (yb_current X1 X2 X3 X4 X5). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_82 (yb_current X1 X2 X3 X4 X5)). tauto. exact (rem_731 X1 X2 X3 X4 X5).
Qed.

Remark rem_733 : (forall X:term, auto___type_1 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_1_pagent.  tauto.
Defined.

Remark rem_734 : (forall X:term, auto___type_1 X -> auto_agent X)
    -> auto_agent i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pagent.  case (rem_733 epsilon_m__type_1_pagent). clear  epsilon_m__type_1_pagent. intros. apply trans_agent_i_1;  tauto.
 clear  epsilon_m__type_1_pagent. tauto.
Defined.

Remark rem_735 : (forall X:term, auto___type_1 X -> auto_agent X)
    -> auto___type_1 i -> auto_agent i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pagent. intro H. intros.
  elim (rem_396 H);  intros.
  apply (rem_734 epsilon_m__type_1_pagent);  tauto.
Defined.

Remark rem_736 : (forall X:term, auto___type_1 X -> auto_agent X)
    -> auto_agent server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pagent.  case (rem_733 epsilon_m__type_1_pagent). clear  epsilon_m__type_1_pagent. intros. apply trans_agent_server_1;  tauto.
 clear  epsilon_m__type_1_pagent. tauto.
Defined.

Remark rem_737 : (forall X:term, auto___type_1 X -> auto_agent X)
    -> auto___type_1 server -> auto_agent server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pagent. intro H. intros.
  elim (rem_399 H);  intros.
  apply (rem_736 epsilon_m__type_1_pagent);  tauto.
Defined.

Remark rem_738 : (forall X:term, auto___type_1 X -> auto_agent X)
    -> auto_agent bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pagent.  case (rem_733 epsilon_m__type_1_pagent). clear  epsilon_m__type_1_pagent. intros. apply trans_agent_bob_1;  tauto.
 clear  epsilon_m__type_1_pagent. tauto.
Defined.

Remark rem_739 : (forall X:term, auto___type_1 X -> auto_agent X)
    -> auto___type_1 bob -> auto_agent bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pagent. intro H. intros.
  elim (rem_402 H);  intros.
  apply (rem_738 epsilon_m__type_1_pagent);  tauto.
Defined.

Remark rem_740 : (forall X:term, auto___type_1 X -> auto_agent X)
    -> auto_agent alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pagent.  case (rem_733 epsilon_m__type_1_pagent). clear  epsilon_m__type_1_pagent. intros. apply trans_agent_alice_1;  tauto.
 clear  epsilon_m__type_1_pagent. tauto.
Defined.

Remark rem_741 : (forall X:term, auto___type_1 X -> auto_agent X)
    -> auto___type_1 alice -> auto_agent alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pagent. intro H. intros.
  elim (rem_405 H);  intros.
  apply (rem_740 epsilon_m__type_1_pagent);  tauto.
Defined.

Remark rem_742 : forall X1:term, auto___type_1 X1 -> auto_agent X1. (* Induct. *)
Proof.
  fix epsilon_m__type_1_pagent 1.
  intro X. case X.
  exact (rem_741 epsilon_m__type_1_pagent ).
  exact (rem_739 epsilon_m__type_1_pagent ).
  intros X1 X2. intro H. elim (rem_412 X1 X2 H).
  intros X1 X2. intro H. elim (rem_424 X1 X2 H).
  exact (rem_735 epsilon_m__type_1_pagent ).
  intros X1 X2. intro H. elim (rem_426 X1 X2 H).
   intro H. elim (rem_409  H).
  intros X1 X2. intro H. elim (rem_419 X1 X2 H).
  intros X1 X2. intro H. elim (rem_414 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_421 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_415 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_420  H).
   intro H. elim (rem_425  H).
  intros X1. intro H. elim (rem_407 X1 H).
  exact (rem_737 epsilon_m__type_1_pagent ).
  intros X1 X2 X3. intro H. elim (rem_411 X1 X2 X3 H).
   intro H. elim (rem_413  H).
  intros X1 X2. intro H. elim (rem_416 X1 X2 H).
  intros X1 X2. intro H. elim (rem_410 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_427 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_422 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_418 X1 X2 H).
  intros X1 X2. intro H. elim (rem_408 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_417 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_423 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_743 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_1 X1 -> auto_agent X1). tauto. exact (rem_742 X1).
Qed.

Remark rem_744 : forall X1:term, auto___type_1 X1 -> auto___type_1 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_745 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___type_1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_1 X1 -> auto___type_1 X1). tauto. exact (rem_744 X1).
Qed.

Remark rem_746 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto_agent X2). tauto. exact (rem_605 X2).
Qed.

Remark rem_747 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_607 X2).
Qed.

Remark rem_748 : forall X3:term, auto___def_12 X3 -> auto___def_12 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_749 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_12 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_12 X3). tauto. exact (rem_748 X3).
Qed.

Remark rem_750 : forall X4:term, auto___def_15 X4 -> auto___def_15 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_751 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_15 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_15 X4 -> auto___def_15 X4). tauto. exact (rem_750 X4).
Qed.

Remark rem_752 : forall X5:term, auto___def_18 X5 -> auto___def_18 X5. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_753 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_18 X5. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_18 X5 -> auto___def_18 X5). tauto. exact (rem_752 X5).
Qed.

Remark rem_754 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> (auto_agent X1 /\ auto___type_1 X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_12 X3 /\ auto___def_15 X4 /\ auto___def_18 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_743 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_1 X1). 2:apply (rem_745 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_746 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_747 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_12 X3). 2:apply (rem_749 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_15 X4). 2:apply (rem_751 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_18 X5). 2:apply (rem_753 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_755 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_82 (yb_current X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_754 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_82_yb_current_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_756 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_12 X3 -> auto___def_82 (yb_current X1 X2 X3 X4 X5). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_82 (yb_current X1 X2 X3 X4 X5)). tauto. exact (rem_755 X1 X2 X3 X4 X5).
Qed.

Remark rem_757 : forall X1 X2 X3 X4 X5:term, auto___def_69 X1 X2 X3 X4 X5 -> or_2
    (auto_agent X1 /\ auto_knows_current X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_65 X3 /\ auto___def_68 X4 /\ auto___def_62 X5)
    (auto_agent X1 /\ auto___type_1 X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_15 X3 /\ auto___def_18 X4 /\ auto___def_12 X5)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_758 : forall X1 X2 X3 X4 X5:term, auto___def_69 X1 X2 X4 X5 X3 -> auto___def_82 (yb_current X1 X2 X3 X4 X5). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_757 X1 X2 X4 X5 X3 H);  intros.
  apply (rem_732 X1 X2 X3 X4 X5);  tauto.
  apply (rem_756 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_759 : forall X1 X2:term, auto___def_26 X1 -> auto___def_38 sym -> auto___type_3 X2 -> auto___def_57 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_38 sym -> False). tauto.
  exact (rem_13).
Qed.

Remark rem_760 : forall X1 X2:term, auto___def_38 sym -> auto___type_3 X2 -> auto___def_26 X1 -> auto___def_57 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 X1 -> auto___def_38 sym -> auto___type_3 X2 -> auto___def_57 X1 X2). tauto. exact (rem_759 X1 X2).
Qed.

Remark rem_761 : forall X1 X2:term, auto___def_26 X1 -> auto___def_27 (key sym X2) -> auto___def_57 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_16 sym X2 H);  intros.
  apply (rem_760 X1 X2);  tauto.
Qed.

Remark rem_762 : auto___def_92 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_763 : auto___def_92 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_762 H);  intros.
Qed.

Remark rem_764 : forall X1 X2:term, auto___def_90 X1 -> auto___def_92 sym -> auto___type_15 X2 -> auto___def_57 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_92 sym -> False). tauto.
  exact (rem_763).
Qed.

Remark rem_765 : forall X1 X2:term, auto___def_92 sym -> auto___type_15 X2 -> auto___def_90 X1 -> auto___def_57 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_90 X1 -> auto___def_92 sym -> auto___type_15 X2 -> auto___def_57 X1 X2). tauto. exact (rem_764 X1 X2).
Qed.

Remark rem_766 : forall X1 X2:term, auto___def_90 X1 -> auto___def_91 (key sym X2) -> auto___def_57 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_318 sym X2 H);  intros.
  apply (rem_765 X1 X2);  tauto.
Qed.

Remark rem_767 : auto___def_85 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_768 : auto___def_85 sym -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_767 H);  intros.
Qed.

Remark rem_769 : forall X1 X2:term, auto___def_73 X1 -> auto___def_85 sym -> auto___type_12 X2 -> auto___def_57 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_85 sym -> False). tauto.
  exact (rem_768).
Qed.

Remark rem_770 : forall X1 X2:term, auto___def_85 sym -> auto___type_12 X2 -> auto___def_73 X1 -> auto___def_57 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_73 X1 -> auto___def_85 sym -> auto___type_12 X2 -> auto___def_57 X1 X2). tauto. exact (rem_769 X1 X2).
Qed.

Remark rem_771 : forall X1 X2:term, auto___def_73 X1 -> auto___def_74 (key sym X2) -> auto___def_57 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_240 sym X2 H);  intros.
  apply (rem_770 X1 X2);  tauto.
Qed.

Remark rem_772 : forall X1 X2:term, auto___def_43 X1 -> auto___def_45 sym -> auto___type_6 X2 -> auto___def_57 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_45 sym -> False). tauto.
  exact (rem_19).
Qed.

Remark rem_773 : forall X1 X2:term, auto___def_45 sym -> auto___type_6 X2 -> auto___def_43 X1 -> auto___def_57 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_45 sym -> auto___type_6 X2 -> auto___def_57 X1 X2). tauto. exact (rem_772 X1 X2).
Qed.

Remark rem_774 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 (key sym X2) -> auto___def_57 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_22 sym X2 H);  intros.
  apply (rem_773 X1 X2);  tauto.
Qed.

Remark rem_775 : forall X1 X2:term, auto___def_21 sym -> auto___def_61 X1 -> auto_agent X2 -> auto___def_57 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 sym -> False). tauto.
  exact (rem_25).
Qed.

Remark rem_776 : forall X1 X2:term, auto___def_21 sym -> auto_agent X2 -> auto___def_61 X1 -> auto___def_57 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_21 sym -> auto___def_61 X1 -> auto_agent X2 -> auto___def_57 X1 X2). tauto. exact (rem_775 X1 X2).
Qed.

Remark rem_777 : forall X1 X2:term, auto___def_11 (key sym X2) -> auto___def_61 X1 -> auto___def_57 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_28 sym X2 H);  intros.
  apply (rem_776 X1 X2);  tauto.
Qed.

Remark rem_778 : forall X1 X2:term, auto___def_61 X1 -> auto___def_11 (key sym X2) -> auto___def_57 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_11 (key sym X2) -> auto___def_61 X1 -> auto___def_57 X1 X2). tauto. exact (rem_777 X1 X2).
Qed.

Remark rem_779 : forall X1 X2:term, auto___def_10 X1 -> auto___def_21 sym -> auto_agent X2 -> auto___def_57 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 sym -> False). tauto.
  exact (rem_25).
Qed.

Remark rem_780 : forall X1 X2:term, auto___def_21 sym -> auto_agent X2 -> auto___def_10 X1 -> auto___def_57 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_21 sym -> auto_agent X2 -> auto___def_57 X1 X2). tauto. exact (rem_779 X1 X2).
Qed.

Remark rem_781 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 (key sym X2) -> auto___def_57 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_28 sym X2 H);  intros.
  apply (rem_780 X1 X2);  tauto.
Qed.

Remark rem_782 : forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_783 : forall X1 X2:term, auto___def_51 sym -> auto___def_52 X2 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_782 X1).
Qed.

Remark rem_784 : forall X2:term, auto___def_52 X2 -> auto___def_52 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_785 : forall X1 X2:term, auto___def_51 sym -> auto___def_52 X2 -> auto_knows_current X1 -> auto___def_52 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_52 X2 -> auto___def_52 X2). tauto. exact (rem_784 X2).
Qed.

Remark rem_786 : forall X1 X2:term, auto___def_51 sym -> auto___def_52 X2 -> auto_knows_current X1 -> (auto_knows_current X1 /\ auto___def_52 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_knows_current X1). 2:apply (rem_783 X1 X2);  assumption.
  cut (auto___def_52 X2). 2:apply (rem_785 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_787 : forall X1 X2:term, auto___def_51 sym -> auto___def_52 X2 -> auto_knows_current X1 -> auto___def_57 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_786 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_57_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_788 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current (key sym X2) -> auto___def_57 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_309 sym X2 H);  intros.
  apply (rem_787 X1 X2);  tauto.
Qed.

Remark rem_789 : forall X1 X2:term, auto_knows_current (crypt X1 (key sym X2)) -> auto___def_57 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_346 X1 (key sym X2) H);  intros.
  apply (rem_761 X1 X2);  tauto.
  apply (rem_766 X1 X2);  tauto.
  apply (rem_771 X1 X2);  tauto.
  apply (rem_774 X1 X2);  tauto.
  apply (rem_778 X1 X2);  tauto.
  apply (rem_781 X1 X2);  tauto.
  apply (rem_788 X1 X2);  tauto.
Qed.

Remark rem_790 : forall X1 X2 X3 X4 X5:term, auto___def_48 X1 X2 X4 X5 X3 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1.
  tauto.
Qed.

Remark rem_791 : forall X1 X2 X3 X4 X5:term, auto___def_48 X1 X2 X4 X5 X3 -> auto___def_49 (xb_old X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1.
  case (rem_790 X1 X2 X3 X4 X5 A1). clear  A1. intros. apply trans___def_49_xb_old_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_792 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X4 -> auto___def_82 X5 -> auto___type_12 X2 -> auto___type_13 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_13 X1 -> auto_agent X1). tauto. exact (rem_172 X1).
Qed.

Remark rem_793 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X4 -> auto___def_82 X5 -> auto___type_12 X2 -> auto___type_13 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_13 X1 -> auto___type_13 X1). tauto. exact (rem_174 X1).
Qed.

Remark rem_794 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X4 -> auto___def_82 X5 -> auto___type_12 X2 -> auto___type_13 X1 -> auto_agent X2 -> auto_agent X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_12 X2 -> auto_agent X2). tauto. exact (rem_210 X2).
Qed.

Remark rem_795 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X4 -> auto___def_82 X5 -> auto___type_12 X2 -> auto___type_13 X1 -> auto_agent X2 -> auto_agent X1 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_212 X2).
Qed.

Remark rem_796 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X4 -> auto___def_82 X5 -> auto___type_12 X2 -> auto___type_13 X1 -> auto_agent X2 -> auto_agent X1 -> (auto_agent X1 /\ auto___type_13 X1 /\ auto_agent X2 /\ auto___type_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_792 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_13 X1). 2:apply (rem_793 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_794 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_795 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_797 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X4 -> auto___def_82 X5 -> auto___type_12 X2 -> auto___type_13 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_94 (ya_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_796 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_94_ya_current_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_798 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_13 X1 -> auto_agent X2 -> auto___type_12 X2 -> auto___def_75 X3 -> auto___def_82 X4 -> auto___def_79 X5 -> auto___def_94 (ya_current X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X5 X4.
  cut (auto___def_75 X3 -> auto___def_79 X4 -> auto___def_82 X5 -> auto___type_12 X2 -> auto___type_13 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_94 (ya_current X1 X2)). tauto. exact (rem_797 X1 X2 X3 X4 X5).
Qed.

Remark rem_799 : forall X1 X2 X3 X4 X5:term, auto___def_86 X1 X2 X3 X4 X5 -> auto___def_94 (ya_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_459 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_798 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_800 : forall X1:term, auto___def_79 X1 -> auto___def_79 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_801 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___def_79 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_79 X1 -> auto___def_79 X1). tauto. exact (rem_800 X1).
Qed.

Remark rem_802 : forall X2:term, auto___def_80 X2 -> auto___def_80 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_803 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___def_80 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_80 X2 -> auto___def_80 X2). tauto. exact (rem_802 X2).
Qed.

Remark rem_804 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> (auto___def_79 X1 /\ auto___def_80 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_79 X1). 2:apply (rem_801 X1 X2);  assumption.
  cut (auto___def_80 X2). 2:apply (rem_803 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_805 : forall X1 X2:term, auto___def_79 X1 -> auto___def_80 X2 -> auto___def_78 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_804 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_78_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_806 : forall X1 X2:term, auto___def_80 X2 -> auto___def_79 X1 -> auto___def_78 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_79 X1 -> auto___def_80 X2 -> auto___def_78 (cons X1 X2)). tauto. exact (rem_805 X1 X2).
Qed.

Remark rem_807 : forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_808 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_807 X1).
Qed.

Remark rem_809 : forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_810 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_809 X2).
Qed.

Remark rem_811 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_808 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_810 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_812 : forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_8 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_811 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_8_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_813 : forall X1 X2:term, auto___def_11 X2 -> auto___def_10 X1 -> auto___def_8 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_11 X2 -> auto___def_8 (crypt X1 X2)). tauto. exact (rem_812 X1 X2).
Qed.

Remark rem_814 : auto___def_37 pub. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_37_pub_1;  tauto.
 tauto.
Qed.

Remark rem_815 : forall X1:term, auto___def_68 X1 -> auto___def_68 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_816 : forall X1 X2:term, auto___def_19 X2 -> auto___def_68 X1 -> auto___def_68 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_68 X1 -> auto___def_68 X1). tauto. exact (rem_815 X1).
Qed.

Remark rem_817 : forall X2:term, auto___def_19 X2 -> auto___def_19 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_818 : forall X1 X2:term, auto___def_19 X2 -> auto___def_68 X1 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_817 X2).
Qed.

Remark rem_819 : forall X1 X2:term, auto___def_19 X2 -> auto___def_68 X1 -> (auto___def_68 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_68 X1). 2:apply (rem_816 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_818 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_820 : forall X1 X2:term, auto___def_19 X2 -> auto___def_68 X1 -> auto___def_67 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_819 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_67_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_821 : forall X1:term, auto___type_4 X1 -> auto___type_4 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_822 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_4 X1 -> auto___type_4 X1). tauto. exact (rem_821 X1).
Qed.

Remark rem_823 : (forall X:term, auto___type_4 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_4_pagent.  tauto.
Defined.

Remark rem_824 : (forall X:term, auto___type_4 X -> auto_agent X)
    -> auto_agent i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pagent.  case (rem_823 epsilon_m__type_4_pagent). clear  epsilon_m__type_4_pagent. intros. apply trans_agent_i_1;  tauto.
 clear  epsilon_m__type_4_pagent. tauto.
Defined.

Remark rem_825 : (forall X:term, auto___type_4 X -> auto_agent X)
    -> auto___type_4 i -> auto_agent i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pagent. intro H. intros.
  elim (rem_673 H);  intros.
  apply (rem_824 epsilon_m__type_4_pagent);  tauto.
Defined.

Remark rem_826 : (forall X:term, auto___type_4 X -> auto_agent X)
    -> auto_agent server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pagent.  case (rem_823 epsilon_m__type_4_pagent). clear  epsilon_m__type_4_pagent. intros. apply trans_agent_server_1;  tauto.
 clear  epsilon_m__type_4_pagent. tauto.
Defined.

Remark rem_827 : (forall X:term, auto___type_4 X -> auto_agent X)
    -> auto___type_4 server -> auto_agent server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pagent. intro H. intros.
  elim (rem_676 H);  intros.
  apply (rem_826 epsilon_m__type_4_pagent);  tauto.
Defined.

Remark rem_828 : (forall X:term, auto___type_4 X -> auto_agent X)
    -> auto_agent bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pagent.  case (rem_823 epsilon_m__type_4_pagent). clear  epsilon_m__type_4_pagent. intros. apply trans_agent_bob_1;  tauto.
 clear  epsilon_m__type_4_pagent. tauto.
Defined.

Remark rem_829 : (forall X:term, auto___type_4 X -> auto_agent X)
    -> auto___type_4 bob -> auto_agent bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pagent. intro H. intros.
  elim (rem_679 H);  intros.
  apply (rem_828 epsilon_m__type_4_pagent);  tauto.
Defined.

Remark rem_830 : (forall X:term, auto___type_4 X -> auto_agent X)
    -> auto_agent alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_4_pagent.  case (rem_823 epsilon_m__type_4_pagent). clear  epsilon_m__type_4_pagent. intros. apply trans_agent_alice_1;  tauto.
 clear  epsilon_m__type_4_pagent. tauto.
Defined.

Remark rem_831 : (forall X:term, auto___type_4 X -> auto_agent X)
    -> auto___type_4 alice -> auto_agent alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_4_pagent. intro H. intros.
  elim (rem_682 H);  intros.
  apply (rem_830 epsilon_m__type_4_pagent);  tauto.
Defined.

Remark rem_832 : forall X1:term, auto___type_4 X1 -> auto_agent X1. (* Induct. *)
Proof.
  fix epsilon_m__type_4_pagent 1.
  intro X. case X.
  exact (rem_831 epsilon_m__type_4_pagent ).
  exact (rem_829 epsilon_m__type_4_pagent ).
  intros X1 X2. intro H. elim (rem_689 X1 X2 H).
  intros X1 X2. intro H. elim (rem_701 X1 X2 H).
  exact (rem_825 epsilon_m__type_4_pagent ).
  intros X1 X2. intro H. elim (rem_703 X1 X2 H).
   intro H. elim (rem_686  H).
  intros X1 X2. intro H. elim (rem_696 X1 X2 H).
  intros X1 X2. intro H. elim (rem_691 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_698 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_692 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_697  H).
   intro H. elim (rem_702  H).
  intros X1. intro H. elim (rem_684 X1 H).
  exact (rem_827 epsilon_m__type_4_pagent ).
  intros X1 X2 X3. intro H. elim (rem_688 X1 X2 X3 H).
   intro H. elim (rem_690  H).
  intros X1 X2. intro H. elim (rem_693 X1 X2 H).
  intros X1 X2. intro H. elim (rem_687 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_704 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_699 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_695 X1 X2 H).
  intros X1 X2. intro H. elim (rem_685 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_694 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_700 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_833 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_4 X1 -> auto_agent X1). tauto. exact (rem_832 X1).
Qed.

Remark rem_834 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pagent.  tauto.
Defined.

Remark rem_835 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto_agent i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pagent.  case (rem_834 epsilon_m__type_3_pagent). clear  epsilon_m__type_3_pagent. intros. apply trans_agent_i_1;  tauto.
 clear  epsilon_m__type_3_pagent. tauto.
Defined.

Remark rem_836 : auto___type_3 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_837 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto___type_3 i -> auto_agent i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pagent. intro H. intros.
  elim (rem_836 H);  intros.
  apply (rem_835 epsilon_m__type_3_pagent);  tauto.
Defined.

Remark rem_838 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto_agent server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pagent.  case (rem_834 epsilon_m__type_3_pagent). clear  epsilon_m__type_3_pagent. intros. apply trans_agent_server_1;  tauto.
 clear  epsilon_m__type_3_pagent. tauto.
Defined.

Remark rem_839 : auto___type_3 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_840 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto___type_3 server -> auto_agent server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pagent. intro H. intros.
  elim (rem_839 H);  intros.
  apply (rem_838 epsilon_m__type_3_pagent);  tauto.
Defined.

Remark rem_841 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto_agent bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pagent.  case (rem_834 epsilon_m__type_3_pagent). clear  epsilon_m__type_3_pagent. intros. apply trans_agent_bob_1;  tauto.
 clear  epsilon_m__type_3_pagent. tauto.
Defined.

Remark rem_842 : auto___type_3 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_843 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto___type_3 bob -> auto_agent bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pagent. intro H. intros.
  elim (rem_842 H);  intros.
  apply (rem_841 epsilon_m__type_3_pagent);  tauto.
Defined.

Remark rem_844 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto_agent alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pagent.  case (rem_834 epsilon_m__type_3_pagent). clear  epsilon_m__type_3_pagent. intros. apply trans_agent_alice_1;  tauto.
 clear  epsilon_m__type_3_pagent. tauto.
Defined.

Remark rem_845 : auto___type_3 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_846 : (forall X:term, auto___type_3 X -> auto_agent X)
    -> auto___type_3 alice -> auto_agent alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pagent. intro H. intros.
  elim (rem_845 H);  intros.
  apply (rem_844 epsilon_m__type_3_pagent);  tauto.
Defined.

Remark rem_847 : forall X1:term, auto___type_3 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_848 : forall X1 X2:term, auto___type_3 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_849 : auto___type_3 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_850 : forall X1 X2:term, auto___type_3 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_851 : forall X1 X2 X3:term, auto___type_3 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_852 : forall X1 X2:term, auto___type_3 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_853 : auto___type_3 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_854 : forall X1 X2:term, auto___type_3 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_855 : forall X1 X2 X3 X4 X5:term, auto___type_3 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_856 : forall X1 X2:term, auto___type_3 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_857 : forall X1 X2 X3 X4 X5:term, auto___type_3 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_858 : forall X1 X2:term, auto___type_3 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_859 : forall X1 X2:term, auto___type_3 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_860 : auto___type_3 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_861 : forall X1 X2 X3 X4 X5:term, auto___type_3 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_862 : forall X1 X2 X3 X4 X5:term, auto___type_3 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_863 : forall X1 X2 X3 X4 X5:term, auto___type_3 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_864 : forall X1 X2:term, auto___type_3 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_865 : auto___type_3 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_866 : forall X1 X2:term, auto___type_3 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_867 : forall X1 X2 X3 X4 X5:term, auto___type_3 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_868 : forall X2:term, auto___type_3 X2 -> auto_agent X2. (* Induct. *)
Proof.
  fix epsilon_m__type_3_pagent 1.
  intro X. case X.
  exact (rem_846 epsilon_m__type_3_pagent ).
  exact (rem_843 epsilon_m__type_3_pagent ).
  intros X1 X2. intro H. elim (rem_852 X1 X2 H).
  intros X1 X2. intro H. elim (rem_864 X1 X2 H).
  exact (rem_837 epsilon_m__type_3_pagent ).
  intros X1 X2. intro H. elim (rem_866 X1 X2 H).
   intro H. elim (rem_849  H).
  intros X1 X2. intro H. elim (rem_859 X1 X2 H).
  intros X1 X2. intro H. elim (rem_854 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_861 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_855 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_860  H).
   intro H. elim (rem_865  H).
  intros X1. intro H. elim (rem_847 X1 H).
  exact (rem_840 epsilon_m__type_3_pagent ).
  intros X1 X2 X3. intro H. elim (rem_851 X1 X2 X3 H).
   intro H. elim (rem_853  H).
  intros X1 X2. intro H. elim (rem_856 X1 X2 H).
  intros X1 X2. intro H. elim (rem_850 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_867 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_862 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_858 X1 X2 H).
  intros X1 X2. intro H. elim (rem_848 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_857 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_863 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_869 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_3 X2 -> auto_agent X2). tauto. exact (rem_868 X2).
Qed.

Remark rem_870 : forall X2:term, auto___type_3 X2 -> auto___type_3 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_871 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___type_3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_3 X2 -> auto___type_3 X2). tauto. exact (rem_870 X2).
Qed.

Remark rem_872 : forall X3:term, auto___def_28 X3 -> auto___def_28 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_873 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_28 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_28 X3). tauto. exact (rem_872 X3).
Qed.

Remark rem_874 : forall X4:term, auto___def_35 X4 -> auto___def_35 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_875 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_35 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_35 X4 -> auto___def_35 X4). tauto. exact (rem_874 X4).
Qed.

Remark rem_876 : forall X5:term, auto___def_32 X5 -> auto___def_32 X5. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_877 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_32 X5. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_32 X5 -> auto___def_32 X5). tauto. exact (rem_876 X5).
Qed.

Remark rem_878 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> (auto___type_4 X1 /\ auto_agent X1 /\ auto_agent X2 /\ auto___type_3 X2 /\ auto___def_28 X3 /\ auto___def_35 X4 /\ auto___def_32 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7 A8.
  cut (auto___type_4 X1). 2:apply (rem_822 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X1). 2:apply (rem_833 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_869 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_3 X2). 2:apply (rem_871 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_28 X3). 2:apply (rem_873 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_35 X4). 2:apply (rem_875 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_32 X5). 2:apply (rem_877 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_879 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7 A8.
  case (rem_878 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7 A8). clear  A1 A2 A3 A4 A5 A6 A7 A8. intros. apply trans___def_39_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7 A8. tauto.
Qed.

Remark rem_880 : forall X1 X2 X3 X4 X5:term, auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___def_28 X3 -> auto___def_32 X5 -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_32 X5 -> auto___def_35 X4 -> auto___def_36 (key pub X1) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_879 X1 X2 X3 X4 X5).
Qed.

Remark rem_881 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_34 (crypt X4 (key pub X1)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_112 X4 (key pub X1) H);  intros.
  apply (rem_880 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_882 : forall X1 X2 X3 X4 X5:term, auto___def_25 nil -> auto___def_28 X3 -> auto___def_32 X5 -> auto___def_34 (crypt X4 (key pub X1)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_32 X5 -> auto___def_34 (crypt X4 (key pub X1)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto.
  exact (rem_881 X1 X2 X3 X4 X5).
Qed.

Remark rem_883 : forall X1 X2 X3 X4 X5:term, auto___def_34 (crypt X4 (key pub X1)) -> auto___def_25 nil -> auto___def_28 X3 -> auto___def_32 X5 -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_25 nil -> auto___def_28 X3 -> auto___def_32 X5 -> auto___def_34 (crypt X4 (key pub X1)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_882 X1 X2 X3 X4 X5).
Qed.

Remark rem_884 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_32 X5 -> auto___def_33 (cons (crypt X4 (key pub X1)) nil) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_116 (crypt X4 (key pub X1)) nil H);  intros.
  apply (rem_883 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_885 : forall X1 X2 X3 X4 X5:term, auto___def_32 X5 -> auto___def_33 (cons (crypt X4 (key pub X1)) nil) -> auto___def_28 X3 -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_32 X5 -> auto___def_33 (cons (crypt X4 (key pub X1)) nil) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_884 X1 X2 X3 X4 X5).
Qed.

Remark rem_886 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_31 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_119 X5 (cons (crypt X4 (key pub X1)) nil) H);  intros.
  apply (rem_885 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_887 : forall X1 X2 X3 X4 X5:term, auto___type_5 (noncea_old X1 X2) -> auto___def_31 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___def_28 X3 -> auto___type_3 X2 -> auto___type_4 X1 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_31 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_3 X2 -> auto___type_4 X1 -> auto___type_5 (noncea_old X1 X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_886 X1 X2 X3 X4 X5).
Qed.

Remark rem_888 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_30 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_3 X2 -> auto___type_4 X1 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_122 (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)) H);  intros.
  apply (rem_887 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_889 : forall X1 X2 X3 X4 X5:term, auto___type_4 X1 -> auto___def_30 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___def_28 X3 -> auto___type_3 X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_30 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_3 X2 -> auto___type_4 X1 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_888 X1 X2 X3 X4 X5).
Qed.

Remark rem_890 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___type_3 X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_125 X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) H);  intros.
  apply (rem_889 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_891 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_38 prv -> auto___type_3 X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___type_3 X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto.
  exact (rem_890 X1 X2 X3 X4 X5).
Qed.

Remark rem_892 : forall X1 X2 X3 X4 X5:term, auto___def_38 prv -> auto___type_3 X2 -> auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_38 prv -> auto___type_3 X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_891 X1 X2 X3 X4 X5).
Qed.

Remark rem_893 : forall X1 X2 X3 X4 X5:term, auto___def_27 (key prv X2) -> auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_16 prv X2 H);  intros.
  apply (rem_892 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_894 : forall X1 X2 X3 X4 X5:term, auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_27 (key prv X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_27 (key prv X2) -> auto___def_28 X3 -> auto___def_29 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_893 X1 X2 X3 X4 X5).
Qed.

Remark rem_895 : forall X1 X2 X3 X4 X5:term, auto___def_26 (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto___def_27 (key prv X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_131 X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) H);  intros.
  apply (rem_894 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_896 : forall X1 X2 X3 X4 X5:term, auto___def_28 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_44 (key prv X2) -> auto___type_3 X3 -> auto_agent X3 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_245 X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) H);  intros.
Qed.

Remark rem_897 : forall X1 X2 X3 X4 X5:term, auto_agent X3 -> auto___type_3 X3 -> auto___def_28 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_44 (key prv X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_44 (key prv X2) -> auto___type_3 X3 -> auto_agent X3 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_896 X1 X2 X3 X4 X5).
Qed.

Remark rem_898 : forall X1 X2 X3 X4 X5:term, auto___def_43 (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto___def_44 (key prv X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_248 X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) H);  intros.
  apply (rem_897 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_899 : forall X1 X2:term, auto___def_15 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_900 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 (noncea_old X1 X2) -> auto___def_16 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_899 X1 X2 H);  intros.
Qed.

Remark rem_901 : forall X1 X2 X3 X4 X5:term, auto___def_15 (noncea_old X1 X2) -> auto___def_16 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___def_12 X3 -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_15 (noncea_old X1 X2) -> auto___def_16 (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_900 X1 X2 X3 X4 X5).
Qed.

Remark rem_902 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_14 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_267 (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)) H);  intros.
  apply (rem_901 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_903 : forall X1 X2 X3 X4 X5:term, auto___type_2 X1 -> auto___def_14 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___def_12 X3 -> auto_agent X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_14 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto___type_2 X1 -> auto_agent X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_902 X1 X2 X3 X4 X5).
Qed.

Remark rem_904 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_agent X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_270 X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) H);  intros.
  apply (rem_903 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_905 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_21 prv -> auto_agent X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_agent X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto.
  exact (rem_904 X1 X2 X3 X4 X5).
Qed.

Remark rem_906 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto_agent X2 -> auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_21 prv -> auto_agent X2 -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_905 X1 X2 X3 X4 X5).
Qed.

Remark rem_907 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key prv X2) -> auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 prv X2 H);  intros.
  apply (rem_906 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_908 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto___def_11 (key prv X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key prv X2) -> auto___def_12 X3 -> auto___def_13 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_907 X1 X2 X3 X4 X5).
Qed.

Remark rem_909 : forall X1 X2 X3 X4 X5:term, auto___def_10 (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto___def_11 (key prv X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_276 X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) H);  intros.
  apply (rem_908 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_910 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___type_3 X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_30 prv X2 H);  intros.
Qed.

Remark rem_911 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_38 pub -> auto___type_3 X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___type_3 X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto.
  exact (rem_910 X1 X2 X3 X4 X5).
Qed.

Remark rem_912 : forall X1 X2 X3 X4 X5:term, auto___def_38 pub -> auto___type_3 X1 -> auto___def_26 X4 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___def_38 pub -> auto___type_3 X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_911 X1 X2 X3 X4 X5).
Qed.

Remark rem_913 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_27 (key pub X1) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_16 pub X1 H);  intros.
  apply (rem_912 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_914 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___type_6 X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_30 prv X2 H);  intros.
Qed.

Remark rem_915 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_45 pub -> auto___type_6 X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___type_6 X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto.
  exact (rem_914 X1 X2 X3 X4 X5).
Qed.

Remark rem_916 : forall X1 X2 X3 X4 X5:term, auto___def_45 pub -> auto___type_6 X1 -> auto___def_43 X4 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___def_45 pub -> auto___type_6 X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_915 X1 X2 X3 X4 X5).
Qed.

Remark rem_917 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_44 (key pub X1) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_22 pub X1 H);  intros.
  apply (rem_916 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_918 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto_agent X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_30 prv X2 H);  intros.
Qed.

Remark rem_919 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_21 pub -> auto_agent X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto_agent X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto.
  exact (rem_918 X1 X2 X3 X4 X5).
Qed.

Remark rem_920 : forall X1 X2 X3 X4 X5:term, auto___def_21 pub -> auto_agent X1 -> auto___def_10 X4 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto___def_21 pub -> auto_agent X1 -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_919 X1 X2 X3 X4 X5).
Qed.

Remark rem_921 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_11 (key pub X1) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_28 pub X1 H);  intros.
  apply (rem_920 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_922 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (key pub X1) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_30 prv X2 H);  intros.
Qed.

Remark rem_923 : forall X1 X2 X3 X4 X5:term, auto_knows_old X4 -> auto_knows_old (key pub X1) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X4 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (key pub X1) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_922 X1 X2 X3 X4 X5).
Qed.

Remark rem_924 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (crypt X4 (key pub X1)) -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_32 X4 (key pub X1) H);  intros.
  apply (rem_913 X1 X2 X3 X4 X5);  tauto.
  apply (rem_917 X1 X2 X3 X4 X5);  tauto.
  apply (rem_921 X1 X2 X3 X4 X5);  tauto.
  apply (rem_923 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_925 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (crypt X4 (key pub X1)) -> auto_knows_old (key prv X2) -> auto_knows_old nil -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (crypt X4 (key pub X1)) -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto.
  exact (rem_924 X1 X2 X3 X4 X5).
Qed.

Remark rem_926 : forall X1 X2 X3 X4 X5:term, auto_knows_old (crypt X4 (key pub X1)) -> auto_knows_old nil -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (crypt X4 (key pub X1)) -> auto_knows_old (key prv X2) -> auto_knows_old nil -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_925 X1 X2 X3 X4 X5).
Qed.

Remark rem_927 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (cons (crypt X4 (key pub X1)) nil) -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_650 (crypt X4 (key pub X1)) nil H);  intros.
  apply (rem_926 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_928 : forall X1 X2 X3 X4 X5:term, auto_knows_old X5 -> auto_knows_old (cons (crypt X4 (key pub X1)) nil) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old X5 -> auto_knows_old (cons (crypt X4 (key pub X1)) nil) -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_927 X1 X2 X3 X4 X5).
Qed.

Remark rem_929 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3. intro H. intros.
  elim (rem_650 X5 (cons (crypt X4 (key pub X1)) nil) H);  intros.
  apply (rem_928 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_930 : forall X1 X2 X3 X4 X5:term, auto_knows_old (noncea_old X1 X2) -> auto_knows_old (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (key prv X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (cons X5 (cons (crypt X4 (key pub X1)) nil)) -> auto_knows_old (key prv X2) -> auto_knows_old (noncea_old X1 X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_929 X1 X2 X3 X4 X5).
Qed.

Remark rem_931 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto_knows_old (key prv X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3. intro H. intros.
  elim (rem_650 (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)) H);  intros.
  apply (rem_930 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_932 : forall X1 X2 X3 X4 X5:term, auto_knows_old X1 -> auto_knows_old (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (key prv X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X3 -> auto_knows_old (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) -> auto_knows_old (key prv X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_931 X1 X2 X3 X4 X5).
Qed.

Remark rem_933 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_old (key prv X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_650 X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))) H);  intros.
  apply (rem_932 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_934 : forall X1 X2 X3 X4 X5:term, auto_knows_old X3 -> auto_knows_old (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_old X2 -> auto_knows_old (key prv X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old X3 -> auto_knows_old (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) -> auto_knows_old (key prv X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_933 X1 X2 X3 X4 X5).
Qed.

Remark rem_935 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_knows_old (key prv X2) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_650 X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil)))) H);  intros.
  apply (rem_934 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_936 : forall X1 X2 X3 X4 X5:term, auto_knows_old (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_knows_old (key prv X2) -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) -> auto_knows_old (key prv X2) -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_935 X1 X2 X3 X4 X5).
Qed.

Remark rem_937 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old (crypt (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_32 (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2) H);  intros.
  apply (rem_895 X1 X2 X3 X4 X5);  tauto.
  apply (rem_898 X1 X2 X3 X4 X5);  tauto.
  apply (rem_909 X1 X2 X3 X4 X5);  tauto.
  apply (rem_936 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_938 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old (crypt (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) -> auto_knows_old nil -> auto___def_39 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old (crypt (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) -> auto___def_39 X1 X2 X3 X4 X5). tauto.
  exact (rem_937 X1 X2 X3 X4 X5).
Qed.

Remark rem_939 : forall X1 X2 X3 X4 X5:term, auto_knows_old (crypt (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) -> auto_knows_old nil -> auto_knows_old X2 -> auto___def_39 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_old X2 -> auto_knows_old (crypt (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) -> auto_knows_old nil -> auto___def_39 X1 X2 X3 X4 X5). tauto. exact (rem_938 X1 X2 X3 X4 X5).
Qed.

Remark rem_940 : forall X1 X2 X3 X4 X5:term, auto_knows_old X2 -> auto_knows_old (cons (crypt (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) nil) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_650 (crypt (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) nil H);  intros.
  apply (rem_939 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_941 : forall X1 X2 X3 X4 X5:term, auto_knows_old (cons X2 (cons (crypt (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) nil)) -> auto___def_39 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_650 X2 (cons (crypt (cons X3 (cons X1 (cons (noncea_old X1 X2) (cons X5 (cons (crypt X4 (key pub X1)) nil))))) (key prv X2)) nil) H);  intros.
  apply (rem_940 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_942 : forall X1 X2:term, auto___def_14 X2 -> auto___type_2 X1 -> auto___type_2 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_2 X1 -> auto___type_2 X1). tauto. exact (rem_461 X1).
Qed.

Remark rem_943 : forall X2:term, auto___def_14 X2 -> auto___def_14 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_944 : forall X1 X2:term, auto___def_14 X2 -> auto___type_2 X1 -> auto___def_14 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_14 X2 -> auto___def_14 X2). tauto. exact (rem_943 X2).
Qed.

Remark rem_945 : forall X1 X2:term, auto___def_14 X2 -> auto___type_2 X1 -> (auto___type_2 X1 /\ auto___def_14 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_2 X1). 2:apply (rem_942 X1 X2);  assumption.
  cut (auto___def_14 X2). 2:apply (rem_944 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_946 : forall X1 X2:term, auto___def_14 X2 -> auto___type_2 X1 -> auto___def_13 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_945 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_13_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_947 : forall X1 X2 X3 X4 X5:term, auto___def_48 X2 X3 X1 X4 X5 -> auto___type_10 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_10_1. Qed.

Remark rem_948 : forall X1:term, auto___def_17 X1 -> auto___def_17 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_949 : forall X1 X2:term, auto___def_17 X1 -> auto___def_9 X2 -> auto___def_17 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_17 X1 -> auto___def_17 X1). tauto. exact (rem_948 X1).
Qed.

Remark rem_950 : forall X2:term, auto___def_9 X2 -> auto___def_9 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_951 : forall X1 X2:term, auto___def_17 X1 -> auto___def_9 X2 -> auto___def_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_9 X2 -> auto___def_9 X2). tauto. exact (rem_950 X2).
Qed.

Remark rem_952 : forall X1 X2:term, auto___def_17 X1 -> auto___def_9 X2 -> (auto___def_17 X1 /\ auto___def_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_17 X1). 2:apply (rem_949 X1 X2);  assumption.
  cut (auto___def_9 X2). 2:apply (rem_951 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_953 : forall X1 X2:term, auto___def_17 X1 -> auto___def_9 X2 -> auto___def_16 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_952 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_16_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_954 : forall X1 X2:term, auto___def_9 X2 -> auto___def_17 X1 -> auto___def_16 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_17 X1 -> auto___def_9 X2 -> auto___def_16 (cons X1 X2)). tauto. exact (rem_953 X1 X2).
Qed.

Remark rem_955 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_15 (xa_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_66 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_15_xa_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_956 : forall X1:term, auto___type_3 X1 -> auto___type_3 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_957 : forall X1 X2:term, auto___def_26 X2 -> auto___def_38 prv -> auto___type_3 X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_956 X1).
Qed.

Remark rem_958 : forall X2:term, auto___def_26 X2 -> auto___def_26 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_959 : forall X1 X2:term, auto___def_26 X2 -> auto___def_38 prv -> auto___type_3 X1 -> auto___def_26 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_26 X2 -> auto___def_26 X2). tauto. exact (rem_958 X2).
Qed.

Remark rem_960 : forall X1 X2:term, auto___def_26 X2 -> auto___def_38 prv -> auto___type_3 X1 -> (auto___type_3 X1 /\ auto___def_26 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___type_3 X1). 2:apply (rem_957 X1 X2);  assumption.
  cut (auto___def_26 X2). 2:apply (rem_959 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_961 : forall X1 X2:term, auto___def_26 X2 -> auto___def_38 prv -> auto___type_3 X1 -> auto___def_3 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_960 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_3_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_962 : forall X1 X2:term, auto___def_38 prv -> auto___type_3 X1 -> auto___def_26 X2 -> auto___def_3 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 X2 -> auto___def_38 prv -> auto___type_3 X1 -> auto___def_3 X1 X2). tauto. exact (rem_961 X1 X2).
Qed.

Remark rem_963 : forall X1 X2:term, auto___def_26 X2 -> auto___def_27 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_16 prv X1 H);  intros.
  apply (rem_962 X1 X2);  tauto.
Qed.

Remark rem_964 : forall X1:term, auto___type_6 X1 -> auto___type_6 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_965 : forall X1 X2:term, auto___def_43 X2 -> auto___def_45 prv -> auto___type_6 X1 -> auto___type_6 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_6 X1 -> auto___type_6 X1). tauto. exact (rem_964 X1).
Qed.

Remark rem_966 : forall X2:term, auto___def_43 X2 -> auto___def_43 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_967 : forall X1 X2:term, auto___def_43 X2 -> auto___def_45 prv -> auto___type_6 X1 -> auto___def_43 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_43 X2 -> auto___def_43 X2). tauto. exact (rem_966 X2).
Qed.

Remark rem_968 : forall X1 X2:term, auto___def_43 X2 -> auto___def_45 prv -> auto___type_6 X1 -> (auto___type_6 X1 /\ auto___def_43 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___type_6 X1). 2:apply (rem_965 X1 X2);  assumption.
  cut (auto___def_43 X2). 2:apply (rem_967 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_969 : forall X1 X2:term, auto___def_43 X2 -> auto___def_45 prv -> auto___type_6 X1 -> auto___def_3 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_968 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_3_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_970 : forall X1 X2:term, auto___def_45 prv -> auto___type_6 X1 -> auto___def_43 X2 -> auto___def_3 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_43 X2 -> auto___def_45 prv -> auto___type_6 X1 -> auto___def_3 X1 X2). tauto. exact (rem_969 X1 X2).
Qed.

Remark rem_971 : forall X1 X2:term, auto___def_43 X2 -> auto___def_44 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_22 prv X1 H);  intros.
  apply (rem_970 X1 X2);  tauto.
Qed.

Remark rem_972 : forall X1 X2:term, auto___def_10 X2 -> auto___def_21 prv -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_63 X1).
Qed.

Remark rem_973 : forall X2:term, auto___def_10 X2 -> auto___def_10 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_974 : forall X1 X2:term, auto___def_10 X2 -> auto___def_21 prv -> auto_agent X1 -> auto___def_10 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_10 X2 -> auto___def_10 X2). tauto. exact (rem_973 X2).
Qed.

Remark rem_975 : forall X1 X2:term, auto___def_10 X2 -> auto___def_21 prv -> auto_agent X1 -> (auto_agent X1 /\ auto___def_10 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_agent X1). 2:apply (rem_972 X1 X2);  assumption.
  cut (auto___def_10 X2). 2:apply (rem_974 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_976 : forall X1 X2:term, auto___def_10 X2 -> auto___def_21 prv -> auto_agent X1 -> auto___def_3 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_975 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_3_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_977 : forall X1 X2:term, auto___def_21 prv -> auto_agent X1 -> auto___def_10 X2 -> auto___def_3 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X2 -> auto___def_21 prv -> auto_agent X1 -> auto___def_3 X1 X2). tauto. exact (rem_976 X1 X2).
Qed.

Remark rem_978 : forall X1 X2:term, auto___def_10 X2 -> auto___def_11 (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_28 prv X1 H);  intros.
  apply (rem_977 X1 X2);  tauto.
Qed.

Remark rem_979 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key prv X1) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_30 prv X1 H);  intros.
Qed.

Remark rem_980 : forall X1 X2:term, auto_knows_old (crypt X2 (key prv X1)) -> auto___def_3 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_32 X2 (key prv X1) H);  intros.
  apply (rem_963 X1 X2);  tauto.
  apply (rem_971 X1 X2);  tauto.
  apply (rem_978 X1 X2);  tauto.
  apply (rem_979 X1 X2);  tauto.
Qed.

Remark rem_981 : forall X1:term, auto___def_61 X1 -> auto___def_61 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_982 : forall X1 X2:term, auto___def_11 X2 -> auto___def_61 X1 -> auto___def_61 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_61 X1 -> auto___def_61 X1). tauto. exact (rem_981 X1).
Qed.

Remark rem_983 : forall X1 X2:term, auto___def_11 X2 -> auto___def_61 X1 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_809 X2).
Qed.

Remark rem_984 : forall X1 X2:term, auto___def_11 X2 -> auto___def_61 X1 -> (auto___def_61 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_61 X1). 2:apply (rem_982 X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_983 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_985 : forall X1 X2:term, auto___def_11 X2 -> auto___def_61 X1 -> auto___def_60 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_984 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_60_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_986 : forall X1:term, auto___def_35 X1 -> auto___def_35 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_987 : forall X1 X2:term, auto___def_35 X1 -> auto___def_36 X2 -> auto___def_35 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_35 X1 -> auto___def_35 X1). tauto. exact (rem_986 X1).
Qed.

Remark rem_988 : forall X2:term, auto___def_36 X2 -> auto___def_36 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_989 : forall X1 X2:term, auto___def_35 X1 -> auto___def_36 X2 -> auto___def_36 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_36 X2 -> auto___def_36 X2). tauto. exact (rem_988 X2).
Qed.

Remark rem_990 : forall X1 X2:term, auto___def_35 X1 -> auto___def_36 X2 -> (auto___def_35 X1 /\ auto___def_36 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_35 X1). 2:apply (rem_987 X1 X2);  assumption.
  cut (auto___def_36 X2). 2:apply (rem_989 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_991 : forall X1 X2:term, auto___def_35 X1 -> auto___def_36 X2 -> auto___def_34 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_990 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_34_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_992 : forall X1 X2:term, auto___def_36 X2 -> auto___def_35 X1 -> auto___def_34 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_35 X1 -> auto___def_36 X2 -> auto___def_34 (crypt X1 X2)). tauto. exact (rem_991 X1 X2).
Qed.

Remark rem_993 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_68 (ya_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_66 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_68_ya_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_994 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_62 (noncea_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_66 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_62_noncea_current_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_995 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_28 (nonceb_old X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_754 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_28_nonceb_old_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_996 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_12 X3 -> auto___def_28 (nonceb_old X1 X2 X3 X4 X5). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_28 (nonceb_old X1 X2 X3 X4 X5)). tauto. exact (rem_995 X1 X2 X3 X4 X5).
Qed.

Remark rem_997 : forall X1 X2 X3 X4 X5:term, auto___def_22 X1 X2 X4 X5 X3 -> auto___def_28 (nonceb_old X1 X2 X3 X4 X5). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_431 X1 X2 X4 X5 X3 H);  intros.
  apply (rem_996 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_998 : forall X1:term, auto___type_3 X1 -> auto_agent X1. (* Induct. *)
Proof.
  fix epsilon_m__type_3_pagent 1.
  intro X. case X.
  exact (rem_846 epsilon_m__type_3_pagent ).
  exact (rem_843 epsilon_m__type_3_pagent ).
  intros X1 X2. intro H. elim (rem_852 X1 X2 H).
  intros X1 X2. intro H. elim (rem_864 X1 X2 H).
  exact (rem_837 epsilon_m__type_3_pagent ).
  intros X1 X2. intro H. elim (rem_866 X1 X2 H).
   intro H. elim (rem_849  H).
  intros X1 X2. intro H. elim (rem_859 X1 X2 H).
  intros X1 X2. intro H. elim (rem_854 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_861 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_855 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_860  H).
   intro H. elim (rem_865  H).
  intros X1. intro H. elim (rem_847 X1 H).
  exact (rem_840 epsilon_m__type_3_pagent ).
  intros X1 X2 X3. intro H. elim (rem_851 X1 X2 X3 H).
   intro H. elim (rem_853  H).
  intros X1 X2. intro H. elim (rem_856 X1 X2 H).
  intros X1 X2. intro H. elim (rem_850 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_867 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_862 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_858 X1 X2 H).
  intros X1 X2. intro H. elim (rem_848 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_857 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_863 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_999 : forall X1 X2 X3 X4 X5:term, auto___def_28 X2 -> auto___def_32 X3 -> auto___def_35 X4 -> auto___type_3 X1 -> auto___type_4 X5 -> auto_agent X1 -> auto_agent X5 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_3 X1 -> auto_agent X1). tauto. exact (rem_998 X1).
Qed.

Remark rem_1000 : forall X1 X2 X3 X4 X5:term, auto___def_28 X2 -> auto___def_32 X3 -> auto___def_35 X4 -> auto___type_3 X1 -> auto___type_4 X5 -> auto_agent X1 -> auto_agent X5 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_3 X1 -> auto___type_3 X1). tauto. exact (rem_956 X1).
Qed.

Remark rem_1001 : forall X2:term, auto___def_28 X2 -> auto___def_28 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1002 : forall X1 X2 X3 X4 X5:term, auto___def_28 X2 -> auto___def_32 X3 -> auto___def_35 X4 -> auto___type_3 X1 -> auto___type_4 X5 -> auto_agent X1 -> auto_agent X5 -> auto___def_28 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X2 -> auto___def_28 X2). tauto. exact (rem_1001 X2).
Qed.

Remark rem_1003 : forall X1 X2 X3 X4 X5:term, auto___def_28 X2 -> auto___def_32 X3 -> auto___def_35 X4 -> auto___type_3 X1 -> auto___type_4 X5 -> auto_agent X1 -> auto_agent X5 -> (auto_agent X1 /\ auto___type_3 X1 /\ auto___def_28 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_999 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_3 X1). 2:apply (rem_1000 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_28 X2). 2:apply (rem_1002 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_1004 : forall X1 X2 X3 X4 X5:term, auto___def_28 X2 -> auto___def_32 X3 -> auto___def_35 X4 -> auto___type_3 X1 -> auto___type_4 X5 -> auto_agent X1 -> auto_agent X5 -> auto___def_43 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1003 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_43_cons_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1005 : forall X1 X2 X3 X4 X5:term, auto___type_4 X3 -> auto_agent X3 -> auto_agent X1 -> auto___type_3 X1 -> auto___def_28 X2 -> auto___def_35 X4 -> auto___def_32 X5 -> auto___def_43 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X4 X3.
  cut (auto___def_28 X2 -> auto___def_32 X3 -> auto___def_35 X4 -> auto___type_3 X1 -> auto___type_4 X5 -> auto_agent X1 -> auto_agent X5 -> auto___def_43 (cons X1 X2)). tauto. exact (rem_1004 X1 X2 X3 X4 X5).
Qed.

Remark rem_1006 : forall X1 X2 X3 X4 X5:term, auto___def_39 X3 X1 X2 X4 X5 -> auto___def_43 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_708 X3 X1 X2 X4 X5 H);  intros.
  apply (rem_1005 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1007 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_542 X4 (key pub X2) H);  intros.
Qed.

Remark rem_1008 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___def_33 nil -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1007 X1 X2 X3 X4 X5).
Qed.

Remark rem_1009 : forall X1 X2 X3 X4 X5:term, auto___def_32 (crypt X4 (key pub X2)) -> auto___def_33 nil -> auto___def_28 X5 -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___def_33 nil -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1008 X1 X2 X3 X4 X5).
Qed.

Remark rem_1010 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_31 (cons (crypt X4 (key pub X2)) nil) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_119 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_1009 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1011 : forall X1 X2 X3 X4 X5:term, auto___type_5 X3 -> auto___def_31 (cons (crypt X4 (key pub X2)) nil) -> auto___def_28 X5 -> auto___type_3 X1 -> auto___type_4 X2 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_31 (cons (crypt X4 (key pub X2)) nil) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1010 X1 X2 X3 X4 X5).
Qed.

Remark rem_1012 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_30 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_122 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_1011 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1013 : forall X1 X2 X3 X4 X5:term, auto___type_4 X2 -> auto___def_30 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___def_28 X5 -> auto___type_3 X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_30 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1012 X1 X2 X3 X4 X5).
Qed.

Remark rem_1014 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___type_3 X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_125 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_1013 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1015 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_38 prv -> auto___type_3 X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___type_3 X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1014 X1 X2 X3 X4 X5).
Qed.

Remark rem_1016 : forall X1 X2 X3 X4 X5:term, auto___def_38 prv -> auto___type_3 X1 -> auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_38 prv -> auto___type_3 X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1015 X1 X2 X3 X4 X5).
Qed.

Remark rem_1017 : forall X1 X2 X3 X4 X5:term, auto___def_27 (key prv X1) -> auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_16 prv X1 H);  intros.
  apply (rem_1016 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1018 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_27 (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_27 (key prv X1) -> auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1017 X1 X2 X3 X4 X5).
Qed.

Remark rem_1019 : forall X1 X2 X3 X4 X5:term, auto___def_26 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_27 (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_131 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1018 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1020 : forall X1 X2 X3 X4 X5:term, auto___def_75 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_91 (key prv X1) -> auto___type_12 X5 -> auto_agent X5 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_133 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
Qed.

Remark rem_1021 : forall X1 X2 X3 X4 X5:term, auto_agent X5 -> auto___type_12 X5 -> auto___def_75 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_91 (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_91 (key prv X1) -> auto___type_12 X5 -> auto_agent X5 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1020 X1 X2 X3 X4 X5).
Qed.

Remark rem_1022 : forall X1 X2 X3 X4 X5:term, auto___def_90 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_91 (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_136 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1021 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1023 : forall X1 X2:term, auto___def_79 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1024 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_79 (crypt X4 (key pub X2)) -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_1023 X4 (key pub X2) H);  intros.
Qed.

Remark rem_1025 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_79 (crypt X4 (key pub X2)) -> auto___def_80 nil -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_79 (crypt X4 (key pub X2)) -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1024 X1 X2 X3 X4 X5).
Qed.

Remark rem_1026 : forall X1 X2 X3 X4 X5:term, auto___def_79 (crypt X4 (key pub X2)) -> auto___def_80 nil -> auto___def_75 X5 -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_79 (crypt X4 (key pub X2)) -> auto___def_80 nil -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1025 X1 X2 X3 X4 X5).
Qed.

Remark rem_1027 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_78 (cons (crypt X4 (key pub X2)) nil) -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_230 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_1026 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1028 : forall X1 X2 X3 X4 X5:term, auto___type_14 X3 -> auto___def_78 (cons (crypt X4 (key pub X2)) nil) -> auto___def_75 X5 -> auto___type_12 X1 -> auto___type_13 X2 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_78 (cons (crypt X4 (key pub X2)) nil) -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1027 X1 X2 X3 X4 X5).
Qed.

Remark rem_1029 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_77 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_12 X1 -> auto___type_13 X2 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_233 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_1028 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1030 : forall X1 X2 X3 X4 X5:term, auto___type_13 X2 -> auto___def_77 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___def_75 X5 -> auto___type_12 X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_77 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_12 X1 -> auto___type_13 X2 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1029 X1 X2 X3 X4 X5).
Qed.

Remark rem_1031 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___type_12 X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_236 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_1030 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1032 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_85 prv -> auto___type_12 X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___type_12 X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1031 X1 X2 X3 X4 X5).
Qed.

Remark rem_1033 : forall X1 X2 X3 X4 X5:term, auto___def_85 prv -> auto___type_12 X1 -> auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_85 prv -> auto___type_12 X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1032 X1 X2 X3 X4 X5).
Qed.

Remark rem_1034 : forall X1 X2 X3 X4 X5:term, auto___def_74 (key prv X1) -> auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_240 prv X1 H);  intros.
  apply (rem_1033 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1035 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_74 (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_74 (key prv X1) -> auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1034 X1 X2 X3 X4 X5).
Qed.

Remark rem_1036 : forall X1 X2 X3 X4 X5:term, auto___def_73 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_74 (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_243 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1035 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1037 : forall X1 X2 X3 X4 X5:term, auto___def_28 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_44 (key prv X1) -> auto___type_3 X5 -> auto_agent X5 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_245 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
Qed.

Remark rem_1038 : forall X1 X2 X3 X4 X5:term, auto_agent X5 -> auto___type_3 X5 -> auto___def_28 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_44 (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_44 (key prv X1) -> auto___type_3 X5 -> auto_agent X5 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1037 X1 X2 X3 X4 X5).
Qed.

Remark rem_1039 : forall X1 X2 X3 X4 X5:term, auto___def_43 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_44 (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_248 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1038 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1040 : forall X1 X2 X3 X4 X5:term, auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_63 X1).
Qed.

Remark rem_1041 : forall X1 X2 X3 X4 X5:term, auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto_knows_current X1). tauto. exact (rem_720 X1).
Qed.

Remark rem_1042 : forall X1 X2 X3 X4 X5:term, auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto_agent X2). tauto. exact (rem_605 X2).
Qed.

Remark rem_1043 : forall X1 X2 X3 X4 X5:term, auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_607 X2).
Qed.

Remark rem_1044 : forall X3:term, auto___def_65 X3 -> auto___def_65 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1045 : forall X1 X2 X3 X4 X5:term, auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_65 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_65 X3 -> auto___def_65 X3). tauto. exact (rem_1044 X3).
Qed.

Remark rem_1046 : forall X4:term, auto___def_68 X4 -> auto___def_68 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1047 : forall X1 X2 X3 X4 X5:term, auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_68 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_68 X4 -> auto___def_68 X4). tauto. exact (rem_1046 X4).
Qed.

Remark rem_1048 : forall X5:term, auto___def_62 X5 -> auto___def_62 X5. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1049 : forall X1 X2 X3 X4 X5:term, auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_62 X5. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X5 -> auto___def_62 X5). tauto. exact (rem_1048 X5).
Qed.

Remark rem_1050 : forall X1 X2 X3 X4 X5:term, auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> (auto_agent X1 /\ auto_knows_current X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_65 X3 /\ auto___def_68 X4 /\ auto___def_62 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_1040 X1 X2 X3 X4 X5);  assumption.
  cut (auto_knows_current X1). 2:apply (rem_1041 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_1042 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_1043 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_65 X3). 2:apply (rem_1045 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_68 X4). 2:apply (rem_1047 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_62 X5). 2:apply (rem_1049 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_1051 : forall X1 X2 X3 X4 X5:term, auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1050 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_69_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1052 : forall X1 X2 X3 X4 X5:term, auto___def_68 X4 -> auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1051 X1 X2 X3 X4 X5).
Qed.

Remark rem_1053 : forall X1 X2:term, auto___def_67 (crypt X1 X2) -> or_1
    (auto___def_68 X1 /\ auto___def_19 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1054 : forall X1 X2 X3 X4 X5:term, auto___def_62 X5 -> auto___def_65 X3 -> auto___def_67 (crypt X4 (key pub X2)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_1053 X4 (key pub X2) H);  intros.
  apply (rem_1052 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1055 : forall X1 X2 X3 X4 X5:term, auto___def_62 X5 -> auto___def_65 X3 -> auto___def_67 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X5 -> auto___def_65 X3 -> auto___def_67 (crypt X4 (key pub X2)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1054 X1 X2 X3 X4 X5).
Qed.

Remark rem_1056 : forall X1 X2 X3 X4 X5:term, auto___def_67 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___def_62 X5 -> auto___def_65 X3 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X5 -> auto___def_65 X3 -> auto___def_67 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1055 X1 X2 X3 X4 X5).
Qed.

Remark rem_1057 : forall X1 X2:term, auto___def_66 (cons X1 X2) -> or_1
    (auto___def_67 X1 /\ auto___def_9 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1058 : forall X1 X2 X3 X4 X5:term, auto___def_62 X5 -> auto___def_65 X3 -> auto___def_66 (cons (crypt X4 (key pub X2)) nil) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_1057 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_1056 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1059 : forall X1 X2 X3 X4 X5:term, auto___def_65 X3 -> auto___def_66 (cons (crypt X4 (key pub X2)) nil) -> auto___def_62 X5 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X5 -> auto___def_65 X3 -> auto___def_66 (cons (crypt X4 (key pub X2)) nil) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1058 X1 X2 X3 X4 X5).
Qed.

Remark rem_1060 : forall X1 X2 X3 X4 X5:term, auto___def_62 X5 -> auto___def_64 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_253 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_1059 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1061 : forall X1 X2 X3 X4 X5:term, auto___type_2 X2 -> auto___def_64 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___def_62 X5 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X5 -> auto___def_64 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1060 X1 X2 X3 X4 X5).
Qed.

Remark rem_1062 : forall X1 X2 X3 X4 X5:term, auto___def_62 X5 -> auto___def_63 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_256 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_1061 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1063 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_258 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1062 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1064 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1063 X1 X2 X3 X4 X5).
Qed.

Remark rem_1065 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto_agent X1 -> auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_21 prv -> auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1064 X1 X2 X3 X4 X5).
Qed.

Remark rem_1066 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key prv X1) -> auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 prv X1 H);  intros.
  apply (rem_1065 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1067 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_11 (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key prv X1) -> auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1066 X1 X2 X3 X4 X5).
Qed.

Remark rem_1068 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_63 X1).
Qed.

Remark rem_1069 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___type_1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto___type_1 X1). tauto. exact (rem_569 X1).
Qed.

Remark rem_1070 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto_agent X2). tauto. exact (rem_605 X2).
Qed.

Remark rem_1071 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_607 X2).
Qed.

Remark rem_1072 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_15 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_15 X3 -> auto___def_15 X3). tauto. exact (rem_609 X3).
Qed.

Remark rem_1073 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_18 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_18 X4 -> auto___def_18 X4). tauto. exact (rem_611 X4).
Qed.

Remark rem_1074 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_12 X5. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_12 X5). tauto. exact (rem_613 X5).
Qed.

Remark rem_1075 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> (auto_agent X1 /\ auto___type_1 X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_15 X3 /\ auto___def_18 X4 /\ auto___def_12 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_1068 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_1 X1). 2:apply (rem_1069 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_1070 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_1071 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_15 X3). 2:apply (rem_1072 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_18 X4). 2:apply (rem_1073 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_12 X5). 2:apply (rem_1074 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_1076 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1075 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_69_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1077 : forall X1 X2 X3 X4 X5:term, auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___def_12 X5 -> auto___def_15 X3 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1076 X1 X2 X3 X4 X5).
Qed.

Remark rem_1078 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_618 X4 (key pub X2) H);  intros.
  apply (rem_1077 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1079 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1078 X1 X2 X3 X4 X5).
Qed.

Remark rem_1080 : forall X1 X2 X3 X4 X5:term, auto___def_17 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___def_12 X5 -> auto___def_15 X3 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1079 X1 X2 X3 X4 X5).
Qed.

Remark rem_1081 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_16 (cons (crypt X4 (key pub X2)) nil) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_622 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_1080 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1082 : forall X1 X2 X3 X4 X5:term, auto___def_15 X3 -> auto___def_16 (cons (crypt X4 (key pub X2)) nil) -> auto___def_12 X5 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_16 (cons (crypt X4 (key pub X2)) nil) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1081 X1 X2 X3 X4 X5).
Qed.

Remark rem_1083 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_14 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_267 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_1082 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1084 : forall X1 X2 X3 X4 X5:term, auto___type_2 X2 -> auto___def_14 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___def_12 X5 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_14 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1083 X1 X2 X3 X4 X5).
Qed.

Remark rem_1085 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_270 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_1084 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1086 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_21 prv -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1085 X1 X2 X3 X4 X5).
Qed.

Remark rem_1087 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto_agent X1 -> auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_21 prv -> auto_agent X1 -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1086 X1 X2 X3 X4 X5).
Qed.

Remark rem_1088 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key prv X1) -> auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 prv X1 H);  intros.
  apply (rem_1087 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1089 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_11 (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key prv X1) -> auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1088 X1 X2 X3 X4 X5).
Qed.

Remark rem_1090 : forall X1 X2 X3 X4 X5:term, auto___def_10 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_11 (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_276 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1089 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1091 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1092 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_26 X4 -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1091 X1 X2 X3 X4 X5).
Qed.

Remark rem_1093 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1092 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1094 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_38 pub -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1093 X1 X2 X3 X4 X5).
Qed.

Remark rem_1095 : forall X1 X2 X3 X4 X5:term, auto___def_38 pub -> auto___type_3 X2 -> auto___def_26 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___def_38 pub -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1094 X1 X2 X3 X4 X5).
Qed.

Remark rem_1096 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_27 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_16 pub X2 H);  intros.
  apply (rem_1095 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1097 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_90 X4 -> auto___type_15 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1098 : forall X1 X2 X3 X4 X5:term, auto___def_90 X4 -> auto___type_15 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1097 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1099 : forall X1 X2 X3 X4 X5:term, auto___def_90 X4 -> auto___def_92 pub -> auto___type_15 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_90 X4 -> auto___type_15 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1098 X1 X2 X3 X4 X5).
Qed.

Remark rem_1100 : forall X1 X2 X3 X4 X5:term, auto___def_92 pub -> auto___type_15 X2 -> auto___def_90 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_90 X4 -> auto___def_92 pub -> auto___type_15 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1099 X1 X2 X3 X4 X5).
Qed.

Remark rem_1101 : forall X1 X2 X3 X4 X5:term, auto___def_90 X4 -> auto___def_91 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_318 pub X2 H);  intros.
  apply (rem_1100 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1102 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_73 X4 -> auto___type_12 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1103 : forall X1 X2 X3 X4 X5:term, auto___def_73 X4 -> auto___type_12 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1102 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1104 : forall X1 X2 X3 X4 X5:term, auto___def_73 X4 -> auto___def_85 pub -> auto___type_12 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_73 X4 -> auto___type_12 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1103 X1 X2 X3 X4 X5).
Qed.

Remark rem_1105 : forall X1 X2 X3 X4 X5:term, auto___def_85 pub -> auto___type_12 X2 -> auto___def_73 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_73 X4 -> auto___def_85 pub -> auto___type_12 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1104 X1 X2 X3 X4 X5).
Qed.

Remark rem_1106 : forall X1 X2 X3 X4 X5:term, auto___def_73 X4 -> auto___def_74 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_240 pub X2 H);  intros.
  apply (rem_1105 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1107 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1108 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_43 X4 -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1107 X1 X2 X3 X4 X5).
Qed.

Remark rem_1109 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1108 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1110 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_45 pub -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1109 X1 X2 X3 X4 X5).
Qed.

Remark rem_1111 : forall X1 X2 X3 X4 X5:term, auto___def_45 pub -> auto___type_6 X2 -> auto___def_43 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___def_45 pub -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1110 X1 X2 X3 X4 X5).
Qed.

Remark rem_1112 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_44 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_22 pub X2 H);  intros.
  apply (rem_1111 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1113 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_61 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1114 : forall X1 X2 X3 X4 X5:term, auto___def_61 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1113 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1115 : forall X1 X2 X3 X4 X5:term, auto___def_21 pub -> auto___def_61 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_61 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1114 X1 X2 X3 X4 X5).
Qed.

Remark rem_1116 : forall X1 X2 X3 X4 X5:term, auto___def_21 pub -> auto_agent X2 -> auto___def_61 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_21 pub -> auto___def_61 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1115 X1 X2 X3 X4 X5).
Qed.

Remark rem_1117 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key pub X2) -> auto___def_61 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 pub X2 H);  intros.
  apply (rem_1116 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1118 : forall X1 X2 X3 X4 X5:term, auto___def_61 X4 -> auto___def_11 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key pub X2) -> auto___def_61 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1117 X1 X2 X3 X4 X5).
Qed.

Remark rem_1119 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1120 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_10 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1119 X1 X2 X3 X4 X5).
Qed.

Remark rem_1121 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1120 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1122 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_21 pub -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1121 X1 X2 X3 X4 X5).
Qed.

Remark rem_1123 : forall X1 X2 X3 X4 X5:term, auto___def_21 pub -> auto_agent X2 -> auto___def_10 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto___def_21 pub -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1122 X1 X2 X3 X4 X5).
Qed.

Remark rem_1124 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_11 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_28 pub X2 H);  intros.
  apply (rem_1123 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1125 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X5 -> auto_knows_current (key pub X2) -> auto___def_69 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1126 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (key pub X2) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1125 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1127 : forall X1 X2 X3 X4 X5:term, auto_knows_current X4 -> auto_knows_current (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (key pub X2) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1126 X1 X2 X3 X4 X5).
Qed.

Remark rem_1128 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X2)) -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_346 X4 (key pub X2) H);  intros.
  apply (rem_1096 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1101 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1106 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1112 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1118 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1124 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1127 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1129 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X2)) -> auto_knows_current (key prv X1) -> auto_knows_current nil -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X2)) -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1128 X1 X2 X3 X4 X5).
Qed.

Remark rem_1130 : forall X1 X2 X3 X4 X5:term, auto_knows_current (crypt X4 (key pub X2)) -> auto_knows_current nil -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X2)) -> auto_knows_current (key prv X1) -> auto_knows_current nil -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1129 X1 X2 X3 X4 X5).
Qed.

Remark rem_1131 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (cons (crypt X4 (key pub X2)) nil) -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_350 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_1130 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1132 : forall X1 X2 X3 X4 X5:term, auto_knows_current X3 -> auto_knows_current (cons (crypt X4 (key pub X2)) nil) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (cons (crypt X4 (key pub X2)) nil) -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1131 X1 X2 X3 X4 X5).
Qed.

Remark rem_1133 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3. intro H. intros.
  elim (rem_350 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_1132 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1134 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1133 X1 X2 X3 X4 X5).
Qed.

Remark rem_1135 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_350 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_1134 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1136 : forall X1 X2 X3 X4 X5:term, auto_knows_current X5 -> auto_knows_current (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1135 X1 X2 X3 X4 X5).
Qed.

Remark rem_1137 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_350 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1136 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1138 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current (key prv X1) -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current (key prv X1) -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1137 X1 X2 X3 X4 X5).
Qed.

Remark rem_1139 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_346 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1) H);  intros.
  apply (rem_1019 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1022 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1036 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1039 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1067 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1090 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1138 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1140 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current nil -> auto___def_69 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_69 X1 X2 X3 X4 X5). tauto.
  exact (rem_1139 X1 X2 X3 X4 X5).
Qed.

Remark rem_1141 : forall X1 X2 X3 X4 X5:term, auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current nil -> auto_knows_current X1 -> auto___def_69 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current nil -> auto___def_69 X1 X2 X3 X4 X5). tauto. exact (rem_1140 X1 X2 X3 X4 X5).
Qed.

Remark rem_1142 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_350 (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil H);  intros.
  apply (rem_1141 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1143 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons X1 (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil)) -> auto___def_69 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_350 X1 (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) H);  intros.
  apply (rem_1142 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1144 : forall X1 X2 X3:term, auto___def_52 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3.  case (rem_10). intros. apply trans___def_52_session_old_1;  tauto.
 tauto.
Qed.

Remark rem_1145 : forall X1:term, auto___def_67 X1 -> auto___def_67 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1146 : forall X1 X2:term, auto___def_67 X1 -> auto___def_9 X2 -> auto___def_67 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_67 X1 -> auto___def_67 X1). tauto. exact (rem_1145 X1).
Qed.

Remark rem_1147 : forall X1 X2:term, auto___def_67 X1 -> auto___def_9 X2 -> auto___def_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_9 X2 -> auto___def_9 X2). tauto. exact (rem_950 X2).
Qed.

Remark rem_1148 : forall X1 X2:term, auto___def_67 X1 -> auto___def_9 X2 -> (auto___def_67 X1 /\ auto___def_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_67 X1). 2:apply (rem_1146 X1 X2);  assumption.
  cut (auto___def_9 X2). 2:apply (rem_1147 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1149 : forall X1 X2:term, auto___def_67 X1 -> auto___def_9 X2 -> auto___def_66 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1148 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_66_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1150 : forall X1 X2:term, auto___def_9 X2 -> auto___def_67 X1 -> auto___def_66 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_67 X1 -> auto___def_9 X2 -> auto___def_66 (cons X1 X2)). tauto. exact (rem_1149 X1 X2).
Qed.

Remark rem_1151 : auto___def_51 sym. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_51_sym_1;  tauto.
 tauto.
Qed.

Remark rem_1152 : forall X1 X2:term, auto___def_30 X2 -> auto___type_4 X1 -> auto___type_4 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_4 X1 -> auto___type_4 X1). tauto. exact (rem_821 X1).
Qed.

Remark rem_1153 : forall X2:term, auto___def_30 X2 -> auto___def_30 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1154 : forall X1 X2:term, auto___def_30 X2 -> auto___type_4 X1 -> auto___def_30 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_30 X2 -> auto___def_30 X2). tauto. exact (rem_1153 X2).
Qed.

Remark rem_1155 : forall X1 X2:term, auto___def_30 X2 -> auto___type_4 X1 -> (auto___type_4 X1 /\ auto___def_30 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_4 X1). 2:apply (rem_1152 X1 X2);  assumption.
  cut (auto___def_30 X2). 2:apply (rem_1154 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1156 : forall X1 X2:term, auto___def_30 X2 -> auto___type_4 X1 -> auto___def_29 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1155 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_29_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1157 : auto___def_51 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1158 : auto___def_51 prv -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1157 H);  intros.
Qed.

Remark rem_1159 : forall X1:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_54 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_51 prv -> False). tauto.
  exact (rem_1158).
Qed.

Remark rem_1160 : forall X1:term, auto_knows_current (key prv X1) -> auto___def_54 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1159 X1);  tauto.
Qed.

Remark rem_1161 : forall X1 X2 X3 X4 X5:term, auto___def_39 X1 X2 X3 X4 X5 -> auto___def_46 (xa_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1.
  case (rem_1 X1 X2 X3 X4 X5 A1). clear  A1. intros. apply trans___def_46_xa_old_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_1162 : forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1163 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_1162 X1).
Qed.

Remark rem_1164 : forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1165 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_1164 X2).
Qed.

Remark rem_1166 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_1163 X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_1165 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1167 : forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_41 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1166 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_41_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1168 : forall X1 X2:term, auto___def_44 X2 -> auto___def_43 X1 -> auto___def_41 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_44 X2 -> auto___def_41 (crypt X1 X2)). tauto. exact (rem_1167 X1 X2).
Qed.

Remark rem_1169 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_32 (xb_old X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_754 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_32_xb_old_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1170 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_12 X3 -> auto___def_32 (xb_old X1 X2 X3 X4 X5). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_32 (xb_old X1 X2 X3 X4 X5)). tauto. exact (rem_1169 X1 X2 X3 X4 X5).
Qed.

Remark rem_1171 : forall X1 X2 X3 X4 X5:term, auto___def_22 X1 X2 X4 X5 X3 -> auto___def_32 (xb_old X1 X2 X3 X4 X5). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_431 X1 X2 X4 X5 X3 H);  intros.
  apply (rem_1170 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1172 : forall X1:term, auto___def_71 X1 -> auto___def_71 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1173 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_71 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_71 X1 -> auto___def_71 X1). tauto. exact (rem_1172 X1).
Qed.

Remark rem_1174 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_72 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_72 X2 -> auto___def_72 X2). tauto. exact (rem_667 X2).
Qed.

Remark rem_1175 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> (auto___def_71 X1 /\ auto___def_72 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_71 X1). 2:apply (rem_1173 X1 X2);  assumption.
  cut (auto___def_72 X2). 2:apply (rem_1174 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1176 : forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto___def_70 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1175 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_70_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1177 : forall X1 X2:term, auto___def_72 X2 -> auto___def_71 X1 -> auto___def_70 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_71 X1 -> auto___def_72 X2 -> auto___def_70 (cons X1 X2)). tauto. exact (rem_1176 X1 X2).
Qed.

Remark rem_1178 : forall X1:term, auto___def_85 X1 -> auto___def_85 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1179 : forall X1 X2:term, auto___def_85 X1 -> auto___type_12 X2 -> auto___def_85 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_85 X1 -> auto___def_85 X1). tauto. exact (rem_1178 X1).
Qed.

Remark rem_1180 : forall X1 X2:term, auto___def_85 X1 -> auto___type_12 X2 -> auto___type_12 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_12 X2 -> auto___type_12 X2). tauto. exact (rem_212 X2).
Qed.

Remark rem_1181 : forall X1 X2:term, auto___def_85 X1 -> auto___type_12 X2 -> (auto___def_85 X1 /\ auto___type_12 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_85 X1). 2:apply (rem_1179 X1 X2);  assumption.
  cut (auto___type_12 X2). 2:apply (rem_1180 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1182 : forall X1 X2:term, auto___def_85 X1 -> auto___type_12 X2 -> auto___def_74 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1181 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_74_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1183 : forall X1 X2:term, auto___type_12 X2 -> auto___def_85 X1 -> auto___def_74 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_85 X1 -> auto___type_12 X2 -> auto___def_74 (key X1 X2)). tauto. exact (rem_1182 X1 X2).
Qed.

Remark rem_1184 : forall X1:term, auto___def_90 X1 -> auto___def_90 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1185 : forall X1 X2:term, auto___def_90 X1 -> auto___def_91 X2 -> auto___def_90 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_90 X1 -> auto___def_90 X1). tauto. exact (rem_1184 X1).
Qed.

Remark rem_1186 : forall X2:term, auto___def_91 X2 -> auto___def_91 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1187 : forall X1 X2:term, auto___def_90 X1 -> auto___def_91 X2 -> auto___def_91 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_91 X2 -> auto___def_91 X2). tauto. exact (rem_1186 X2).
Qed.

Remark rem_1188 : forall X1 X2:term, auto___def_90 X1 -> auto___def_91 X2 -> (auto___def_90 X1 /\ auto___def_91 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_90 X1). 2:apply (rem_1185 X1 X2);  assumption.
  cut (auto___def_91 X2). 2:apply (rem_1187 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1189 : forall X1 X2:term, auto___def_90 X1 -> auto___def_91 X2 -> auto___def_88 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1188 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_88_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1190 : forall X1 X2:term, auto___def_91 X2 -> auto___def_90 X1 -> auto___def_88 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_90 X1 -> auto___def_91 X2 -> auto___def_88 (crypt X1 X2)). tauto. exact (rem_1189 X1 X2).
Qed.

Remark rem_1191 : auto___def_21 prv. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_21_prv_1;  tauto.
 tauto.
Qed.

Remark rem_1192 : forall X1:term, auto___def_45 X1 -> auto___def_45 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1193 : forall X1 X2:term, auto___def_45 X1 -> auto___type_6 X2 -> auto___def_45 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_45 X1 -> auto___def_45 X1). tauto. exact (rem_1192 X1).
Qed.

Remark rem_1194 : forall X2:term, auto___type_6 X2 -> auto___type_6 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1195 : forall X1 X2:term, auto___def_45 X1 -> auto___type_6 X2 -> auto___type_6 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_6 X2 -> auto___type_6 X2). tauto. exact (rem_1194 X2).
Qed.

Remark rem_1196 : forall X1 X2:term, auto___def_45 X1 -> auto___type_6 X2 -> (auto___def_45 X1 /\ auto___type_6 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_45 X1). 2:apply (rem_1193 X1 X2);  assumption.
  cut (auto___type_6 X2). 2:apply (rem_1195 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1197 : forall X1 X2:term, auto___def_45 X1 -> auto___type_6 X2 -> auto___def_44 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1196 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_44_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1198 : forall X1 X2:term, auto___type_6 X2 -> auto___def_45 X1 -> auto___def_44 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_45 X1 -> auto___type_6 X2 -> auto___def_44 (key X1 X2)). tauto. exact (rem_1197 X1 X2).
Qed.

Remark rem_1199 : forall X1 X2 X3 X4 X5:term, auto___def_75 X3 -> auto___def_79 X4 -> auto___def_82 X5 -> auto___type_12 X2 -> auto___type_13 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_93 (xa_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_796 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_93_xa_current_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1200 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_13 X1 -> auto_agent X2 -> auto___type_12 X2 -> auto___def_75 X3 -> auto___def_82 X4 -> auto___def_79 X5 -> auto___def_93 (xa_current X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X5 X4.
  cut (auto___def_75 X3 -> auto___def_79 X4 -> auto___def_82 X5 -> auto___type_12 X2 -> auto___type_13 X1 -> auto_agent X2 -> auto_agent X1 -> auto___def_93 (xa_current X1 X2)). tauto. exact (rem_1199 X1 X2 X3 X4 X5).
Qed.

Remark rem_1201 : forall X1 X2 X3 X4 X5:term, auto___def_86 X1 X2 X3 X4 X5 -> auto___def_93 (xa_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_459 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_1200 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1202 : auto___def_89 nil. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_89_nil_1;  tauto.
 tauto.
Qed.

Remark rem_1203 : (forall X:term, auto___def_52 X -> auto___def_58 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_52_p__def_58.  tauto.
Defined.

Remark rem_1204 : (forall X:term, auto___def_52 X -> auto___def_58 X)
    -> forall X1 X2 X3:term, auto___def_58 (session_old X1 X2 X3). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_52_p__def_58. intros X1 X2 X3.  case (rem_1203 epsilon_m__def_52_p__def_58). clear  epsilon_m__def_52_p__def_58. intros. apply trans___def_58_session_old_1;  tauto.
 clear  epsilon_m__def_52_p__def_58. tauto.
Defined.

Remark rem_1205 : (forall X:term, auto___def_52 X -> auto___def_58 X)
    -> forall X1 X2 X3:term, auto___def_52 (session_old X1 X2 X3) -> auto___def_58 (session_old X1 X2 X3). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_52_p__def_58. intros X1 X2 X3. intro H. intros.
  elim (rem_280 X1 X2 X3 H);  intros.
  apply (rem_1204 epsilon_m__def_52_p__def_58 X1 X2 X3);  tauto.
Defined.

Remark rem_1206 : forall X1:term, auto___def_52 X1 -> auto___def_58 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_52_p__def_58 1.
  intro X. case X.
   intro H. elim (rem_292  H).
   intro H. elim (rem_291  H).
  intros X1 X2. intro H. elim (rem_287 X1 X2 H).
  intros X1 X2. intro H. elim (rem_302 X1 X2 H).
   intro H. elim (rem_285  H).
  intros X1 X2. intro H. elim (rem_304 X1 X2 H).
   intro H. elim (rem_284  H).
  intros X1 X2. intro H. elim (rem_297 X1 X2 H).
  intros X1 X2. intro H. elim (rem_290 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_299 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_293 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_298  H).
   intro H. elim (rem_303  H).
  intros X1. intro H. elim (rem_282 X1 H).
   intro H. elim (rem_289  H).
  intros X1 X2 X3;  exact (rem_1205 epsilon_m__def_52_p__def_58 X1 X2 X3).
   intro H. elim (rem_288  H).
  intros X1 X2. intro H. elim (rem_294 X1 X2 H).
  intros X1 X2. intro H. elim (rem_286 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_305 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_300 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_296 X1 X2 H).
  intros X1 X2. intro H. elim (rem_283 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_295 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_301 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1207 : forall X1:term, auto___def_51 sym -> auto___def_52 X1 -> auto___def_58 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1.
  cut (auto___def_52 X1 -> auto___def_58 X1). tauto. exact (rem_1206 X1).
Qed.

Remark rem_1208 : forall X1:term, auto_knows_current (key sym X1) -> auto___def_58 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_309 sym X1 H);  intros.
  apply (rem_1207 X1);  tauto.
Qed.

Remark rem_1209 : forall X1:term, auto_knows_old (key pub X1) -> auto___def_4 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_30 pub X1 H);  intros.
Qed.

Remark rem_1210 : forall X1 X2 X3 X4 X5:term, auto___def_95 X2 X3 X1 X4 X5 -> auto___type_19 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_68 X2 X3 X1 X4 X5 H);  intros.
Qed.

Remark rem_1211 : forall X1 X2 X3 X4 X5:term, auto_knows_old (cons X1 (cons (crypt (cons X2 (cons (nonceb_old X1 X2 X5 X3 X4) nil)) (key prv X1)) nil)) -> auto_knows_old (cons X1 (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil)) -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2.
  tauto.
Qed.

Remark rem_1212 : forall X1 X2 X3 X4 X5:term, auto_knows_old (cons X1 (cons (crypt (cons X2 (cons (nonceb_old X1 X2 X5 X3 X4) nil)) (key prv X1)) nil)) -> auto_knows_old (cons X1 (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil)) -> auto___def_48 X1 X2 X3 X4 X5. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2.
  case (rem_1211 X1 X2 X3 X4 X5 A1 A2). clear  A1 A2. intros. apply trans___def_48_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1213 : auto___def_84 pub. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_84_pub_1;  tauto.
 tauto.
Qed.

Remark rem_1214 : forall X1 X2 X3 X4 X5:term, auto___def_95 X2 X3 X4 X1 X5 -> auto___type_20 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_68 X2 X3 X4 X1 X5 H);  intros.
Qed.

Remark rem_1215 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_75 (nonceb_current X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_730 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_75_nonceb_current_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1216 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_62 X3 -> auto___def_75 (nonceb_current X1 X2 X3 X4 X5). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_75 (nonceb_current X1 X2 X3 X4 X5)). tauto. exact (rem_1215 X1 X2 X3 X4 X5).
Qed.

Remark rem_1217 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_75 (nonceb_current X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_754 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_75_nonceb_current_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1218 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_12 X3 -> auto___def_75 (nonceb_current X1 X2 X3 X4 X5). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_75 (nonceb_current X1 X2 X3 X4 X5)). tauto. exact (rem_1217 X1 X2 X3 X4 X5).
Qed.

Remark rem_1219 : forall X1 X2 X3 X4 X5:term, auto___def_69 X1 X2 X4 X5 X3 -> auto___def_75 (nonceb_current X1 X2 X3 X4 X5). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_757 X1 X2 X4 X5 X3 H);  intros.
  apply (rem_1216 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1218 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1220 : forall X1:term, auto___def_20 X1 -> auto___def_20 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1221 : forall X1 X2:term, auto___def_20 X1 -> auto_agent X2 -> auto___def_20 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_20 X1 -> auto___def_20 X1). tauto. exact (rem_1220 X1).
Qed.

Remark rem_1222 : forall X1 X2:term, auto___def_20 X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_57 X2).
Qed.

Remark rem_1223 : forall X1 X2:term, auto___def_20 X1 -> auto_agent X2 -> (auto___def_20 X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_20 X1). 2:apply (rem_1221 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1222 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1224 : forall X1 X2:term, auto___def_20 X1 -> auto_agent X2 -> auto___def_19 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1223 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_19_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1225 : forall X1 X2:term, auto_agent X2 -> auto___def_20 X1 -> auto___def_19 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_20 X1 -> auto_agent X2 -> auto___def_19 (key X1 X2)). tauto. exact (rem_1224 X1 X2).
Qed.

Remark rem_1226 : forall X1:term, auto___def_18 X1 -> auto___def_18 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1227 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_18 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_18 X1). tauto. exact (rem_1226 X1).
Qed.

Remark rem_1228 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_19 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_19 X2 -> auto___def_19 X2). tauto. exact (rem_817 X2).
Qed.

Remark rem_1229 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> (auto___def_18 X1 /\ auto___def_19 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_18 X1). 2:apply (rem_1227 X1 X2);  assumption.
  cut (auto___def_19 X2). 2:apply (rem_1228 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1230 : forall X1 X2:term, auto___def_18 X1 -> auto___def_19 X2 -> auto___def_17 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1229 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_17_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1231 : forall X1 X2:term, auto___def_19 X2 -> auto___def_18 X1 -> auto___def_17 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_18 X1 -> auto___def_19 X2 -> auto___def_17 (crypt X1 X2)). tauto. exact (rem_1230 X1 X2).
Qed.

Remark rem_1232 : forall X1:term, auto___def_8 X1 -> auto___def_8 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1233 : forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> auto___def_8 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_8 X1 -> auto___def_8 X1). tauto. exact (rem_1232 X1).
Qed.

Remark rem_1234 : forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> auto___def_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_9 X2 -> auto___def_9 X2). tauto. exact (rem_950 X2).
Qed.

Remark rem_1235 : forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> (auto___def_8 X1 /\ auto___def_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_8 X1). 2:apply (rem_1233 X1 X2);  assumption.
  cut (auto___def_9 X2). 2:apply (rem_1234 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1236 : forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> auto___def_7 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1235 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_7_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1237 : forall X1 X2:term, auto___def_9 X2 -> auto___def_8 X1 -> auto___def_7 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_8 X1 -> auto___def_9 X2 -> auto___def_7 (cons X1 X2)). tauto. exact (rem_1236 X1 X2).
Qed.

Remark rem_1238 : forall X1:term, auto_knows_old (key prv X1) -> auto___def_2 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_30 prv X1 H);  intros.
Qed.

Remark rem_1239 : auto___def_38 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1240 : auto___def_38 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1239 H);  intros.
Qed.

Remark rem_1241 : forall X1 X2:term, auto___def_26 X2 -> auto___def_38 pub -> auto___type_3 X1 -> auto___def_53 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_38 pub -> False). tauto.
  exact (rem_1240).
Qed.

Remark rem_1242 : forall X1 X2:term, auto___def_38 pub -> auto___type_3 X1 -> auto___def_26 X2 -> auto___def_53 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 X2 -> auto___def_38 pub -> auto___type_3 X1 -> auto___def_53 X1 X2). tauto. exact (rem_1241 X1 X2).
Qed.

Remark rem_1243 : forall X1 X2:term, auto___def_26 X2 -> auto___def_27 (key pub X1) -> auto___def_53 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_16 pub X1 H);  intros.
  apply (rem_1242 X1 X2);  tauto.
Qed.

Remark rem_1244 : auto___def_92 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1245 : auto___def_92 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1244 H);  intros.
Qed.

Remark rem_1246 : forall X1 X2:term, auto___def_90 X2 -> auto___def_92 pub -> auto___type_15 X1 -> auto___def_53 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_92 pub -> False). tauto.
  exact (rem_1245).
Qed.

Remark rem_1247 : forall X1 X2:term, auto___def_92 pub -> auto___type_15 X1 -> auto___def_90 X2 -> auto___def_53 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_90 X2 -> auto___def_92 pub -> auto___type_15 X1 -> auto___def_53 X1 X2). tauto. exact (rem_1246 X1 X2).
Qed.

Remark rem_1248 : forall X1 X2:term, auto___def_90 X2 -> auto___def_91 (key pub X1) -> auto___def_53 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_318 pub X1 H);  intros.
  apply (rem_1247 X1 X2);  tauto.
Qed.

Remark rem_1249 : auto___def_85 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1250 : auto___def_85 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1249 H);  intros.
Qed.

Remark rem_1251 : forall X1 X2:term, auto___def_73 X2 -> auto___def_85 pub -> auto___type_12 X1 -> auto___def_53 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_85 pub -> False). tauto.
  exact (rem_1250).
Qed.

Remark rem_1252 : forall X1 X2:term, auto___def_85 pub -> auto___type_12 X1 -> auto___def_73 X2 -> auto___def_53 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_73 X2 -> auto___def_85 pub -> auto___type_12 X1 -> auto___def_53 X1 X2). tauto. exact (rem_1251 X1 X2).
Qed.

Remark rem_1253 : forall X1 X2:term, auto___def_73 X2 -> auto___def_74 (key pub X1) -> auto___def_53 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_240 pub X1 H);  intros.
  apply (rem_1252 X1 X2);  tauto.
Qed.

Remark rem_1254 : auto___def_45 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1255 : auto___def_45 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1254 H);  intros.
Qed.

Remark rem_1256 : forall X1 X2:term, auto___def_43 X2 -> auto___def_45 pub -> auto___type_6 X1 -> auto___def_53 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_45 pub -> False). tauto.
  exact (rem_1255).
Qed.

Remark rem_1257 : forall X1 X2:term, auto___def_45 pub -> auto___type_6 X1 -> auto___def_43 X2 -> auto___def_53 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_43 X2 -> auto___def_45 pub -> auto___type_6 X1 -> auto___def_53 X1 X2). tauto. exact (rem_1256 X1 X2).
Qed.

Remark rem_1258 : forall X1 X2:term, auto___def_43 X2 -> auto___def_44 (key pub X1) -> auto___def_53 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_22 pub X1 H);  intros.
  apply (rem_1257 X1 X2);  tauto.
Qed.

Remark rem_1259 : auto___def_21 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1260 : auto___def_21 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1259 H);  intros.
Qed.

Remark rem_1261 : forall X1 X2:term, auto___def_21 pub -> auto___def_61 X2 -> auto_agent X1 -> auto___def_53 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 pub -> False). tauto.
  exact (rem_1260).
Qed.

Remark rem_1262 : forall X1 X2:term, auto___def_21 pub -> auto_agent X1 -> auto___def_61 X2 -> auto___def_53 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_21 pub -> auto___def_61 X2 -> auto_agent X1 -> auto___def_53 X1 X2). tauto. exact (rem_1261 X1 X2).
Qed.

Remark rem_1263 : forall X1 X2:term, auto___def_11 (key pub X1) -> auto___def_61 X2 -> auto___def_53 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_28 pub X1 H);  intros.
  apply (rem_1262 X1 X2);  tauto.
Qed.

Remark rem_1264 : forall X1 X2:term, auto___def_61 X2 -> auto___def_11 (key pub X1) -> auto___def_53 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_11 (key pub X1) -> auto___def_61 X2 -> auto___def_53 X1 X2). tauto. exact (rem_1263 X1 X2).
Qed.

Remark rem_1265 : forall X1 X2:term, auto___def_10 X2 -> auto___def_21 pub -> auto_agent X1 -> auto___def_53 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 pub -> False). tauto.
  exact (rem_1260).
Qed.

Remark rem_1266 : forall X1 X2:term, auto___def_21 pub -> auto_agent X1 -> auto___def_10 X2 -> auto___def_53 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X2 -> auto___def_21 pub -> auto_agent X1 -> auto___def_53 X1 X2). tauto. exact (rem_1265 X1 X2).
Qed.

Remark rem_1267 : forall X1 X2:term, auto___def_10 X2 -> auto___def_11 (key pub X1) -> auto___def_53 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_28 pub X1 H);  intros.
  apply (rem_1266 X1 X2);  tauto.
Qed.

Remark rem_1268 : auto___def_51 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1269 : auto___def_51 pub -> False. (* Eliminate negative atom. *)
Proof.
  intro H. intros.
  elim (rem_1268 H);  intros.
Qed.

Remark rem_1270 : forall X1 X2:term, auto___def_51 pub -> auto___def_52 X1 -> auto_knows_current X2 -> auto___def_53 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_51 pub -> False). tauto.
  exact (rem_1269).
Qed.

Remark rem_1271 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key pub X1) -> auto___def_53 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_309 pub X1 H);  intros.
  apply (rem_1270 X1 X2);  tauto.
Qed.

Remark rem_1272 : forall X1 X2:term, auto_knows_current (crypt X2 (key pub X1)) -> auto___def_53 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_346 X2 (key pub X1) H);  intros.
  apply (rem_1243 X1 X2);  tauto.
  apply (rem_1248 X1 X2);  tauto.
  apply (rem_1253 X1 X2);  tauto.
  apply (rem_1258 X1 X2);  tauto.
  apply (rem_1264 X1 X2);  tauto.
  apply (rem_1267 X1 X2);  tauto.
  apply (rem_1271 X1 X2);  tauto.
Qed.

Remark rem_1273 : forall X1 X2:term, auto___def_26 X2 -> auto___def_38 pub -> auto___type_3 X1 -> auto___def_1 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_38 pub -> False). tauto.
  exact (rem_1240).
Qed.

Remark rem_1274 : forall X1 X2:term, auto___def_38 pub -> auto___type_3 X1 -> auto___def_26 X2 -> auto___def_1 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 X2 -> auto___def_38 pub -> auto___type_3 X1 -> auto___def_1 X1 X2). tauto. exact (rem_1273 X1 X2).
Qed.

Remark rem_1275 : forall X1 X2:term, auto___def_26 X2 -> auto___def_27 (key pub X1) -> auto___def_1 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_16 pub X1 H);  intros.
  apply (rem_1274 X1 X2);  tauto.
Qed.

Remark rem_1276 : forall X1 X2:term, auto___def_43 X2 -> auto___def_45 pub -> auto___type_6 X1 -> auto___def_1 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_45 pub -> False). tauto.
  exact (rem_1255).
Qed.

Remark rem_1277 : forall X1 X2:term, auto___def_45 pub -> auto___type_6 X1 -> auto___def_43 X2 -> auto___def_1 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_43 X2 -> auto___def_45 pub -> auto___type_6 X1 -> auto___def_1 X1 X2). tauto. exact (rem_1276 X1 X2).
Qed.

Remark rem_1278 : forall X1 X2:term, auto___def_43 X2 -> auto___def_44 (key pub X1) -> auto___def_1 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_22 pub X1 H);  intros.
  apply (rem_1277 X1 X2);  tauto.
Qed.

Remark rem_1279 : forall X1 X2:term, auto___def_10 X2 -> auto___def_21 pub -> auto_agent X1 -> auto___def_1 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_21 pub -> False). tauto.
  exact (rem_1260).
Qed.

Remark rem_1280 : forall X1 X2:term, auto___def_21 pub -> auto_agent X1 -> auto___def_10 X2 -> auto___def_1 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X2 -> auto___def_21 pub -> auto_agent X1 -> auto___def_1 X1 X2). tauto. exact (rem_1279 X1 X2).
Qed.

Remark rem_1281 : forall X1 X2:term, auto___def_10 X2 -> auto___def_11 (key pub X1) -> auto___def_1 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_28 pub X1 H);  intros.
  apply (rem_1280 X1 X2);  tauto.
Qed.

Remark rem_1282 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old (key pub X1) -> auto___def_1 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_30 pub X1 H);  intros.
Qed.

Remark rem_1283 : forall X1 X2:term, auto_knows_old (crypt X2 (key pub X1)) -> auto___def_1 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_32 X2 (key pub X1) H);  intros.
  apply (rem_1275 X1 X2);  tauto.
  apply (rem_1278 X1 X2);  tauto.
  apply (rem_1281 X1 X2);  tauto.
  apply (rem_1282 X1 X2);  tauto.
Qed.

Remark rem_1284 : forall X1:term, auto___def_84 X1 -> auto___def_84 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1285 : forall X1 X2:term, auto___def_84 X1 -> auto___type_13 X2 -> auto___def_84 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_84 X1 -> auto___def_84 X1). tauto. exact (rem_1284 X1).
Qed.

Remark rem_1286 : forall X2:term, auto___type_13 X2 -> auto___type_13 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1287 : forall X1 X2:term, auto___def_84 X1 -> auto___type_13 X2 -> auto___type_13 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_13 X2 -> auto___type_13 X2). tauto. exact (rem_1286 X2).
Qed.

Remark rem_1288 : forall X1 X2:term, auto___def_84 X1 -> auto___type_13 X2 -> (auto___def_84 X1 /\ auto___type_13 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_84 X1). 2:apply (rem_1285 X1 X2);  assumption.
  cut (auto___type_13 X2). 2:apply (rem_1287 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1289 : forall X1 X2:term, auto___def_84 X1 -> auto___type_13 X2 -> auto___def_83 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1288 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_83_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1290 : forall X1 X2:term, auto___type_13 X2 -> auto___def_84 X1 -> auto___def_83 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_84 X1 -> auto___type_13 X2 -> auto___def_83 (key X1 X2)). tauto. exact (rem_1289 X1 X2).
Qed.

Remark rem_1291 : forall X1:term, auto___def_73 X1 -> auto___def_73 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1292 : forall X1 X2:term, auto___def_73 X1 -> auto___def_74 X2 -> auto___def_73 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_73 X1 -> auto___def_73 X1). tauto. exact (rem_1291 X1).
Qed.

Remark rem_1293 : forall X2:term, auto___def_74 X2 -> auto___def_74 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1294 : forall X1 X2:term, auto___def_73 X1 -> auto___def_74 X2 -> auto___def_74 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_74 X2 -> auto___def_74 X2). tauto. exact (rem_1293 X2).
Qed.

Remark rem_1295 : forall X1 X2:term, auto___def_73 X1 -> auto___def_74 X2 -> (auto___def_73 X1 /\ auto___def_74 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_73 X1). 2:apply (rem_1292 X1 X2);  assumption.
  cut (auto___def_74 X2). 2:apply (rem_1294 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1296 : forall X1 X2:term, auto___def_73 X1 -> auto___def_74 X2 -> auto___def_71 (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1295 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_71_crypt_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1297 : forall X1 X2:term, auto___def_74 X2 -> auto___def_73 X1 -> auto___def_71 (crypt X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_73 X1 -> auto___def_74 X2 -> auto___def_71 (crypt X1 X2)). tauto. exact (rem_1296 X1 X2).
Qed.

Remark rem_1298 : forall X1:term, auto___def_60 X1 -> auto___def_60 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1299 : forall X1 X2:term, auto___def_60 X1 -> auto___def_9 X2 -> auto___def_60 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_60 X1 -> auto___def_60 X1). tauto. exact (rem_1298 X1).
Qed.

Remark rem_1300 : forall X1 X2:term, auto___def_60 X1 -> auto___def_9 X2 -> auto___def_9 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_9 X2 -> auto___def_9 X2). tauto. exact (rem_950 X2).
Qed.

Remark rem_1301 : forall X1 X2:term, auto___def_60 X1 -> auto___def_9 X2 -> (auto___def_60 X1 /\ auto___def_9 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_60 X1). 2:apply (rem_1299 X1 X2);  assumption.
  cut (auto___def_9 X2). 2:apply (rem_1300 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1302 : forall X1 X2:term, auto___def_60 X1 -> auto___def_9 X2 -> auto___def_59 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1301 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_59_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1303 : forall X1 X2:term, auto___def_9 X2 -> auto___def_60 X1 -> auto___def_59 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_60 X1 -> auto___def_9 X2 -> auto___def_59 (cons X1 X2)). tauto. exact (rem_1302 X1 X2).
Qed.

Remark rem_1304 : forall X1:term, auto___def_38 X1 -> auto___def_38 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1305 : forall X1 X2:term, auto___def_38 X1 -> auto___type_3 X2 -> auto___def_38 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_38 X1 -> auto___def_38 X1). tauto. exact (rem_1304 X1).
Qed.

Remark rem_1306 : forall X1 X2:term, auto___def_38 X1 -> auto___type_3 X2 -> auto___type_3 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 X2 -> auto___type_3 X2). tauto. exact (rem_870 X2).
Qed.

Remark rem_1307 : forall X1 X2:term, auto___def_38 X1 -> auto___type_3 X2 -> (auto___def_38 X1 /\ auto___type_3 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_38 X1). 2:apply (rem_1305 X1 X2);  assumption.
  cut (auto___type_3 X2). 2:apply (rem_1306 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1308 : forall X1 X2:term, auto___def_38 X1 -> auto___type_3 X2 -> auto___def_27 (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1307 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_27_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1309 : forall X1 X2:term, auto___type_3 X2 -> auto___def_38 X1 -> auto___def_27 (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_38 X1 -> auto___type_3 X2 -> auto___def_27 (key X1 X2)). tauto. exact (rem_1308 X1 X2).
Qed.

Remark rem_1310 : forall X1 X2 X3 X4 X5:term, auto___def_95 X1 X2 X4 X5 X3 -> auto___def_97 (yb_current X1 X2 X3 X4 X5). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_68 X1 X2 X4 X5 X3 H);  intros.
Qed.

Remark rem_1311 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_35 (yb_old X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_754 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_35_yb_old_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1312 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_12 X3 -> auto___def_35 (yb_old X1 X2 X3 X4 X5). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_35 (yb_old X1 X2 X3 X4 X5)). tauto. exact (rem_1311 X1 X2 X3 X4 X5).
Qed.

Remark rem_1313 : forall X1 X2 X3 X4 X5:term, auto___def_22 X1 X2 X4 X5 X3 -> auto___def_35 (yb_old X1 X2 X3 X4 X5). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_431 X1 X2 X4 X5 X3 H);  intros.
  apply (rem_1312 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1314 : forall X1 X2 X3 X4 X5:term, auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_79 (xb_current X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_730 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_79_xb_current_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1315 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_62 X3 -> auto___def_79 (xb_current X1 X2 X3 X4 X5). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X1 -> auto___def_79 (xb_current X1 X2 X3 X4 X5)). tauto. exact (rem_1314 X1 X2 X3 X4 X5).
Qed.

Remark rem_1316 : forall X1 X2 X3 X4 X5:term, auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_79 (xb_current X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_754 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_79_xb_current_2;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1317 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_12 X3 -> auto___def_79 (xb_current X1 X2 X3 X4 X5). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto___def_79 (xb_current X1 X2 X3 X4 X5)). tauto. exact (rem_1316 X1 X2 X3 X4 X5).
Qed.

Remark rem_1318 : forall X1 X2 X3 X4 X5:term, auto___def_69 X1 X2 X4 X5 X3 -> auto___def_79 (xb_current X1 X2 X3 X4 X5). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_757 X1 X2 X4 X5 X3 H);  intros.
  apply (rem_1315 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1317 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1319 : forall X1 X2 X3 X4 X5:term, auto___def_95 X1 X2 X4 X5 X3 -> auto___def_96 (xb_current X1 X2 X3 X4 X5). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_68 X1 X2 X4 X5 X3 H);  intros.
Qed.

Remark rem_1320 : auto___def_72 nil. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_72_nil_1;  tauto.
 tauto.
Qed.

Remark rem_1321 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1322 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1321 epsilon_m__def_79_p__type_16 X1).
Defined.

Remark rem_1323 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1:term, auto_knows_current X1 -> auto_knows_current X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1324 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1323 epsilon_m__def_79_p__type_16 X1).
Defined.

Remark rem_1325 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1326 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1325 epsilon_m__def_79_p__type_16 X2).
Defined.

Remark rem_1327 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X2:term, auto___type_2 X2 -> auto___type_2 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1328 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_1327 epsilon_m__def_79_p__type_16 X2).
Defined.

Remark rem_1329 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X3:term, auto___def_62 X3 -> auto___def_62 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1330 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_62 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X3 -> auto___def_62 X3). tauto. exact (rem_1329 epsilon_m__def_79_p__type_16 X3).
Defined.

Remark rem_1331 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X4:term, auto___def_65 X4 -> auto___def_65 X4. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1332 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_65 X4. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto___def_65 X4 -> auto___def_65 X4). tauto. exact (rem_1331 epsilon_m__def_79_p__type_16 X4).
Defined.

Remark rem_1333 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X5:term, auto___def_68 X5 -> auto___def_68 X5. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1334 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_68 X5. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto___def_68 X5 -> auto___def_68 X5). tauto. exact (rem_1333 epsilon_m__def_79_p__type_16 X5).
Defined.

Remark rem_1335 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> (auto_agent X1 /\ auto_knows_current X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_62 X3 /\ auto___def_65 X4 /\ auto___def_68 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_1322 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto_knows_current X1). 2:apply (rem_1324 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_1326 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_1328 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_62 X3). 2:apply (rem_1330 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_65 X4). 2:apply (rem_1332 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_68 X5). 2:apply (rem_1334 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  tauto.
Defined.

Remark rem_1336 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_62 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___type_16 (xb_current X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1335 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  epsilon_m__def_79_p__type_16 A1 A2 A3 A4 A5 A6 A7. intros. apply trans___type_16_xb_current_1;  tauto.
 clear  epsilon_m__def_79_p__type_16 A1 A2 A3 A4 A5 A6 A7. tauto.
Defined.

Remark rem_1337 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1321 epsilon_m__def_79_p__type_16 X1).
Defined.

Remark rem_1338 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1:term, auto___type_1 X1 -> auto___type_1 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1339 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_1 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto___type_1 X1 -> auto___type_1 X1). tauto. exact (rem_1338 epsilon_m__def_79_p__type_16 X1).
Defined.

Remark rem_1340 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1325 epsilon_m__def_79_p__type_16 X2).
Defined.

Remark rem_1341 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_2 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X2 -> auto___type_2 X2). tauto. exact (rem_1327 epsilon_m__def_79_p__type_16 X2).
Defined.

Remark rem_1342 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X3:term, auto___def_12 X3 -> auto___def_12 X3. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1343 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_12 X3. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X3 -> auto___def_12 X3). tauto. exact (rem_1342 epsilon_m__def_79_p__type_16 X3).
Defined.

Remark rem_1344 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X4:term, auto___def_15 X4 -> auto___def_15 X4. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1345 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_15 X4. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto___def_15 X4 -> auto___def_15 X4). tauto. exact (rem_1344 epsilon_m__def_79_p__type_16 X4).
Defined.

Remark rem_1346 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X5:term, auto___def_18 X5 -> auto___def_18 X5. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1347 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_18 X5. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5.
  cut (auto___def_18 X5 -> auto___def_18 X5). tauto. exact (rem_1346 epsilon_m__def_79_p__type_16 X5).
Defined.

Remark rem_1348 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> (auto_agent X1 /\ auto___type_1 X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_12 X3 /\ auto___def_15 X4 /\ auto___def_18 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_1337 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_1 X1). 2:apply (rem_1339 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto_agent X2). 2:apply (rem_1340 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_2 X2). 2:apply (rem_1341 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_12 X3). 2:apply (rem_1343 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_15 X4). 2:apply (rem_1345 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_18 X5). 2:apply (rem_1347 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  assumption.
  tauto.
Defined.

Remark rem_1349 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___type_16 (xb_current X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1348 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  epsilon_m__def_79_p__type_16 A1 A2 A3 A4 A5 A6 A7. intros. apply trans___type_16_xb_current_2;  tauto.
 clear  epsilon_m__def_79_p__type_16 A1 A2 A3 A4 A5 A6 A7. tauto.
Defined.

Remark rem_1350 : forall X1 X2 X3 X4 X5:term, auto___def_79 (xb_current X1 X2 X3 X4 X5) -> or_2
    (auto_agent X1 /\ auto_knows_current X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_62 X3 /\ auto___def_65 X4 /\ auto___def_68 X5)
    (auto_agent X1 /\ auto___type_1 X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_12 X3 /\ auto___def_15 X4 /\ auto___def_18 X5)
.
Proof.
  intros. inversion H.
  intros. apply or_2_intro_1; tauto.
  intros. apply or_2_intro_2; tauto.
Qed.

Remark rem_1351 : (forall X:term, auto___def_79 X -> auto___type_16 X)
    -> forall X1 X2 X3 X4 X5:term, auto___def_79 (xb_current X1 X2 X3 X4 X5) -> auto___type_16 (xb_current X1 X2 X3 X4 X5). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_79_p__type_16. intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_1350 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_1336 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1349 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5);  tauto.
Defined.

Remark rem_1352 : forall X1:term, auto___def_79 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1353 : forall X1 X2:term, auto___def_79 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1354 : auto___def_79 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1355 : auto___def_79 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1356 : forall X1 X2:term, auto___def_79 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1357 : forall X1 X2 X3:term, auto___def_79 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1358 : forall X1 X2:term, auto___def_79 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1359 : auto___def_79 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1360 : auto___def_79 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1361 : forall X1 X2:term, auto___def_79 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1362 : auto___def_79 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1363 : auto___def_79 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1364 : forall X1 X2 X3 X4 X5:term, auto___def_79 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1365 : forall X1 X2:term, auto___def_79 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1366 : forall X1 X2 X3 X4 X5:term, auto___def_79 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1367 : forall X1 X2:term, auto___def_79 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1368 : forall X1 X2:term, auto___def_79 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1369 : auto___def_79 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1370 : forall X1 X2 X3 X4 X5:term, auto___def_79 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1371 : forall X1 X2 X3 X4 X5:term, auto___def_79 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1372 : forall X1 X2 X3 X4 X5:term, auto___def_79 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1373 : auto___def_79 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1374 : forall X1 X2:term, auto___def_79 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1375 : forall X1:term, auto___def_79 X1 -> auto___type_16 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_79_p__type_16 1.
  intro X. case X.
   intro H. elim (rem_1363  H).
   intro H. elim (rem_1362  H).
  intros X1 X2. intro H. elim (rem_1358 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1023 X1 X2 H).
   intro H. elim (rem_1355  H).
  intros X1 X2. intro H. elim (rem_1374 X1 X2 H).
   intro H. elim (rem_1354  H).
  intros X1 X2. intro H. elim (rem_1368 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1361 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1370 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1364 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_1369  H).
   intro H. elim (rem_1373  H).
  intros X1. intro H. elim (rem_1352 X1 H).
   intro H. elim (rem_1360  H).
  intros X1 X2 X3. intro H. elim (rem_1357 X1 X2 X3 H).
   intro H. elim (rem_1359  H).
  intros X1 X2. intro H. elim (rem_1365 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1356 X1 X2 H).
  intros X1 X2 X3 X4 X5;  exact (rem_1351 epsilon_m__def_79_p__type_16 X1 X2 X3 X4 X5).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1371 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_1367 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1353 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1366 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1372 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1376 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_79 X1 -> auto___def_82 X3 -> auto___type_12 X4 -> auto___type_13 X5 -> auto_agent X5 -> auto_agent X4 -> auto___type_16 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_79 X1 -> auto___type_16 X1). tauto. exact (rem_1375 X1).
Qed.

Remark rem_1377 : forall X1 X2 X3 X4 X5:term, auto_agent X2 -> auto___type_13 X2 -> auto_agent X3 -> auto___type_12 X3 -> auto___def_75 X4 -> auto___def_82 X5 -> auto___def_79 X1 -> auto___type_16 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X5 X4 X2 X3.
  cut (auto___def_75 X2 -> auto___def_79 X1 -> auto___def_82 X3 -> auto___type_12 X4 -> auto___type_13 X5 -> auto_agent X5 -> auto_agent X4 -> auto___type_16 X1). tauto. exact (rem_1376 X1 X2 X3 X4 X5).
Qed.

Remark rem_1378 : forall X1 X2 X3 X4 X5:term, auto___def_86 X2 X3 X4 X5 X1 -> auto___type_16 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_459 X2 X3 X4 X5 X1 H);  intros.
  apply (rem_1377 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1379 : auto___def_85 prv. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_85_prv_1;  tauto.
 tauto.
Qed.

Remark rem_1380 : (forall X:term, auto___type_2 X -> auto___type_3 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_3.  tauto.
Defined.

Remark rem_1381 : (forall X:term, auto___type_2 X -> auto___type_3 X)
    -> auto___type_3 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_3.  case (rem_1380 epsilon_m__type_2_p__type_3). clear  epsilon_m__type_2_p__type_3. intros. apply trans___type_3_i_1;  tauto.
 clear  epsilon_m__type_2_p__type_3. tauto.
Defined.

Remark rem_1382 : (forall X:term, auto___type_2 X -> auto___type_3 X)
    -> auto___type_2 i -> auto___type_3 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_3. intro H. intros.
  elim (rem_573 H);  intros.
  apply (rem_1381 epsilon_m__type_2_p__type_3);  tauto.
Defined.

Remark rem_1383 : (forall X:term, auto___type_2 X -> auto___type_3 X)
    -> auto___type_3 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_3.  case (rem_1380 epsilon_m__type_2_p__type_3). clear  epsilon_m__type_2_p__type_3. intros. apply trans___type_3_server_1;  tauto.
 clear  epsilon_m__type_2_p__type_3. tauto.
Defined.

Remark rem_1384 : (forall X:term, auto___type_2 X -> auto___type_3 X)
    -> auto___type_2 server -> auto___type_3 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_3. intro H. intros.
  elim (rem_576 H);  intros.
  apply (rem_1383 epsilon_m__type_2_p__type_3);  tauto.
Defined.

Remark rem_1385 : (forall X:term, auto___type_2 X -> auto___type_3 X)
    -> auto___type_3 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_3.  case (rem_1380 epsilon_m__type_2_p__type_3). clear  epsilon_m__type_2_p__type_3. intros. apply trans___type_3_bob_1;  tauto.
 clear  epsilon_m__type_2_p__type_3. tauto.
Defined.

Remark rem_1386 : (forall X:term, auto___type_2 X -> auto___type_3 X)
    -> auto___type_2 bob -> auto___type_3 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_3. intro H. intros.
  elim (rem_579 H);  intros.
  apply (rem_1385 epsilon_m__type_2_p__type_3);  tauto.
Defined.

Remark rem_1387 : (forall X:term, auto___type_2 X -> auto___type_3 X)
    -> auto___type_3 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_3.  case (rem_1380 epsilon_m__type_2_p__type_3). clear  epsilon_m__type_2_p__type_3. intros. apply trans___type_3_alice_1;  tauto.
 clear  epsilon_m__type_2_p__type_3. tauto.
Defined.

Remark rem_1388 : (forall X:term, auto___type_2 X -> auto___type_3 X)
    -> auto___type_2 alice -> auto___type_3 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_3. intro H. intros.
  elim (rem_582 H);  intros.
  apply (rem_1387 epsilon_m__type_2_p__type_3);  tauto.
Defined.

Remark rem_1389 : forall X1:term, auto___type_2 X1 -> auto___type_3 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_2_p__type_3 1.
  intro X. case X.
  exact (rem_1388 epsilon_m__type_2_p__type_3 ).
  exact (rem_1386 epsilon_m__type_2_p__type_3 ).
  intros X1 X2. intro H. elim (rem_589 X1 X2 H).
  intros X1 X2. intro H. elim (rem_601 X1 X2 H).
  exact (rem_1382 epsilon_m__type_2_p__type_3 ).
  intros X1 X2. intro H. elim (rem_603 X1 X2 H).
   intro H. elim (rem_586  H).
  intros X1 X2. intro H. elim (rem_596 X1 X2 H).
  intros X1 X2. intro H. elim (rem_591 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_598 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_592 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_597  H).
   intro H. elim (rem_602  H).
  intros X1. intro H. elim (rem_584 X1 H).
  exact (rem_1384 epsilon_m__type_2_p__type_3 ).
  intros X1 X2 X3. intro H. elim (rem_588 X1 X2 X3 H).
   intro H. elim (rem_590  H).
  intros X1 X2. intro H. elim (rem_593 X1 X2 H).
  intros X1 X2. intro H. elim (rem_587 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_604 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_599 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_595 X1 X2 H).
  intros X1 X2. intro H. elim (rem_585 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_594 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_600 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1390 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_1 X5 -> auto___type_2 X1 -> auto_agent X5 -> auto_agent X1 -> auto___type_3 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X1 -> auto___type_3 X1). tauto. exact (rem_1389 X1).
Qed.

Remark rem_1391 : forall X1 X2 X3 X4 X5:term, auto_agent X2 -> auto___type_1 X2 -> auto_agent X1 -> auto___type_2 X1 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_12 X5 -> auto___type_3 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X5 X3 X4 X2.
  cut (auto___def_12 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_1 X5 -> auto___type_2 X1 -> auto_agent X5 -> auto_agent X1 -> auto___type_3 X1). tauto. exact (rem_1390 X1 X2 X3 X4 X5).
Qed.

Remark rem_1392 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 X1 X3 X4 X5 -> auto___type_3 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_431 X2 X1 X3 X4 X5 H);  intros.
  apply (rem_1391 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1393 : auto___def_42 nil. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_42_nil_1;  tauto.
 tauto.
Qed.

Remark rem_1394 : forall X1:term, auto___def_75 X1 -> auto___def_75 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1395 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___def_75 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_75 X1 -> auto___def_75 X1). tauto. exact (rem_1394 X1).
Qed.

Remark rem_1396 : forall X2:term, auto___def_76 X2 -> auto___def_76 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1397 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___def_76 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_76 X2 -> auto___def_76 X2). tauto. exact (rem_1396 X2).
Qed.

Remark rem_1398 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> (auto___def_75 X1 /\ auto___def_76 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_75 X1). 2:apply (rem_1395 X1 X2);  assumption.
  cut (auto___def_76 X2). 2:apply (rem_1397 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1399 : forall X1 X2:term, auto___def_75 X1 -> auto___def_76 X2 -> auto___def_73 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1398 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_73_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1400 : forall X1 X2:term, auto___def_76 X2 -> auto___def_75 X1 -> auto___def_73 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_75 X1 -> auto___def_76 X2 -> auto___def_73 (cons X1 X2)). tauto. exact (rem_1399 X1 X2).
Qed.

Remark rem_1401 : forall X1:term, auto___def_41 X1 -> auto___def_41 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1402 : forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> auto___def_41 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_41 X1 -> auto___def_41 X1). tauto. exact (rem_1401 X1).
Qed.

Remark rem_1403 : forall X2:term, auto___def_42 X2 -> auto___def_42 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1404 : forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> auto___def_42 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_42 X2 -> auto___def_42 X2). tauto. exact (rem_1403 X2).
Qed.

Remark rem_1405 : forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> (auto___def_41 X1 /\ auto___def_42 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_41 X1). 2:apply (rem_1402 X1 X2);  assumption.
  cut (auto___def_42 X2). 2:apply (rem_1404 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1406 : forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> auto___def_40 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1405 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_40_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1407 : forall X1 X2:term, auto___def_42 X2 -> auto___def_41 X1 -> auto___def_40 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_41 X1 -> auto___def_42 X2 -> auto___def_40 (cons X1 X2)). tauto. exact (rem_1406 X1 X2).
Qed.

Remark rem_1408 : forall X1 X2 X3 X4 X5:term, auto___def_28 X2 -> auto___type_3 X1 -> auto___type_4 (nonceb_current X1 X2 X5 X3 X4) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_698 X1 X2 X5 X3 X4 H);  intros.
Qed.

Remark rem_1409 : forall X1 X2 X3 X4 X5:term, auto___def_28 X2 -> auto___def_30 nil -> auto___type_3 X1 -> auto___type_4 (nonceb_current X1 X2 X5 X3 X4) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X2 -> auto___type_3 X1 -> auto___type_4 (nonceb_current X1 X2 X5 X3 X4) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1408 X1 X2 X3 X4 X5).
Qed.

Remark rem_1410 : forall X1 X2 X3 X4 X5:term, auto___type_4 (nonceb_current X1 X2 X5 X3 X4) -> auto___def_30 nil -> auto___def_28 X2 -> auto___type_3 X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X2 -> auto___def_30 nil -> auto___type_3 X1 -> auto___type_4 (nonceb_current X1 X2 X5 X3 X4) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1409 X1 X2 X3 X4 X5).
Qed.

Remark rem_1411 : forall X1 X2 X3 X4 X5:term, auto___def_28 X2 -> auto___def_29 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___type_3 X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_125 (nonceb_current X1 X2 X5 X3 X4) nil H);  intros.
  apply (rem_1410 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1412 : forall X1 X2 X3 X4 X5:term, auto___def_28 X2 -> auto___def_29 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_38 prv -> auto___type_3 X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X2 -> auto___def_29 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___type_3 X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1411 X1 X2 X3 X4 X5).
Qed.

Remark rem_1413 : forall X1 X2 X3 X4 X5:term, auto___def_38 prv -> auto___type_3 X1 -> auto___def_28 X2 -> auto___def_29 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X2 -> auto___def_29 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_38 prv -> auto___type_3 X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1412 X1 X2 X3 X4 X5).
Qed.

Remark rem_1414 : forall X1 X2 X3 X4 X5:term, auto___def_27 (key prv X1) -> auto___def_28 X2 -> auto___def_29 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_16 prv X1 H);  intros.
  apply (rem_1413 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1415 : forall X1 X2 X3 X4 X5:term, auto___def_28 X2 -> auto___def_29 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_27 (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_27 (key prv X1) -> auto___def_28 X2 -> auto___def_29 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1414 X1 X2 X3 X4 X5).
Qed.

Remark rem_1416 : forall X1 X2 X3 X4 X5:term, auto___def_26 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto___def_27 (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_131 X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil) H);  intros.
  apply (rem_1415 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1417 : forall X1 X2 X3 X4 X5:term, auto___def_75 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_91 (key prv X1) -> auto___type_12 X2 -> auto_agent X2 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_133 (nonceb_current X1 X2 X5 X3 X4) nil H);  intros.
Qed.

Remark rem_1418 : forall X1 X2 X3 X4 X5:term, auto_agent X2 -> auto___type_12 X2 -> auto___def_75 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_91 (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_91 (key prv X1) -> auto___type_12 X2 -> auto_agent X2 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1417 X1 X2 X3 X4 X5).
Qed.

Remark rem_1419 : forall X1 X2 X3 X4 X5:term, auto___def_90 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto___def_91 (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_136 X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil) H);  intros.
  apply (rem_1418 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1420 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___type_12 X1 -> auto___type_13 (nonceb_current X1 X2 X5 X3 X4) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_165 X1 X2 X5 X3 X4 H);  intros.
Qed.

Remark rem_1421 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_77 nil -> auto___type_12 X1 -> auto___type_13 (nonceb_current X1 X2 X5 X3 X4) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X2 -> auto___type_12 X1 -> auto___type_13 (nonceb_current X1 X2 X5 X3 X4) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1420 X1 X2 X3 X4 X5).
Qed.

Remark rem_1422 : forall X1 X2 X3 X4 X5:term, auto___type_13 (nonceb_current X1 X2 X5 X3 X4) -> auto___def_77 nil -> auto___def_75 X2 -> auto___type_12 X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X2 -> auto___def_77 nil -> auto___type_12 X1 -> auto___type_13 (nonceb_current X1 X2 X5 X3 X4) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1421 X1 X2 X3 X4 X5).
Qed.

Remark rem_1423 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_76 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___type_12 X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_236 (nonceb_current X1 X2 X5 X3 X4) nil H);  intros.
  apply (rem_1422 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1424 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_76 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_85 prv -> auto___type_12 X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X2 -> auto___def_76 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___type_12 X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1423 X1 X2 X3 X4 X5).
Qed.

Remark rem_1425 : forall X1 X2 X3 X4 X5:term, auto___def_85 prv -> auto___type_12 X1 -> auto___def_75 X2 -> auto___def_76 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X2 -> auto___def_76 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_85 prv -> auto___type_12 X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1424 X1 X2 X3 X4 X5).
Qed.

Remark rem_1426 : forall X1 X2 X3 X4 X5:term, auto___def_74 (key prv X1) -> auto___def_75 X2 -> auto___def_76 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_240 prv X1 H);  intros.
  apply (rem_1425 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1427 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_76 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_74 (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_74 (key prv X1) -> auto___def_75 X2 -> auto___def_76 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1426 X1 X2 X3 X4 X5).
Qed.

Remark rem_1428 : forall X1 X2 X3 X4 X5:term, auto___def_73 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto___def_74 (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_243 X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil) H);  intros.
  apply (rem_1427 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1429 : forall X1 X2 X3 X4 X5:term, auto___def_28 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_44 (key prv X1) -> auto___type_3 X2 -> auto_agent X2 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_245 (nonceb_current X1 X2 X5 X3 X4) nil H);  intros.
Qed.

Remark rem_1430 : forall X1 X2 X3 X4 X5:term, auto_agent X2 -> auto___type_3 X2 -> auto___def_28 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_44 (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_44 (key prv X1) -> auto___type_3 X2 -> auto_agent X2 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1429 X1 X2 X3 X4 X5).
Qed.

Remark rem_1431 : forall X1 X2 X3 X4 X5:term, auto___def_43 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto___def_44 (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_248 X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil) H);  intros.
  apply (rem_1430 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1432 : forall X1 X2 X3 X4 X5:term, auto___def_62 X2 -> auto___type_2 (nonceb_current X1 X2 X5 X3 X4) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_598 X1 X2 X5 X3 X4 H);  intros.
Qed.

Remark rem_1433 : forall X1 X2 X3 X4 X5:term, auto___def_62 X2 -> auto___def_64 nil -> auto___type_2 (nonceb_current X1 X2 X5 X3 X4) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X2 -> auto___type_2 (nonceb_current X1 X2 X5 X3 X4) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1432 X1 X2 X3 X4 X5).
Qed.

Remark rem_1434 : forall X1 X2 X3 X4 X5:term, auto___type_2 (nonceb_current X1 X2 X5 X3 X4) -> auto___def_64 nil -> auto___def_62 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X2 -> auto___def_64 nil -> auto___type_2 (nonceb_current X1 X2 X5 X3 X4) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1433 X1 X2 X3 X4 X5).
Qed.

Remark rem_1435 : forall X1 X2 X3 X4 X5:term, auto___def_62 X2 -> auto___def_63 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_256 (nonceb_current X1 X2 X5 X3 X4) nil H);  intros.
  apply (rem_1434 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1436 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_258 X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil) H);  intros.
  apply (rem_1435 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1437 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto___def_61 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_61 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1436 X1 X2 X3 X4 X5).
Qed.

Remark rem_1438 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto_agent X1 -> auto___def_61 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_21 prv -> auto___def_61 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1437 X1 X2 X3 X4 X5).
Qed.

Remark rem_1439 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key prv X1) -> auto___def_61 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 prv X1 H);  intros.
  apply (rem_1438 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1440 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto___def_11 (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key prv X1) -> auto___def_61 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1439 X1 X2 X3 X4 X5).
Qed.

Remark rem_1441 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___type_2 (nonceb_current X1 X2 X5 X3 X4) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_598 X1 X2 X5 X3 X4 H);  intros.
Qed.

Remark rem_1442 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_14 nil -> auto___type_2 (nonceb_current X1 X2 X5 X3 X4) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___type_2 (nonceb_current X1 X2 X5 X3 X4) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1441 X1 X2 X3 X4 X5).
Qed.

Remark rem_1443 : forall X1 X2 X3 X4 X5:term, auto___type_2 (nonceb_current X1 X2 X5 X3 X4) -> auto___def_14 nil -> auto___def_12 X2 -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_14 nil -> auto___type_2 (nonceb_current X1 X2 X5 X3 X4) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1442 X1 X2 X3 X4 X5).
Qed.

Remark rem_1444 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_270 (nonceb_current X1 X2 X5 X3 X4) nil H);  intros.
  apply (rem_1443 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1445 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_21 prv -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1444 X1 X2 X3 X4 X5).
Qed.

Remark rem_1446 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto_agent X1 -> auto___def_12 X2 -> auto___def_13 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X2 -> auto___def_13 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_21 prv -> auto_agent X1 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1445 X1 X2 X3 X4 X5).
Qed.

Remark rem_1447 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key prv X1) -> auto___def_12 X2 -> auto___def_13 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 prv X1 H);  intros.
  apply (rem_1446 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1448 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_13 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto___def_11 (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key prv X1) -> auto___def_12 X2 -> auto___def_13 (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1447 X1 X2 X3 X4 X5).
Qed.

Remark rem_1449 : forall X1 X2 X3 X4 X5:term, auto___def_10 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto___def_11 (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_276 X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil) H);  intros.
  apply (rem_1448 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1450 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_542 X4 (key pub X2) H);  intros.
Qed.

Remark rem_1451 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___def_33 nil -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1450 X1 X2 X3 X4 X5).
Qed.

Remark rem_1452 : forall X1 X2 X3 X4 X5:term, auto___def_32 (crypt X4 (key pub X2)) -> auto___def_33 nil -> auto___def_28 X5 -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_32 (crypt X4 (key pub X2)) -> auto___def_33 nil -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1451 X1 X2 X3 X4 X5).
Qed.

Remark rem_1453 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_31 (cons (crypt X4 (key pub X2)) nil) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_119 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_1452 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1454 : forall X1 X2 X3 X4 X5:term, auto___type_5 X3 -> auto___def_31 (cons (crypt X4 (key pub X2)) nil) -> auto___def_28 X5 -> auto___type_3 X1 -> auto___type_4 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_31 (cons (crypt X4 (key pub X2)) nil) -> auto___type_3 X1 -> auto___type_4 X2 -> auto___type_5 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1453 X1 X2 X3 X4 X5).
Qed.

Remark rem_1455 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_30 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_122 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_1454 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1456 : forall X1 X2 X3 X4 X5:term, auto___type_4 X2 -> auto___def_30 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___def_28 X5 -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_30 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_3 X1 -> auto___type_4 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1455 X1 X2 X3 X4 X5).
Qed.

Remark rem_1457 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_125 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_1456 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1458 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_38 prv -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1457 X1 X2 X3 X4 X5).
Qed.

Remark rem_1459 : forall X1 X2 X3 X4 X5:term, auto___def_38 prv -> auto___type_3 X1 -> auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_38 prv -> auto___type_3 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1458 X1 X2 X3 X4 X5).
Qed.

Remark rem_1460 : forall X1 X2 X3 X4 X5:term, auto___def_27 (key prv X1) -> auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_16 prv X1 H);  intros.
  apply (rem_1459 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1461 : forall X1 X2 X3 X4 X5:term, auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_27 (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_27 (key prv X1) -> auto___def_28 X5 -> auto___def_29 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1460 X1 X2 X3 X4 X5).
Qed.

Remark rem_1462 : forall X1 X2 X3 X4 X5:term, auto___def_26 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_27 (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_131 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1461 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1463 : forall X1 X2 X3 X4 X5:term, auto___def_75 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_91 (key prv X1) -> auto___type_12 X5 -> auto_agent X5 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_133 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
Qed.

Remark rem_1464 : forall X1 X2 X3 X4 X5:term, auto_agent X5 -> auto___type_12 X5 -> auto___def_75 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_91 (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_91 (key prv X1) -> auto___type_12 X5 -> auto_agent X5 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1463 X1 X2 X3 X4 X5).
Qed.

Remark rem_1465 : forall X1 X2 X3 X4 X5:term, auto___def_90 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_91 (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_136 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1464 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1466 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_79 (crypt X4 (key pub X2)) -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_1023 X4 (key pub X2) H);  intros.
Qed.

Remark rem_1467 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_79 (crypt X4 (key pub X2)) -> auto___def_80 nil -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_79 (crypt X4 (key pub X2)) -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1466 X1 X2 X3 X4 X5).
Qed.

Remark rem_1468 : forall X1 X2 X3 X4 X5:term, auto___def_79 (crypt X4 (key pub X2)) -> auto___def_80 nil -> auto___def_75 X5 -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_79 (crypt X4 (key pub X2)) -> auto___def_80 nil -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1467 X1 X2 X3 X4 X5).
Qed.

Remark rem_1469 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_78 (cons (crypt X4 (key pub X2)) nil) -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_230 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_1468 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1470 : forall X1 X2 X3 X4 X5:term, auto___type_14 X3 -> auto___def_78 (cons (crypt X4 (key pub X2)) nil) -> auto___def_75 X5 -> auto___type_12 X1 -> auto___type_13 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_78 (cons (crypt X4 (key pub X2)) nil) -> auto___type_12 X1 -> auto___type_13 X2 -> auto___type_14 X3 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1469 X1 X2 X3 X4 X5).
Qed.

Remark rem_1471 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_77 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_12 X1 -> auto___type_13 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_233 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_1470 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1472 : forall X1 X2 X3 X4 X5:term, auto___type_13 X2 -> auto___def_77 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___def_75 X5 -> auto___type_12 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_77 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_12 X1 -> auto___type_13 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1471 X1 X2 X3 X4 X5).
Qed.

Remark rem_1473 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___type_12 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_236 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_1472 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1474 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_85 prv -> auto___type_12 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___type_12 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1473 X1 X2 X3 X4 X5).
Qed.

Remark rem_1475 : forall X1 X2 X3 X4 X5:term, auto___def_85 prv -> auto___type_12 X1 -> auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_85 prv -> auto___type_12 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1474 X1 X2 X3 X4 X5).
Qed.

Remark rem_1476 : forall X1 X2 X3 X4 X5:term, auto___def_74 (key prv X1) -> auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_240 prv X1 H);  intros.
  apply (rem_1475 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1477 : forall X1 X2 X3 X4 X5:term, auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_74 (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_74 (key prv X1) -> auto___def_75 X5 -> auto___def_76 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1476 X1 X2 X3 X4 X5).
Qed.

Remark rem_1478 : forall X1 X2 X3 X4 X5:term, auto___def_73 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_74 (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_243 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1477 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1479 : forall X1 X2 X3 X4 X5:term, auto___def_28 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_44 (key prv X1) -> auto___type_3 X5 -> auto_agent X5 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_245 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
Qed.

Remark rem_1480 : forall X1 X2 X3 X4 X5:term, auto_agent X5 -> auto___type_3 X5 -> auto___def_28 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_44 (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_28 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_44 (key prv X1) -> auto___type_3 X5 -> auto_agent X5 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1479 X1 X2 X3 X4 X5).
Qed.

Remark rem_1481 : forall X1 X2 X3 X4 X5:term, auto___def_43 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_44 (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_248 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1480 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1482 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1483 : forall X1 X2 X3 X4 X5:term, auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6 H7 H8. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1482 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1484 : forall X1 X2 X3 X4 X5:term, auto___def_20 pub -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1483 X1 X2 X3 X4 X5).
Qed.

Remark rem_1485 : forall X1 X2 X3 X4 X5:term, auto___def_20 pub -> auto_agent X2 -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_20 pub -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1484 X1 X2 X3 X4 X5).
Qed.

Remark rem_1486 : forall X1 X2:term, auto___def_19 (key X1 X2) -> or_1
    (auto___def_20 X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1487 : forall X1 X2 X3 X4 X5:term, auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_1486 pub X2 H);  intros.
  apply (rem_1485 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1488 : forall X1 X2 X3 X4 X5:term, auto___def_68 X4 -> auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_19 (key pub X2) -> auto___def_62 X5 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1487 X1 X2 X3 X4 X5).
Qed.

Remark rem_1489 : forall X1 X2 X3 X4 X5:term, auto___def_62 X5 -> auto___def_65 X3 -> auto___def_67 (crypt X4 (key pub X2)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_1053 X4 (key pub X2) H);  intros.
  apply (rem_1488 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1490 : forall X1 X2 X3 X4 X5:term, auto___def_62 X5 -> auto___def_65 X3 -> auto___def_67 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X5 -> auto___def_65 X3 -> auto___def_67 (crypt X4 (key pub X2)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1489 X1 X2 X3 X4 X5).
Qed.

Remark rem_1491 : forall X1 X2 X3 X4 X5:term, auto___def_67 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___def_62 X5 -> auto___def_65 X3 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X5 -> auto___def_65 X3 -> auto___def_67 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1490 X1 X2 X3 X4 X5).
Qed.

Remark rem_1492 : forall X1 X2 X3 X4 X5:term, auto___def_62 X5 -> auto___def_65 X3 -> auto___def_66 (cons (crypt X4 (key pub X2)) nil) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_1057 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_1491 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1493 : forall X1 X2 X3 X4 X5:term, auto___def_65 X3 -> auto___def_66 (cons (crypt X4 (key pub X2)) nil) -> auto___def_62 X5 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X5 -> auto___def_65 X3 -> auto___def_66 (cons (crypt X4 (key pub X2)) nil) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1492 X1 X2 X3 X4 X5).
Qed.

Remark rem_1494 : forall X1 X2 X3 X4 X5:term, auto___def_62 X5 -> auto___def_64 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_253 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_1493 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1495 : forall X1 X2 X3 X4 X5:term, auto___type_2 X2 -> auto___def_64 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___def_62 X5 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X5 -> auto___def_64 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1494 X1 X2 X3 X4 X5).
Qed.

Remark rem_1496 : forall X1 X2 X3 X4 X5:term, auto___def_62 X5 -> auto___def_63 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_256 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_1495 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1497 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_258 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1496 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1498 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1497 X1 X2 X3 X4 X5).
Qed.

Remark rem_1499 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto_agent X1 -> auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_21 prv -> auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1498 X1 X2 X3 X4 X5).
Qed.

Remark rem_1500 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key prv X1) -> auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 prv X1 H);  intros.
  apply (rem_1499 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1501 : forall X1 X2 X3 X4 X5:term, auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_11 (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key prv X1) -> auto___def_61 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1500 X1 X2 X3 X4 X5).
Qed.

Remark rem_1502 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1503 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1502 X1 X2 X3 X4 X5).
Qed.

Remark rem_1504 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6 H7 H8. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1503 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1505 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_20 pub -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1504 X1 X2 X3 X4 X5).
Qed.

Remark rem_1506 : forall X1 X2 X3 X4 X5:term, auto___def_20 pub -> auto_agent X2 -> auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_20 pub -> auto___type_2 X2 -> auto_agent X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1505 X1 X2 X3 X4 X5).
Qed.

Remark rem_1507 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3. intro H. intros.
  elim (rem_1486 pub X2 H);  intros.
  apply (rem_1506 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1508 : forall X1 X2 X3 X4 X5:term, auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___def_12 X5 -> auto___def_15 X3 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_19 (key pub X2) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1507 X1 X2 X3 X4 X5).
Qed.

Remark rem_1509 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_618 X4 (key pub X2) H);  intros.
  apply (rem_1508 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1510 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1509 X1 X2 X3 X4 X5).
Qed.

Remark rem_1511 : forall X1 X2 X3 X4 X5:term, auto___def_17 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___def_12 X5 -> auto___def_15 X3 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_17 (crypt X4 (key pub X2)) -> auto___def_9 nil -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1510 X1 X2 X3 X4 X5).
Qed.

Remark rem_1512 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_15 X3 -> auto___def_16 (cons (crypt X4 (key pub X2)) nil) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_622 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_1511 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1513 : forall X1 X2 X3 X4 X5:term, auto___def_15 X3 -> auto___def_16 (cons (crypt X4 (key pub X2)) nil) -> auto___def_12 X5 -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_15 X3 -> auto___def_16 (cons (crypt X4 (key pub X2)) nil) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1512 X1 X2 X3 X4 X5).
Qed.

Remark rem_1514 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_14 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_267 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_1513 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1515 : forall X1 X2 X3 X4 X5:term, auto___type_2 X2 -> auto___def_14 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___def_12 X5 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_14 (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto___type_2 X2 -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1514 X1 X2 X3 X4 X5).
Qed.

Remark rem_1516 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_270 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_1515 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1517 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_21 prv -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1516 X1 X2 X3 X4 X5).
Qed.

Remark rem_1518 : forall X1 X2 X3 X4 X5:term, auto___def_21 prv -> auto_agent X1 -> auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_21 prv -> auto_agent X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1517 X1 X2 X3 X4 X5).
Qed.

Remark rem_1519 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key prv X1) -> auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 prv X1 H);  intros.
  apply (rem_1518 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1520 : forall X1 X2 X3 X4 X5:term, auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto___def_11 (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key prv X1) -> auto___def_12 X5 -> auto___def_13 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1519 X1 X2 X3 X4 X5).
Qed.

Remark rem_1521 : forall X1 X2 X3 X4 X5:term, auto___def_10 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto___def_11 (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_276 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1520 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1522 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1523 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_26 X4 -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1522 X1 X2 X3 X4 X5).
Qed.

Remark rem_1524 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1523 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1525 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_38 pub -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1524 X1 X2 X3 X4 X5).
Qed.

Remark rem_1526 : forall X1 X2 X3 X4 X5:term, auto___def_38 pub -> auto___type_3 X2 -> auto___def_26 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_26 X4 -> auto___def_38 pub -> auto___type_3 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1525 X1 X2 X3 X4 X5).
Qed.

Remark rem_1527 : forall X1 X2 X3 X4 X5:term, auto___def_26 X4 -> auto___def_27 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_16 pub X2 H);  intros.
  apply (rem_1526 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1528 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_90 X4 -> auto___type_15 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1529 : forall X1 X2 X3 X4 X5:term, auto___def_90 X4 -> auto___type_15 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1528 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1530 : forall X1 X2 X3 X4 X5:term, auto___def_90 X4 -> auto___def_92 pub -> auto___type_15 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_90 X4 -> auto___type_15 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1529 X1 X2 X3 X4 X5).
Qed.

Remark rem_1531 : forall X1 X2 X3 X4 X5:term, auto___def_92 pub -> auto___type_15 X2 -> auto___def_90 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_90 X4 -> auto___def_92 pub -> auto___type_15 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1530 X1 X2 X3 X4 X5).
Qed.

Remark rem_1532 : forall X1 X2 X3 X4 X5:term, auto___def_90 X4 -> auto___def_91 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_318 pub X2 H);  intros.
  apply (rem_1531 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1533 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_73 X4 -> auto___type_12 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1534 : forall X1 X2 X3 X4 X5:term, auto___def_73 X4 -> auto___type_12 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1533 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1535 : forall X1 X2 X3 X4 X5:term, auto___def_73 X4 -> auto___def_85 pub -> auto___type_12 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_73 X4 -> auto___type_12 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1534 X1 X2 X3 X4 X5).
Qed.

Remark rem_1536 : forall X1 X2 X3 X4 X5:term, auto___def_85 pub -> auto___type_12 X2 -> auto___def_73 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_73 X4 -> auto___def_85 pub -> auto___type_12 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1535 X1 X2 X3 X4 X5).
Qed.

Remark rem_1537 : forall X1 X2 X3 X4 X5:term, auto___def_73 X4 -> auto___def_74 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_240 pub X2 H);  intros.
  apply (rem_1536 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1538 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1539 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_43 X4 -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1538 X1 X2 X3 X4 X5).
Qed.

Remark rem_1540 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1539 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1541 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_45 pub -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1540 X1 X2 X3 X4 X5).
Qed.

Remark rem_1542 : forall X1 X2 X3 X4 X5:term, auto___def_45 pub -> auto___type_6 X2 -> auto___def_43 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_43 X4 -> auto___def_45 pub -> auto___type_6 X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1541 X1 X2 X3 X4 X5).
Qed.

Remark rem_1543 : forall X1 X2 X3 X4 X5:term, auto___def_43 X4 -> auto___def_44 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_22 pub X2 H);  intros.
  apply (rem_1542 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1544 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_61 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1545 : forall X1 X2 X3 X4 X5:term, auto___def_61 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1544 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1546 : forall X1 X2 X3 X4 X5:term, auto___def_21 pub -> auto___def_61 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_61 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1545 X1 X2 X3 X4 X5).
Qed.

Remark rem_1547 : forall X1 X2 X3 X4 X5:term, auto___def_21 pub -> auto_agent X2 -> auto___def_61 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_21 pub -> auto___def_61 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1546 X1 X2 X3 X4 X5).
Qed.

Remark rem_1548 : forall X1 X2 X3 X4 X5:term, auto___def_11 (key pub X2) -> auto___def_61 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_28 pub X2 H);  intros.
  apply (rem_1547 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1549 : forall X1 X2 X3 X4 X5:term, auto___def_61 X4 -> auto___def_11 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_11 (key pub X2) -> auto___def_61 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1548 X1 X2 X3 X4 X5).
Qed.

Remark rem_1550 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1551 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto___def_10 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto___def_51 prv -> auto___def_52 X1 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1550 X1 X2 X3 X4 X5).
Qed.

Remark rem_1552 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5 H6. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1551 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1553 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_21 pub -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1552 X1 X2 X3 X4 X5).
Qed.

Remark rem_1554 : forall X1 X2 X3 X4 X5:term, auto___def_21 pub -> auto_agent X2 -> auto___def_10 X4 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_10 X4 -> auto___def_21 pub -> auto_agent X2 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1553 X1 X2 X3 X4 X5).
Qed.

Remark rem_1555 : forall X1 X2 X3 X4 X5:term, auto___def_10 X4 -> auto___def_11 (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_28 pub X2 H);  intros.
  apply (rem_1554 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1556 : forall X1 X2 X3 X4 X5:term, auto___def_51 prv -> auto___def_52 X1 -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X5 -> auto_knows_current (key pub X2) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4 X5. intros.
  assert (HH:=(rem_306 X1)). tauto.
Qed.

Remark rem_1557 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (key pub X2) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4 H5. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1556 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1558 : forall X1 X2 X3 X4 X5:term, auto_knows_current X4 -> auto_knows_current (key pub X2) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X4 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (key pub X2) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1557 X1 X2 X3 X4 X5).
Qed.

Remark rem_1559 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X2)) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_346 X4 (key pub X2) H);  intros.
  apply (rem_1527 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1532 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1537 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1543 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1549 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1555 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1558 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1560 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X2)) -> auto_knows_current (key prv X1) -> auto_knows_current nil -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X2)) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1559 X1 X2 X3 X4 X5).
Qed.

Remark rem_1561 : forall X1 X2 X3 X4 X5:term, auto_knows_current (crypt X4 (key pub X2)) -> auto_knows_current nil -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (crypt X4 (key pub X2)) -> auto_knows_current (key prv X1) -> auto_knows_current nil -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1560 X1 X2 X3 X4 X5).
Qed.

Remark rem_1562 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (cons (crypt X4 (key pub X2)) nil) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3 H4. intro H. intros.
  elim (rem_350 (crypt X4 (key pub X2)) nil H);  intros.
  apply (rem_1561 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1563 : forall X1 X2 X3 X4 X5:term, auto_knows_current X3 -> auto_knows_current (cons (crypt X4 (key pub X2)) nil) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X3 -> auto_knows_current X5 -> auto_knows_current (cons (crypt X4 (key pub X2)) nil) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1562 X1 X2 X3 X4 X5).
Qed.

Remark rem_1564 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3. intro H. intros.
  elim (rem_350 X3 (cons (crypt X4 (key pub X2)) nil) H);  intros.
  apply (rem_1563 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1565 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (cons X3 (cons (crypt X4 (key pub X2)) nil)) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1564 X1 X2 X3 X4 X5).
Qed.

Remark rem_1566 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2 H3. intro H. intros.
  elim (rem_350 X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)) H);  intros.
  apply (rem_1565 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1567 : forall X1 X2 X3 X4 X5:term, auto_knows_current X5 -> auto_knows_current (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X5 -> auto_knows_current (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1566 X1 X2 X3 X4 X5).
Qed.

Remark rem_1568 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_350 X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil))) H);  intros.
  apply (rem_1567 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1569 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current (key prv X1) -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1568 X1 X2 X3 X4 X5).
Qed.

Remark rem_1570 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_346 (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1) H);  intros.
  apply (rem_1462 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1465 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1478 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1481 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1501 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1521 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1569 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1571 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current (key prv X1) -> auto_knows_current nil -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current (key prv X1) -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1570 X1 X2 X3 X4 X5).
Qed.

Remark rem_1572 : forall X1 X2 X3 X4 X5:term, auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto_knows_current nil -> auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current (key prv X1) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current (key prv X1) -> auto_knows_current nil -> auto_knows_current (nonceb_current X1 X2 X5 X3 X4) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1571 X1 X2 X3 X4 X5).
Qed.

Remark rem_1573 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current (key prv X1) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1 H2. intro H. intros.
  elim (rem_350 (nonceb_current X1 X2 X5 X3 X4) nil H);  intros.
  apply (rem_1572 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1574 : forall X1 X2 X3 X4 X5:term, auto_knows_current X2 -> auto_knows_current (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current (key prv X1) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (cons (nonceb_current X1 X2 X5 X3 X4) nil) -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current (key prv X1) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1573 X1 X2 X3 X4 X5).
Qed.

Remark rem_1575 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current (key prv X1) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_350 X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil) H);  intros.
  apply (rem_1574 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1576 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto_knows_current (key prv X1) -> auto_knows_current X1 -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current (key prv X1) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1575 X1 X2 X3 X4 X5).
Qed.

Remark rem_1577 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_346 (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1) H);  intros.
  apply (rem_1416 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1419 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1428 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1431 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1440 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1449 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1576 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1578 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current nil -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1577 X1 X2 X3 X4 X5).
Qed.

Remark rem_1579 : forall X1 X2 X3 X4 X5:term, auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current nil -> auto_knows_current X1 -> auto_knows_current (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) -> auto_knows_current (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) -> auto_knows_current nil -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1578 X1 X2 X3 X4 X5).
Qed.

Remark rem_1580 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) -> auto_knows_current (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_350 (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil H);  intros.
  apply (rem_1579 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1581 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) -> auto_knows_current (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) -> auto_knows_current nil -> auto___def_95 X1 X2 X3 X4 X5. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) -> auto_knows_current (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) -> auto___def_95 X1 X2 X3 X4 X5). tauto.
  exact (rem_1580 X1 X2 X3 X4 X5).
Qed.

Remark rem_1582 : forall X1 X2 X3 X4 X5:term, auto_knows_current (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) -> auto_knows_current nil -> auto_knows_current X1 -> auto_knows_current (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) -> auto_knows_current (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) -> auto_knows_current nil -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1581 X1 X2 X3 X4 X5).
Qed.

Remark rem_1583 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (cons (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) nil) -> auto_knows_current (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_350 (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) nil H);  intros.
  apply (rem_1582 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1584 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) -> auto_knows_current X1 -> auto_knows_current (cons (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) nil) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current (cons (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) nil) -> auto_knows_current (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1583 X1 X2 X3 X4 X5).
Qed.

Remark rem_1585 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (cons X1 (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil)) -> auto_knows_current (cons (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) nil) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros H1. intro H. intros.
  elim (rem_350 X1 (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil) H);  intros.
  apply (rem_1584 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1586 : forall X1 X2 X3 X4 X5:term, auto_knows_current X1 -> auto_knows_current (cons (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) nil) -> auto_knows_current (cons X1 (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil)) -> auto___def_95 X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto_knows_current X1 -> auto_knows_current (cons X1 (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil)) -> auto_knows_current (cons (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) nil) -> auto___def_95 X1 X2 X3 X4 X5). tauto. exact (rem_1585 X1 X2 X3 X4 X5).
Qed.

Remark rem_1587 : forall X1 X2 X3 X4 X5:term, auto_knows_current (cons X1 (cons (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) nil)) -> auto_knows_current (cons X1 (cons (crypt (cons X5 (cons X2 (cons X3 (cons (crypt X4 (key pub X2)) nil)))) (key prv X1)) nil)) -> auto___def_95 X1 X2 X3 X4 X5. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_350 X1 (cons (crypt (cons X2 (cons (nonceb_current X1 X2 X5 X3 X4) nil)) (key prv X1)) nil) H);  intros.
  apply (rem_1586 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1588 : forall X1:term, auto___def_32 X1 -> auto___def_32 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1589 : forall X1 X2:term, auto___def_32 X1 -> auto___def_33 X2 -> auto___def_32 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_32 X1 -> auto___def_32 X1). tauto. exact (rem_1588 X1).
Qed.

Remark rem_1590 : forall X2:term, auto___def_33 X2 -> auto___def_33 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1591 : forall X1 X2:term, auto___def_32 X1 -> auto___def_33 X2 -> auto___def_33 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_33 X2 -> auto___def_33 X2). tauto. exact (rem_1590 X2).
Qed.

Remark rem_1592 : forall X1 X2:term, auto___def_32 X1 -> auto___def_33 X2 -> (auto___def_32 X1 /\ auto___def_33 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_32 X1). 2:apply (rem_1589 X1 X2);  assumption.
  cut (auto___def_33 X2). 2:apply (rem_1591 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1593 : forall X1 X2:term, auto___def_32 X1 -> auto___def_33 X2 -> auto___def_31 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1592 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_31_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1594 : forall X1 X2:term, auto___def_33 X2 -> auto___def_32 X1 -> auto___def_31 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_32 X1 -> auto___def_33 X2 -> auto___def_31 (cons X1 X2)). tauto. exact (rem_1593 X1 X2).
Qed.

Remark rem_1595 : (forall X:term, auto_agent X -> auto___type_13 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_magent_p__type_13.  tauto.
Defined.

Remark rem_1596 : (forall X:term, auto_agent X -> auto___type_13 X)
    -> auto___type_13 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_13.  case (rem_1595 epsilon_magent_p__type_13). clear  epsilon_magent_p__type_13. intros. apply trans___type_13_i_1;  tauto.
 clear  epsilon_magent_p__type_13. tauto.
Defined.

Remark rem_1597 : (forall X:term, auto_agent X -> auto___type_13 X)
    -> auto_agent i -> auto___type_13 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_13. intro H. intros.
  elim (rem_72 H);  intros.
  apply (rem_1596 epsilon_magent_p__type_13);  tauto.
Defined.

Remark rem_1598 : (forall X:term, auto_agent X -> auto___type_13 X)
    -> auto___type_13 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_13.  case (rem_1595 epsilon_magent_p__type_13). clear  epsilon_magent_p__type_13. intros. apply trans___type_13_server_1;  tauto.
 clear  epsilon_magent_p__type_13. tauto.
Defined.

Remark rem_1599 : (forall X:term, auto_agent X -> auto___type_13 X)
    -> auto_agent server -> auto___type_13 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_13. intro H. intros.
  elim (rem_75 H);  intros.
  apply (rem_1598 epsilon_magent_p__type_13);  tauto.
Defined.

Remark rem_1600 : (forall X:term, auto_agent X -> auto___type_13 X)
    -> auto___type_13 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_13.  case (rem_1595 epsilon_magent_p__type_13). clear  epsilon_magent_p__type_13. intros. apply trans___type_13_bob_1;  tauto.
 clear  epsilon_magent_p__type_13. tauto.
Defined.

Remark rem_1601 : (forall X:term, auto_agent X -> auto___type_13 X)
    -> auto_agent bob -> auto___type_13 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_13. intro H. intros.
  elim (rem_78 H);  intros.
  apply (rem_1600 epsilon_magent_p__type_13);  tauto.
Defined.

Remark rem_1602 : (forall X:term, auto_agent X -> auto___type_13 X)
    -> auto___type_13 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_magent_p__type_13.  case (rem_1595 epsilon_magent_p__type_13). clear  epsilon_magent_p__type_13. intros. apply trans___type_13_alice_1;  tauto.
 clear  epsilon_magent_p__type_13. tauto.
Defined.

Remark rem_1603 : (forall X:term, auto_agent X -> auto___type_13 X)
    -> auto_agent alice -> auto___type_13 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_p__type_13. intro H. intros.
  elim (rem_81 H);  intros.
  apply (rem_1602 epsilon_magent_p__type_13);  tauto.
Defined.

Remark rem_1604 : forall X1:term, auto_agent X1 -> auto___type_13 X1. (* Induct. *)
Proof.
  fix epsilon_magent_p__type_13 1.
  intro X. case X.
  exact (rem_1603 epsilon_magent_p__type_13 ).
  exact (rem_1601 epsilon_magent_p__type_13 ).
  intros X1 X2. intro H. elim (rem_88 X1 X2 H).
  intros X1 X2. intro H. elim (rem_100 X1 X2 H).
  exact (rem_1597 epsilon_magent_p__type_13 ).
  intros X1 X2. intro H. elim (rem_102 X1 X2 H).
   intro H. elim (rem_85  H).
  intros X1 X2. intro H. elim (rem_95 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_97 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_91 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_96  H).
   intro H. elim (rem_101  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_1599 epsilon_magent_p__type_13 ).
  intros X1 X2 X3. intro H. elim (rem_87 X1 X2 X3 H).
   intro H. elim (rem_89  H).
  intros X1 X2. intro H. elim (rem_92 X1 X2 H).
  intros X1 X2. intro H. elim (rem_86 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_103 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_98 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_94 X1 X2 H).
  intros X1 X2. intro H. elim (rem_84 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_93 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_99 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1605 : forall X1 X2 X3 X4 X5:term, auto___def_62 X2 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X5 -> auto_agent X5 -> auto_agent X1 -> auto_knows_current X1 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto_agent X1 -> auto___type_13 X1). tauto. exact (rem_1604 X1).
Qed.

Remark rem_1606 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto_knows_current X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___def_62 X5 -> auto___type_13 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X5 X3 X4 X2.
  cut (auto___def_62 X2 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X5 -> auto_agent X5 -> auto_agent X1 -> auto_knows_current X1 -> auto___type_13 X1). tauto. exact (rem_1605 X1 X2 X3 X4 X5).
Qed.

Remark rem_1607 : (forall X:term, auto___type_1 X -> auto___type_13 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_1_p__type_13.  tauto.
Defined.

Remark rem_1608 : (forall X:term, auto___type_1 X -> auto___type_13 X)
    -> auto___type_13 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_p__type_13.  case (rem_1607 epsilon_m__type_1_p__type_13). clear  epsilon_m__type_1_p__type_13. intros. apply trans___type_13_i_1;  tauto.
 clear  epsilon_m__type_1_p__type_13. tauto.
Defined.

Remark rem_1609 : (forall X:term, auto___type_1 X -> auto___type_13 X)
    -> auto___type_1 i -> auto___type_13 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_p__type_13. intro H. intros.
  elim (rem_396 H);  intros.
  apply (rem_1608 epsilon_m__type_1_p__type_13);  tauto.
Defined.

Remark rem_1610 : (forall X:term, auto___type_1 X -> auto___type_13 X)
    -> auto___type_13 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_p__type_13.  case (rem_1607 epsilon_m__type_1_p__type_13). clear  epsilon_m__type_1_p__type_13. intros. apply trans___type_13_server_1;  tauto.
 clear  epsilon_m__type_1_p__type_13. tauto.
Defined.

Remark rem_1611 : (forall X:term, auto___type_1 X -> auto___type_13 X)
    -> auto___type_1 server -> auto___type_13 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_p__type_13. intro H. intros.
  elim (rem_399 H);  intros.
  apply (rem_1610 epsilon_m__type_1_p__type_13);  tauto.
Defined.

Remark rem_1612 : (forall X:term, auto___type_1 X -> auto___type_13 X)
    -> auto___type_13 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_p__type_13.  case (rem_1607 epsilon_m__type_1_p__type_13). clear  epsilon_m__type_1_p__type_13. intros. apply trans___type_13_bob_1;  tauto.
 clear  epsilon_m__type_1_p__type_13. tauto.
Defined.

Remark rem_1613 : (forall X:term, auto___type_1 X -> auto___type_13 X)
    -> auto___type_1 bob -> auto___type_13 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_p__type_13. intro H. intros.
  elim (rem_402 H);  intros.
  apply (rem_1612 epsilon_m__type_1_p__type_13);  tauto.
Defined.

Remark rem_1614 : (forall X:term, auto___type_1 X -> auto___type_13 X)
    -> auto___type_13 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_p__type_13.  case (rem_1607 epsilon_m__type_1_p__type_13). clear  epsilon_m__type_1_p__type_13. intros. apply trans___type_13_alice_1;  tauto.
 clear  epsilon_m__type_1_p__type_13. tauto.
Defined.

Remark rem_1615 : (forall X:term, auto___type_1 X -> auto___type_13 X)
    -> auto___type_1 alice -> auto___type_13 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_p__type_13. intro H. intros.
  elim (rem_405 H);  intros.
  apply (rem_1614 epsilon_m__type_1_p__type_13);  tauto.
Defined.

Remark rem_1616 : forall X1:term, auto___type_1 X1 -> auto___type_13 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_1_p__type_13 1.
  intro X. case X.
  exact (rem_1615 epsilon_m__type_1_p__type_13 ).
  exact (rem_1613 epsilon_m__type_1_p__type_13 ).
  intros X1 X2. intro H. elim (rem_412 X1 X2 H).
  intros X1 X2. intro H. elim (rem_424 X1 X2 H).
  exact (rem_1609 epsilon_m__type_1_p__type_13 ).
  intros X1 X2. intro H. elim (rem_426 X1 X2 H).
   intro H. elim (rem_409  H).
  intros X1 X2. intro H. elim (rem_419 X1 X2 H).
  intros X1 X2. intro H. elim (rem_414 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_421 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_415 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_420  H).
   intro H. elim (rem_425  H).
  intros X1. intro H. elim (rem_407 X1 H).
  exact (rem_1611 epsilon_m__type_1_p__type_13 ).
  intros X1 X2 X3. intro H. elim (rem_411 X1 X2 X3 H).
   intro H. elim (rem_413  H).
  intros X1 X2. intro H. elim (rem_416 X1 X2 H).
  intros X1 X2. intro H. elim (rem_410 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_427 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_422 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_418 X1 X2 H).
  intros X1 X2. intro H. elim (rem_408 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_417 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_423 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1617 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_1 X1 -> auto___type_2 X5 -> auto_agent X5 -> auto_agent X1 -> auto___type_13 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_1 X1 -> auto___type_13 X1). tauto. exact (rem_1616 X1).
Qed.

Remark rem_1618 : forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_12 X5 -> auto___type_13 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X5 X3 X4 X2.
  cut (auto___def_12 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_1 X1 -> auto___type_2 X5 -> auto_agent X5 -> auto_agent X1 -> auto___type_13 X1). tauto. exact (rem_1617 X1 X2 X3 X4 X5).
Qed.

Remark rem_1619 : forall X1 X2 X3 X4 X5:term, auto___def_69 X1 X2 X3 X4 X5 -> auto___type_13 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_757 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_1606 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1618 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1620 : (forall X:term, auto___def_12 X -> auto___type_5 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1621 : (forall X:term, auto___def_12 X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_12_p__type_5. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1620 epsilon_m__def_12_p__type_5 X1).
Defined.

Remark rem_1622 : (forall X:term, auto___def_12 X -> auto___type_5 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1623 : (forall X:term, auto___def_12 X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_12_p__type_5. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1622 epsilon_m__def_12_p__type_5 X2).
Defined.

Remark rem_1624 : (forall X:term, auto___def_12 X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_12_p__type_5. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_1621 epsilon_m__def_12_p__type_5 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1623 epsilon_m__def_12_p__type_5 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1625 : (forall X:term, auto___def_12 X -> auto___type_5 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_5 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_12_p__type_5. intros X1 X2. intros A1 A2.
  case (rem_1624 epsilon_m__def_12_p__type_5 X1 X2 A1 A2). clear  epsilon_m__def_12_p__type_5 A1 A2. intros. apply trans___type_5_noncea_old_1;  tauto.
 clear  epsilon_m__def_12_p__type_5 A1 A2. tauto.
Defined.

Remark rem_1626 : forall X1 X2:term, auto___def_12 (noncea_old X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1627 : (forall X:term, auto___def_12 X -> auto___type_5 X)
    -> forall X1 X2:term, auto___def_12 (noncea_old X1 X2) -> auto___type_5 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_12_p__type_5. intros X1 X2. intro H. intros.
  elim (rem_1626 X1 X2 H);  intros.
  apply (rem_1625 epsilon_m__def_12_p__type_5 X1 X2);  tauto.
Defined.

Remark rem_1628 : forall X1:term, auto___def_12 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1629 : forall X1 X2:term, auto___def_12 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1630 : auto___def_12 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1631 : auto___def_12 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1632 : forall X1 X2:term, auto___def_12 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1633 : forall X1 X2 X3:term, auto___def_12 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1634 : forall X1 X2:term, auto___def_12 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1635 : auto___def_12 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1636 : auto___def_12 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1637 : auto___def_12 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1638 : auto___def_12 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1639 : forall X1 X2 X3 X4 X5:term, auto___def_12 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1640 : forall X1 X2:term, auto___def_12 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1641 : forall X1 X2 X3 X4 X5:term, auto___def_12 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1642 : forall X1 X2:term, auto___def_12 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1643 : forall X1 X2:term, auto___def_12 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1644 : auto___def_12 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1645 : forall X1 X2 X3 X4 X5:term, auto___def_12 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1646 : forall X1 X2 X3 X4 X5:term, auto___def_12 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1647 : forall X1 X2 X3 X4 X5:term, auto___def_12 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1648 : forall X1 X2:term, auto___def_12 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1649 : auto___def_12 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1650 : forall X1 X2:term, auto___def_12 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1651 : forall X1 X2 X3 X4 X5:term, auto___def_12 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1652 : forall X1:term, auto___def_12 X1 -> auto___type_5 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_12_p__type_5 1.
  intro X. case X.
   intro H. elim (rem_1638  H).
   intro H. elim (rem_1637  H).
  intros X1 X2. intro H. elim (rem_1634 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1648 X1 X2 H).
   intro H. elim (rem_1631  H).
  intros X1 X2. intro H. elim (rem_1650 X1 X2 H).
   intro H. elim (rem_1630  H).
  intros X1 X2. intro H. elim (rem_1643 X1 X2 H).
  intros X1 X2;  exact (rem_1627 epsilon_m__def_12_p__type_5 X1 X2).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1645 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1639 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_1644  H).
   intro H. elim (rem_1649  H).
  intros X1. intro H. elim (rem_1628 X1 H).
   intro H. elim (rem_1636  H).
  intros X1 X2 X3. intro H. elim (rem_1633 X1 X2 X3 H).
   intro H. elim (rem_1635  H).
  intros X1 X2. intro H. elim (rem_1640 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1632 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1651 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1646 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_1642 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1629 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1641 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1647 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1653 : forall X1 X2 X3 X4 X5:term, auto___def_12 X1 -> auto___def_15 X2 -> auto___def_18 X3 -> auto___type_1 X4 -> auto___type_2 X5 -> auto_agent X4 -> auto_agent X5 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X1 -> auto___type_5 X1). tauto. exact (rem_1652 X1).
Qed.

Remark rem_1654 : forall X1 X2 X3 X4 X5:term, auto_agent X2 -> auto___type_1 X2 -> auto_agent X3 -> auto___type_2 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_12 X1 -> auto___type_5 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X5 X2 X3.
  cut (auto___def_12 X1 -> auto___def_15 X2 -> auto___def_18 X3 -> auto___type_1 X4 -> auto___type_2 X5 -> auto_agent X4 -> auto_agent X5 -> auto___type_5 X1). tauto. exact (rem_1653 X1 X2 X3 X4 X5).
Qed.

Remark rem_1655 : forall X1 X2 X3 X4 X5:term, auto___def_22 X2 X3 X4 X5 X1 -> auto___type_5 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_431 X2 X3 X4 X5 X1 H);  intros.
  apply (rem_1654 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1656 : forall X1:term, auto___type_5 X1 -> auto___type_5 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1657 : forall X1 X2:term, auto___def_31 X2 -> auto___type_5 X1 -> auto___type_5 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_5 X1 -> auto___type_5 X1). tauto. exact (rem_1656 X1).
Qed.

Remark rem_1658 : forall X2:term, auto___def_31 X2 -> auto___def_31 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1659 : forall X1 X2:term, auto___def_31 X2 -> auto___type_5 X1 -> auto___def_31 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_31 X2 -> auto___def_31 X2). tauto. exact (rem_1658 X2).
Qed.

Remark rem_1660 : forall X1 X2:term, auto___def_31 X2 -> auto___type_5 X1 -> (auto___type_5 X1 /\ auto___def_31 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___type_5 X1). 2:apply (rem_1657 X1 X2);  assumption.
  cut (auto___def_31 X2). 2:apply (rem_1659 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1661 : forall X1 X2:term, auto___def_31 X2 -> auto___type_5 X1 -> auto___def_30 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1660 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_30_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1662 : (forall X:term, auto___def_62 X -> auto___type_14 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1663 : (forall X:term, auto___def_62 X -> auto___type_14 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_62_p__type_14. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1662 epsilon_m__def_62_p__type_14 X1).
Defined.

Remark rem_1664 : (forall X:term, auto___def_62 X -> auto___type_14 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1665 : (forall X:term, auto___def_62 X -> auto___type_14 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_62_p__type_14. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1664 epsilon_m__def_62_p__type_14 X2).
Defined.

Remark rem_1666 : (forall X:term, auto___def_62 X -> auto___type_14 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_62_p__type_14. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_1663 epsilon_m__def_62_p__type_14 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1665 epsilon_m__def_62_p__type_14 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1667 : (forall X:term, auto___def_62 X -> auto___type_14 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_14 (noncea_current X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_62_p__type_14. intros X1 X2. intros A1 A2.
  case (rem_1666 epsilon_m__def_62_p__type_14 X1 X2 A1 A2). clear  epsilon_m__def_62_p__type_14 A1 A2. intros. apply trans___type_14_noncea_current_1;  tauto.
 clear  epsilon_m__def_62_p__type_14 A1 A2. tauto.
Defined.

Remark rem_1668 : forall X1 X2:term, auto___def_62 (noncea_current X1 X2) -> or_1
    (auto_agent X1 /\ auto_agent X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1669 : (forall X:term, auto___def_62 X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_62 (noncea_current X1 X2) -> auto___type_14 (noncea_current X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_62_p__type_14. intros X1 X2. intro H. intros.
  elim (rem_1668 X1 X2 H);  intros.
  apply (rem_1667 epsilon_m__def_62_p__type_14 X1 X2);  tauto.
Defined.

Remark rem_1670 : forall X1:term, auto___def_62 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1671 : forall X1 X2:term, auto___def_62 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1672 : auto___def_62 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1673 : auto___def_62 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1674 : forall X1 X2:term, auto___def_62 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1675 : forall X1 X2 X3:term, auto___def_62 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1676 : forall X1 X2:term, auto___def_62 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1677 : auto___def_62 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1678 : auto___def_62 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1679 : forall X1 X2:term, auto___def_62 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1680 : auto___def_62 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1681 : auto___def_62 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1682 : forall X1 X2 X3 X4 X5:term, auto___def_62 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1683 : forall X1 X2:term, auto___def_62 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1684 : forall X1 X2 X3 X4 X5:term, auto___def_62 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1685 : forall X1 X2:term, auto___def_62 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1686 : auto___def_62 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1687 : forall X1 X2 X3 X4 X5:term, auto___def_62 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1688 : forall X1 X2 X3 X4 X5:term, auto___def_62 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1689 : forall X1 X2 X3 X4 X5:term, auto___def_62 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1690 : forall X1 X2:term, auto___def_62 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1691 : auto___def_62 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1692 : forall X1 X2:term, auto___def_62 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1693 : forall X1 X2 X3 X4 X5:term, auto___def_62 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1694 : forall X1:term, auto___def_62 X1 -> auto___type_14 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_62_p__type_14 1.
  intro X. case X.
   intro H. elim (rem_1681  H).
   intro H. elim (rem_1680  H).
  intros X1 X2. intro H. elim (rem_1676 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1690 X1 X2 H).
   intro H. elim (rem_1673  H).
  intros X1 X2. intro H. elim (rem_1692 X1 X2 H).
   intro H. elim (rem_1672  H).
  intros X1 X2;  exact (rem_1669 epsilon_m__def_62_p__type_14 X1 X2).
  intros X1 X2. intro H. elim (rem_1679 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1687 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1682 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_1686  H).
   intro H. elim (rem_1691  H).
  intros X1. intro H. elim (rem_1670 X1 H).
   intro H. elim (rem_1678  H).
  intros X1 X2 X3. intro H. elim (rem_1675 X1 X2 X3 H).
   intro H. elim (rem_1677  H).
  intros X1 X2. intro H. elim (rem_1683 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1674 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1693 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1688 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_1685 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1671 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1684 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1689 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1695 : forall X1 X2 X3 X4 X5:term, auto___def_62 X1 -> auto___def_65 X2 -> auto___def_68 X3 -> auto___type_2 X4 -> auto_agent X5 -> auto_agent X4 -> auto_knows_current X5 -> auto___type_14 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_62 X1 -> auto___type_14 X1). tauto. exact (rem_1694 X1).
Qed.

Remark rem_1696 : forall X1 X2 X3 X4 X5:term, auto_agent X2 -> auto_knows_current X2 -> auto_agent X3 -> auto___type_2 X3 -> auto___def_65 X4 -> auto___def_68 X5 -> auto___def_62 X1 -> auto___type_14 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X5 X4 X2 X3.
  cut (auto___def_62 X1 -> auto___def_65 X2 -> auto___def_68 X3 -> auto___type_2 X4 -> auto_agent X5 -> auto_agent X4 -> auto_knows_current X5 -> auto___type_14 X1). tauto. exact (rem_1695 X1 X2 X3 X4 X5).
Qed.

Remark rem_1697 : (forall X:term, auto___def_12 X -> auto___type_14 X)
    -> forall X1:term, auto_agent X1 -> auto_agent X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1698 : (forall X:term, auto___def_12 X -> auto___type_14 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_12_p__type_14. intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_1697 epsilon_m__def_12_p__type_14 X1).
Defined.

Remark rem_1699 : (forall X:term, auto___def_12 X -> auto___type_14 X)
    -> forall X2:term, auto_agent X2 -> auto_agent X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1700 : (forall X:term, auto___def_12 X -> auto___type_14 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto_agent X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_12_p__type_14. intros X1 X2.
  cut (auto_agent X2 -> auto_agent X2). tauto. exact (rem_1699 epsilon_m__def_12_p__type_14 X2).
Defined.

Remark rem_1701 : (forall X:term, auto___def_12 X -> auto___type_14 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> (auto_agent X1 /\ auto_agent X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_12_p__type_14. intros X1 X2. intros A1 A2.
  cut (auto_agent X1). 2:apply (rem_1698 epsilon_m__def_12_p__type_14 X1 X2);  assumption.
  cut (auto_agent X2). 2:apply (rem_1700 epsilon_m__def_12_p__type_14 X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1702 : (forall X:term, auto___def_12 X -> auto___type_14 X)
    -> forall X1 X2:term, auto_agent X1 -> auto_agent X2 -> auto___type_14 (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_12_p__type_14. intros X1 X2. intros A1 A2.
  case (rem_1701 epsilon_m__def_12_p__type_14 X1 X2 A1 A2). clear  epsilon_m__def_12_p__type_14 A1 A2. intros. apply trans___type_14_noncea_old_1;  tauto.
 clear  epsilon_m__def_12_p__type_14 A1 A2. tauto.
Defined.

Remark rem_1703 : (forall X:term, auto___def_12 X -> auto___type_14 X)
    -> forall X1 X2:term, auto___def_12 (noncea_old X1 X2) -> auto___type_14 (noncea_old X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_12_p__type_14. intros X1 X2. intro H. intros.
  elim (rem_1626 X1 X2 H);  intros.
  apply (rem_1702 epsilon_m__def_12_p__type_14 X1 X2);  tauto.
Defined.

Remark rem_1704 : forall X1:term, auto___def_12 X1 -> auto___type_14 X1. (* Induct. *)
Proof.
  fix epsilon_m__def_12_p__type_14 1.
  intro X. case X.
   intro H. elim (rem_1638  H).
   intro H. elim (rem_1637  H).
  intros X1 X2. intro H. elim (rem_1634 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1648 X1 X2 H).
   intro H. elim (rem_1631  H).
  intros X1 X2. intro H. elim (rem_1650 X1 X2 H).
   intro H. elim (rem_1630  H).
  intros X1 X2. intro H. elim (rem_1643 X1 X2 H).
  intros X1 X2;  exact (rem_1703 epsilon_m__def_12_p__type_14 X1 X2).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1645 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1639 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_1644  H).
   intro H. elim (rem_1649  H).
  intros X1. intro H. elim (rem_1628 X1 H).
   intro H. elim (rem_1636  H).
  intros X1 X2 X3. intro H. elim (rem_1633 X1 X2 X3 H).
   intro H. elim (rem_1635  H).
  intros X1 X2. intro H. elim (rem_1640 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1632 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1651 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1646 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_1642 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1629 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1641 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1647 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1705 : forall X1 X2 X3 X4 X5:term, auto___def_12 X1 -> auto___def_15 X2 -> auto___def_18 X3 -> auto___type_1 X4 -> auto___type_2 X5 -> auto_agent X4 -> auto_agent X5 -> auto___type_14 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_12 X1 -> auto___type_14 X1). tauto. exact (rem_1704 X1).
Qed.

Remark rem_1706 : forall X1 X2 X3 X4 X5:term, auto_agent X2 -> auto___type_1 X2 -> auto_agent X3 -> auto___type_2 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto___def_12 X1 -> auto___type_14 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X4 X5 X2 X3.
  cut (auto___def_12 X1 -> auto___def_15 X2 -> auto___def_18 X3 -> auto___type_1 X4 -> auto___type_2 X5 -> auto_agent X4 -> auto_agent X5 -> auto___type_14 X1). tauto. exact (rem_1705 X1 X2 X3 X4 X5).
Qed.

Remark rem_1707 : forall X1 X2 X3 X4 X5:term, auto___def_69 X2 X3 X4 X5 X1 -> auto___type_14 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_757 X2 X3 X4 X5 X1 H);  intros.
  apply (rem_1696 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1706 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1708 : auto___def_45 prv. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_45_prv_1;  tauto.
 tauto.
Qed.

Remark rem_1709 : forall X1 X2 X3 X4 X5:term, auto___def_48 X1 X2 X4 X5 X3 -> auto___def_50 (yb_old X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1.
  case (rem_790 X1 X2 X3 X4 X5 A1). clear  A1. intros. apply trans___def_50_yb_old_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_1710 : auto___def_20 pub. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans___def_20_pub_1;  tauto.
 tauto.
Qed.

Remark rem_1711 : (forall X:term, auto___type_2 X -> auto___type_12 X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_2_p__type_12.  tauto.
Defined.

Remark rem_1712 : (forall X:term, auto___type_2 X -> auto___type_12 X)
    -> auto___type_12 i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_12.  case (rem_1711 epsilon_m__type_2_p__type_12). clear  epsilon_m__type_2_p__type_12. intros. apply trans___type_12_i_1;  tauto.
 clear  epsilon_m__type_2_p__type_12. tauto.
Defined.

Remark rem_1713 : (forall X:term, auto___type_2 X -> auto___type_12 X)
    -> auto___type_2 i -> auto___type_12 i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_12. intro H. intros.
  elim (rem_573 H);  intros.
  apply (rem_1712 epsilon_m__type_2_p__type_12);  tauto.
Defined.

Remark rem_1714 : (forall X:term, auto___type_2 X -> auto___type_12 X)
    -> auto___type_12 server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_12.  case (rem_1711 epsilon_m__type_2_p__type_12). clear  epsilon_m__type_2_p__type_12. intros. apply trans___type_12_server_1;  tauto.
 clear  epsilon_m__type_2_p__type_12. tauto.
Defined.

Remark rem_1715 : (forall X:term, auto___type_2 X -> auto___type_12 X)
    -> auto___type_2 server -> auto___type_12 server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_12. intro H. intros.
  elim (rem_576 H);  intros.
  apply (rem_1714 epsilon_m__type_2_p__type_12);  tauto.
Defined.

Remark rem_1716 : (forall X:term, auto___type_2 X -> auto___type_12 X)
    -> auto___type_12 bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_12.  case (rem_1711 epsilon_m__type_2_p__type_12). clear  epsilon_m__type_2_p__type_12. intros. apply trans___type_12_bob_1;  tauto.
 clear  epsilon_m__type_2_p__type_12. tauto.
Defined.

Remark rem_1717 : (forall X:term, auto___type_2 X -> auto___type_12 X)
    -> auto___type_2 bob -> auto___type_12 bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_12. intro H. intros.
  elim (rem_579 H);  intros.
  apply (rem_1716 epsilon_m__type_2_p__type_12);  tauto.
Defined.

Remark rem_1718 : (forall X:term, auto___type_2 X -> auto___type_12 X)
    -> auto___type_12 alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_2_p__type_12.  case (rem_1711 epsilon_m__type_2_p__type_12). clear  epsilon_m__type_2_p__type_12. intros. apply trans___type_12_alice_1;  tauto.
 clear  epsilon_m__type_2_p__type_12. tauto.
Defined.

Remark rem_1719 : (forall X:term, auto___type_2 X -> auto___type_12 X)
    -> auto___type_2 alice -> auto___type_12 alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_2_p__type_12. intro H. intros.
  elim (rem_582 H);  intros.
  apply (rem_1718 epsilon_m__type_2_p__type_12);  tauto.
Defined.

Remark rem_1720 : forall X1:term, auto___type_2 X1 -> auto___type_12 X1. (* Induct. *)
Proof.
  fix epsilon_m__type_2_p__type_12 1.
  intro X. case X.
  exact (rem_1719 epsilon_m__type_2_p__type_12 ).
  exact (rem_1717 epsilon_m__type_2_p__type_12 ).
  intros X1 X2. intro H. elim (rem_589 X1 X2 H).
  intros X1 X2. intro H. elim (rem_601 X1 X2 H).
  exact (rem_1713 epsilon_m__type_2_p__type_12 ).
  intros X1 X2. intro H. elim (rem_603 X1 X2 H).
   intro H. elim (rem_586  H).
  intros X1 X2. intro H. elim (rem_596 X1 X2 H).
  intros X1 X2. intro H. elim (rem_591 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_598 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_592 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_597  H).
   intro H. elim (rem_602  H).
  intros X1. intro H. elim (rem_584 X1 H).
  exact (rem_1715 epsilon_m__type_2_p__type_12 ).
  intros X1 X2 X3. intro H. elim (rem_588 X1 X2 X3 H).
   intro H. elim (rem_590  H).
  intros X1 X2. intro H. elim (rem_593 X1 X2 H).
  intros X1 X2. intro H. elim (rem_587 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_604 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_599 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_595 X1 X2 H).
  intros X1 X2. intro H. elim (rem_585 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_594 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_600 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1721 : forall X1 X2 X3 X4 X5:term, auto___def_62 X2 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X1 -> auto_agent X5 -> auto_agent X1 -> auto_knows_current X5 -> auto___type_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X1 -> auto___type_12 X1). tauto. exact (rem_1720 X1).
Qed.

Remark rem_1722 : forall X1 X2 X3 X4 X5:term, auto_agent X2 -> auto_knows_current X2 -> auto_agent X1 -> auto___type_2 X1 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___def_62 X5 -> auto___type_12 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X5 X3 X4 X2.
  cut (auto___def_62 X2 -> auto___def_65 X3 -> auto___def_68 X4 -> auto___type_2 X1 -> auto_agent X5 -> auto_agent X1 -> auto_knows_current X5 -> auto___type_12 X1). tauto. exact (rem_1721 X1 X2 X3 X4 X5).
Qed.

Remark rem_1723 : forall X1 X2 X3 X4 X5:term, auto___def_12 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_1 X5 -> auto___type_2 X1 -> auto_agent X5 -> auto_agent X1 -> auto___type_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_2 X1 -> auto___type_12 X1). tauto. exact (rem_1720 X1).
Qed.

Remark rem_1724 : forall X1 X2 X3 X4 X5:term, auto_agent X2 -> auto___type_1 X2 -> auto_agent X1 -> auto___type_2 X1 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___def_12 X5 -> auto___type_12 X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X5 X3 X4 X2.
  cut (auto___def_12 X2 -> auto___def_15 X3 -> auto___def_18 X4 -> auto___type_1 X5 -> auto___type_2 X1 -> auto_agent X5 -> auto_agent X1 -> auto___type_12 X1). tauto. exact (rem_1723 X1 X2 X3 X4 X5).
Qed.

Remark rem_1725 : forall X1 X2 X3 X4 X5:term, auto___def_69 X2 X1 X3 X4 X5 -> auto___type_12 X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_757 X2 X1 X3 X4 X5 H);  intros.
  apply (rem_1722 X1 X2 X3 X4 X5);  tauto.
  apply (rem_1724 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1726 : forall X1:term, auto___type_12 X1 -> auto_agent X1. (* Induct. *)
Proof.
  fix epsilon_m__type_12_pagent 1.
  intro X. case X.
  exact (rem_188 epsilon_m__type_12_pagent ).
  exact (rem_185 epsilon_m__type_12_pagent ).
  intros X1 X2. intro H. elim (rem_194 X1 X2 H).
  intros X1 X2. intro H. elim (rem_206 X1 X2 H).
  exact (rem_179 epsilon_m__type_12_pagent ).
  intros X1 X2. intro H. elim (rem_208 X1 X2 H).
   intro H. elim (rem_191  H).
  intros X1 X2. intro H. elim (rem_201 X1 X2 H).
  intros X1 X2. intro H. elim (rem_196 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_203 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_197 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_202  H).
   intro H. elim (rem_207  H).
  intros X1. intro H. elim (rem_189 X1 H).
  exact (rem_182 epsilon_m__type_12_pagent ).
  intros X1 X2 X3. intro H. elim (rem_193 X1 X2 X3 H).
   intro H. elim (rem_195  H).
  intros X1 X2. intro H. elim (rem_198 X1 X2 H).
  intros X1 X2. intro H. elim (rem_192 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_209 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_204 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_200 X1 X2 H).
  intros X1 X2. intro H. elim (rem_190 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_199 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_205 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1727 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_79 X3 -> auto___def_82 X4 -> auto___type_12 X1 -> auto___type_13 X5 -> auto_agent X1 -> auto_agent X5 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_12 X1 -> auto_agent X1). tauto. exact (rem_1726 X1).
Qed.

Remark rem_1728 : forall X1:term, auto___type_12 X1 -> auto___type_12 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1729 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_79 X3 -> auto___def_82 X4 -> auto___type_12 X1 -> auto___type_13 X5 -> auto_agent X1 -> auto_agent X5 -> auto___type_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_12 X1 -> auto___type_12 X1). tauto. exact (rem_1728 X1).
Qed.

Remark rem_1730 : forall X2:term, auto___def_75 X2 -> auto___def_75 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1731 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_79 X3 -> auto___def_82 X4 -> auto___type_12 X1 -> auto___type_13 X5 -> auto_agent X1 -> auto_agent X5 -> auto___def_75 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_75 X2 -> auto___def_75 X2). tauto. exact (rem_1730 X2).
Qed.

Remark rem_1732 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_79 X3 -> auto___def_82 X4 -> auto___type_12 X1 -> auto___type_13 X5 -> auto_agent X1 -> auto_agent X5 -> (auto_agent X1 /\ auto___type_12 X1 /\ auto___def_75 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  cut (auto_agent X1). 2:apply (rem_1727 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_12 X1). 2:apply (rem_1729 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_75 X2). 2:apply (rem_1731 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_1733 : forall X1 X2 X3 X4 X5:term, auto___def_75 X2 -> auto___def_79 X3 -> auto___def_82 X4 -> auto___type_12 X1 -> auto___type_13 X5 -> auto_agent X1 -> auto_agent X5 -> auto___def_90 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_1732 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  A1 A2 A3 A4 A5 A6 A7. intros. apply trans___def_90_cons_1;  tauto.
 clear  A1 A2 A3 A4 A5 A6 A7. tauto.
Qed.

Remark rem_1734 : forall X1 X2 X3 X4 X5:term, auto_agent X3 -> auto___type_13 X3 -> auto_agent X1 -> auto___type_12 X1 -> auto___def_75 X2 -> auto___def_82 X4 -> auto___def_79 X5 -> auto___def_90 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X5 X4 X3.
  cut (auto___def_75 X2 -> auto___def_79 X3 -> auto___def_82 X4 -> auto___type_12 X1 -> auto___type_13 X5 -> auto_agent X1 -> auto_agent X5 -> auto___def_90 (cons X1 X2)). tauto. exact (rem_1733 X1 X2 X3 X4 X5).
Qed.

Remark rem_1735 : forall X1 X2 X3 X4 X5:term, auto___def_86 X3 X1 X2 X4 X5 -> auto___def_90 (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_459 X3 X1 X2 X4 X5 H);  intros.
  apply (rem_1734 X1 X2 X3 X4 X5);  tauto.
Qed.

Remark rem_1736 : forall X1 X2:term, auto_agent X2 -> auto_agent X1 -> auto___def_18 (ya_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_66 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_18_ya_old_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1737 : forall X1:term, auto___def_34 X1 -> auto___def_34 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1738 : forall X1 X2:term, auto___def_25 X2 -> auto___def_34 X1 -> auto___def_34 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_34 X1 -> auto___def_34 X1). tauto. exact (rem_1737 X1).
Qed.

Remark rem_1739 : forall X1 X2:term, auto___def_25 X2 -> auto___def_34 X1 -> auto___def_25 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_25 X2 -> auto___def_25 X2). tauto. exact (rem_5 X2).
Qed.

Remark rem_1740 : forall X1 X2:term, auto___def_25 X2 -> auto___def_34 X1 -> (auto___def_34 X1 /\ auto___def_25 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_34 X1). 2:apply (rem_1738 X1 X2);  assumption.
  cut (auto___def_25 X2). 2:apply (rem_1739 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1741 : forall X1 X2:term, auto___def_25 X2 -> auto___def_34 X1 -> auto___def_33 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1740 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_33_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1742 : forall X1:term, auto___def_51 pub -> auto___def_52 X1 -> auto___def_56 X1. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_51 pub -> False). tauto.
  exact (rem_1269).
Qed.

Remark rem_1743 : forall X1:term, auto_knows_current (key pub X1) -> auto___def_56 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_309 pub X1 H);  intros.
  apply (rem_1742 X1);  tauto.
Qed.

Remark rem_1744 : forall X1:term, auto_knows_old (key sym X1) -> auto___def_6 X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_30 sym X1 H);  intros.
Qed.

Remark rem_1745 : forall X1 X2 X3 X4 X5:term, auto___def_48 X2 X3 X4 X1 X5 -> auto___type_11 X1. (* Subsumed by universal clause. *)
Proof. intros. apply trans___type_11_1. Qed.

Remark rem_1746 : forall X1:term, auto___def_88 X1 -> auto___def_88 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1747 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___def_88 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_88 X1 -> auto___def_88 X1). tauto. exact (rem_1746 X1).
Qed.

Remark rem_1748 : forall X2:term, auto___def_89 X2 -> auto___def_89 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1749 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___def_89 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_89 X2 -> auto___def_89 X2). tauto. exact (rem_1748 X2).
Qed.

Remark rem_1750 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> (auto___def_88 X1 /\ auto___def_89 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_88 X1). 2:apply (rem_1747 X1 X2);  assumption.
  cut (auto___def_89 X2). 2:apply (rem_1749 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1751 : forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto___def_87 (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_1750 X1 X2 A1 A2). clear  A1 A2. intros. apply trans___def_87_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_1752 : forall X1 X2:term, auto___def_89 X2 -> auto___def_88 X1 -> auto___def_87 (cons X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_88 X1 -> auto___def_89 X2 -> auto___def_87 (cons X1 X2)). tauto. exact (rem_1751 X1 X2).
Qed.

Remark rem_1753 : forall X1 X2:term, auto___def_26 X2 -> auto___def_38 prv -> auto___type_3 X1 -> auto___def_55 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_960 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_55_6;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1754 : forall X1 X2:term, auto___def_38 prv -> auto___type_3 X1 -> auto___def_26 X2 -> auto___def_55 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 X2 -> auto___def_38 prv -> auto___type_3 X1 -> auto___def_55 X1 X2). tauto. exact (rem_1753 X1 X2).
Qed.

Remark rem_1755 : forall X1 X2:term, auto___def_26 X2 -> auto___def_27 (key prv X1) -> auto___def_55 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_16 prv X1 H);  intros.
  apply (rem_1754 X1 X2);  tauto.
Qed.

Remark rem_1756 : forall X1:term, auto___type_15 X1 -> auto___type_15 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1757 : forall X1 X2:term, auto___def_90 X2 -> auto___def_92 prv -> auto___type_15 X1 -> auto___type_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_15 X1 -> auto___type_15 X1). tauto. exact (rem_1756 X1).
Qed.

Remark rem_1758 : forall X2:term, auto___def_90 X2 -> auto___def_90 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1759 : forall X1 X2:term, auto___def_90 X2 -> auto___def_92 prv -> auto___type_15 X1 -> auto___def_90 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_90 X2 -> auto___def_90 X2). tauto. exact (rem_1758 X2).
Qed.

Remark rem_1760 : forall X1 X2:term, auto___def_90 X2 -> auto___def_92 prv -> auto___type_15 X1 -> (auto___type_15 X1 /\ auto___def_90 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___type_15 X1). 2:apply (rem_1757 X1 X2);  assumption.
  cut (auto___def_90 X2). 2:apply (rem_1759 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1761 : forall X1 X2:term, auto___def_90 X2 -> auto___def_92 prv -> auto___type_15 X1 -> auto___def_55 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1760 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_55_2;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1762 : forall X1 X2:term, auto___def_92 prv -> auto___type_15 X1 -> auto___def_90 X2 -> auto___def_55 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_90 X2 -> auto___def_92 prv -> auto___type_15 X1 -> auto___def_55 X1 X2). tauto. exact (rem_1761 X1 X2).
Qed.

Remark rem_1763 : forall X1 X2:term, auto___def_90 X2 -> auto___def_91 (key prv X1) -> auto___def_55 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_318 prv X1 H);  intros.
  apply (rem_1762 X1 X2);  tauto.
Qed.

Remark rem_1764 : forall X1 X2:term, auto___def_73 X2 -> auto___def_85 prv -> auto___type_12 X1 -> auto___type_12 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_12 X1 -> auto___type_12 X1). tauto. exact (rem_1728 X1).
Qed.

Remark rem_1765 : forall X2:term, auto___def_73 X2 -> auto___def_73 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1766 : forall X1 X2:term, auto___def_73 X2 -> auto___def_85 prv -> auto___type_12 X1 -> auto___def_73 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_73 X2 -> auto___def_73 X2). tauto. exact (rem_1765 X2).
Qed.

Remark rem_1767 : forall X1 X2:term, auto___def_73 X2 -> auto___def_85 prv -> auto___type_12 X1 -> (auto___type_12 X1 /\ auto___def_73 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto___type_12 X1). 2:apply (rem_1764 X1 X2);  assumption.
  cut (auto___def_73 X2). 2:apply (rem_1766 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1768 : forall X1 X2:term, auto___def_73 X2 -> auto___def_85 prv -> auto___type_12 X1 -> auto___def_55 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1767 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_55_3;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1769 : forall X1 X2:term, auto___def_85 prv -> auto___type_12 X1 -> auto___def_73 X2 -> auto___def_55 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_73 X2 -> auto___def_85 prv -> auto___type_12 X1 -> auto___def_55 X1 X2). tauto. exact (rem_1768 X1 X2).
Qed.

Remark rem_1770 : forall X1 X2:term, auto___def_73 X2 -> auto___def_74 (key prv X1) -> auto___def_55 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_240 prv X1 H);  intros.
  apply (rem_1769 X1 X2);  tauto.
Qed.

Remark rem_1771 : forall X1 X2:term, auto___def_43 X2 -> auto___def_45 prv -> auto___type_6 X1 -> auto___def_55 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_968 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_55_4;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1772 : forall X1 X2:term, auto___def_45 prv -> auto___type_6 X1 -> auto___def_43 X2 -> auto___def_55 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_43 X2 -> auto___def_45 prv -> auto___type_6 X1 -> auto___def_55 X1 X2). tauto. exact (rem_1771 X1 X2).
Qed.

Remark rem_1773 : forall X1 X2:term, auto___def_43 X2 -> auto___def_44 (key prv X1) -> auto___def_55 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_22 prv X1 H);  intros.
  apply (rem_1772 X1 X2);  tauto.
Qed.

Remark rem_1774 : forall X1 X2:term, auto___def_21 prv -> auto___def_61 X2 -> auto_agent X1 -> auto_agent X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_agent X1 -> auto_agent X1). tauto. exact (rem_63 X1).
Qed.

Remark rem_1775 : forall X2:term, auto___def_61 X2 -> auto___def_61 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1776 : forall X1 X2:term, auto___def_21 prv -> auto___def_61 X2 -> auto_agent X1 -> auto___def_61 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_61 X2 -> auto___def_61 X2). tauto. exact (rem_1775 X2).
Qed.

Remark rem_1777 : forall X1 X2:term, auto___def_21 prv -> auto___def_61 X2 -> auto_agent X1 -> (auto_agent X1 /\ auto___def_61 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  cut (auto_agent X1). 2:apply (rem_1774 X1 X2);  assumption.
  cut (auto___def_61 X2). 2:apply (rem_1776 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_1778 : forall X1 X2:term, auto___def_21 prv -> auto___def_61 X2 -> auto_agent X1 -> auto___def_55 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_1777 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_55_1;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1779 : forall X1 X2:term, auto___def_21 prv -> auto_agent X1 -> auto___def_61 X2 -> auto___def_55 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_21 prv -> auto___def_61 X2 -> auto_agent X1 -> auto___def_55 X1 X2). tauto. exact (rem_1778 X1 X2).
Qed.

Remark rem_1780 : forall X1 X2:term, auto___def_11 (key prv X1) -> auto___def_61 X2 -> auto___def_55 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_28 prv X1 H);  intros.
  apply (rem_1779 X1 X2);  tauto.
Qed.

Remark rem_1781 : forall X1 X2:term, auto___def_61 X2 -> auto___def_11 (key prv X1) -> auto___def_55 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_11 (key prv X1) -> auto___def_61 X2 -> auto___def_55 X1 X2). tauto. exact (rem_1780 X1 X2).
Qed.

Remark rem_1782 : forall X1 X2:term, auto___def_10 X2 -> auto___def_21 prv -> auto_agent X1 -> auto___def_55 X1 X2. (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2 A3.
  case (rem_975 X1 X2 A1 A2 A3). clear  A1 A2 A3. intros. apply trans___def_55_5;  tauto.
 clear  A1 A2 A3. tauto.
Qed.

Remark rem_1783 : forall X1 X2:term, auto___def_21 prv -> auto_agent X1 -> auto___def_10 X2 -> auto___def_55 X1 X2. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X2 -> auto___def_21 prv -> auto_agent X1 -> auto___def_55 X1 X2). tauto. exact (rem_1782 X1 X2).
Qed.

Remark rem_1784 : forall X1 X2:term, auto___def_10 X2 -> auto___def_11 (key prv X1) -> auto___def_55 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_28 prv X1 H);  intros.
  apply (rem_1783 X1 X2);  tauto.
Qed.

Remark rem_1785 : forall X1 X2:term, auto___def_51 prv -> auto___def_52 X1 -> auto_knows_current X2 -> auto___def_55 X1 X2. (* Split. *)
Proof.
  intros X1 X2.
  cut (auto___def_51 prv -> False). tauto.
  exact (rem_1158).
Qed.

Remark rem_1786 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current (key prv X1) -> auto___def_55 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intros H1. intro H. intros.
  elim (rem_309 prv X1 H);  intros.
  apply (rem_1785 X1 X2);  tauto.
Qed.

Remark rem_1787 : forall X1 X2:term, auto_knows_current (crypt X2 (key prv X1)) -> auto___def_55 X1 X2. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_346 X2 (key prv X1) H);  intros.
  apply (rem_1755 X1 X2);  tauto.
  apply (rem_1763 X1 X2);  tauto.
  apply (rem_1770 X1 X2);  tauto.
  apply (rem_1773 X1 X2);  tauto.
  apply (rem_1781 X1 X2);  tauto.
  apply (rem_1784 X1 X2);  tauto.
  apply (rem_1786 X1 X2);  tauto.
Qed.

(* [appp] Proofs that all approximation clauses hold. *)


Remark rem_1788 : forall X1 X2:term, auto___def_5 X1 X2 -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1789 : forall X1 X2:term, auto___def_5 X1 X2 -> auto___def_6 X2 -> auto_knows_old X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1788 X1 X2 H);  intros.
Qed.

Remark rem_1790 : forall X1 X2 X3 X4 X5:term, auto_knows_current (yb_old X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5.  case (rem_10). intros. apply trans_knows_current_yb_old_1;  tauto.
 tauto.
Qed.

Remark rem_1791 : forall X1 X2:term, auto___def_52 X2 -> auto___def_58 X2 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_782 X1).
Qed.

Remark rem_1792 : forall X1 X2:term, auto_knows_current X1 -> auto___def_52 X2 -> auto___def_58 X2 -> auto_knows_current X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_52 X2 -> auto___def_58 X2 -> auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_1791 X1 X2).
Qed.

Remark rem_1793 : forall X1 X2:term, auto___def_57 X1 X2 -> or_1
    (auto_knows_current X1 /\ auto___def_52 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1794 : forall X1 X2:term, auto___def_57 X1 X2 -> auto___def_58 X2 -> auto_knows_current X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1793 X1 X2 H);  intros.
  apply (rem_1792 X1 X2);  tauto.
Qed.

Remark rem_1795 : auto_agent i. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans_agent_i_1;  tauto.
 tauto.
Qed.

Remark rem_1796 : forall X1:term, auto_knows_old X1 -> auto_knows_old X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_1797 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_1796 X1).
Qed.

Remark rem_1798 : forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_old X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X1). tauto. exact (rem_1797 X1 X2).
Qed.

Remark rem_1799 : forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto_knows_old X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_650 X1 X2 H);  intros.
  apply (rem_1798 X1 X2);  tauto.
Qed.

Remark rem_1800 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intros X1.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (Hrec X1).
Defined.

Remark rem_1801 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_1800 epsilon_mknows_old_pknows_current X1);  assumption.
  tauto.
Defined.

Remark rem_1802 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intros A1.
  case (rem_1801 epsilon_mknows_old_pknows_current X1 A1). clear  epsilon_mknows_old_pknows_current A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1. tauto.
Defined.

Remark rem_1803 : forall X1:term, auto_knows_old (s X1) -> or_1
    (auto_knows_old X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1804 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto_knows_old (s X1) -> auto_knows_current (s X1). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1. intro H. intros.
  elim (rem_1803 X1 H);  intros.
  apply (rem_1802 epsilon_mknows_old_pknows_current X1);  tauto.
Defined.

Remark rem_1805 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  tauto.
Defined.

Remark rem_1806 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_1805 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_1807 : auto_knows_old nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1808 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_1807 H);  intros.
  apply (rem_1806 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_1809 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_1805 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_1810 : auto_knows_old i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1811 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_1810 H);  intros.
  apply (rem_1809 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_1812 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto_knows_old X1 -> auto_knows_current X1). tauto. exact (rem_1800 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_1813 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto_knows_old X2 -> auto_knows_current X2. (* Use induction hypothesis. *)
Proof.
   intro Hrec. intros X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (Hrec X2).
Defined.

Remark rem_1814 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_current X2). tauto. exact (rem_1813 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_1815 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_1812 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_1814 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1816 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1815 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1817 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_650 X1 X2 H);  intros.
  apply (rem_1816 epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1818 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_1805 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_1819 : auto_knows_old server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1820 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_1819 H);  intros.
  apply (rem_1818 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_1821 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_1805 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_1822 : auto_knows_old bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1823 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_1822 H);  intros.
  apply (rem_1821 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_1824 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current.  case (rem_1805 epsilon_mknows_old_pknows_current). clear  epsilon_mknows_old_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_mknows_old_pknows_current. tauto.
Defined.

Remark rem_1825 : auto_knows_old alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1826 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> auto_knows_old alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intro H. intros.
  elim (rem_1825 H);  intros.
  apply (rem_1824 epsilon_mknows_old_pknows_current);  tauto.
Defined.

Remark rem_1827 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_26 X1 -> auto___def_26 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1828 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_26 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_26 X1 -> auto___def_26 X1). tauto. exact (rem_1827 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_1829 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_27 X2 -> auto___def_27 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1830 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_27 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_27 X2 -> auto___def_27 X2). tauto. exact (rem_1829 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_1831 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> (auto___def_26 X1 /\ auto___def_27 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_26 X1). 2:apply (rem_1828 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_27 X2). 2:apply (rem_1830 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1832 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1831 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_1;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1833 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1834 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_1833 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_1835 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1836 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_1835 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_1837 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_1834 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_1836 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1838 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1837 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_4;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1839 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1840 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_1839 epsilon_mknows_old_pknows_current X1).
Defined.

Remark rem_1841 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1842 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_1841 epsilon_mknows_old_pknows_current X2).
Defined.

Remark rem_1843 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_1840 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_1842 epsilon_mknows_old_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1844 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1843 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_6;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1845 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old X1 -> auto_knows_old X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_1815 epsilon_mknows_old_pknows_current X1 X2 A1 A2). clear  epsilon_mknows_old_pknows_current A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  epsilon_mknows_old_pknows_current A1 A2. tauto.
Defined.

Remark rem_1846 : (forall X:term, auto_knows_old X -> auto_knows_current X)
    -> forall X1 X2:term, auto_knows_old (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_old_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_32 X1 X2 H);  intros.
  apply (rem_1832 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_1838 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_1844 epsilon_mknows_old_pknows_current X1 X2);  tauto.
  apply (rem_1845 epsilon_mknows_old_pknows_current X1 X2);  tauto.
Defined.

Remark rem_1847 : forall X1 X2:term, auto_knows_old (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1848 : forall X1 X2:term, auto_knows_old (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1849 : forall X1 X2 X3:term, auto_knows_old (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1850 : auto_knows_old sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1851 : forall X1 X2:term, auto_knows_old (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1852 : forall X1 X2 X3 X4 X5:term, auto_knows_old (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1853 : forall X1 X2:term, auto_knows_old (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1854 : forall X1 X2 X3 X4 X5:term, auto_knows_old (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1855 : forall X1 X2:term, auto_knows_old (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1856 : forall X1 X2:term, auto_knows_old (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1857 : auto_knows_old prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1858 : forall X1 X2 X3 X4 X5:term, auto_knows_old (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1859 : forall X1 X2 X3 X4 X5:term, auto_knows_old (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1860 : forall X1 X2 X3 X4 X5:term, auto_knows_old (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1861 : auto_knows_old pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1862 : forall X1 X2 X3 X4 X5:term, auto_knows_old (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1863 : forall X1:term, auto_knows_old X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_mknows_old_pknows_current 1.
  intro X. case X.
  exact (rem_1826 epsilon_mknows_old_pknows_current ).
  exact (rem_1823 epsilon_mknows_old_pknows_current ).
  intros X1 X2;  exact (rem_1817 epsilon_mknows_old_pknows_current X1 X2).
  intros X1 X2;  exact (rem_1846 epsilon_mknows_old_pknows_current X1 X2).
  exact (rem_1811 epsilon_mknows_old_pknows_current ).
  intros X1 X2. intro H. elim (rem_30 X1 X2 H).
  exact (rem_1808 epsilon_mknows_old_pknows_current ).
  intros X1 X2. intro H. elim (rem_1856 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1851 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1858 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1852 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_1857  H).
   intro H. elim (rem_1861  H).
  intros X1;  exact (rem_1804 epsilon_mknows_old_pknows_current X1).
  exact (rem_1820 epsilon_mknows_old_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_1849 X1 X2 X3 H).
   intro H. elim (rem_1850  H).
  intros X1 X2. intro H. elim (rem_1853 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1848 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1862 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1859 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_1855 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1847 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1854 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1860 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1864 : forall X1 X2 X3 X4 X5:term, auto_bob_data_current X1 X2 X3 X4 X5 -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1865 : forall X1 X2 X3 X4:term, auto_bob_data_current bob X1 X2 X3 X4 -> auto_knows_current X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1864 bob X1 X2 X3 X4 H);  intros.
Qed.

Remark rem_1866 : forall X1 X2 X3 X4:term, auto_bob_data_current bob X1 X2 X3 X4 -> auto_knows_current X4 -> auto___query__intruder_knows_ya_as_seen_by_bob. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_bob_data_current bob X1 X2 X3 X4 -> auto_knows_current X4 -> False). tauto.
  exact (rem_1865 X1 X2 X3 X4).
Qed.

Remark rem_1867 : forall X1 X2 X3 X4:term, auto_bob_data_current bob X2 X3 X4 X1 -> auto_knows_current X1 -> auto___query__intruder_knows_ya_as_seen_by_bob. (* Prove equivalent, normalized clause. *)
Proof.
   intros X4 X1 X2 X3.
  cut (auto_bob_data_current bob X1 X2 X3 X4 -> auto_knows_current X4 -> auto___query__intruder_knows_ya_as_seen_by_bob). tauto. exact (rem_1866 X1 X2 X3 X4).
Qed.

Remark rem_1868 : forall X1 X2:term, auto___def_1 X1 X2 -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1869 : forall X1 X2:term, auto___def_1 X2 X1 -> auto___def_2 X2 -> auto_knows_old X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_1868 X2 X1 H);  intros.
Qed.

Remark rem_1870 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  tauto.
Defined.

Remark rem_1871 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto_knows_old i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  case (rem_1870 epsilon_m__type_6_pknows_old). clear  epsilon_m__type_6_pknows_old. intros. apply trans_knows_old_i_1;  tauto.
 clear  epsilon_m__type_6_pknows_old. tauto.
Defined.

Remark rem_1872 : auto___type_6 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1873 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto___type_6 i -> auto_knows_old i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intro H. intros.
  elim (rem_1872 H);  intros.
  apply (rem_1871 epsilon_m__type_6_pknows_old);  tauto.
Defined.

Remark rem_1874 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto_knows_old server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  case (rem_1870 epsilon_m__type_6_pknows_old). clear  epsilon_m__type_6_pknows_old. intros. apply trans_knows_old_server_1;  tauto.
 clear  epsilon_m__type_6_pknows_old. tauto.
Defined.

Remark rem_1875 : auto___type_6 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1876 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto___type_6 server -> auto_knows_old server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intro H. intros.
  elim (rem_1875 H);  intros.
  apply (rem_1874 epsilon_m__type_6_pknows_old);  tauto.
Defined.

Remark rem_1877 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto_knows_old bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  case (rem_1870 epsilon_m__type_6_pknows_old). clear  epsilon_m__type_6_pknows_old. intros. apply trans_knows_old_bob_1;  tauto.
 clear  epsilon_m__type_6_pknows_old. tauto.
Defined.

Remark rem_1878 : auto___type_6 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1879 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto___type_6 bob -> auto_knows_old bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intro H. intros.
  elim (rem_1878 H);  intros.
  apply (rem_1877 epsilon_m__type_6_pknows_old);  tauto.
Defined.

Remark rem_1880 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto_knows_old alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old.  case (rem_1870 epsilon_m__type_6_pknows_old). clear  epsilon_m__type_6_pknows_old. intros. apply trans_knows_old_alice_1;  tauto.
 clear  epsilon_m__type_6_pknows_old. tauto.
Defined.

Remark rem_1881 : auto___type_6 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1882 : (forall X:term, auto___type_6 X -> auto_knows_old X)
    -> auto___type_6 alice -> auto_knows_old alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_pknows_old. intro H. intros.
  elim (rem_1881 H);  intros.
  apply (rem_1880 epsilon_m__type_6_pknows_old);  tauto.
Defined.

Remark rem_1883 : forall X1:term, auto___type_6 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1884 : forall X1 X2:term, auto___type_6 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1885 : auto___type_6 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1886 : forall X1 X2:term, auto___type_6 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1887 : forall X1 X2 X3:term, auto___type_6 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1888 : forall X1 X2:term, auto___type_6 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1889 : auto___type_6 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1890 : forall X1 X2:term, auto___type_6 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1891 : forall X1 X2 X3 X4 X5:term, auto___type_6 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1892 : forall X1 X2:term, auto___type_6 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1893 : forall X1 X2 X3 X4 X5:term, auto___type_6 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1894 : forall X1 X2:term, auto___type_6 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1895 : forall X1 X2:term, auto___type_6 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1896 : auto___type_6 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1897 : forall X1 X2 X3 X4 X5:term, auto___type_6 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1898 : forall X1 X2 X3 X4 X5:term, auto___type_6 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1899 : forall X1 X2 X3 X4 X5:term, auto___type_6 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1900 : forall X1 X2:term, auto___type_6 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1901 : auto___type_6 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1902 : forall X1 X2:term, auto___type_6 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1903 : forall X1 X2 X3 X4 X5:term, auto___type_6 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1904 : forall X1:term, auto___type_6 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__type_6_pknows_old 1.
  intro X. case X.
  exact (rem_1882 epsilon_m__type_6_pknows_old ).
  exact (rem_1879 epsilon_m__type_6_pknows_old ).
  intros X1 X2. intro H. elim (rem_1888 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1900 X1 X2 H).
  exact (rem_1873 epsilon_m__type_6_pknows_old ).
  intros X1 X2. intro H. elim (rem_1902 X1 X2 H).
   intro H. elim (rem_1885  H).
  intros X1 X2. intro H. elim (rem_1895 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1890 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1897 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1891 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_1896  H).
   intro H. elim (rem_1901  H).
  intros X1. intro H. elim (rem_1883 X1 H).
  exact (rem_1876 epsilon_m__type_6_pknows_old ).
  intros X1 X2 X3. intro H. elim (rem_1887 X1 X2 X3 H).
   intro H. elim (rem_1889  H).
  intros X1 X2. intro H. elim (rem_1892 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1886 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1903 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1898 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_1894 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1884 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1893 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1899 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1905 : forall X1 X2:term, auto___def_40 X2 -> auto___type_6 X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_6 X1 -> auto_knows_old X1). tauto. exact (rem_1904 X1).
Qed.

Remark rem_1906 : (forall X:term, auto___def_41 X -> auto_knows_old X)
    -> forall X1:term, auto___def_43 X1 -> auto___def_43 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1907 : (forall X:term, auto___def_41 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_43 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_41_pknows_old. intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_43 X1). tauto. exact (rem_1906 epsilon_m__def_41_pknows_old X1).
Defined.

Remark rem_1908 : (forall X:term, auto___def_41 X -> auto_knows_old X)
    -> forall X2:term, auto___def_44 X2 -> auto___def_44 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_1909 : (forall X:term, auto___def_41 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto___def_44 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_41_pknows_old. intros X1 X2.
  cut (auto___def_44 X2 -> auto___def_44 X2). tauto. exact (rem_1908 epsilon_m__def_41_pknows_old X2).
Defined.

Remark rem_1910 : (forall X:term, auto___def_41 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> (auto___def_43 X1 /\ auto___def_44 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_41_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_43 X1). 2:apply (rem_1907 epsilon_m__def_41_pknows_old X1 X2);  assumption.
  cut (auto___def_44 X2). 2:apply (rem_1909 epsilon_m__def_41_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1911 : (forall X:term, auto___def_41 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_43 X1 -> auto___def_44 X2 -> auto_knows_old (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_41_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_1910 epsilon_m__def_41_pknows_old X1 X2 A1 A2). clear  epsilon_m__def_41_pknows_old A1 A2. intros. apply trans_knows_old_crypt_2;  tauto.
 clear  epsilon_m__def_41_pknows_old A1 A2. tauto.
Defined.

Remark rem_1912 : forall X1 X2:term, auto___def_41 (crypt X1 X2) -> or_1
    (auto___def_43 X1 /\ auto___def_44 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1913 : (forall X:term, auto___def_41 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_41 (crypt X1 X2) -> auto_knows_old (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_41_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_1912 X1 X2 H);  intros.
  apply (rem_1911 epsilon_m__def_41_pknows_old X1 X2);  tauto.
Defined.

Remark rem_1914 : forall X1:term, auto___def_41 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1915 : forall X1 X2:term, auto___def_41 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1916 : auto___def_41 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1917 : auto___def_41 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1918 : forall X1 X2:term, auto___def_41 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1919 : forall X1 X2 X3:term, auto___def_41 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1920 : forall X1 X2:term, auto___def_41 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1921 : auto___def_41 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1922 : auto___def_41 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1923 : forall X1 X2:term, auto___def_41 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1924 : auto___def_41 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1925 : auto___def_41 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1926 : forall X1 X2 X3 X4 X5:term, auto___def_41 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1927 : forall X1 X2:term, auto___def_41 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1928 : forall X1 X2 X3 X4 X5:term, auto___def_41 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1929 : forall X1 X2:term, auto___def_41 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1930 : forall X1 X2:term, auto___def_41 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1931 : auto___def_41 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1932 : forall X1 X2 X3 X4 X5:term, auto___def_41 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1933 : forall X1 X2 X3 X4 X5:term, auto___def_41 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1934 : forall X1 X2 X3 X4 X5:term, auto___def_41 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1935 : auto___def_41 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1936 : forall X1 X2:term, auto___def_41 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1937 : forall X1 X2 X3 X4 X5:term, auto___def_41 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1938 : forall X1:term, auto___def_41 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__def_41_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_1925  H).
   intro H. elim (rem_1924  H).
  intros X1 X2. intro H. elim (rem_1920 X1 X2 H).
  intros X1 X2;  exact (rem_1913 epsilon_m__def_41_pknows_old X1 X2).
   intro H. elim (rem_1917  H).
  intros X1 X2. intro H. elim (rem_1936 X1 X2 H).
   intro H. elim (rem_1916  H).
  intros X1 X2. intro H. elim (rem_1930 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1923 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1932 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1926 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_1931  H).
   intro H. elim (rem_1935  H).
  intros X1. intro H. elim (rem_1914 X1 H).
   intro H. elim (rem_1922  H).
  intros X1 X2 X3. intro H. elim (rem_1919 X1 X2 X3 H).
   intro H. elim (rem_1921  H).
  intros X1 X2. intro H. elim (rem_1927 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1918 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1937 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1933 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_1929 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1915 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1928 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1934 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1939 : (forall X:term, auto___def_40 X -> auto_knows_old X)
    -> forall X1:term, auto___def_41 X1 -> auto_knows_old X1. (* Cut history. *)
Proof.  intros epsilon_m__def_40_pknows_old. exact (rem_1938).
Defined.

Remark rem_1940 : (forall X:term, auto___def_40 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_40_pknows_old. intros X1 X2.
  cut (auto___def_41 X1 -> auto_knows_old X1). tauto. exact (rem_1939 epsilon_m__def_40_pknows_old X1).
Defined.

Remark rem_1941 : (forall X:term, auto___def_42 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_42_pknows_old.  tauto.
Defined.

Remark rem_1942 : (forall X:term, auto___def_42 X -> auto_knows_old X)
    -> auto_knows_old nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_42_pknows_old.  case (rem_1941 epsilon_m__def_42_pknows_old). clear  epsilon_m__def_42_pknows_old. intros. apply trans_knows_old_nil_1;  tauto.
 clear  epsilon_m__def_42_pknows_old. tauto.
Defined.

Remark rem_1943 : auto___def_42 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1944 : (forall X:term, auto___def_42 X -> auto_knows_old X)
    -> auto___def_42 nil -> auto_knows_old nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_42_pknows_old. intro H. intros.
  elim (rem_1943 H);  intros.
  apply (rem_1942 epsilon_m__def_42_pknows_old);  tauto.
Defined.

Remark rem_1945 : forall X1:term, auto___def_42 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1946 : forall X1 X2:term, auto___def_42 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1947 : auto___def_42 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1948 : forall X1 X2:term, auto___def_42 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1949 : forall X1 X2 X3:term, auto___def_42 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1950 : forall X1 X2:term, auto___def_42 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1951 : auto___def_42 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1952 : auto___def_42 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1953 : forall X1 X2:term, auto___def_42 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1954 : auto___def_42 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1955 : auto___def_42 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1956 : forall X1 X2 X3 X4 X5:term, auto___def_42 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1957 : forall X1 X2:term, auto___def_42 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1958 : forall X1 X2 X3 X4 X5:term, auto___def_42 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1959 : forall X1 X2:term, auto___def_42 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1960 : forall X1 X2:term, auto___def_42 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1961 : auto___def_42 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1962 : forall X1 X2 X3 X4 X5:term, auto___def_42 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1963 : forall X1 X2 X3 X4 X5:term, auto___def_42 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1964 : forall X1 X2 X3 X4 X5:term, auto___def_42 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1965 : forall X1 X2:term, auto___def_42 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1966 : auto___def_42 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1967 : forall X1 X2:term, auto___def_42 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1968 : forall X1 X2 X3 X4 X5:term, auto___def_42 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1969 : forall X2:term, auto___def_42 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_42_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_1955  H).
   intro H. elim (rem_1954  H).
  intros X1 X2. intro H. elim (rem_1950 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1965 X1 X2 H).
   intro H. elim (rem_1947  H).
  intros X1 X2. intro H. elim (rem_1967 X1 X2 H).
  exact (rem_1944 epsilon_m__def_42_pknows_old ).
  intros X1 X2. intro H. elim (rem_1960 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1953 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1962 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1956 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_1961  H).
   intro H. elim (rem_1966  H).
  intros X1. intro H. elim (rem_1945 X1 H).
   intro H. elim (rem_1952  H).
  intros X1 X2 X3. intro H. elim (rem_1949 X1 X2 X3 H).
   intro H. elim (rem_1951  H).
  intros X1 X2. intro H. elim (rem_1957 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1948 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1968 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1963 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_1959 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1946 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1958 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1964 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_1970 : (forall X:term, auto___def_40 X -> auto_knows_old X)
    -> forall X2:term, auto___def_42 X2 -> auto_knows_old X2. (* Cut history. *)
Proof.  intros epsilon_m__def_40_pknows_old. exact (rem_1969).
Defined.

Remark rem_1971 : (forall X:term, auto___def_40 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_40_pknows_old. intros X1 X2.
  cut (auto___def_42 X2 -> auto_knows_old X2). tauto. exact (rem_1970 epsilon_m__def_40_pknows_old X2).
Defined.

Remark rem_1972 : (forall X:term, auto___def_40 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_40_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_1940 epsilon_m__def_40_pknows_old X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_1971 epsilon_m__def_40_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_1973 : (forall X:term, auto___def_40 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_41 X1 -> auto___def_42 X2 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_40_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_1972 epsilon_m__def_40_pknows_old X1 X2 A1 A2). clear  epsilon_m__def_40_pknows_old A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  epsilon_m__def_40_pknows_old A1 A2. tauto.
Defined.

Remark rem_1974 : forall X1 X2:term, auto___def_40 (cons X1 X2) -> or_1
    (auto___def_41 X1 /\ auto___def_42 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_1975 : (forall X:term, auto___def_40 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_40 (cons X1 X2) -> auto_knows_old (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_40_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_1974 X1 X2 H);  intros.
  apply (rem_1973 epsilon_m__def_40_pknows_old X1 X2);  tauto.
Defined.

Remark rem_1976 : forall X1:term, auto___def_40 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1977 : forall X1 X2:term, auto___def_40 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1978 : auto___def_40 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1979 : auto___def_40 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1980 : forall X1 X2:term, auto___def_40 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1981 : forall X1 X2 X3:term, auto___def_40 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1982 : auto___def_40 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1983 : auto___def_40 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1984 : forall X1 X2:term, auto___def_40 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1985 : auto___def_40 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1986 : auto___def_40 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1987 : forall X1 X2 X3 X4 X5:term, auto___def_40 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1988 : forall X1 X2:term, auto___def_40 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1989 : forall X1 X2 X3 X4 X5:term, auto___def_40 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1990 : forall X1 X2:term, auto___def_40 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1991 : forall X1 X2:term, auto___def_40 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1992 : auto___def_40 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1993 : forall X1 X2 X3 X4 X5:term, auto___def_40 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1994 : forall X1 X2 X3 X4 X5:term, auto___def_40 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1995 : forall X1 X2 X3 X4 X5:term, auto___def_40 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1996 : forall X1 X2:term, auto___def_40 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1997 : auto___def_40 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1998 : forall X1 X2:term, auto___def_40 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_1999 : forall X1 X2 X3 X4 X5:term, auto___def_40 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2000 : forall X2:term, auto___def_40 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_40_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_1986  H).
   intro H. elim (rem_1985  H).
  intros X1 X2;  exact (rem_1975 epsilon_m__def_40_pknows_old X1 X2).
  intros X1 X2. intro H. elim (rem_1996 X1 X2 H).
   intro H. elim (rem_1979  H).
  intros X1 X2. intro H. elim (rem_1998 X1 X2 H).
   intro H. elim (rem_1978  H).
  intros X1 X2. intro H. elim (rem_1991 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1984 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1993 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1987 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_1992  H).
   intro H. elim (rem_1997  H).
  intros X1. intro H. elim (rem_1976 X1 H).
   intro H. elim (rem_1983  H).
  intros X1 X2 X3. intro H. elim (rem_1981 X1 X2 X3 H).
   intro H. elim (rem_1982  H).
  intros X1 X2. intro H. elim (rem_1988 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1980 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1999 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1994 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_1990 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1977 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1989 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1995 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2001 : forall X1 X2:term, auto___def_40 X2 -> auto___type_6 X1 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_40 X2 -> auto_knows_old X2). tauto. exact (rem_2000 X2).
Qed.

Remark rem_2002 : forall X1 X2:term, auto___def_40 X2 -> auto___type_6 X1 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_1905 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2001 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2003 : forall X1 X2:term, auto___def_40 X2 -> auto___type_6 X1 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2002 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2004 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_3_pknows_old.  tauto.
Defined.

Remark rem_2005 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto_knows_old i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old.  case (rem_2004 epsilon_m__type_3_pknows_old). clear  epsilon_m__type_3_pknows_old. intros. apply trans_knows_old_i_1;  tauto.
 clear  epsilon_m__type_3_pknows_old. tauto.
Defined.

Remark rem_2006 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto___type_3 i -> auto_knows_old i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old. intro H. intros.
  elim (rem_836 H);  intros.
  apply (rem_2005 epsilon_m__type_3_pknows_old);  tauto.
Defined.

Remark rem_2007 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto_knows_old server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old.  case (rem_2004 epsilon_m__type_3_pknows_old). clear  epsilon_m__type_3_pknows_old. intros. apply trans_knows_old_server_1;  tauto.
 clear  epsilon_m__type_3_pknows_old. tauto.
Defined.

Remark rem_2008 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto___type_3 server -> auto_knows_old server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old. intro H. intros.
  elim (rem_839 H);  intros.
  apply (rem_2007 epsilon_m__type_3_pknows_old);  tauto.
Defined.

Remark rem_2009 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto_knows_old bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old.  case (rem_2004 epsilon_m__type_3_pknows_old). clear  epsilon_m__type_3_pknows_old. intros. apply trans_knows_old_bob_1;  tauto.
 clear  epsilon_m__type_3_pknows_old. tauto.
Defined.

Remark rem_2010 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto___type_3 bob -> auto_knows_old bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old. intro H. intros.
  elim (rem_842 H);  intros.
  apply (rem_2009 epsilon_m__type_3_pknows_old);  tauto.
Defined.

Remark rem_2011 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto_knows_old alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old.  case (rem_2004 epsilon_m__type_3_pknows_old). clear  epsilon_m__type_3_pknows_old. intros. apply trans_knows_old_alice_1;  tauto.
 clear  epsilon_m__type_3_pknows_old. tauto.
Defined.

Remark rem_2012 : (forall X:term, auto___type_3 X -> auto_knows_old X)
    -> auto___type_3 alice -> auto_knows_old alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_pknows_old. intro H. intros.
  elim (rem_845 H);  intros.
  apply (rem_2011 epsilon_m__type_3_pknows_old);  tauto.
Defined.

Remark rem_2013 : forall X1:term, auto___type_3 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__type_3_pknows_old 1.
  intro X. case X.
  exact (rem_2012 epsilon_m__type_3_pknows_old ).
  exact (rem_2010 epsilon_m__type_3_pknows_old ).
  intros X1 X2. intro H. elim (rem_852 X1 X2 H).
  intros X1 X2. intro H. elim (rem_864 X1 X2 H).
  exact (rem_2006 epsilon_m__type_3_pknows_old ).
  intros X1 X2. intro H. elim (rem_866 X1 X2 H).
   intro H. elim (rem_849  H).
  intros X1 X2. intro H. elim (rem_859 X1 X2 H).
  intros X1 X2. intro H. elim (rem_854 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_861 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_855 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_860  H).
   intro H. elim (rem_865  H).
  intros X1. intro H. elim (rem_847 X1 H).
  exact (rem_2008 epsilon_m__type_3_pknows_old ).
  intros X1 X2 X3. intro H. elim (rem_851 X1 X2 X3 H).
   intro H. elim (rem_853  H).
  intros X1 X2. intro H. elim (rem_856 X1 X2 H).
  intros X1 X2. intro H. elim (rem_850 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_867 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_862 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_858 X1 X2 H).
  intros X1 X2. intro H. elim (rem_848 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_857 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_863 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2014 : forall X1 X2:term, auto___def_23 X2 -> auto___type_3 X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_3 X1 -> auto_knows_old X1). tauto. exact (rem_2013 X1).
Qed.

Remark rem_2015 : (forall X:term, auto___def_24 X -> auto_knows_old X)
    -> forall X1:term, auto___def_26 X1 -> auto___def_26 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2016 : (forall X:term, auto___def_24 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_26 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_24_pknows_old. intros X1 X2.
  cut (auto___def_26 X1 -> auto___def_26 X1). tauto. exact (rem_2015 epsilon_m__def_24_pknows_old X1).
Defined.

Remark rem_2017 : (forall X:term, auto___def_24 X -> auto_knows_old X)
    -> forall X2:term, auto___def_27 X2 -> auto___def_27 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2018 : (forall X:term, auto___def_24 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto___def_27 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_24_pknows_old. intros X1 X2.
  cut (auto___def_27 X2 -> auto___def_27 X2). tauto. exact (rem_2017 epsilon_m__def_24_pknows_old X2).
Defined.

Remark rem_2019 : (forall X:term, auto___def_24 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> (auto___def_26 X1 /\ auto___def_27 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_24_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_26 X1). 2:apply (rem_2016 epsilon_m__def_24_pknows_old X1 X2);  assumption.
  cut (auto___def_27 X2). 2:apply (rem_2018 epsilon_m__def_24_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2020 : (forall X:term, auto___def_24 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_26 X1 -> auto___def_27 X2 -> auto_knows_old (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_24_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2019 epsilon_m__def_24_pknows_old X1 X2 A1 A2). clear  epsilon_m__def_24_pknows_old A1 A2. intros. apply trans_knows_old_crypt_1;  tauto.
 clear  epsilon_m__def_24_pknows_old A1 A2. tauto.
Defined.

Remark rem_2021 : forall X1 X2:term, auto___def_24 (crypt X1 X2) -> or_1
    (auto___def_26 X1 /\ auto___def_27 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2022 : (forall X:term, auto___def_24 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_24 (crypt X1 X2) -> auto_knows_old (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_24_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_2021 X1 X2 H);  intros.
  apply (rem_2020 epsilon_m__def_24_pknows_old X1 X2);  tauto.
Defined.

Remark rem_2023 : forall X1:term, auto___def_24 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2024 : forall X1 X2:term, auto___def_24 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2025 : auto___def_24 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2026 : auto___def_24 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2027 : forall X1 X2:term, auto___def_24 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2028 : forall X1 X2 X3:term, auto___def_24 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2029 : forall X1 X2:term, auto___def_24 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2030 : auto___def_24 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2031 : auto___def_24 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2032 : forall X1 X2:term, auto___def_24 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2033 : auto___def_24 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2034 : auto___def_24 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2035 : forall X1 X2 X3 X4 X5:term, auto___def_24 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2036 : forall X1 X2:term, auto___def_24 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2037 : forall X1 X2 X3 X4 X5:term, auto___def_24 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2038 : forall X1 X2:term, auto___def_24 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2039 : forall X1 X2:term, auto___def_24 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2040 : auto___def_24 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2041 : forall X1 X2 X3 X4 X5:term, auto___def_24 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2042 : forall X1 X2 X3 X4 X5:term, auto___def_24 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2043 : forall X1 X2 X3 X4 X5:term, auto___def_24 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2044 : auto___def_24 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2045 : forall X1 X2:term, auto___def_24 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2046 : forall X1 X2 X3 X4 X5:term, auto___def_24 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2047 : forall X1:term, auto___def_24 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__def_24_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_2034  H).
   intro H. elim (rem_2033  H).
  intros X1 X2. intro H. elim (rem_2029 X1 X2 H).
  intros X1 X2;  exact (rem_2022 epsilon_m__def_24_pknows_old X1 X2).
   intro H. elim (rem_2026  H).
  intros X1 X2. intro H. elim (rem_2045 X1 X2 H).
   intro H. elim (rem_2025  H).
  intros X1 X2. intro H. elim (rem_2039 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2032 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2041 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2035 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2040  H).
   intro H. elim (rem_2044  H).
  intros X1. intro H. elim (rem_2023 X1 H).
   intro H. elim (rem_2031  H).
  intros X1 X2 X3. intro H. elim (rem_2028 X1 X2 X3 H).
   intro H. elim (rem_2030  H).
  intros X1 X2. intro H. elim (rem_2036 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2027 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2046 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2042 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2038 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2024 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2037 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2043 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2048 : (forall X:term, auto___def_23 X -> auto_knows_old X)
    -> forall X1:term, auto___def_24 X1 -> auto_knows_old X1. (* Cut history. *)
Proof.  intros epsilon_m__def_23_pknows_old. exact (rem_2047).
Defined.

Remark rem_2049 : (forall X:term, auto___def_23 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_23_pknows_old. intros X1 X2.
  cut (auto___def_24 X1 -> auto_knows_old X1). tauto. exact (rem_2048 epsilon_m__def_23_pknows_old X1).
Defined.

Remark rem_2050 : (forall X:term, auto___def_25 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_25_pknows_old.  tauto.
Defined.

Remark rem_2051 : (forall X:term, auto___def_25 X -> auto_knows_old X)
    -> auto_knows_old nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_25_pknows_old.  case (rem_2050 epsilon_m__def_25_pknows_old). clear  epsilon_m__def_25_pknows_old. intros. apply trans_knows_old_nil_1;  tauto.
 clear  epsilon_m__def_25_pknows_old. tauto.
Defined.

Remark rem_2052 : auto___def_25 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2053 : (forall X:term, auto___def_25 X -> auto_knows_old X)
    -> auto___def_25 nil -> auto_knows_old nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_25_pknows_old. intro H. intros.
  elim (rem_2052 H);  intros.
  apply (rem_2051 epsilon_m__def_25_pknows_old);  tauto.
Defined.

Remark rem_2054 : forall X1:term, auto___def_25 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2055 : forall X1 X2:term, auto___def_25 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2056 : auto___def_25 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2057 : forall X1 X2:term, auto___def_25 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2058 : forall X1 X2 X3:term, auto___def_25 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2059 : forall X1 X2:term, auto___def_25 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2060 : auto___def_25 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2061 : auto___def_25 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2062 : forall X1 X2:term, auto___def_25 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2063 : auto___def_25 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2064 : auto___def_25 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2065 : forall X1 X2 X3 X4 X5:term, auto___def_25 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2066 : forall X1 X2:term, auto___def_25 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2067 : forall X1 X2 X3 X4 X5:term, auto___def_25 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2068 : forall X1 X2:term, auto___def_25 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2069 : forall X1 X2:term, auto___def_25 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2070 : auto___def_25 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2071 : forall X1 X2 X3 X4 X5:term, auto___def_25 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2072 : forall X1 X2 X3 X4 X5:term, auto___def_25 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2073 : forall X1 X2 X3 X4 X5:term, auto___def_25 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2074 : forall X1 X2:term, auto___def_25 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2075 : auto___def_25 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2076 : forall X1 X2:term, auto___def_25 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2077 : forall X1 X2 X3 X4 X5:term, auto___def_25 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2078 : forall X2:term, auto___def_25 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_25_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_2064  H).
   intro H. elim (rem_2063  H).
  intros X1 X2. intro H. elim (rem_2059 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2074 X1 X2 H).
   intro H. elim (rem_2056  H).
  intros X1 X2. intro H. elim (rem_2076 X1 X2 H).
  exact (rem_2053 epsilon_m__def_25_pknows_old ).
  intros X1 X2. intro H. elim (rem_2069 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2062 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2071 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2065 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2070  H).
   intro H. elim (rem_2075  H).
  intros X1. intro H. elim (rem_2054 X1 H).
   intro H. elim (rem_2061  H).
  intros X1 X2 X3. intro H. elim (rem_2058 X1 X2 X3 H).
   intro H. elim (rem_2060  H).
  intros X1 X2. intro H. elim (rem_2066 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2057 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2077 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2072 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2068 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2055 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2067 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2073 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2079 : (forall X:term, auto___def_23 X -> auto_knows_old X)
    -> forall X2:term, auto___def_25 X2 -> auto_knows_old X2. (* Cut history. *)
Proof.  intros epsilon_m__def_23_pknows_old. exact (rem_2078).
Defined.

Remark rem_2080 : (forall X:term, auto___def_23 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_23_pknows_old. intros X1 X2.
  cut (auto___def_25 X2 -> auto_knows_old X2). tauto. exact (rem_2079 epsilon_m__def_23_pknows_old X2).
Defined.

Remark rem_2081 : (forall X:term, auto___def_23 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_23_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_2049 epsilon_m__def_23_pknows_old X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2080 epsilon_m__def_23_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2082 : (forall X:term, auto___def_23 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_24 X1 -> auto___def_25 X2 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_23_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2081 epsilon_m__def_23_pknows_old X1 X2 A1 A2). clear  epsilon_m__def_23_pknows_old A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  epsilon_m__def_23_pknows_old A1 A2. tauto.
Defined.

Remark rem_2083 : forall X1 X2:term, auto___def_23 (cons X1 X2) -> or_1
    (auto___def_24 X1 /\ auto___def_25 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2084 : (forall X:term, auto___def_23 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_23 (cons X1 X2) -> auto_knows_old (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_23_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_2083 X1 X2 H);  intros.
  apply (rem_2082 epsilon_m__def_23_pknows_old X1 X2);  tauto.
Defined.

Remark rem_2085 : forall X1:term, auto___def_23 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2086 : forall X1 X2:term, auto___def_23 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2087 : auto___def_23 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2088 : auto___def_23 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2089 : forall X1 X2:term, auto___def_23 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2090 : forall X1 X2 X3:term, auto___def_23 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2091 : auto___def_23 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2092 : auto___def_23 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2093 : forall X1 X2:term, auto___def_23 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2094 : auto___def_23 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2095 : auto___def_23 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2096 : forall X1 X2 X3 X4 X5:term, auto___def_23 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2097 : forall X1 X2:term, auto___def_23 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2098 : forall X1 X2 X3 X4 X5:term, auto___def_23 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2099 : forall X1 X2:term, auto___def_23 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2100 : forall X1 X2:term, auto___def_23 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2101 : auto___def_23 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2102 : forall X1 X2 X3 X4 X5:term, auto___def_23 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2103 : forall X1 X2 X3 X4 X5:term, auto___def_23 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2104 : forall X1 X2 X3 X4 X5:term, auto___def_23 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2105 : forall X1 X2:term, auto___def_23 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2106 : auto___def_23 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2107 : forall X1 X2:term, auto___def_23 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2108 : forall X1 X2 X3 X4 X5:term, auto___def_23 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2109 : forall X2:term, auto___def_23 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_23_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_2095  H).
   intro H. elim (rem_2094  H).
  intros X1 X2;  exact (rem_2084 epsilon_m__def_23_pknows_old X1 X2).
  intros X1 X2. intro H. elim (rem_2105 X1 X2 H).
   intro H. elim (rem_2088  H).
  intros X1 X2. intro H. elim (rem_2107 X1 X2 H).
   intro H. elim (rem_2087  H).
  intros X1 X2. intro H. elim (rem_2100 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2093 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2102 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2096 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2101  H).
   intro H. elim (rem_2106  H).
  intros X1. intro H. elim (rem_2085 X1 H).
   intro H. elim (rem_2092  H).
  intros X1 X2 X3. intro H. elim (rem_2090 X1 X2 X3 H).
   intro H. elim (rem_2091  H).
  intros X1 X2. intro H. elim (rem_2097 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2089 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2108 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2103 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2099 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2086 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2098 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2104 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2110 : forall X1 X2:term, auto___def_23 X2 -> auto___type_3 X1 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_23 X2 -> auto_knows_old X2). tauto. exact (rem_2109 X2).
Qed.

Remark rem_2111 : forall X1 X2:term, auto___def_23 X2 -> auto___type_3 X1 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_2014 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2110 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2112 : forall X1 X2:term, auto___def_23 X2 -> auto___type_3 X1 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2111 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2113 : (forall X:term, auto___type_1 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_1_pknows_current.  tauto.
Defined.

Remark rem_2114 : (forall X:term, auto___type_1 X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows_current.  case (rem_2113 epsilon_m__type_1_pknows_current). clear  epsilon_m__type_1_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_m__type_1_pknows_current. tauto.
Defined.

Remark rem_2115 : (forall X:term, auto___type_1 X -> auto_knows_current X)
    -> auto___type_1 i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows_current. intro H. intros.
  elim (rem_396 H);  intros.
  apply (rem_2114 epsilon_m__type_1_pknows_current);  tauto.
Defined.

Remark rem_2116 : (forall X:term, auto___type_1 X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows_current.  case (rem_2113 epsilon_m__type_1_pknows_current). clear  epsilon_m__type_1_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_m__type_1_pknows_current. tauto.
Defined.

Remark rem_2117 : (forall X:term, auto___type_1 X -> auto_knows_current X)
    -> auto___type_1 server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows_current. intro H. intros.
  elim (rem_399 H);  intros.
  apply (rem_2116 epsilon_m__type_1_pknows_current);  tauto.
Defined.

Remark rem_2118 : (forall X:term, auto___type_1 X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows_current.  case (rem_2113 epsilon_m__type_1_pknows_current). clear  epsilon_m__type_1_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_m__type_1_pknows_current. tauto.
Defined.

Remark rem_2119 : (forall X:term, auto___type_1 X -> auto_knows_current X)
    -> auto___type_1 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows_current. intro H. intros.
  elim (rem_402 H);  intros.
  apply (rem_2118 epsilon_m__type_1_pknows_current);  tauto.
Defined.

Remark rem_2120 : (forall X:term, auto___type_1 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows_current.  case (rem_2113 epsilon_m__type_1_pknows_current). clear  epsilon_m__type_1_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m__type_1_pknows_current. tauto.
Defined.

Remark rem_2121 : (forall X:term, auto___type_1 X -> auto_knows_current X)
    -> auto___type_1 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows_current. intro H. intros.
  elim (rem_405 H);  intros.
  apply (rem_2120 epsilon_m__type_1_pknows_current);  tauto.
Defined.

Remark rem_2122 : forall X1:term, auto___type_1 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__type_1_pknows_current 1.
  intro X. case X.
  exact (rem_2121 epsilon_m__type_1_pknows_current ).
  exact (rem_2119 epsilon_m__type_1_pknows_current ).
  intros X1 X2. intro H. elim (rem_412 X1 X2 H).
  intros X1 X2. intro H. elim (rem_424 X1 X2 H).
  exact (rem_2115 epsilon_m__type_1_pknows_current ).
  intros X1 X2. intro H. elim (rem_426 X1 X2 H).
   intro H. elim (rem_409  H).
  intros X1 X2. intro H. elim (rem_419 X1 X2 H).
  intros X1 X2. intro H. elim (rem_414 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_421 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_415 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_420  H).
   intro H. elim (rem_425  H).
  intros X1. intro H. elim (rem_407 X1 H).
  exact (rem_2117 epsilon_m__type_1_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_411 X1 X2 X3 H).
   intro H. elim (rem_413  H).
  intros X1 X2. intro H. elim (rem_416 X1 X2 H).
  intros X1 X2. intro H. elim (rem_410 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_427 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_422 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_418 X1 X2 H).
  intros X1 X2. intro H. elim (rem_408 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_417 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_423 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2123 : forall X1 X2:term, auto___def_59 X2 -> auto___type_1 X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_1 X1 -> auto_knows_current X1). tauto. exact (rem_2122 X1).
Qed.

Remark rem_2124 : (forall X:term, auto___def_60 X -> auto_knows_current X)
    -> forall X1:term, auto___def_61 X1 -> auto___def_61 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2125 : (forall X:term, auto___def_60 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_11 X2 -> auto___def_61 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_60_pknows_current. intros X1 X2.
  cut (auto___def_61 X1 -> auto___def_61 X1). tauto. exact (rem_2124 epsilon_m__def_60_pknows_current X1).
Defined.

Remark rem_2126 : (forall X:term, auto___def_60 X -> auto_knows_current X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2127 : (forall X:term, auto___def_60 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_60_pknows_current. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_2126 epsilon_m__def_60_pknows_current X2).
Defined.

Remark rem_2128 : (forall X:term, auto___def_60 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_11 X2 -> (auto___def_61 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_60_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_61 X1). 2:apply (rem_2125 epsilon_m__def_60_pknows_current X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_2127 epsilon_m__def_60_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2129 : (forall X:term, auto___def_60 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_61 X1 -> auto___def_11 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_60_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2128 epsilon_m__def_60_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_60_pknows_current A1 A2. intros. apply trans_knows_current_crypt_5;  tauto.
 clear  epsilon_m__def_60_pknows_current A1 A2. tauto.
Defined.

Remark rem_2130 : forall X1 X2:term, auto___def_60 (crypt X1 X2) -> or_1
    (auto___def_61 X1 /\ auto___def_11 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2131 : (forall X:term, auto___def_60 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_60 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_60_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2130 X1 X2 H);  intros.
  apply (rem_2129 epsilon_m__def_60_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2132 : forall X1:term, auto___def_60 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2133 : forall X1 X2:term, auto___def_60 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2134 : auto___def_60 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2135 : auto___def_60 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2136 : forall X1 X2:term, auto___def_60 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2137 : forall X1 X2 X3:term, auto___def_60 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2138 : forall X1 X2:term, auto___def_60 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2139 : auto___def_60 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2140 : auto___def_60 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2141 : forall X1 X2:term, auto___def_60 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2142 : auto___def_60 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2143 : auto___def_60 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2144 : forall X1 X2 X3 X4 X5:term, auto___def_60 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2145 : forall X1 X2:term, auto___def_60 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2146 : forall X1 X2 X3 X4 X5:term, auto___def_60 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2147 : forall X1 X2:term, auto___def_60 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2148 : forall X1 X2:term, auto___def_60 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2149 : auto___def_60 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2150 : forall X1 X2 X3 X4 X5:term, auto___def_60 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2151 : forall X1 X2 X3 X4 X5:term, auto___def_60 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2152 : forall X1 X2 X3 X4 X5:term, auto___def_60 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2153 : auto___def_60 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2154 : forall X1 X2:term, auto___def_60 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2155 : forall X1 X2 X3 X4 X5:term, auto___def_60 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2156 : forall X1:term, auto___def_60 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_60_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2143  H).
   intro H. elim (rem_2142  H).
  intros X1 X2. intro H. elim (rem_2138 X1 X2 H).
  intros X1 X2;  exact (rem_2131 epsilon_m__def_60_pknows_current X1 X2).
   intro H. elim (rem_2135  H).
  intros X1 X2. intro H. elim (rem_2154 X1 X2 H).
   intro H. elim (rem_2134  H).
  intros X1 X2. intro H. elim (rem_2148 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2141 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2150 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2144 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2149  H).
   intro H. elim (rem_2153  H).
  intros X1. intro H. elim (rem_2132 X1 H).
   intro H. elim (rem_2140  H).
  intros X1 X2 X3. intro H. elim (rem_2137 X1 X2 X3 H).
   intro H. elim (rem_2139  H).
  intros X1 X2. intro H. elim (rem_2145 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2136 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2155 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2151 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2147 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2133 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2146 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2152 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2157 : (forall X:term, auto___def_59 X -> auto_knows_current X)
    -> forall X1:term, auto___def_60 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_59_pknows_current. exact (rem_2156).
Defined.

Remark rem_2158 : (forall X:term, auto___def_59 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___def_9 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_59_pknows_current. intros X1 X2.
  cut (auto___def_60 X1 -> auto_knows_current X1). tauto. exact (rem_2157 epsilon_m__def_59_pknows_current X1).
Defined.

Remark rem_2159 : (forall X:term, auto___def_9 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_9_pknows_current.  tauto.
Defined.

Remark rem_2160 : (forall X:term, auto___def_9 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_9_pknows_current.  case (rem_2159 epsilon_m__def_9_pknows_current). clear  epsilon_m__def_9_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__def_9_pknows_current. tauto.
Defined.

Remark rem_2161 : auto___def_9 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2162 : (forall X:term, auto___def_9 X -> auto_knows_current X)
    -> auto___def_9 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_9_pknows_current. intro H. intros.
  elim (rem_2161 H);  intros.
  apply (rem_2160 epsilon_m__def_9_pknows_current);  tauto.
Defined.

Remark rem_2163 : forall X1:term, auto___def_9 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2164 : forall X1 X2:term, auto___def_9 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2165 : auto___def_9 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2166 : forall X1 X2:term, auto___def_9 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2167 : forall X1 X2 X3:term, auto___def_9 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2168 : forall X1 X2:term, auto___def_9 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2169 : auto___def_9 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2170 : auto___def_9 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2171 : forall X1 X2:term, auto___def_9 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2172 : auto___def_9 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2173 : auto___def_9 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2174 : forall X1 X2 X3 X4 X5:term, auto___def_9 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2175 : forall X1 X2:term, auto___def_9 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2176 : forall X1 X2 X3 X4 X5:term, auto___def_9 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2177 : forall X1 X2:term, auto___def_9 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2178 : forall X1 X2:term, auto___def_9 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2179 : auto___def_9 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2180 : forall X1 X2 X3 X4 X5:term, auto___def_9 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2181 : forall X1 X2 X3 X4 X5:term, auto___def_9 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2182 : forall X1 X2 X3 X4 X5:term, auto___def_9 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2183 : forall X1 X2:term, auto___def_9 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2184 : auto___def_9 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2185 : forall X1 X2:term, auto___def_9 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2186 : forall X1 X2 X3 X4 X5:term, auto___def_9 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2187 : forall X2:term, auto___def_9 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_9_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2173  H).
   intro H. elim (rem_2172  H).
  intros X1 X2. intro H. elim (rem_2168 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2183 X1 X2 H).
   intro H. elim (rem_2165  H).
  intros X1 X2. intro H. elim (rem_2185 X1 X2 H).
  exact (rem_2162 epsilon_m__def_9_pknows_current ).
  intros X1 X2. intro H. elim (rem_2178 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2171 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2180 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2174 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2179  H).
   intro H. elim (rem_2184  H).
  intros X1. intro H. elim (rem_2163 X1 H).
   intro H. elim (rem_2170  H).
  intros X1 X2 X3. intro H. elim (rem_2167 X1 X2 X3 H).
   intro H. elim (rem_2169  H).
  intros X1 X2. intro H. elim (rem_2175 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2166 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2186 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2181 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2177 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2164 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2176 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2182 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2188 : (forall X:term, auto___def_59 X -> auto_knows_current X)
    -> forall X2:term, auto___def_9 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_59_pknows_current. exact (rem_2187).
Defined.

Remark rem_2189 : (forall X:term, auto___def_59 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___def_9 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_59_pknows_current. intros X1 X2.
  cut (auto___def_9 X2 -> auto_knows_current X2). tauto. exact (rem_2188 epsilon_m__def_59_pknows_current X2).
Defined.

Remark rem_2190 : (forall X:term, auto___def_59 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___def_9 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_59_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2158 epsilon_m__def_59_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2189 epsilon_m__def_59_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2191 : (forall X:term, auto___def_59 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_60 X1 -> auto___def_9 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_59_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2190 epsilon_m__def_59_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_59_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_59_pknows_current A1 A2. tauto.
Defined.

Remark rem_2192 : forall X1 X2:term, auto___def_59 (cons X1 X2) -> or_1
    (auto___def_60 X1 /\ auto___def_9 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2193 : (forall X:term, auto___def_59 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_59 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_59_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2192 X1 X2 H);  intros.
  apply (rem_2191 epsilon_m__def_59_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2194 : forall X1:term, auto___def_59 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2195 : forall X1 X2:term, auto___def_59 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2196 : auto___def_59 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2197 : auto___def_59 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2198 : forall X1 X2:term, auto___def_59 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2199 : forall X1 X2 X3:term, auto___def_59 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2200 : auto___def_59 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2201 : auto___def_59 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2202 : forall X1 X2:term, auto___def_59 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2203 : auto___def_59 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2204 : auto___def_59 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2205 : forall X1 X2 X3 X4 X5:term, auto___def_59 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2206 : forall X1 X2:term, auto___def_59 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2207 : forall X1 X2 X3 X4 X5:term, auto___def_59 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2208 : forall X1 X2:term, auto___def_59 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2209 : forall X1 X2:term, auto___def_59 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2210 : auto___def_59 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2211 : forall X1 X2 X3 X4 X5:term, auto___def_59 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2212 : forall X1 X2 X3 X4 X5:term, auto___def_59 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2213 : forall X1 X2 X3 X4 X5:term, auto___def_59 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2214 : forall X1 X2:term, auto___def_59 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2215 : auto___def_59 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2216 : forall X1 X2:term, auto___def_59 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2217 : forall X1 X2 X3 X4 X5:term, auto___def_59 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2218 : forall X2:term, auto___def_59 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_59_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2204  H).
   intro H. elim (rem_2203  H).
  intros X1 X2;  exact (rem_2193 epsilon_m__def_59_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2214 X1 X2 H).
   intro H. elim (rem_2197  H).
  intros X1 X2. intro H. elim (rem_2216 X1 X2 H).
   intro H. elim (rem_2196  H).
  intros X1 X2. intro H. elim (rem_2209 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2202 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2211 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2205 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2210  H).
   intro H. elim (rem_2215  H).
  intros X1. intro H. elim (rem_2194 X1 H).
   intro H. elim (rem_2201  H).
  intros X1 X2 X3. intro H. elim (rem_2199 X1 X2 X3 H).
   intro H. elim (rem_2200  H).
  intros X1 X2. intro H. elim (rem_2206 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2198 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2217 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2212 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2208 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2195 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2207 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2213 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2219 : forall X1 X2:term, auto___def_59 X2 -> auto___type_1 X1 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_59 X2 -> auto_knows_current X2). tauto. exact (rem_2218 X2).
Qed.

Remark rem_2220 : forall X1 X2:term, auto___def_59 X2 -> auto___type_1 X1 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2123 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2219 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2221 : forall X1 X2:term, auto___def_59 X2 -> auto___type_1 X1 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2220 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2222 : auto_knows_old nil. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans_knows_old_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2223 : forall X1 X2 X3 X4 X5:term, auto___def_46 X2 -> auto___def_47 X3 -> auto___type_6 X1 -> auto___type_7 X4 -> auto___type_8 X5 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5.
  tauto.
Qed.

Remark rem_2224 : forall X1 X2 X3 X4 X5:term, auto___def_46 X2 -> auto___def_47 X3 -> auto___type_6 X1 -> auto___type_7 X4 -> auto___type_8 X5 -> auto_alice_data_old X1 X2 X3 X4 X5. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5.
  case (rem_2223 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5). clear  A1 A2 A3 A4 A5. intros. apply trans_alice_data_old_1;  tauto.
 clear  A1 A2 A3 A4 A5. tauto.
Qed.

Remark rem_2225 : forall X1 X2 X3 X4 X5:term, auto___def_47 X3 -> auto___type_8 X5 -> auto___def_46 X2 -> auto___type_7 X4 -> auto___type_6 X1 -> auto_alice_data_old X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_46 X2 -> auto___def_47 X3 -> auto___type_6 X1 -> auto___type_7 X4 -> auto___type_8 X5 -> auto_alice_data_old X1 X2 X3 X4 X5). tauto. exact (rem_2224 X1 X2 X3 X4 X5).
Qed.

Remark rem_2226 : auto___def_4 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2227 : (forall X:term, auto___type_6 X -> auto___def_4 X -> False)
    -> auto___def_4 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_m__def_4. intro H. intros.
  elim (rem_2226 H);  intros.
Defined.

Remark rem_2228 : (forall X:term, auto___type_6 X -> auto___def_4 X -> False)
    -> auto___type_6 i -> auto___def_4 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_m__def_4. intro H. intros.
  elim (rem_1872 H);  intros.
  apply (rem_2227 epsilon_m__type_6_m__def_4);  tauto.
Defined.

Remark rem_2229 : auto___def_4 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2230 : (forall X:term, auto___type_6 X -> auto___def_4 X -> False)
    -> auto___def_4 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_m__def_4. intro H. intros.
  elim (rem_2229 H);  intros.
Defined.

Remark rem_2231 : (forall X:term, auto___type_6 X -> auto___def_4 X -> False)
    -> auto___type_6 server -> auto___def_4 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_m__def_4. intro H. intros.
  elim (rem_1875 H);  intros.
  apply (rem_2230 epsilon_m__type_6_m__def_4);  tauto.
Defined.

Remark rem_2232 : auto___def_4 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2233 : (forall X:term, auto___type_6 X -> auto___def_4 X -> False)
    -> auto___def_4 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_m__def_4. intro H. intros.
  elim (rem_2232 H);  intros.
Defined.

Remark rem_2234 : (forall X:term, auto___type_6 X -> auto___def_4 X -> False)
    -> auto___type_6 bob -> auto___def_4 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_m__def_4. intro H. intros.
  elim (rem_1878 H);  intros.
  apply (rem_2233 epsilon_m__type_6_m__def_4);  tauto.
Defined.

Remark rem_2235 : auto___def_4 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2236 : (forall X:term, auto___type_6 X -> auto___def_4 X -> False)
    -> auto___def_4 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_m__def_4. intro H. intros.
  elim (rem_2235 H);  intros.
Defined.

Remark rem_2237 : (forall X:term, auto___type_6 X -> auto___def_4 X -> False)
    -> auto___type_6 alice -> auto___def_4 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_6_m__def_4. intro H. intros.
  elim (rem_1881 H);  intros.
  apply (rem_2236 epsilon_m__type_6_m__def_4);  tauto.
Defined.

Remark rem_2238 : forall X1:term, auto___type_6 X1 -> auto___def_4 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__type_6_m__def_4 1.
  intro X. case X.
  exact (rem_2237 epsilon_m__type_6_m__def_4 ).
  exact (rem_2234 epsilon_m__type_6_m__def_4 ).
  intros X1 X2. intro H. elim (rem_1888 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1900 X1 X2 H).
  exact (rem_2228 epsilon_m__type_6_m__def_4 ).
  intros X1 X2. intro H. elim (rem_1902 X1 X2 H).
   intro H. elim (rem_1885  H).
  intros X1 X2. intro H. elim (rem_1895 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1890 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1897 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1891 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_1896  H).
   intro H. elim (rem_1901  H).
  intros X1. intro H. elim (rem_1883 X1 H).
  exact (rem_2231 epsilon_m__type_6_m__def_4 ).
  intros X1 X2 X3. intro H. elim (rem_1887 X1 X2 X3 H).
   intro H. elim (rem_1889  H).
  intros X1 X2. intro H. elim (rem_1892 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1886 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1903 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1898 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_1894 X1 X2 H).
  intros X1 X2. intro H. elim (rem_1884 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1893 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_1899 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2239 : forall X1 X2:term, auto___def_4 X2 -> auto___def_43 X1 -> auto___type_6 X2 -> auto_knows_old X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2238 X2)). tauto.
Qed.

Remark rem_2240 : forall X1 X2:term, auto___type_6 X2 -> auto___def_43 X1 -> auto___def_4 X2 -> auto_knows_old X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_4 X2 -> auto___def_43 X1 -> auto___type_6 X2 -> auto_knows_old X1). tauto. exact (rem_2239 X1 X2).
Qed.

Remark rem_2241 : (forall X:term, auto_agent X -> auto___def_4 X -> False)
    -> auto___def_4 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_4. intro H. intros.
  elim (rem_2226 H);  intros.
Defined.

Remark rem_2242 : (forall X:term, auto_agent X -> auto___def_4 X -> False)
    -> auto_agent i -> auto___def_4 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_4. intro H. intros.
  elim (rem_72 H);  intros.
  apply (rem_2241 epsilon_magent_m__def_4);  tauto.
Defined.

Remark rem_2243 : (forall X:term, auto_agent X -> auto___def_4 X -> False)
    -> auto___def_4 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_4. intro H. intros.
  elim (rem_2229 H);  intros.
Defined.

Remark rem_2244 : (forall X:term, auto_agent X -> auto___def_4 X -> False)
    -> auto_agent server -> auto___def_4 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_4. intro H. intros.
  elim (rem_75 H);  intros.
  apply (rem_2243 epsilon_magent_m__def_4);  tauto.
Defined.

Remark rem_2245 : (forall X:term, auto_agent X -> auto___def_4 X -> False)
    -> auto___def_4 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_4. intro H. intros.
  elim (rem_2232 H);  intros.
Defined.

Remark rem_2246 : (forall X:term, auto_agent X -> auto___def_4 X -> False)
    -> auto_agent bob -> auto___def_4 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_4. intro H. intros.
  elim (rem_78 H);  intros.
  apply (rem_2245 epsilon_magent_m__def_4);  tauto.
Defined.

Remark rem_2247 : (forall X:term, auto_agent X -> auto___def_4 X -> False)
    -> auto___def_4 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_4. intro H. intros.
  elim (rem_2235 H);  intros.
Defined.

Remark rem_2248 : (forall X:term, auto_agent X -> auto___def_4 X -> False)
    -> auto_agent alice -> auto___def_4 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_4. intro H. intros.
  elim (rem_81 H);  intros.
  apply (rem_2247 epsilon_magent_m__def_4);  tauto.
Defined.

Remark rem_2249 : forall X1:term, auto_agent X1 -> auto___def_4 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_magent_m__def_4 1.
  intro X. case X.
  exact (rem_2248 epsilon_magent_m__def_4 ).
  exact (rem_2246 epsilon_magent_m__def_4 ).
  intros X1 X2. intro H. elim (rem_88 X1 X2 H).
  intros X1 X2. intro H. elim (rem_100 X1 X2 H).
  exact (rem_2242 epsilon_magent_m__def_4 ).
  intros X1 X2. intro H. elim (rem_102 X1 X2 H).
   intro H. elim (rem_85  H).
  intros X1 X2. intro H. elim (rem_95 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_97 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_91 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_96  H).
   intro H. elim (rem_101  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_2244 epsilon_magent_m__def_4 ).
  intros X1 X2 X3. intro H. elim (rem_87 X1 X2 X3 H).
   intro H. elim (rem_89  H).
  intros X1 X2. intro H. elim (rem_92 X1 X2 H).
  intros X1 X2. intro H. elim (rem_86 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_103 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_98 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_94 X1 X2 H).
  intros X1 X2. intro H. elim (rem_84 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_93 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_99 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2250 : forall X1 X2:term, auto___def_10 X1 -> auto___def_4 X2 -> auto_agent X2 -> auto_knows_old X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2249 X2)). tauto.
Qed.

Remark rem_2251 : forall X1 X2:term, auto_agent X2 -> auto___def_10 X1 -> auto___def_4 X2 -> auto_knows_old X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_4 X2 -> auto_agent X2 -> auto_knows_old X1). tauto. exact (rem_2250 X1 X2).
Qed.

Remark rem_2252 : (forall X:term, auto___type_3 X -> auto___def_4 X -> False)
    -> auto___def_4 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_m__def_4. intro H. intros.
  elim (rem_2226 H);  intros.
Defined.

Remark rem_2253 : (forall X:term, auto___type_3 X -> auto___def_4 X -> False)
    -> auto___type_3 i -> auto___def_4 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_m__def_4. intro H. intros.
  elim (rem_836 H);  intros.
  apply (rem_2252 epsilon_m__type_3_m__def_4);  tauto.
Defined.

Remark rem_2254 : (forall X:term, auto___type_3 X -> auto___def_4 X -> False)
    -> auto___def_4 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_m__def_4. intro H. intros.
  elim (rem_2229 H);  intros.
Defined.

Remark rem_2255 : (forall X:term, auto___type_3 X -> auto___def_4 X -> False)
    -> auto___type_3 server -> auto___def_4 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_m__def_4. intro H. intros.
  elim (rem_839 H);  intros.
  apply (rem_2254 epsilon_m__type_3_m__def_4);  tauto.
Defined.

Remark rem_2256 : (forall X:term, auto___type_3 X -> auto___def_4 X -> False)
    -> auto___def_4 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_m__def_4. intro H. intros.
  elim (rem_2232 H);  intros.
Defined.

Remark rem_2257 : (forall X:term, auto___type_3 X -> auto___def_4 X -> False)
    -> auto___type_3 bob -> auto___def_4 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_m__def_4. intro H. intros.
  elim (rem_842 H);  intros.
  apply (rem_2256 epsilon_m__type_3_m__def_4);  tauto.
Defined.

Remark rem_2258 : (forall X:term, auto___type_3 X -> auto___def_4 X -> False)
    -> auto___def_4 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_m__def_4. intro H. intros.
  elim (rem_2235 H);  intros.
Defined.

Remark rem_2259 : (forall X:term, auto___type_3 X -> auto___def_4 X -> False)
    -> auto___type_3 alice -> auto___def_4 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_3_m__def_4. intro H. intros.
  elim (rem_845 H);  intros.
  apply (rem_2258 epsilon_m__type_3_m__def_4);  tauto.
Defined.

Remark rem_2260 : forall X1:term, auto___type_3 X1 -> auto___def_4 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__type_3_m__def_4 1.
  intro X. case X.
  exact (rem_2259 epsilon_m__type_3_m__def_4 ).
  exact (rem_2257 epsilon_m__type_3_m__def_4 ).
  intros X1 X2. intro H. elim (rem_852 X1 X2 H).
  intros X1 X2. intro H. elim (rem_864 X1 X2 H).
  exact (rem_2253 epsilon_m__type_3_m__def_4 ).
  intros X1 X2. intro H. elim (rem_866 X1 X2 H).
   intro H. elim (rem_849  H).
  intros X1 X2. intro H. elim (rem_859 X1 X2 H).
  intros X1 X2. intro H. elim (rem_854 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_861 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_855 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_860  H).
   intro H. elim (rem_865  H).
  intros X1. intro H. elim (rem_847 X1 H).
  exact (rem_2255 epsilon_m__type_3_m__def_4 ).
  intros X1 X2 X3. intro H. elim (rem_851 X1 X2 X3 H).
   intro H. elim (rem_853  H).
  intros X1 X2. intro H. elim (rem_856 X1 X2 H).
  intros X1 X2. intro H. elim (rem_850 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_867 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_862 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_858 X1 X2 H).
  intros X1 X2. intro H. elim (rem_848 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_857 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_863 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2261 : forall X1 X2:term, auto___def_26 X1 -> auto___def_4 X2 -> auto___type_3 X2 -> auto_knows_old X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2260 X2)). tauto.
Qed.

Remark rem_2262 : forall X1 X2:term, auto___type_3 X2 -> auto___def_26 X1 -> auto___def_4 X2 -> auto_knows_old X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 X1 -> auto___def_4 X2 -> auto___type_3 X2 -> auto_knows_old X1). tauto. exact (rem_2261 X1 X2).
Qed.

Inductive or_3(H1 H2 H3:Prop) : Prop :=
    or_3_intro_1 : H1 -> (or_3 H1 H2 H3)
  | or_3_intro_2 : H2 -> (or_3 H1 H2 H3)
  | or_3_intro_3 : H3 -> (or_3 H1 H2 H3)
.

Remark rem_2263 : forall X1 X2:term, auto___def_3 X1 X2 -> or_3
    (auto___type_6 X1 /\ auto___def_43 X2)
    (auto_agent X1 /\ auto___def_10 X2)
    (auto___type_3 X1 /\ auto___def_26 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_3_intro_1; tauto.
  intros. apply or_3_intro_2; tauto.
  intros. apply or_3_intro_3; tauto.
Qed.

Remark rem_2264 : forall X1 X2:term, auto___def_3 X2 X1 -> auto___def_4 X2 -> auto_knows_old X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2263 X2 X1 H);  intros.
  apply (rem_2240 X1 X2);  tauto.
  apply (rem_2251 X1 X2);  tauto.
  apply (rem_2262 X1 X2);  tauto.
Qed.

Remark rem_2265 : forall X2:term, auto_knows_old X2 -> auto_knows_old X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2266 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_old X2 -> auto_knows_old X2). tauto. exact (rem_2265 X2).
Qed.

Remark rem_2267 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_1797 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2266 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2268 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2267 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_old_crypt_4;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2269 : forall X1 X2 X3 X4:term, auto_bob_data_current bob X1 X2 X3 X4 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_1864 bob X1 X2 X3 X4 H);  intros.
Qed.

Remark rem_2270 : forall X1 X2 X3 X4:term, auto_bob_data_current bob X1 X2 X3 X4 -> auto_knows_current X2 -> auto___query__intruder_knows_yb_as_seen_by_bob. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_bob_data_current bob X1 X2 X3 X4 -> auto_knows_current X2 -> False). tauto.
  exact (rem_2269 X1 X2 X3 X4).
Qed.

Remark rem_2271 : forall X1 X2 X3 X4:term, auto_bob_data_current bob X2 X1 X3 X4 -> auto_knows_current X1 -> auto___query__intruder_knows_yb_as_seen_by_bob. (* Prove equivalent, normalized clause. *)
Proof.
   intros X2 X1 X3 X4.
  cut (auto_bob_data_current bob X1 X2 X3 X4 -> auto_knows_current X2 -> auto___query__intruder_knows_yb_as_seen_by_bob). tauto. exact (rem_2270 X1 X2 X3 X4).
Qed.

Remark rem_2272 : forall X1 X2 X3 X4 X5:term, auto___def_93 X2 -> auto___def_94 X3 -> auto___type_15 X1 -> auto___type_16 X4 -> auto___type_17 X5 -> auto___type_15 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_15 X1 -> auto___type_15 X1). tauto. exact (rem_1756 X1).
Qed.

Remark rem_2273 : forall X2:term, auto___def_93 X2 -> auto___def_93 X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2274 : forall X1 X2 X3 X4 X5:term, auto___def_93 X2 -> auto___def_94 X3 -> auto___type_15 X1 -> auto___type_16 X4 -> auto___type_17 X5 -> auto___def_93 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_93 X2 -> auto___def_93 X2). tauto. exact (rem_2273 X2).
Qed.

Remark rem_2275 : forall X3:term, auto___def_94 X3 -> auto___def_94 X3. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2276 : forall X1 X2 X3 X4 X5:term, auto___def_93 X2 -> auto___def_94 X3 -> auto___type_15 X1 -> auto___type_16 X4 -> auto___type_17 X5 -> auto___def_94 X3. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_94 X3 -> auto___def_94 X3). tauto. exact (rem_2275 X3).
Qed.

Remark rem_2277 : forall X4:term, auto___type_16 X4 -> auto___type_16 X4. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2278 : forall X1 X2 X3 X4 X5:term, auto___def_93 X2 -> auto___def_94 X3 -> auto___type_15 X1 -> auto___type_16 X4 -> auto___type_17 X5 -> auto___type_16 X4. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_16 X4 -> auto___type_16 X4). tauto. exact (rem_2277 X4).
Qed.

Remark rem_2279 : forall X5:term, auto___type_17 X5 -> auto___type_17 X5. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2280 : forall X1 X2 X3 X4 X5:term, auto___def_93 X2 -> auto___def_94 X3 -> auto___type_15 X1 -> auto___type_16 X4 -> auto___type_17 X5 -> auto___type_17 X5. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___type_17 X5 -> auto___type_17 X5). tauto. exact (rem_2279 X5).
Qed.

Remark rem_2281 : forall X1 X2 X3 X4 X5:term, auto___def_93 X2 -> auto___def_94 X3 -> auto___type_15 X1 -> auto___type_16 X4 -> auto___type_17 X5 -> (auto___type_15 X1 /\ auto___def_93 X2 /\ auto___def_94 X3 /\ auto___type_16 X4 /\ auto___type_17 X5) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5.
  cut (auto___type_15 X1). 2:apply (rem_2272 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_93 X2). 2:apply (rem_2274 X1 X2 X3 X4 X5);  assumption.
  cut (auto___def_94 X3). 2:apply (rem_2276 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_16 X4). 2:apply (rem_2278 X1 X2 X3 X4 X5);  assumption.
  cut (auto___type_17 X5). 2:apply (rem_2280 X1 X2 X3 X4 X5);  assumption.
  tauto.
Qed.

Remark rem_2282 : forall X1 X2 X3 X4 X5:term, auto___def_93 X2 -> auto___def_94 X3 -> auto___type_15 X1 -> auto___type_16 X4 -> auto___type_17 X5 -> auto_alice_data_current X1 X2 X3 X4 X5. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5.
  case (rem_2281 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5). clear  A1 A2 A3 A4 A5. intros. apply trans_alice_data_current_1;  tauto.
 clear  A1 A2 A3 A4 A5. tauto.
Qed.

Remark rem_2283 : forall X1 X2 X3 X4 X5:term, auto___def_94 X3 -> auto___type_17 X5 -> auto___def_93 X2 -> auto___type_16 X4 -> auto___type_15 X1 -> auto_alice_data_current X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_93 X2 -> auto___def_94 X3 -> auto___type_15 X1 -> auto___type_16 X4 -> auto___type_17 X5 -> auto_alice_data_current X1 X2 X3 X4 X5). tauto. exact (rem_2282 X1 X2 X3 X4 X5).
Qed.

Remark rem_2284 : forall X1 X2:term, auto_knows_current (ya_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2.  case (rem_10). intros. apply trans_knows_current_ya_old_1;  tauto.
 tauto.
Qed.

Remark rem_2285 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_782 X1).
Qed.

Remark rem_2286 : forall X1 X2:term, auto_knows_current (cons X2 X1) -> auto_knows_current X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_350 X2 X1 H);  intros.
  apply (rem_2285 X1 X2);  tauto.
Qed.

Remark rem_2287 : auto_agent server. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans_agent_server_1;  tauto.
 tauto.
Qed.

Remark rem_2288 : (forall X:term, auto___type_15 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_15_pknows_current.  tauto.
Defined.

Remark rem_2289 : (forall X:term, auto___type_15 X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_15_pknows_current.  case (rem_2288 epsilon_m__type_15_pknows_current). clear  epsilon_m__type_15_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_m__type_15_pknows_current. tauto.
Defined.

Remark rem_2290 : auto___type_15 i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2291 : (forall X:term, auto___type_15 X -> auto_knows_current X)
    -> auto___type_15 i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_15_pknows_current. intro H. intros.
  elim (rem_2290 H);  intros.
  apply (rem_2289 epsilon_m__type_15_pknows_current);  tauto.
Defined.

Remark rem_2292 : (forall X:term, auto___type_15 X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_15_pknows_current.  case (rem_2288 epsilon_m__type_15_pknows_current). clear  epsilon_m__type_15_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_m__type_15_pknows_current. tauto.
Defined.

Remark rem_2293 : auto___type_15 server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2294 : (forall X:term, auto___type_15 X -> auto_knows_current X)
    -> auto___type_15 server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_15_pknows_current. intro H. intros.
  elim (rem_2293 H);  intros.
  apply (rem_2292 epsilon_m__type_15_pknows_current);  tauto.
Defined.

Remark rem_2295 : (forall X:term, auto___type_15 X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_15_pknows_current.  case (rem_2288 epsilon_m__type_15_pknows_current). clear  epsilon_m__type_15_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_m__type_15_pknows_current. tauto.
Defined.

Remark rem_2296 : auto___type_15 bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2297 : (forall X:term, auto___type_15 X -> auto_knows_current X)
    -> auto___type_15 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_15_pknows_current. intro H. intros.
  elim (rem_2296 H);  intros.
  apply (rem_2295 epsilon_m__type_15_pknows_current);  tauto.
Defined.

Remark rem_2298 : (forall X:term, auto___type_15 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_15_pknows_current.  case (rem_2288 epsilon_m__type_15_pknows_current). clear  epsilon_m__type_15_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m__type_15_pknows_current. tauto.
Defined.

Remark rem_2299 : auto___type_15 alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2300 : (forall X:term, auto___type_15 X -> auto_knows_current X)
    -> auto___type_15 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_15_pknows_current. intro H. intros.
  elim (rem_2299 H);  intros.
  apply (rem_2298 epsilon_m__type_15_pknows_current);  tauto.
Defined.

Remark rem_2301 : forall X1:term, auto___type_15 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2302 : forall X1 X2:term, auto___type_15 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2303 : auto___type_15 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2304 : forall X1 X2:term, auto___type_15 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2305 : forall X1 X2 X3:term, auto___type_15 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2306 : forall X1 X2:term, auto___type_15 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2307 : auto___type_15 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2308 : forall X1 X2:term, auto___type_15 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2309 : forall X1 X2 X3 X4 X5:term, auto___type_15 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2310 : forall X1 X2:term, auto___type_15 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2311 : forall X1 X2 X3 X4 X5:term, auto___type_15 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2312 : forall X1 X2:term, auto___type_15 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2313 : forall X1 X2:term, auto___type_15 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2314 : auto___type_15 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2315 : forall X1 X2 X3 X4 X5:term, auto___type_15 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2316 : forall X1 X2 X3 X4 X5:term, auto___type_15 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2317 : forall X1 X2 X3 X4 X5:term, auto___type_15 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2318 : forall X1 X2:term, auto___type_15 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2319 : auto___type_15 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2320 : forall X1 X2:term, auto___type_15 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2321 : forall X1 X2 X3 X4 X5:term, auto___type_15 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2322 : forall X1:term, auto___type_15 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__type_15_pknows_current 1.
  intro X. case X.
  exact (rem_2300 epsilon_m__type_15_pknows_current ).
  exact (rem_2297 epsilon_m__type_15_pknows_current ).
  intros X1 X2. intro H. elim (rem_2306 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2318 X1 X2 H).
  exact (rem_2291 epsilon_m__type_15_pknows_current ).
  intros X1 X2. intro H. elim (rem_2320 X1 X2 H).
   intro H. elim (rem_2303  H).
  intros X1 X2. intro H. elim (rem_2313 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2308 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2315 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2309 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2314  H).
   intro H. elim (rem_2319  H).
  intros X1. intro H. elim (rem_2301 X1 H).
  exact (rem_2294 epsilon_m__type_15_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_2305 X1 X2 X3 H).
   intro H. elim (rem_2307  H).
  intros X1 X2. intro H. elim (rem_2310 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2304 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2321 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2316 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2312 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2302 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2311 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2317 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2323 : forall X1 X2:term, auto___def_87 X2 -> auto___type_15 X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_15 X1 -> auto_knows_current X1). tauto. exact (rem_2322 X1).
Qed.

Remark rem_2324 : (forall X:term, auto___def_88 X -> auto_knows_current X)
    -> forall X1:term, auto___def_90 X1 -> auto___def_90 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2325 : (forall X:term, auto___def_88 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_90 X1 -> auto___def_91 X2 -> auto___def_90 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_88_pknows_current. intros X1 X2.
  cut (auto___def_90 X1 -> auto___def_90 X1). tauto. exact (rem_2324 epsilon_m__def_88_pknows_current X1).
Defined.

Remark rem_2326 : (forall X:term, auto___def_88 X -> auto_knows_current X)
    -> forall X2:term, auto___def_91 X2 -> auto___def_91 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2327 : (forall X:term, auto___def_88 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_90 X1 -> auto___def_91 X2 -> auto___def_91 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_88_pknows_current. intros X1 X2.
  cut (auto___def_91 X2 -> auto___def_91 X2). tauto. exact (rem_2326 epsilon_m__def_88_pknows_current X2).
Defined.

Remark rem_2328 : (forall X:term, auto___def_88 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_90 X1 -> auto___def_91 X2 -> (auto___def_90 X1 /\ auto___def_91 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_88_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_90 X1). 2:apply (rem_2325 epsilon_m__def_88_pknows_current X1 X2);  assumption.
  cut (auto___def_91 X2). 2:apply (rem_2327 epsilon_m__def_88_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2329 : (forall X:term, auto___def_88 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_90 X1 -> auto___def_91 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_88_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2328 epsilon_m__def_88_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_88_pknows_current A1 A2. intros. apply trans_knows_current_crypt_2;  tauto.
 clear  epsilon_m__def_88_pknows_current A1 A2. tauto.
Defined.

Remark rem_2330 : forall X1 X2:term, auto___def_88 (crypt X1 X2) -> or_1
    (auto___def_90 X1 /\ auto___def_91 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2331 : (forall X:term, auto___def_88 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_88 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_88_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2330 X1 X2 H);  intros.
  apply (rem_2329 epsilon_m__def_88_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2332 : forall X1:term, auto___def_88 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2333 : forall X1 X2:term, auto___def_88 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2334 : auto___def_88 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2335 : auto___def_88 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2336 : forall X1 X2:term, auto___def_88 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2337 : forall X1 X2 X3:term, auto___def_88 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2338 : forall X1 X2:term, auto___def_88 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2339 : auto___def_88 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2340 : auto___def_88 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2341 : forall X1 X2:term, auto___def_88 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2342 : auto___def_88 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2343 : auto___def_88 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2344 : forall X1 X2 X3 X4 X5:term, auto___def_88 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2345 : forall X1 X2:term, auto___def_88 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2346 : forall X1 X2 X3 X4 X5:term, auto___def_88 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2347 : forall X1 X2:term, auto___def_88 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2348 : forall X1 X2:term, auto___def_88 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2349 : auto___def_88 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2350 : forall X1 X2 X3 X4 X5:term, auto___def_88 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2351 : forall X1 X2 X3 X4 X5:term, auto___def_88 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2352 : forall X1 X2 X3 X4 X5:term, auto___def_88 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2353 : auto___def_88 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2354 : forall X1 X2:term, auto___def_88 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2355 : forall X1 X2 X3 X4 X5:term, auto___def_88 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2356 : forall X1:term, auto___def_88 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_88_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2343  H).
   intro H. elim (rem_2342  H).
  intros X1 X2. intro H. elim (rem_2338 X1 X2 H).
  intros X1 X2;  exact (rem_2331 epsilon_m__def_88_pknows_current X1 X2).
   intro H. elim (rem_2335  H).
  intros X1 X2. intro H. elim (rem_2354 X1 X2 H).
   intro H. elim (rem_2334  H).
  intros X1 X2. intro H. elim (rem_2348 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2341 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2350 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2344 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2349  H).
   intro H. elim (rem_2353  H).
  intros X1. intro H. elim (rem_2332 X1 H).
   intro H. elim (rem_2340  H).
  intros X1 X2 X3. intro H. elim (rem_2337 X1 X2 X3 H).
   intro H. elim (rem_2339  H).
  intros X1 X2. intro H. elim (rem_2345 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2336 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2355 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2351 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2347 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2333 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2346 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2352 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2357 : (forall X:term, auto___def_87 X -> auto_knows_current X)
    -> forall X1:term, auto___def_88 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_87_pknows_current. exact (rem_2356).
Defined.

Remark rem_2358 : (forall X:term, auto___def_87 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_87_pknows_current. intros X1 X2.
  cut (auto___def_88 X1 -> auto_knows_current X1). tauto. exact (rem_2357 epsilon_m__def_87_pknows_current X1).
Defined.

Remark rem_2359 : (forall X:term, auto___def_89 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_89_pknows_current.  tauto.
Defined.

Remark rem_2360 : (forall X:term, auto___def_89 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_89_pknows_current.  case (rem_2359 epsilon_m__def_89_pknows_current). clear  epsilon_m__def_89_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__def_89_pknows_current. tauto.
Defined.

Remark rem_2361 : auto___def_89 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2362 : (forall X:term, auto___def_89 X -> auto_knows_current X)
    -> auto___def_89 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_89_pknows_current. intro H. intros.
  elim (rem_2361 H);  intros.
  apply (rem_2360 epsilon_m__def_89_pknows_current);  tauto.
Defined.

Remark rem_2363 : forall X1:term, auto___def_89 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2364 : forall X1 X2:term, auto___def_89 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2365 : auto___def_89 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2366 : forall X1 X2:term, auto___def_89 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2367 : forall X1 X2 X3:term, auto___def_89 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2368 : forall X1 X2:term, auto___def_89 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2369 : auto___def_89 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2370 : auto___def_89 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2371 : forall X1 X2:term, auto___def_89 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2372 : auto___def_89 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2373 : auto___def_89 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2374 : forall X1 X2 X3 X4 X5:term, auto___def_89 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2375 : forall X1 X2:term, auto___def_89 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2376 : forall X1 X2 X3 X4 X5:term, auto___def_89 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2377 : forall X1 X2:term, auto___def_89 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2378 : forall X1 X2:term, auto___def_89 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2379 : auto___def_89 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2380 : forall X1 X2 X3 X4 X5:term, auto___def_89 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2381 : forall X1 X2 X3 X4 X5:term, auto___def_89 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2382 : forall X1 X2 X3 X4 X5:term, auto___def_89 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2383 : forall X1 X2:term, auto___def_89 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2384 : auto___def_89 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2385 : forall X1 X2:term, auto___def_89 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2386 : forall X1 X2 X3 X4 X5:term, auto___def_89 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2387 : forall X2:term, auto___def_89 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_89_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2373  H).
   intro H. elim (rem_2372  H).
  intros X1 X2. intro H. elim (rem_2368 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2383 X1 X2 H).
   intro H. elim (rem_2365  H).
  intros X1 X2. intro H. elim (rem_2385 X1 X2 H).
  exact (rem_2362 epsilon_m__def_89_pknows_current ).
  intros X1 X2. intro H. elim (rem_2378 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2371 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2380 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2374 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2379  H).
   intro H. elim (rem_2384  H).
  intros X1. intro H. elim (rem_2363 X1 H).
   intro H. elim (rem_2370  H).
  intros X1 X2 X3. intro H. elim (rem_2367 X1 X2 X3 H).
   intro H. elim (rem_2369  H).
  intros X1 X2. intro H. elim (rem_2375 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2366 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2386 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2381 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2377 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2364 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2376 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2382 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2388 : (forall X:term, auto___def_87 X -> auto_knows_current X)
    -> forall X2:term, auto___def_89 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_87_pknows_current. exact (rem_2387).
Defined.

Remark rem_2389 : (forall X:term, auto___def_87 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_87_pknows_current. intros X1 X2.
  cut (auto___def_89 X2 -> auto_knows_current X2). tauto. exact (rem_2388 epsilon_m__def_87_pknows_current X2).
Defined.

Remark rem_2390 : (forall X:term, auto___def_87 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_87_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2358 epsilon_m__def_87_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2389 epsilon_m__def_87_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2391 : (forall X:term, auto___def_87 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_88 X1 -> auto___def_89 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_87_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2390 epsilon_m__def_87_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_87_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_87_pknows_current A1 A2. tauto.
Defined.

Remark rem_2392 : forall X1 X2:term, auto___def_87 (cons X1 X2) -> or_1
    (auto___def_88 X1 /\ auto___def_89 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2393 : (forall X:term, auto___def_87 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_87 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_87_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2392 X1 X2 H);  intros.
  apply (rem_2391 epsilon_m__def_87_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2394 : forall X1:term, auto___def_87 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2395 : forall X1 X2:term, auto___def_87 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2396 : auto___def_87 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2397 : auto___def_87 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2398 : forall X1 X2:term, auto___def_87 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2399 : forall X1 X2 X3:term, auto___def_87 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2400 : auto___def_87 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2401 : auto___def_87 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2402 : forall X1 X2:term, auto___def_87 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2403 : auto___def_87 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2404 : auto___def_87 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2405 : forall X1 X2 X3 X4 X5:term, auto___def_87 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2406 : forall X1 X2:term, auto___def_87 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2407 : forall X1 X2 X3 X4 X5:term, auto___def_87 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2408 : forall X1 X2:term, auto___def_87 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2409 : forall X1 X2:term, auto___def_87 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2410 : auto___def_87 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2411 : forall X1 X2 X3 X4 X5:term, auto___def_87 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2412 : forall X1 X2 X3 X4 X5:term, auto___def_87 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2413 : forall X1 X2 X3 X4 X5:term, auto___def_87 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2414 : forall X1 X2:term, auto___def_87 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2415 : auto___def_87 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2416 : forall X1 X2:term, auto___def_87 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2417 : forall X1 X2 X3 X4 X5:term, auto___def_87 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2418 : forall X2:term, auto___def_87 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_87_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2404  H).
   intro H. elim (rem_2403  H).
  intros X1 X2;  exact (rem_2393 epsilon_m__def_87_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2414 X1 X2 H).
   intro H. elim (rem_2397  H).
  intros X1 X2. intro H. elim (rem_2416 X1 X2 H).
   intro H. elim (rem_2396  H).
  intros X1 X2. intro H. elim (rem_2409 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2402 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2411 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2405 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2410  H).
   intro H. elim (rem_2415  H).
  intros X1. intro H. elim (rem_2394 X1 H).
   intro H. elim (rem_2401  H).
  intros X1 X2 X3. intro H. elim (rem_2399 X1 X2 X3 H).
   intro H. elim (rem_2400  H).
  intros X1 X2. intro H. elim (rem_2406 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2398 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2417 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2412 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2408 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2395 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2407 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2413 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2419 : forall X1 X2:term, auto___def_87 X2 -> auto___type_15 X1 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_87 X2 -> auto_knows_current X2). tauto. exact (rem_2418 X2).
Qed.

Remark rem_2420 : forall X1 X2:term, auto___def_87 X2 -> auto___type_15 X1 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2323 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2419 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2421 : forall X1 X2:term, auto___def_87 X2 -> auto___type_15 X1 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2420 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2422 : forall X1 X2:term, auto_knows_old (cons X2 X1) -> auto_knows_old X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_650 X2 X1 H);  intros.
  apply (rem_1797 X1 X2);  tauto.
Qed.

Remark rem_2423 : forall X1:term, auto_knows_current (s X1) -> or_1
    (auto_knows_current X1).
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2424 : forall X1:term, auto_knows_current (s X1) -> auto_knows_current X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_2423 X1 H);  intros.
  apply (rem_782 X1);  tauto.
Qed.

Remark rem_2425 : forall X2:term, auto_knows_current X2 -> auto_knows_current X2. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2426 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X2). tauto. exact (rem_2425 X2).
Qed.

Remark rem_2427 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2285 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2426 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2428 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2427 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_current_crypt_7;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2429 : auto_knows_current nil. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans_knows_current_nil_1;  tauto.
 tauto.
Qed.

Remark rem_2430 : auto_agent bob. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans_agent_bob_1;  tauto.
 tauto.
Qed.

Remark rem_2431 : forall X1 X2 X3 X4 X5:term, auto___def_49 X2 -> auto___def_50 X3 -> auto___type_10 X4 -> auto___type_11 X5 -> auto___type_9 X1 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5.
  tauto.
Qed.

Remark rem_2432 : forall X1 X2 X3 X4 X5:term, auto___def_49 X2 -> auto___def_50 X3 -> auto___type_10 X4 -> auto___type_11 X5 -> auto___type_9 X1 -> auto_bob_data_old X1 X2 X3 X4 X5. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5.
  case (rem_2431 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5). clear  A1 A2 A3 A4 A5. intros. apply trans_bob_data_old_1;  tauto.
 clear  A1 A2 A3 A4 A5. tauto.
Qed.

Remark rem_2433 : forall X1 X2 X3 X4 X5:term, auto___def_50 X3 -> auto___type_11 X5 -> auto___def_49 X2 -> auto___type_10 X4 -> auto___type_9 X1 -> auto_bob_data_old X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_49 X2 -> auto___def_50 X3 -> auto___type_10 X4 -> auto___type_11 X5 -> auto___type_9 X1 -> auto_bob_data_old X1 X2 X3 X4 X5). tauto. exact (rem_2432 X1 X2 X3 X4 X5).
Qed.

Remark rem_2434 : forall X1 X2:term, auto_knows_current (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2435 : (forall X:term, auto___def_94 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto_knows_current (ya_current X1 X2) -> auto_agent X1 -> auto___type_13 X1 -> auto_agent X2 -> auto___type_12 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_94_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_2434 X1 X2 H);  intros.
Defined.

Remark rem_2436 : forall X1 X2:term, auto___def_94 (ya_current X1 X2) -> or_1
    (auto_agent X1 /\ auto___type_13 X1 /\ auto_agent X2 /\ auto___type_12 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2437 : (forall X:term, auto___def_94 X -> auto_knows_current X -> False)
    -> forall X1 X2:term, auto___def_94 (ya_current X1 X2) -> auto_knows_current (ya_current X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_94_mknows_current. intros X1 X2. intro H. intros.
  elim (rem_2436 X1 X2 H);  intros.
  apply (rem_2435 epsilon_m__def_94_mknows_current X1 X2);  tauto.
Defined.

Remark rem_2438 : forall X1:term, auto___def_94 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2439 : forall X1 X2:term, auto___def_94 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2440 : auto___def_94 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2441 : auto___def_94 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2442 : forall X1 X2:term, auto___def_94 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2443 : forall X1 X2 X3:term, auto___def_94 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2444 : forall X1 X2:term, auto___def_94 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2445 : auto___def_94 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2446 : auto___def_94 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2447 : forall X1 X2:term, auto___def_94 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2448 : auto___def_94 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2449 : auto___def_94 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2450 : forall X1 X2 X3 X4 X5:term, auto___def_94 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2451 : forall X1 X2:term, auto___def_94 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2452 : forall X1 X2 X3 X4 X5:term, auto___def_94 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2453 : forall X1 X2:term, auto___def_94 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2454 : auto___def_94 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2455 : forall X1 X2 X3 X4 X5:term, auto___def_94 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2456 : forall X1 X2 X3 X4 X5:term, auto___def_94 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2457 : forall X1 X2 X3 X4 X5:term, auto___def_94 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2458 : forall X1 X2:term, auto___def_94 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2459 : auto___def_94 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2460 : forall X1 X2:term, auto___def_94 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2461 : forall X1 X2 X3 X4 X5:term, auto___def_94 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2462 : forall X1:term, auto___def_94 X1 -> auto_knows_current X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_94_mknows_current 1.
  intro X. case X.
   intro H. elim (rem_2449  H).
   intro H. elim (rem_2448  H).
  intros X1 X2. intro H. elim (rem_2444 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2458 X1 X2 H).
   intro H. elim (rem_2441  H).
  intros X1 X2. intro H. elim (rem_2460 X1 X2 H).
   intro H. elim (rem_2440  H).
  intros X1 X2. intro H. elim (rem_2453 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2447 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2455 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2450 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2454  H).
   intro H. elim (rem_2459  H).
  intros X1. intro H. elim (rem_2438 X1 H).
   intro H. elim (rem_2446  H).
  intros X1 X2 X3. intro H. elim (rem_2443 X1 X2 X3 H).
   intro H. elim (rem_2445  H).
  intros X1 X2. intro H. elim (rem_2451 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2442 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2461 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2456 X1 X2 X3 X4 X5 H).
  intros X1 X2;  exact (rem_2437 epsilon_m__def_94_mknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2439 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2452 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2457 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2463 : forall X1 X2 X3 X4:term, auto___def_93 X1 -> auto___def_94 X2 -> auto___type_15 alice -> auto___type_16 X3 -> auto___type_17 X4 -> auto_knows_current X2 -> False. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_2462 X2)). tauto.
Qed.

Remark rem_2464 : forall X1 X2 X3 X4:term, auto___type_15 alice -> auto___def_93 X1 -> auto___def_94 X2 -> auto___type_16 X3 -> auto___type_17 X4 -> auto_knows_current X2 -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_93 X1 -> auto___def_94 X2 -> auto___type_15 alice -> auto___type_16 X3 -> auto___type_17 X4 -> auto_knows_current X2 -> False). tauto. exact (rem_2463 X1 X2 X3 X4).
Qed.

Remark rem_2465 : forall X1 X2 X3 X4 X5:term, auto_alice_data_current X1 X2 X3 X4 X5 -> or_1
    (auto___type_15 X1 /\ auto___def_93 X2 /\ auto___def_94 X3 /\ auto___type_16 X4 /\ auto___type_17 X5)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2466 : forall X1 X2 X3 X4:term, auto_alice_data_current alice X1 X2 X3 X4 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_2465 alice X1 X2 X3 X4 H);  intros.
  apply (rem_2464 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2467 : forall X1 X2 X3 X4:term, auto_alice_data_current alice X1 X2 X3 X4 -> auto_knows_current X2 -> auto___query__intruder_knows_ya_as_seen_by_alice. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_alice_data_current alice X1 X2 X3 X4 -> auto_knows_current X2 -> False). tauto.
  exact (rem_2466 X1 X2 X3 X4).
Qed.

Remark rem_2468 : forall X1 X2 X3 X4:term, auto_alice_data_current alice X2 X1 X3 X4 -> auto_knows_current X1 -> auto___query__intruder_knows_ya_as_seen_by_alice. (* Prove equivalent, normalized clause. *)
Proof.
   intros X2 X1 X3 X4.
  cut (auto_alice_data_current alice X1 X2 X3 X4 -> auto_knows_current X2 -> auto___query__intruder_knows_ya_as_seen_by_alice). tauto. exact (rem_2467 X1 X2 X3 X4).
Qed.

Remark rem_2469 : auto___def_56 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2470 : (forall X:term, auto_agent X -> auto___def_56 X -> False)
    -> auto___def_56 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_56. intro H. intros.
  elim (rem_2469 H);  intros.
Defined.

Remark rem_2471 : (forall X:term, auto_agent X -> auto___def_56 X -> False)
    -> auto_agent i -> auto___def_56 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_56. intro H. intros.
  elim (rem_72 H);  intros.
  apply (rem_2470 epsilon_magent_m__def_56);  tauto.
Defined.

Remark rem_2472 : auto___def_56 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2473 : (forall X:term, auto_agent X -> auto___def_56 X -> False)
    -> auto___def_56 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_56. intro H. intros.
  elim (rem_2472 H);  intros.
Defined.

Remark rem_2474 : (forall X:term, auto_agent X -> auto___def_56 X -> False)
    -> auto_agent server -> auto___def_56 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_56. intro H. intros.
  elim (rem_75 H);  intros.
  apply (rem_2473 epsilon_magent_m__def_56);  tauto.
Defined.

Remark rem_2475 : auto___def_56 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2476 : (forall X:term, auto_agent X -> auto___def_56 X -> False)
    -> auto___def_56 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_56. intro H. intros.
  elim (rem_2475 H);  intros.
Defined.

Remark rem_2477 : (forall X:term, auto_agent X -> auto___def_56 X -> False)
    -> auto_agent bob -> auto___def_56 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_56. intro H. intros.
  elim (rem_78 H);  intros.
  apply (rem_2476 epsilon_magent_m__def_56);  tauto.
Defined.

Remark rem_2478 : auto___def_56 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2479 : (forall X:term, auto_agent X -> auto___def_56 X -> False)
    -> auto___def_56 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_56. intro H. intros.
  elim (rem_2478 H);  intros.
Defined.

Remark rem_2480 : (forall X:term, auto_agent X -> auto___def_56 X -> False)
    -> auto_agent alice -> auto___def_56 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_magent_m__def_56. intro H. intros.
  elim (rem_81 H);  intros.
  apply (rem_2479 epsilon_magent_m__def_56);  tauto.
Defined.

Remark rem_2481 : forall X1:term, auto_agent X1 -> auto___def_56 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_magent_m__def_56 1.
  intro X. case X.
  exact (rem_2480 epsilon_magent_m__def_56 ).
  exact (rem_2477 epsilon_magent_m__def_56 ).
  intros X1 X2. intro H. elim (rem_88 X1 X2 H).
  intros X1 X2. intro H. elim (rem_100 X1 X2 H).
  exact (rem_2471 epsilon_magent_m__def_56 ).
  intros X1 X2. intro H. elim (rem_102 X1 X2 H).
   intro H. elim (rem_85  H).
  intros X1 X2. intro H. elim (rem_95 X1 X2 H).
  intros X1 X2. intro H. elim (rem_90 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_97 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_91 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_96  H).
   intro H. elim (rem_101  H).
  intros X1. intro H. elim (rem_83 X1 H).
  exact (rem_2474 epsilon_magent_m__def_56 ).
  intros X1 X2 X3. intro H. elim (rem_87 X1 X2 X3 H).
   intro H. elim (rem_89  H).
  intros X1 X2. intro H. elim (rem_92 X1 X2 H).
  intros X1 X2. intro H. elim (rem_86 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_103 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_98 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_94 X1 X2 H).
  intros X1 X2. intro H. elim (rem_84 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_93 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_99 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2482 : forall X1 X2:term, auto___def_56 X2 -> auto___def_61 X1 -> auto_agent X2 -> auto_knows_current X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2481 X2)). tauto.
Qed.

Remark rem_2483 : forall X1 X2:term, auto_agent X2 -> auto___def_61 X1 -> auto___def_56 X2 -> auto_knows_current X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_56 X2 -> auto___def_61 X1 -> auto_agent X2 -> auto_knows_current X1). tauto. exact (rem_2482 X1 X2).
Qed.

Remark rem_2484 : forall X1:term, auto___def_56 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2485 : forall X1 X2:term, auto___def_56 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2486 : auto___def_56 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2487 : forall X1 X2:term, auto___def_56 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2488 : forall X1 X2 X3:term, auto___def_56 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2489 : forall X1 X2:term, auto___def_56 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2490 : auto___def_56 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2491 : forall X1 X2:term, auto___def_56 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2492 : forall X1 X2 X3 X4 X5:term, auto___def_56 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2493 : forall X1 X2:term, auto___def_56 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2494 : forall X1 X2 X3 X4 X5:term, auto___def_56 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2495 : forall X1 X2:term, auto___def_56 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2496 : forall X1 X2:term, auto___def_56 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2497 : auto___def_56 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2498 : forall X1 X2 X3 X4 X5:term, auto___def_56 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2499 : forall X1 X2 X3 X4 X5:term, auto___def_56 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2500 : forall X1 X2 X3 X4 X5:term, auto___def_56 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2501 : forall X1 X2:term, auto___def_56 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2502 : auto___def_56 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2503 : forall X1 X2:term, auto___def_56 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2504 : forall X1 X2 X3 X4 X5:term, auto___def_56 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2505 : forall X1:term, auto___def_56 X1 -> auto___type_15 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_56_m__type_15 1.
  intro X. case X.
   intro H. elim (rem_2478  H).
   intro H. elim (rem_2475  H).
  intros X1 X2. intro H. elim (rem_2489 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2501 X1 X2 H).
   intro H. elim (rem_2469  H).
  intros X1 X2. intro H. elim (rem_2503 X1 X2 H).
   intro H. elim (rem_2486  H).
  intros X1 X2. intro H. elim (rem_2496 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2491 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2498 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2492 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2497  H).
   intro H. elim (rem_2502  H).
  intros X1. intro H. elim (rem_2484 X1 H).
   intro H. elim (rem_2472  H).
  intros X1 X2 X3. intro H. elim (rem_2488 X1 X2 X3 H).
   intro H. elim (rem_2490  H).
  intros X1 X2. intro H. elim (rem_2493 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2487 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2504 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2499 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2495 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2485 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2494 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2500 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2506 : forall X1 X2:term, auto___def_56 X2 -> auto___def_90 X1 -> auto___type_15 X2 -> auto_knows_current X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2505 X2)). tauto.
Qed.

Remark rem_2507 : forall X1 X2:term, auto___type_15 X2 -> auto___def_90 X1 -> auto___def_56 X2 -> auto_knows_current X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_56 X2 -> auto___def_90 X1 -> auto___type_15 X2 -> auto_knows_current X1). tauto. exact (rem_2506 X1 X2).
Qed.

Remark rem_2508 : forall X1:term, auto___def_56 X1 -> auto___type_12 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_56_m__type_12 1.
  intro X. case X.
   intro H. elim (rem_2478  H).
   intro H. elim (rem_2475  H).
  intros X1 X2. intro H. elim (rem_2489 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2501 X1 X2 H).
   intro H. elim (rem_2469  H).
  intros X1 X2. intro H. elim (rem_2503 X1 X2 H).
   intro H. elim (rem_2486  H).
  intros X1 X2. intro H. elim (rem_2496 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2491 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2498 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2492 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2497  H).
   intro H. elim (rem_2502  H).
  intros X1. intro H. elim (rem_2484 X1 H).
   intro H. elim (rem_2472  H).
  intros X1 X2 X3. intro H. elim (rem_2488 X1 X2 X3 H).
   intro H. elim (rem_2490  H).
  intros X1 X2. intro H. elim (rem_2493 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2487 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2504 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2499 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2495 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2485 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2494 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2500 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2509 : forall X1 X2:term, auto___def_56 X2 -> auto___def_73 X1 -> auto___type_12 X2 -> auto_knows_current X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2508 X2)). tauto.
Qed.

Remark rem_2510 : forall X1 X2:term, auto___type_12 X2 -> auto___def_73 X1 -> auto___def_56 X2 -> auto_knows_current X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_56 X2 -> auto___def_73 X1 -> auto___type_12 X2 -> auto_knows_current X1). tauto. exact (rem_2509 X1 X2).
Qed.

Remark rem_2511 : (forall X:term, auto___def_43 X -> auto_knows_current X)
    -> forall X1:term, auto_agent X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_43_pknows_current. exact (rem_720).
Defined.

Remark rem_2512 : (forall X:term, auto___def_43 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto___type_3 X1 -> auto___def_28 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_43_pknows_current. intros X1 X2.
  cut (auto_agent X1 -> auto_knows_current X1). tauto. exact (rem_2511 epsilon_m__def_43_pknows_current X1).
Defined.

Remark rem_2513 : (forall X:term, auto___def_28 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_28_pknows_current. intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  tauto.
Defined.

Remark rem_2514 : (forall X:term, auto___def_28 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4 X5:term, auto_agent X1 -> auto___type_1 X1 -> auto_agent X2 -> auto___type_2 X2 -> auto___def_12 X3 -> auto___def_15 X4 -> auto___def_18 X5 -> auto_knows_current (nonceb_old X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_28_pknows_current. intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5 A6 A7.
  case (rem_2513 epsilon_m__def_28_pknows_current X1 X2 X3 X4 X5 A1 A2 A3 A4 A5 A6 A7). clear  epsilon_m__def_28_pknows_current A1 A2 A3 A4 A5 A6 A7. intros. apply trans_knows_current_nonceb_old_1;  tauto.
 clear  epsilon_m__def_28_pknows_current A1 A2 A3 A4 A5 A6 A7. tauto.
Defined.

Remark rem_2515 : forall X1 X2 X3 X4 X5:term, auto___def_28 (nonceb_old X1 X2 X3 X4 X5) -> or_1
    (auto_agent X1 /\ auto___type_1 X1 /\ auto_agent X2 /\ auto___type_2 X2 /\ auto___def_12 X3 /\ auto___def_15 X4 /\ auto___def_18 X5)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2516 : (forall X:term, auto___def_28 X -> auto_knows_current X)
    -> forall X1 X2 X3 X4 X5:term, auto___def_28 (nonceb_old X1 X2 X3 X4 X5) -> auto_knows_current (nonceb_old X1 X2 X3 X4 X5). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_28_pknows_current. intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_2515 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_2514 epsilon_m__def_28_pknows_current X1 X2 X3 X4 X5);  tauto.
Defined.

Remark rem_2517 : forall X1:term, auto___def_28 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2518 : forall X1 X2:term, auto___def_28 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2519 : auto___def_28 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2520 : auto___def_28 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2521 : forall X1 X2:term, auto___def_28 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2522 : forall X1 X2 X3:term, auto___def_28 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2523 : auto___def_28 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2524 : auto___def_28 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2525 : forall X1 X2:term, auto___def_28 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2526 : auto___def_28 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2527 : auto___def_28 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2528 : forall X1 X2:term, auto___def_28 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2529 : forall X1 X2 X3 X4 X5:term, auto___def_28 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2530 : forall X1 X2:term, auto___def_28 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2531 : forall X1 X2:term, auto___def_28 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2532 : auto___def_28 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2533 : forall X1 X2 X3 X4 X5:term, auto___def_28 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2534 : forall X1 X2 X3 X4 X5:term, auto___def_28 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2535 : forall X1 X2 X3 X4 X5:term, auto___def_28 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2536 : forall X1 X2:term, auto___def_28 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2537 : auto___def_28 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2538 : forall X1 X2:term, auto___def_28 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2539 : forall X1 X2 X3 X4 X5:term, auto___def_28 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2540 : forall X2:term, auto___def_28 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_28_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2527  H).
   intro H. elim (rem_2526  H).
  intros X1 X2. intro H. elim (rem_245 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2536 X1 X2 H).
   intro H. elim (rem_2520  H).
  intros X1 X2. intro H. elim (rem_2538 X1 X2 H).
   intro H. elim (rem_2519  H).
  intros X1 X2. intro H. elim (rem_2531 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2525 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2533 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5;  exact (rem_2516 epsilon_m__def_28_pknows_current X1 X2 X3 X4 X5).
   intro H. elim (rem_2532  H).
   intro H. elim (rem_2537  H).
  intros X1. intro H. elim (rem_2517 X1 H).
   intro H. elim (rem_2524  H).
  intros X1 X2 X3. intro H. elim (rem_2522 X1 X2 X3 H).
   intro H. elim (rem_2523  H).
  intros X1 X2. intro H. elim (rem_2528 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2521 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2539 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2534 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2530 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2518 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2529 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2535 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2541 : (forall X:term, auto___def_43 X -> auto_knows_current X)
    -> forall X2:term, auto___def_28 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_43_pknows_current. exact (rem_2540).
Defined.

Remark rem_2542 : (forall X:term, auto___def_43 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto___type_3 X1 -> auto___def_28 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_43_pknows_current. intros X1 X2.
  cut (auto___def_28 X2 -> auto_knows_current X2). tauto. exact (rem_2541 epsilon_m__def_43_pknows_current X2).
Defined.

Remark rem_2543 : (forall X:term, auto___def_43 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto___type_3 X1 -> auto___def_28 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_43_pknows_current. intros X1 X2. intros A1 A2 A3.
  cut (auto_knows_current X1). 2:apply (rem_2512 epsilon_m__def_43_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2542 epsilon_m__def_43_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2544 : (forall X:term, auto___def_43 X -> auto_knows_current X)
    -> forall X1 X2:term, auto_agent X1 -> auto___type_3 X1 -> auto___def_28 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_43_pknows_current. intros X1 X2. intros A1 A2 A3.
  case (rem_2543 epsilon_m__def_43_pknows_current X1 X2 A1 A2 A3). clear  epsilon_m__def_43_pknows_current A1 A2 A3. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_43_pknows_current A1 A2 A3. tauto.
Defined.

Remark rem_2545 : (forall X:term, auto___def_43 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_43 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_43_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_248 X1 X2 H);  intros.
  apply (rem_2544 epsilon_m__def_43_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2546 : forall X1:term, auto___def_43 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2547 : forall X1 X2:term, auto___def_43 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2548 : auto___def_43 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2549 : auto___def_43 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2550 : forall X1 X2:term, auto___def_43 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2551 : forall X1 X2 X3:term, auto___def_43 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2552 : auto___def_43 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2553 : auto___def_43 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2554 : forall X1 X2:term, auto___def_43 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2555 : auto___def_43 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2556 : auto___def_43 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2557 : forall X1 X2 X3 X4 X5:term, auto___def_43 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2558 : forall X1 X2:term, auto___def_43 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2559 : forall X1 X2 X3 X4 X5:term, auto___def_43 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2560 : forall X1 X2:term, auto___def_43 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2561 : forall X1 X2:term, auto___def_43 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2562 : auto___def_43 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2563 : forall X1 X2 X3 X4 X5:term, auto___def_43 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2564 : forall X1 X2 X3 X4 X5:term, auto___def_43 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2565 : forall X1 X2 X3 X4 X5:term, auto___def_43 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2566 : forall X1 X2:term, auto___def_43 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2567 : auto___def_43 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2568 : forall X1 X2:term, auto___def_43 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2569 : forall X1 X2 X3 X4 X5:term, auto___def_43 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2570 : forall X1:term, auto___def_43 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_43_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2556  H).
   intro H. elim (rem_2555  H).
  intros X1 X2;  exact (rem_2545 epsilon_m__def_43_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2566 X1 X2 H).
   intro H. elim (rem_2549  H).
  intros X1 X2. intro H. elim (rem_2568 X1 X2 H).
   intro H. elim (rem_2548  H).
  intros X1 X2. intro H. elim (rem_2561 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2554 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2563 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2557 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2562  H).
   intro H. elim (rem_2567  H).
  intros X1. intro H. elim (rem_2546 X1 H).
   intro H. elim (rem_2553  H).
  intros X1 X2 X3. intro H. elim (rem_2551 X1 X2 X3 H).
   intro H. elim (rem_2552  H).
  intros X1 X2. intro H. elim (rem_2558 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2550 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2569 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2564 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2560 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2547 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2559 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2565 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2571 : forall X1 X2:term, auto___def_43 X1 -> auto___def_56 X2 -> auto___type_6 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_43 X1 -> auto_knows_current X1). tauto. exact (rem_2570 X1).
Qed.

Remark rem_2572 : forall X1 X2:term, auto___type_6 X2 -> auto___def_43 X1 -> auto___def_56 X2 -> auto_knows_current X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_43 X1 -> auto___def_56 X2 -> auto___type_6 X2 -> auto_knows_current X1). tauto. exact (rem_2571 X1 X2).
Qed.

Remark rem_2573 : forall X1 X2:term, auto___def_10 X1 -> auto___def_56 X2 -> auto_agent X2 -> auto_knows_current X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2481 X2)). tauto.
Qed.

Remark rem_2574 : forall X1 X2:term, auto_agent X2 -> auto___def_10 X1 -> auto___def_56 X2 -> auto_knows_current X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_56 X2 -> auto_agent X2 -> auto_knows_current X1). tauto. exact (rem_2573 X1 X2).
Qed.

Remark rem_2575 : forall X1:term, auto___def_56 X1 -> auto___type_3 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_56_m__type_3 1.
  intro X. case X.
   intro H. elim (rem_2478  H).
   intro H. elim (rem_2475  H).
  intros X1 X2. intro H. elim (rem_2489 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2501 X1 X2 H).
   intro H. elim (rem_2469  H).
  intros X1 X2. intro H. elim (rem_2503 X1 X2 H).
   intro H. elim (rem_2486  H).
  intros X1 X2. intro H. elim (rem_2496 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2491 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2498 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2492 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2497  H).
   intro H. elim (rem_2502  H).
  intros X1. intro H. elim (rem_2484 X1 H).
   intro H. elim (rem_2472  H).
  intros X1 X2 X3. intro H. elim (rem_2488 X1 X2 X3 H).
   intro H. elim (rem_2490  H).
  intros X1 X2. intro H. elim (rem_2493 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2487 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2504 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2499 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2495 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2485 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2494 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2500 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2576 : forall X1 X2:term, auto___def_26 X1 -> auto___def_56 X2 -> auto___type_3 X2 -> auto_knows_current X1. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2. intros.
  assert (HH:=(rem_2575 X2)). tauto.
Qed.

Remark rem_2577 : forall X1 X2:term, auto___type_3 X2 -> auto___def_26 X1 -> auto___def_56 X2 -> auto_knows_current X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_26 X1 -> auto___def_56 X2 -> auto___type_3 X2 -> auto_knows_current X1). tauto. exact (rem_2576 X1 X2).
Qed.

Inductive or_6(H1 H2 H3 H4 H5 H6:Prop) : Prop :=
    or_6_intro_1 : H1 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_2 : H2 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_3 : H3 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_4 : H4 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_5 : H5 -> (or_6 H1 H2 H3 H4 H5 H6)
  | or_6_intro_6 : H6 -> (or_6 H1 H2 H3 H4 H5 H6)
.

Remark rem_2578 : forall X1 X2:term, auto___def_55 X1 X2 -> or_6
    (auto_agent X1 /\ auto___def_61 X2)
    (auto___type_15 X1 /\ auto___def_90 X2)
    (auto___type_12 X1 /\ auto___def_73 X2)
    (auto___type_6 X1 /\ auto___def_43 X2)
    (auto_agent X1 /\ auto___def_10 X2)
    (auto___type_3 X1 /\ auto___def_26 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_6_intro_1; tauto.
  intros. apply or_6_intro_2; tauto.
  intros. apply or_6_intro_3; tauto.
  intros. apply or_6_intro_4; tauto.
  intros. apply or_6_intro_5; tauto.
  intros. apply or_6_intro_6; tauto.
Qed.

Remark rem_2579 : forall X1 X2:term, auto___def_55 X2 X1 -> auto___def_56 X2 -> auto_knows_current X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2578 X2 X1 H);  intros.
  apply (rem_2483 X1 X2);  tauto.
  apply (rem_2507 X1 X2);  tauto.
  apply (rem_2510 X1 X2);  tauto.
  apply (rem_2572 X1 X2);  tauto.
  apply (rem_2574 X1 X2);  tauto.
  apply (rem_2577 X1 X2);  tauto.
Qed.

Remark rem_2580 : auto_agent alice. (* Deduce positive atom. *)
Proof.
   case rem_10. intros. apply trans_agent_alice_1;  tauto.
 tauto.
Qed.

Remark rem_2581 : forall X1:term, auto___def_96 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2582 : forall X1 X2:term, auto___def_96 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2583 : auto___def_96 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2584 : auto___def_96 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2585 : forall X1 X2:term, auto___def_96 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2586 : forall X1 X2 X3:term, auto___def_96 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2587 : forall X1 X2:term, auto___def_96 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2588 : auto___def_96 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2589 : auto___def_96 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2590 : forall X1 X2:term, auto___def_96 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2591 : auto___def_96 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2592 : auto___def_96 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2593 : forall X1 X2 X3 X4 X5:term, auto___def_96 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2594 : forall X1 X2:term, auto___def_96 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2595 : forall X1 X2 X3 X4 X5:term, auto___def_96 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2596 : forall X1 X2:term, auto___def_96 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2597 : forall X1 X2:term, auto___def_96 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2598 : auto___def_96 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2599 : forall X1 X2 X3 X4 X5:term, auto___def_96 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2600 : forall X1 X2 X3 X4 X5:term, auto___def_96 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2601 : forall X1 X2 X3 X4 X5:term, auto___def_96 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2602 : forall X1 X2:term, auto___def_96 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2603 : auto___def_96 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2604 : forall X1 X2:term, auto___def_96 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2605 : forall X1 X2 X3 X4 X5:term, auto___def_96 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2606 : forall X1:term, auto___def_96 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_m__def_96 1.
  intro X. case X.
   intro H. elim (rem_2592  H).
   intro H. elim (rem_2591  H).
  intros X1 X2. intro H. elim (rem_2587 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2602 X1 X2 H).
   intro H. elim (rem_2584  H).
  intros X1 X2. intro H. elim (rem_2604 X1 X2 H).
   intro H. elim (rem_2583  H).
  intros X1 X2. intro H. elim (rem_2597 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2590 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2599 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2593 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2598  H).
   intro H. elim (rem_2603  H).
  intros X1. intro H. elim (rem_2581 X1 H).
   intro H. elim (rem_2589  H).
  intros X1 X2 X3. intro H. elim (rem_2586 X1 X2 X3 H).
   intro H. elim (rem_2588  H).
  intros X1 X2. intro H. elim (rem_2594 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2585 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2605 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2600 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2596 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2582 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2595 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2601 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2607 : forall X1:term, auto___def_96 X1 -> False. (* Split. *)
Proof.
  intros X1.
  cut (auto___def_96 X1 -> False). tauto.
  exact (rem_2606 X1).
Qed.

Remark rem_2608 : forall X1 X2 X3 X4 X5:term, auto___def_96 X1 -> auto___def_97 X2 -> auto___type_18 X3 -> auto___type_19 X4 -> auto___type_20 X5 -> False. (* Split. *)
Proof.
  intros X1 X2 X3 X4 X5.
  cut (auto___def_96 X1 -> False). tauto.
  exact (rem_2607 X1).
Qed.

Remark rem_2609 : forall X1 X2 X3 X4 X5:term, auto___def_96 X2 -> auto___def_97 X3 -> auto___type_18 X1 -> auto___type_19 X4 -> auto___type_20 X5 -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X3 X1 X2 X4 X5.
  cut (auto___def_96 X1 -> auto___def_97 X2 -> auto___type_18 X3 -> auto___type_19 X4 -> auto___type_20 X5 -> False). tauto. exact (rem_2608 X1 X2 X3 X4 X5).
Qed.

Remark rem_2610 : forall X1 X2 X3 X4 X5:term, auto___def_96 X2 -> auto___def_97 X3 -> auto___type_18 X1 -> auto___type_19 X4 -> auto___type_20 X5 -> auto_bob_data_current X1 X2 X3 X4 X5. (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5. intros A1 A2 A3 A4 A5.
  cut (False). tauto.
  exact (rem_2609 X1 X2 X3 X4 X5 A1 A2 A3 A4 A5).
Qed.

Remark rem_2611 : forall X1 X2 X3 X4 X5:term, auto___def_97 X3 -> auto___type_20 X5 -> auto___def_96 X2 -> auto___type_19 X4 -> auto___type_18 X1 -> auto_bob_data_current X1 X2 X3 X4 X5. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4 X5.
  cut (auto___def_96 X2 -> auto___def_97 X3 -> auto___type_18 X1 -> auto___type_19 X4 -> auto___type_20 X5 -> auto_bob_data_current X1 X2 X3 X4 X5). tauto. exact (rem_2610 X1 X2 X3 X4 X5).
Qed.

Remark rem_2612 : forall X1 X2:term, auto_knows_current (xa_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2.  case (rem_10). intros. apply trans_knows_current_xa_old_1;  tauto.
 tauto.
Qed.

Remark rem_2613 : forall X1:term, auto_knows_current X1 -> auto_knows_current X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1. intros A1.
  cut (auto_knows_current X1). 2:apply (rem_782 X1);  assumption.
  tauto.
Qed.

Remark rem_2614 : forall X1:term, auto_knows_current X1 -> auto_knows_current (s X1). (* Deduce positive atom. *)
Proof.
  intros X1. intros A1.
  case (rem_2613 X1 A1). clear  A1. intros. apply trans_knows_current_s_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_2615 : forall X1:term, auto_knows_old (s X1) -> auto_knows_old X1. (* Eliminate negative atom. *)
Proof.
  intros X1. intro H. intros.
  elim (rem_1803 X1 H);  intros.
  apply (rem_1796 X1);  tauto.
Qed.

Remark rem_2616 : forall X1:term, auto_knows_old X1 -> auto_knows_old X1 \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1. intros A1.
  cut (auto_knows_old X1). 2:apply (rem_1796 X1);  assumption.
  tauto.
Qed.

Remark rem_2617 : forall X1:term, auto_knows_old X1 -> auto_knows_old (s X1). (* Deduce positive atom. *)
Proof.
  intros X1. intros A1.
  case (rem_2616 X1 A1). clear  A1. intros. apply trans_knows_old_s_1;  tauto.
 clear  A1. tauto.
Qed.

Remark rem_2618 : forall X1 X2:term, auto_knows_current X1 -> auto_knows_current X2 -> auto_knows_current X1. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current X1). tauto. exact (rem_2285 X1 X2).
Qed.

Remark rem_2619 : forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto_knows_current X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_350 X1 X2 H);  intros.
  apply (rem_2618 X1 X2);  tauto.
Qed.

Remark rem_2620 : forall X1:term, auto___def_51 X1 -> auto___def_51 X1. (* Tautology. *)
Proof. tauto. Qed.

Remark rem_2621 : forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___def_51 X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_51 X1). tauto. exact (rem_2620 X1).
Qed.

Remark rem_2622 : forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto___def_52 X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_52 X2 -> auto___def_52 X2). tauto. exact (rem_784 X2).
Qed.

Remark rem_2623 : forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> (auto___def_51 X1 /\ auto___def_52 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto___def_51 X1). 2:apply (rem_2621 X1 X2);  assumption.
  cut (auto___def_52 X2). 2:apply (rem_2622 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2624 : forall X1 X2:term, auto___def_51 X1 -> auto___def_52 X2 -> auto_knows_current (key X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2623 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_current_key_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2625 : forall X1 X2:term, auto___def_52 X2 -> auto___def_51 X1 -> auto_knows_current (key X1 X2). (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2.
  cut (auto___def_51 X1 -> auto___def_52 X2 -> auto_knows_current (key X1 X2)). tauto. exact (rem_2624 X1 X2).
Qed.

Remark rem_2626 : forall X1 X2:term, auto___def_53 X1 X2 -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2627 : forall X1 X2:term, auto___def_53 X2 X1 -> auto___def_54 X2 -> auto_knows_current X1. (* Eliminate negative atom. *)
Proof.
  intros X1 X2. intro H. intros.
  elim (rem_2626 X2 X1 H);  intros.
Qed.

Remark rem_2628 : forall X1 X2 X3 X4 X5:term, auto_knows_current (xb_old X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5.  case (rem_10). intros. apply trans_knows_current_xb_old_1;  tauto.
 tauto.
Qed.

Remark rem_2629 : (forall X:term, auto___type_1 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_1_pknows_old.  tauto.
Defined.

Remark rem_2630 : (forall X:term, auto___type_1 X -> auto_knows_old X)
    -> auto_knows_old i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows_old.  case (rem_2629 epsilon_m__type_1_pknows_old). clear  epsilon_m__type_1_pknows_old. intros. apply trans_knows_old_i_1;  tauto.
 clear  epsilon_m__type_1_pknows_old. tauto.
Defined.

Remark rem_2631 : (forall X:term, auto___type_1 X -> auto_knows_old X)
    -> auto___type_1 i -> auto_knows_old i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows_old. intro H. intros.
  elim (rem_396 H);  intros.
  apply (rem_2630 epsilon_m__type_1_pknows_old);  tauto.
Defined.

Remark rem_2632 : (forall X:term, auto___type_1 X -> auto_knows_old X)
    -> auto_knows_old server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows_old.  case (rem_2629 epsilon_m__type_1_pknows_old). clear  epsilon_m__type_1_pknows_old. intros. apply trans_knows_old_server_1;  tauto.
 clear  epsilon_m__type_1_pknows_old. tauto.
Defined.

Remark rem_2633 : (forall X:term, auto___type_1 X -> auto_knows_old X)
    -> auto___type_1 server -> auto_knows_old server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows_old. intro H. intros.
  elim (rem_399 H);  intros.
  apply (rem_2632 epsilon_m__type_1_pknows_old);  tauto.
Defined.

Remark rem_2634 : (forall X:term, auto___type_1 X -> auto_knows_old X)
    -> auto_knows_old bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows_old.  case (rem_2629 epsilon_m__type_1_pknows_old). clear  epsilon_m__type_1_pknows_old. intros. apply trans_knows_old_bob_1;  tauto.
 clear  epsilon_m__type_1_pknows_old. tauto.
Defined.

Remark rem_2635 : (forall X:term, auto___type_1 X -> auto_knows_old X)
    -> auto___type_1 bob -> auto_knows_old bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows_old. intro H. intros.
  elim (rem_402 H);  intros.
  apply (rem_2634 epsilon_m__type_1_pknows_old);  tauto.
Defined.

Remark rem_2636 : (forall X:term, auto___type_1 X -> auto_knows_old X)
    -> auto_knows_old alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_1_pknows_old.  case (rem_2629 epsilon_m__type_1_pknows_old). clear  epsilon_m__type_1_pknows_old. intros. apply trans_knows_old_alice_1;  tauto.
 clear  epsilon_m__type_1_pknows_old. tauto.
Defined.

Remark rem_2637 : (forall X:term, auto___type_1 X -> auto_knows_old X)
    -> auto___type_1 alice -> auto_knows_old alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_1_pknows_old. intro H. intros.
  elim (rem_405 H);  intros.
  apply (rem_2636 epsilon_m__type_1_pknows_old);  tauto.
Defined.

Remark rem_2638 : forall X1:term, auto___type_1 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__type_1_pknows_old 1.
  intro X. case X.
  exact (rem_2637 epsilon_m__type_1_pknows_old ).
  exact (rem_2635 epsilon_m__type_1_pknows_old ).
  intros X1 X2. intro H. elim (rem_412 X1 X2 H).
  intros X1 X2. intro H. elim (rem_424 X1 X2 H).
  exact (rem_2631 epsilon_m__type_1_pknows_old ).
  intros X1 X2. intro H. elim (rem_426 X1 X2 H).
   intro H. elim (rem_409  H).
  intros X1 X2. intro H. elim (rem_419 X1 X2 H).
  intros X1 X2. intro H. elim (rem_414 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_421 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_415 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_420  H).
   intro H. elim (rem_425  H).
  intros X1. intro H. elim (rem_407 X1 H).
  exact (rem_2633 epsilon_m__type_1_pknows_old ).
  intros X1 X2 X3. intro H. elim (rem_411 X1 X2 X3 H).
   intro H. elim (rem_413  H).
  intros X1 X2. intro H. elim (rem_416 X1 X2 H).
  intros X1 X2. intro H. elim (rem_410 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_427 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_422 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_418 X1 X2 H).
  intros X1 X2. intro H. elim (rem_408 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_417 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_423 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2639 : forall X1 X2:term, auto___def_7 X2 -> auto___type_1 X1 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_1 X1 -> auto_knows_old X1). tauto. exact (rem_2638 X1).
Qed.

Remark rem_2640 : (forall X:term, auto___def_8 X -> auto_knows_old X)
    -> forall X1:term, auto___def_10 X1 -> auto___def_10 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2641 : (forall X:term, auto___def_8 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_10 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_8_pknows_old. intros X1 X2.
  cut (auto___def_10 X1 -> auto___def_10 X1). tauto. exact (rem_2640 epsilon_m__def_8_pknows_old X1).
Defined.

Remark rem_2642 : (forall X:term, auto___def_8 X -> auto_knows_old X)
    -> forall X2:term, auto___def_11 X2 -> auto___def_11 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2643 : (forall X:term, auto___def_8 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto___def_11 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_8_pknows_old. intros X1 X2.
  cut (auto___def_11 X2 -> auto___def_11 X2). tauto. exact (rem_2642 epsilon_m__def_8_pknows_old X2).
Defined.

Remark rem_2644 : (forall X:term, auto___def_8 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> (auto___def_10 X1 /\ auto___def_11 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_8_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto___def_10 X1). 2:apply (rem_2641 epsilon_m__def_8_pknows_old X1 X2);  assumption.
  cut (auto___def_11 X2). 2:apply (rem_2643 epsilon_m__def_8_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2645 : (forall X:term, auto___def_8 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_10 X1 -> auto___def_11 X2 -> auto_knows_old (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_8_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2644 epsilon_m__def_8_pknows_old X1 X2 A1 A2). clear  epsilon_m__def_8_pknows_old A1 A2. intros. apply trans_knows_old_crypt_3;  tauto.
 clear  epsilon_m__def_8_pknows_old A1 A2. tauto.
Defined.

Remark rem_2646 : forall X1 X2:term, auto___def_8 (crypt X1 X2) -> or_1
    (auto___def_10 X1 /\ auto___def_11 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2647 : (forall X:term, auto___def_8 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_8 (crypt X1 X2) -> auto_knows_old (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_8_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_2646 X1 X2 H);  intros.
  apply (rem_2645 epsilon_m__def_8_pknows_old X1 X2);  tauto.
Defined.

Remark rem_2648 : forall X1:term, auto___def_8 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2649 : forall X1 X2:term, auto___def_8 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2650 : auto___def_8 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2651 : auto___def_8 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2652 : forall X1 X2:term, auto___def_8 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2653 : forall X1 X2 X3:term, auto___def_8 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2654 : forall X1 X2:term, auto___def_8 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2655 : auto___def_8 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2656 : auto___def_8 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2657 : forall X1 X2:term, auto___def_8 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2658 : auto___def_8 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2659 : auto___def_8 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2660 : forall X1 X2 X3 X4 X5:term, auto___def_8 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2661 : forall X1 X2:term, auto___def_8 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2662 : forall X1 X2 X3 X4 X5:term, auto___def_8 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2663 : forall X1 X2:term, auto___def_8 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2664 : forall X1 X2:term, auto___def_8 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2665 : auto___def_8 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2666 : forall X1 X2 X3 X4 X5:term, auto___def_8 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2667 : forall X1 X2 X3 X4 X5:term, auto___def_8 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2668 : forall X1 X2 X3 X4 X5:term, auto___def_8 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2669 : auto___def_8 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2670 : forall X1 X2:term, auto___def_8 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2671 : forall X1 X2 X3 X4 X5:term, auto___def_8 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2672 : forall X1:term, auto___def_8 X1 -> auto_knows_old X1. (* Induct. *)
Proof.
  fix epsilon_m__def_8_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_2659  H).
   intro H. elim (rem_2658  H).
  intros X1 X2. intro H. elim (rem_2654 X1 X2 H).
  intros X1 X2;  exact (rem_2647 epsilon_m__def_8_pknows_old X1 X2).
   intro H. elim (rem_2651  H).
  intros X1 X2. intro H. elim (rem_2670 X1 X2 H).
   intro H. elim (rem_2650  H).
  intros X1 X2. intro H. elim (rem_2664 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2657 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2666 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2660 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2665  H).
   intro H. elim (rem_2669  H).
  intros X1. intro H. elim (rem_2648 X1 H).
   intro H. elim (rem_2656  H).
  intros X1 X2 X3. intro H. elim (rem_2653 X1 X2 X3 H).
   intro H. elim (rem_2655  H).
  intros X1 X2. intro H. elim (rem_2661 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2652 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2671 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2667 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2663 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2649 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2662 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2668 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2673 : (forall X:term, auto___def_7 X -> auto_knows_old X)
    -> forall X1:term, auto___def_8 X1 -> auto_knows_old X1. (* Cut history. *)
Proof.  intros epsilon_m__def_7_pknows_old. exact (rem_2672).
Defined.

Remark rem_2674 : (forall X:term, auto___def_7 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> auto_knows_old X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_7_pknows_old. intros X1 X2.
  cut (auto___def_8 X1 -> auto_knows_old X1). tauto. exact (rem_2673 epsilon_m__def_7_pknows_old X1).
Defined.

Remark rem_2675 : (forall X:term, auto___def_9 X -> auto_knows_old X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_9_pknows_old.  tauto.
Defined.

Remark rem_2676 : (forall X:term, auto___def_9 X -> auto_knows_old X)
    -> auto_knows_old nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_9_pknows_old.  case (rem_2675 epsilon_m__def_9_pknows_old). clear  epsilon_m__def_9_pknows_old. intros. apply trans_knows_old_nil_1;  tauto.
 clear  epsilon_m__def_9_pknows_old. tauto.
Defined.

Remark rem_2677 : (forall X:term, auto___def_9 X -> auto_knows_old X)
    -> auto___def_9 nil -> auto_knows_old nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_9_pknows_old. intro H. intros.
  elim (rem_2161 H);  intros.
  apply (rem_2676 epsilon_m__def_9_pknows_old);  tauto.
Defined.

Remark rem_2678 : forall X2:term, auto___def_9 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_9_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_2173  H).
   intro H. elim (rem_2172  H).
  intros X1 X2. intro H. elim (rem_2168 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2183 X1 X2 H).
   intro H. elim (rem_2165  H).
  intros X1 X2. intro H. elim (rem_2185 X1 X2 H).
  exact (rem_2677 epsilon_m__def_9_pknows_old ).
  intros X1 X2. intro H. elim (rem_2178 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2171 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2180 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2174 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2179  H).
   intro H. elim (rem_2184  H).
  intros X1. intro H. elim (rem_2163 X1 H).
   intro H. elim (rem_2170  H).
  intros X1 X2 X3. intro H. elim (rem_2167 X1 X2 X3 H).
   intro H. elim (rem_2169  H).
  intros X1 X2. intro H. elim (rem_2175 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2166 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2186 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2181 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2177 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2164 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2176 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2182 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2679 : (forall X:term, auto___def_7 X -> auto_knows_old X)
    -> forall X2:term, auto___def_9 X2 -> auto_knows_old X2. (* Cut history. *)
Proof.  intros epsilon_m__def_7_pknows_old. exact (rem_2678).
Defined.

Remark rem_2680 : (forall X:term, auto___def_7 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_7_pknows_old. intros X1 X2.
  cut (auto___def_9 X2 -> auto_knows_old X2). tauto. exact (rem_2679 epsilon_m__def_7_pknows_old X2).
Defined.

Remark rem_2681 : (forall X:term, auto___def_7 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_7_pknows_old. intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_2674 epsilon_m__def_7_pknows_old X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2680 epsilon_m__def_7_pknows_old X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2682 : (forall X:term, auto___def_7 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_8 X1 -> auto___def_9 X2 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_7_pknows_old. intros X1 X2. intros A1 A2.
  case (rem_2681 epsilon_m__def_7_pknows_old X1 X2 A1 A2). clear  epsilon_m__def_7_pknows_old A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  epsilon_m__def_7_pknows_old A1 A2. tauto.
Defined.

Remark rem_2683 : forall X1 X2:term, auto___def_7 (cons X1 X2) -> or_1
    (auto___def_8 X1 /\ auto___def_9 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2684 : (forall X:term, auto___def_7 X -> auto_knows_old X)
    -> forall X1 X2:term, auto___def_7 (cons X1 X2) -> auto_knows_old (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_7_pknows_old. intros X1 X2. intro H. intros.
  elim (rem_2683 X1 X2 H);  intros.
  apply (rem_2682 epsilon_m__def_7_pknows_old X1 X2);  tauto.
Defined.

Remark rem_2685 : forall X1:term, auto___def_7 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2686 : forall X1 X2:term, auto___def_7 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2687 : auto___def_7 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2688 : auto___def_7 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2689 : forall X1 X2:term, auto___def_7 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2690 : forall X1 X2 X3:term, auto___def_7 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2691 : auto___def_7 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2692 : auto___def_7 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2693 : forall X1 X2:term, auto___def_7 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2694 : auto___def_7 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2695 : auto___def_7 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2696 : forall X1 X2 X3 X4 X5:term, auto___def_7 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2697 : forall X1 X2:term, auto___def_7 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2698 : forall X1 X2 X3 X4 X5:term, auto___def_7 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2699 : forall X1 X2:term, auto___def_7 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2700 : forall X1 X2:term, auto___def_7 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2701 : auto___def_7 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2702 : forall X1 X2 X3 X4 X5:term, auto___def_7 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2703 : forall X1 X2 X3 X4 X5:term, auto___def_7 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2704 : forall X1 X2 X3 X4 X5:term, auto___def_7 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2705 : forall X1 X2:term, auto___def_7 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2706 : auto___def_7 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2707 : forall X1 X2:term, auto___def_7 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2708 : forall X1 X2 X3 X4 X5:term, auto___def_7 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2709 : forall X2:term, auto___def_7 X2 -> auto_knows_old X2. (* Induct. *)
Proof.
  fix epsilon_m__def_7_pknows_old 1.
  intro X. case X.
   intro H. elim (rem_2695  H).
   intro H. elim (rem_2694  H).
  intros X1 X2;  exact (rem_2684 epsilon_m__def_7_pknows_old X1 X2).
  intros X1 X2. intro H. elim (rem_2705 X1 X2 H).
   intro H. elim (rem_2688  H).
  intros X1 X2. intro H. elim (rem_2707 X1 X2 H).
   intro H. elim (rem_2687  H).
  intros X1 X2. intro H. elim (rem_2700 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2693 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2702 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2696 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2701  H).
   intro H. elim (rem_2706  H).
  intros X1. intro H. elim (rem_2685 X1 H).
   intro H. elim (rem_2692  H).
  intros X1 X2 X3. intro H. elim (rem_2690 X1 X2 X3 H).
   intro H. elim (rem_2691  H).
  intros X1 X2. intro H. elim (rem_2697 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2689 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2708 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2703 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2699 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2686 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2698 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2704 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2710 : forall X1 X2:term, auto___def_7 X2 -> auto___type_1 X1 -> auto_knows_old X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_7 X2 -> auto_knows_old X2). tauto. exact (rem_2709 X2).
Qed.

Remark rem_2711 : forall X1 X2:term, auto___def_7 X2 -> auto___type_1 X1 -> (auto_knows_old X1 /\ auto_knows_old X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_knows_old X1). 2:apply (rem_2639 X1 X2);  assumption.
  cut (auto_knows_old X2). 2:apply (rem_2710 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2712 : forall X1 X2:term, auto___def_7 X2 -> auto___type_1 X1 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2711 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2713 : forall X1 X2:term, auto_knows_current (noncea_old X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2.  case (rem_10). intros. apply trans_knows_current_noncea_old_1;  tauto.
 tauto.
Qed.

Remark rem_2714 : forall X1:term, auto___type_17 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2715 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1:term, auto___type_17 (s X1) -> auto_knows_current X1 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1. intro H. intros.
  elim (rem_2714 X1 H);  intros.
Defined.

Remark rem_2716 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1:term, auto_knows_current (s X1) -> auto___type_17 (s X1) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1. intro H. intros.
  elim (rem_2423 X1 H);  intros.
  apply (rem_2715 epsilon_mknows_current_m__type_17 X1);  tauto.
Defined.

Remark rem_2717 : forall X1 X2:term, auto___type_17 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2718 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (ya_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2717 X1 X2 H);  intros.
Defined.

Remark rem_2719 : forall X1 X2:term, auto_knows_current (ya_old X1 X2) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2720 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto_knows_current (ya_old X1 X2) -> auto___type_17 (ya_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2719 X1 X2 H);  intros.
  apply (rem_2718 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
Defined.

Remark rem_2721 : auto___type_17 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2722 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> auto___type_17 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intro H. intros.
  elim (rem_2721 H);  intros.
Defined.

Remark rem_2723 : auto_knows_current nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2724 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> auto_knows_current nil -> auto___type_17 nil -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intro H. intros.
  elim (rem_2723 H);  intros.
  apply (rem_2722 epsilon_mknows_current_m__type_17);  tauto.
Defined.

Remark rem_2725 : auto___type_17 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2726 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> auto___type_17 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intro H. intros.
  elim (rem_2725 H);  intros.
Defined.

Remark rem_2727 : auto_knows_current i -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2728 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> auto_knows_current i -> auto___type_17 i -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intro H. intros.
  elim (rem_2727 H);  intros.
  apply (rem_2726 epsilon_mknows_current_m__type_17);  tauto.
Defined.

Remark rem_2729 : forall X1 X2:term, auto___type_17 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2730 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (xa_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2729 X1 X2 H);  intros.
Defined.

Remark rem_2731 : forall X1 X2:term, auto_knows_current (xa_old X1 X2) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2732 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto_knows_current (xa_old X1 X2) -> auto___type_17 (xa_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2731 X1 X2 H);  intros.
  apply (rem_2730 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
Defined.

Remark rem_2733 : forall X1 X2:term, auto___type_17 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2734 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (cons X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2733 X1 X2 H);  intros.
Defined.

Remark rem_2735 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto_knows_current (cons X1 X2) -> auto___type_17 (cons X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_350 X1 X2 H);  intros.
  apply (rem_2734 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
Defined.

Remark rem_2736 : auto___type_17 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2737 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> auto___type_17 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intro H. intros.
  elim (rem_2736 H);  intros.
Defined.

Remark rem_2738 : auto_knows_current server -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2739 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> auto_knows_current server -> auto___type_17 server -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intro H. intros.
  elim (rem_2738 H);  intros.
  apply (rem_2737 epsilon_mknows_current_m__type_17);  tauto.
Defined.

Remark rem_2740 : forall X1 X2:term, auto___type_17 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2741 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2740 X1 X2 H);  intros.
Defined.

Remark rem_2742 : forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2743 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto_knows_current (noncea_old X1 X2) -> auto___type_17 (noncea_old X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2742 X1 X2 H);  intros.
  apply (rem_2741 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
Defined.

Remark rem_2744 : auto___type_17 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2745 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> auto___type_17 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intro H. intros.
  elim (rem_2744 H);  intros.
Defined.

Remark rem_2746 : auto_knows_current bob -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2747 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> auto_knows_current bob -> auto___type_17 bob -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intro H. intros.
  elim (rem_2746 H);  intros.
  apply (rem_2745 epsilon_mknows_current_m__type_17);  tauto.
Defined.

Remark rem_2748 : auto___type_17 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2749 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> auto___type_17 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intro H. intros.
  elim (rem_2748 H);  intros.
Defined.

Remark rem_2750 : auto_knows_current alice -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2751 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> auto_knows_current alice -> auto___type_17 alice -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intro H. intros.
  elim (rem_2750 H);  intros.
  apply (rem_2749 epsilon_mknows_current_m__type_17);  tauto.
Defined.

Remark rem_2752 : forall X1 X2 X3 X4 X5:term, auto___type_17 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2753 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2 X3 X4 X5:term, auto___type_17 (nonceb_old X1 X2 X3 X4 X5) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_2752 X1 X2 X3 X4 X5 H);  intros.
Defined.

Remark rem_2754 : forall X1 X2 X3 X4 X5:term, auto_knows_current (nonceb_old X1 X2 X3 X4 X5) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2755 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2 X3 X4 X5:term, auto_knows_current (nonceb_old X1 X2 X3 X4 X5) -> auto___type_17 (nonceb_old X1 X2 X3 X4 X5) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_2754 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_2753 epsilon_mknows_current_m__type_17 X1 X2 X3 X4 X5);  tauto.
Defined.

Remark rem_2756 : forall X1 X2 X3 X4 X5:term, auto___type_17 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2757 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2 X3 X4 X5:term, auto___type_17 (xb_old X1 X2 X3 X4 X5) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_2756 X1 X2 X3 X4 X5 H);  intros.
Defined.

Remark rem_2758 : forall X1 X2 X3 X4 X5:term, auto_knows_current (xb_old X1 X2 X3 X4 X5) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2759 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2 X3 X4 X5:term, auto_knows_current (xb_old X1 X2 X3 X4 X5) -> auto___type_17 (xb_old X1 X2 X3 X4 X5) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_2758 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_2757 epsilon_mknows_current_m__type_17 X1 X2 X3 X4 X5);  tauto.
Defined.

Remark rem_2760 : forall X1 X2 X3 X4 X5:term, auto___type_17 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2761 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2 X3 X4 X5:term, auto___type_17 (yb_old X1 X2 X3 X4 X5) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_2760 X1 X2 X3 X4 X5 H);  intros.
Defined.

Remark rem_2762 : forall X1 X2 X3 X4 X5:term, auto_knows_current (yb_old X1 X2 X3 X4 X5) -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2763 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2 X3 X4 X5:term, auto_knows_current (yb_old X1 X2 X3 X4 X5) -> auto___type_17 (yb_old X1 X2 X3 X4 X5) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2 X3 X4 X5. intro H. intros.
  elim (rem_2762 X1 X2 X3 X4 X5 H);  intros.
  apply (rem_2761 epsilon_mknows_current_m__type_17 X1 X2 X3 X4 X5);  tauto.
Defined.

Remark rem_2764 : forall X1 X2:term, auto___type_17 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2765 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (crypt X1 X2) -> auto___def_26 X1 -> auto___def_27 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2764 X1 X2 H);  intros.
Defined.

Remark rem_2766 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (crypt X1 X2) -> auto___def_90 X1 -> auto___def_91 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2764 X1 X2 H);  intros.
Defined.

Remark rem_2767 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (crypt X1 X2) -> auto___def_73 X1 -> auto___def_74 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2764 X1 X2 H);  intros.
Defined.

Remark rem_2768 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (crypt X1 X2) -> auto___def_43 X1 -> auto___def_44 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2764 X1 X2 H);  intros.
Defined.

Remark rem_2769 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (crypt X1 X2) -> auto___def_61 X1 -> auto___def_11 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2764 X1 X2 H);  intros.
Defined.

Remark rem_2770 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (crypt X1 X2) -> auto___def_10 X1 -> auto___def_11 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2764 X1 X2 H);  intros.
Defined.

Remark rem_2771 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (crypt X1 X2) -> auto_knows_current X1 -> auto_knows_current X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2764 X1 X2 H);  intros.
Defined.

Remark rem_2772 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto_knows_current (crypt X1 X2) -> auto___type_17 (crypt X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_346 X1 X2 H);  intros.
  apply (rem_2765 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
  apply (rem_2766 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
  apply (rem_2767 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
  apply (rem_2768 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
  apply (rem_2769 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
  apply (rem_2770 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
  apply (rem_2771 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
Defined.

Remark rem_2773 : forall X1 X2:term, auto___type_17 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2774 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto___type_17 (key X1 X2) -> auto___def_51 X1 -> auto___def_52 X2 -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_2773 X1 X2 H);  intros.
Defined.

Remark rem_2775 : (forall X:term, auto_knows_current X -> auto___type_17 X -> False)
    -> forall X1 X2:term, auto_knows_current (key X1 X2) -> auto___type_17 (key X1 X2) -> False. (* Eliminate negative atom. *)
Proof.
  intros epsilon_mknows_current_m__type_17. intros X1 X2. intro H. intros.
  elim (rem_309 X1 X2 H);  intros.
  apply (rem_2774 epsilon_mknows_current_m__type_17 X1 X2);  tauto.
Defined.

Remark rem_2776 : auto_knows_current sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2777 : forall X1 X2:term, auto_knows_current (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2778 : forall X1 X2 X3 X4 X5:term, auto_knows_current (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2779 : forall X1 X2:term, auto_knows_current (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2780 : auto_knows_current prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2781 : forall X1 X2 X3 X4 X5:term, auto_knows_current (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2782 : auto_knows_current pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2783 : forall X1 X2 X3 X4 X5:term, auto_knows_current (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2784 : forall X1:term, auto_knows_current X1 -> auto___type_17 X1 -> False. (* Induct. *)
Proof.
  fix epsilon_mknows_current_m__type_17 1.
  intro X. case X.
  exact (rem_2751 epsilon_mknows_current_m__type_17 ).
  exact (rem_2747 epsilon_mknows_current_m__type_17 ).
  intros X1 X2;  exact (rem_2735 epsilon_mknows_current_m__type_17 X1 X2).
  intros X1 X2;  exact (rem_2772 epsilon_mknows_current_m__type_17 X1 X2).
  exact (rem_2728 epsilon_mknows_current_m__type_17 ).
  intros X1 X2;  exact (rem_2775 epsilon_mknows_current_m__type_17 X1 X2).
  exact (rem_2724 epsilon_mknows_current_m__type_17 ).
  intros X1 X2. intro H. elim (rem_2779 X1 X2 H).
  intros X1 X2;  exact (rem_2743 epsilon_mknows_current_m__type_17 X1 X2).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2781 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5;  exact (rem_2755 epsilon_mknows_current_m__type_17 X1 X2 X3 X4 X5).
   intro H. elim (rem_2780  H).
   intro H. elim (rem_2782  H).
  intros X1;  exact (rem_2716 epsilon_mknows_current_m__type_17 X1).
  exact (rem_2739 epsilon_mknows_current_m__type_17 ).
  intros X1 X2 X3. intro H. elim (rem_278 X1 X2 X3 H).
   intro H. elim (rem_2776  H).
  intros X1 X2. intro H. elim (rem_2777 X1 X2 H).
  intros X1 X2;  exact (rem_2732 epsilon_mknows_current_m__type_17 X1 X2).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2783 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5;  exact (rem_2759 epsilon_mknows_current_m__type_17 X1 X2 X3 X4 X5).
  intros X1 X2. intro H. elim (rem_2434 X1 X2 H).
  intros X1 X2;  exact (rem_2720 epsilon_mknows_current_m__type_17 X1 X2).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2778 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5;  exact (rem_2763 epsilon_mknows_current_m__type_17 X1 X2 X3 X4 X5).
Qed.

Remark rem_2785 : forall X1 X2 X3 X4:term, auto___def_93 X1 -> auto___def_94 X2 -> auto___type_15 alice -> auto___type_16 X3 -> auto___type_17 X4 -> auto_knows_current X4 -> False. (* Subsumed by epsilon clause. *)
Proof.
  intros X1 X2 X3 X4. intros.
  assert (HH:=(rem_2784 X4)). tauto.
Qed.

Remark rem_2786 : forall X1 X2 X3 X4:term, auto___type_15 alice -> auto___def_93 X1 -> auto___def_94 X2 -> auto___type_16 X3 -> auto___type_17 X4 -> auto_knows_current X4 -> False. (* Prove equivalent, normalized clause. *)
Proof.
   intros X1 X2 X3 X4.
  cut (auto___def_93 X1 -> auto___def_94 X2 -> auto___type_15 alice -> auto___type_16 X3 -> auto___type_17 X4 -> auto_knows_current X4 -> False). tauto. exact (rem_2785 X1 X2 X3 X4).
Qed.

Remark rem_2787 : forall X1 X2 X3 X4:term, auto_alice_data_current alice X1 X2 X3 X4 -> auto_knows_current X4 -> False. (* Eliminate negative atom. *)
Proof.
  intros X1 X2 X3 X4. intro H. intros.
  elim (rem_2465 alice X1 X2 X3 X4 H);  intros.
  apply (rem_2786 X1 X2 X3 X4);  tauto.
Qed.

Remark rem_2788 : forall X1 X2 X3 X4:term, auto_alice_data_current alice X1 X2 X3 X4 -> auto_knows_current X4 -> auto___query__intruder_knows_yb_as_seen_by_alice. (* Split. *)
Proof.
  intros X1 X2 X3 X4.
  cut (auto_alice_data_current alice X1 X2 X3 X4 -> auto_knows_current X4 -> False). tauto.
  exact (rem_2787 X1 X2 X3 X4).
Qed.

Remark rem_2789 : forall X1 X2 X3 X4:term, auto_alice_data_current alice X2 X3 X4 X1 -> auto_knows_current X1 -> auto___query__intruder_knows_yb_as_seen_by_alice. (* Prove equivalent, normalized clause. *)
Proof.
   intros X4 X1 X2 X3.
  cut (auto_alice_data_current alice X1 X2 X3 X4 -> auto_knows_current X4 -> auto___query__intruder_knows_yb_as_seen_by_alice). tauto. exact (rem_2788 X1 X2 X3 X4).
Qed.

Remark rem_2790 : forall X1 X2 X3 X4 X5:term, auto_knows_current (nonceb_old X1 X2 X3 X4 X5). (* Deduce positive atom. *)
Proof.
  intros X1 X2 X3 X4 X5.  case (rem_10). intros. apply trans_knows_current_nonceb_old_1;  tauto.
 tauto.
Qed.

Remark rem_2791 : (forall X:term, auto___type_12 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__type_12_pknows_current.  tauto.
Defined.

Remark rem_2792 : (forall X:term, auto___type_12 X -> auto_knows_current X)
    -> auto_knows_current i. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_12_pknows_current.  case (rem_2791 epsilon_m__type_12_pknows_current). clear  epsilon_m__type_12_pknows_current. intros. apply trans_knows_current_i_1;  tauto.
 clear  epsilon_m__type_12_pknows_current. tauto.
Defined.

Remark rem_2793 : (forall X:term, auto___type_12 X -> auto_knows_current X)
    -> auto___type_12 i -> auto_knows_current i. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_pknows_current. intro H. intros.
  elim (rem_178 H);  intros.
  apply (rem_2792 epsilon_m__type_12_pknows_current);  tauto.
Defined.

Remark rem_2794 : (forall X:term, auto___type_12 X -> auto_knows_current X)
    -> auto_knows_current server. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_12_pknows_current.  case (rem_2791 epsilon_m__type_12_pknows_current). clear  epsilon_m__type_12_pknows_current. intros. apply trans_knows_current_server_1;  tauto.
 clear  epsilon_m__type_12_pknows_current. tauto.
Defined.

Remark rem_2795 : (forall X:term, auto___type_12 X -> auto_knows_current X)
    -> auto___type_12 server -> auto_knows_current server. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_pknows_current. intro H. intros.
  elim (rem_181 H);  intros.
  apply (rem_2794 epsilon_m__type_12_pknows_current);  tauto.
Defined.

Remark rem_2796 : (forall X:term, auto___type_12 X -> auto_knows_current X)
    -> auto_knows_current bob. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_12_pknows_current.  case (rem_2791 epsilon_m__type_12_pknows_current). clear  epsilon_m__type_12_pknows_current. intros. apply trans_knows_current_bob_1;  tauto.
 clear  epsilon_m__type_12_pknows_current. tauto.
Defined.

Remark rem_2797 : (forall X:term, auto___type_12 X -> auto_knows_current X)
    -> auto___type_12 bob -> auto_knows_current bob. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_pknows_current. intro H. intros.
  elim (rem_184 H);  intros.
  apply (rem_2796 epsilon_m__type_12_pknows_current);  tauto.
Defined.

Remark rem_2798 : (forall X:term, auto___type_12 X -> auto_knows_current X)
    -> auto_knows_current alice. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__type_12_pknows_current.  case (rem_2791 epsilon_m__type_12_pknows_current). clear  epsilon_m__type_12_pknows_current. intros. apply trans_knows_current_alice_1;  tauto.
 clear  epsilon_m__type_12_pknows_current. tauto.
Defined.

Remark rem_2799 : (forall X:term, auto___type_12 X -> auto_knows_current X)
    -> auto___type_12 alice -> auto_knows_current alice. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__type_12_pknows_current. intro H. intros.
  elim (rem_187 H);  intros.
  apply (rem_2798 epsilon_m__type_12_pknows_current);  tauto.
Defined.

Remark rem_2800 : forall X1:term, auto___type_12 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__type_12_pknows_current 1.
  intro X. case X.
  exact (rem_2799 epsilon_m__type_12_pknows_current ).
  exact (rem_2797 epsilon_m__type_12_pknows_current ).
  intros X1 X2. intro H. elim (rem_194 X1 X2 H).
  intros X1 X2. intro H. elim (rem_206 X1 X2 H).
  exact (rem_2793 epsilon_m__type_12_pknows_current ).
  intros X1 X2. intro H. elim (rem_208 X1 X2 H).
   intro H. elim (rem_191  H).
  intros X1 X2. intro H. elim (rem_201 X1 X2 H).
  intros X1 X2. intro H. elim (rem_196 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_203 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_197 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_202  H).
   intro H. elim (rem_207  H).
  intros X1. intro H. elim (rem_189 X1 H).
  exact (rem_2795 epsilon_m__type_12_pknows_current ).
  intros X1 X2 X3. intro H. elim (rem_193 X1 X2 X3 H).
   intro H. elim (rem_195  H).
  intros X1 X2. intro H. elim (rem_198 X1 X2 H).
  intros X1 X2. intro H. elim (rem_192 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_209 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_204 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_200 X1 X2 H).
  intros X1 X2. intro H. elim (rem_190 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_199 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_205 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2801 : forall X1 X2:term, auto___def_70 X2 -> auto___type_12 X1 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___type_12 X1 -> auto_knows_current X1). tauto. exact (rem_2800 X1).
Qed.

Remark rem_2802 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1:term, auto___def_73 X1 -> auto___def_73 X1. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2803 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_73 X1 -> auto___def_74 X2 -> auto___def_73 X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_71_pknows_current. intros X1 X2.
  cut (auto___def_73 X1 -> auto___def_73 X1). tauto. exact (rem_2802 epsilon_m__def_71_pknows_current X1).
Defined.

Remark rem_2804 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X2:term, auto___def_74 X2 -> auto___def_74 X2. (* Tautology. *)
Proof. intro H. clear H. tauto. Defined.

Remark rem_2805 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_73 X1 -> auto___def_74 X2 -> auto___def_74 X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_71_pknows_current. intros X1 X2.
  cut (auto___def_74 X2 -> auto___def_74 X2). tauto. exact (rem_2804 epsilon_m__def_71_pknows_current X2).
Defined.

Remark rem_2806 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_73 X1 -> auto___def_74 X2 -> (auto___def_73 X1 /\ auto___def_74 X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_71_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto___def_73 X1). 2:apply (rem_2803 epsilon_m__def_71_pknows_current X1 X2);  assumption.
  cut (auto___def_74 X2). 2:apply (rem_2805 epsilon_m__def_71_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2807 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_73 X1 -> auto___def_74 X2 -> auto_knows_current (crypt X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_71_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2806 epsilon_m__def_71_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_71_pknows_current A1 A2. intros. apply trans_knows_current_crypt_3;  tauto.
 clear  epsilon_m__def_71_pknows_current A1 A2. tauto.
Defined.

Remark rem_2808 : forall X1 X2:term, auto___def_71 (crypt X1 X2) -> or_1
    (auto___def_73 X1 /\ auto___def_74 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2809 : (forall X:term, auto___def_71 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_71 (crypt X1 X2) -> auto_knows_current (crypt X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_71_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2808 X1 X2 H);  intros.
  apply (rem_2807 epsilon_m__def_71_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2810 : forall X1:term, auto___def_71 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2811 : forall X1 X2:term, auto___def_71 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2812 : auto___def_71 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2813 : auto___def_71 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2814 : forall X1 X2:term, auto___def_71 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2815 : forall X1 X2 X3:term, auto___def_71 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2816 : forall X1 X2:term, auto___def_71 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2817 : auto___def_71 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2818 : auto___def_71 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2819 : forall X1 X2:term, auto___def_71 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2820 : auto___def_71 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2821 : auto___def_71 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2822 : forall X1 X2 X3 X4 X5:term, auto___def_71 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2823 : forall X1 X2:term, auto___def_71 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2824 : forall X1 X2 X3 X4 X5:term, auto___def_71 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2825 : forall X1 X2:term, auto___def_71 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2826 : forall X1 X2:term, auto___def_71 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2827 : auto___def_71 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2828 : forall X1 X2 X3 X4 X5:term, auto___def_71 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2829 : forall X1 X2 X3 X4 X5:term, auto___def_71 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2830 : forall X1 X2 X3 X4 X5:term, auto___def_71 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2831 : auto___def_71 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2832 : forall X1 X2:term, auto___def_71 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2833 : forall X1 X2 X3 X4 X5:term, auto___def_71 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2834 : forall X1:term, auto___def_71 X1 -> auto_knows_current X1. (* Induct. *)
Proof.
  fix epsilon_m__def_71_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2821  H).
   intro H. elim (rem_2820  H).
  intros X1 X2. intro H. elim (rem_2816 X1 X2 H).
  intros X1 X2;  exact (rem_2809 epsilon_m__def_71_pknows_current X1 X2).
   intro H. elim (rem_2813  H).
  intros X1 X2. intro H. elim (rem_2832 X1 X2 H).
   intro H. elim (rem_2812  H).
  intros X1 X2. intro H. elim (rem_2826 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2819 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2828 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2822 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2827  H).
   intro H. elim (rem_2831  H).
  intros X1. intro H. elim (rem_2810 X1 H).
   intro H. elim (rem_2818  H).
  intros X1 X2 X3. intro H. elim (rem_2815 X1 X2 X3 H).
   intro H. elim (rem_2817  H).
  intros X1 X2. intro H. elim (rem_2823 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2814 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2833 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2829 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2825 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2811 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2824 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2830 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2835 : (forall X:term, auto___def_70 X -> auto_knows_current X)
    -> forall X1:term, auto___def_71 X1 -> auto_knows_current X1. (* Cut history. *)
Proof.  intros epsilon_m__def_70_pknows_current. exact (rem_2834).
Defined.

Remark rem_2836 : (forall X:term, auto___def_70 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto_knows_current X1. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_70_pknows_current. intros X1 X2.
  cut (auto___def_71 X1 -> auto_knows_current X1). tauto. exact (rem_2835 epsilon_m__def_70_pknows_current X1).
Defined.

Remark rem_2837 : (forall X:term, auto___def_72 X -> auto_knows_current X)
    -> True \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_72_pknows_current.  tauto.
Defined.

Remark rem_2838 : (forall X:term, auto___def_72 X -> auto_knows_current X)
    -> auto_knows_current nil. (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_72_pknows_current.  case (rem_2837 epsilon_m__def_72_pknows_current). clear  epsilon_m__def_72_pknows_current. intros. apply trans_knows_current_nil_1;  tauto.
 clear  epsilon_m__def_72_pknows_current. tauto.
Defined.

Remark rem_2839 : auto___def_72 nil -> or_1
    True.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2840 : (forall X:term, auto___def_72 X -> auto_knows_current X)
    -> auto___def_72 nil -> auto_knows_current nil. (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_72_pknows_current. intro H. intros.
  elim (rem_2839 H);  intros.
  apply (rem_2838 epsilon_m__def_72_pknows_current);  tauto.
Defined.

Remark rem_2841 : forall X1:term, auto___def_72 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2842 : forall X1 X2:term, auto___def_72 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2843 : auto___def_72 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2844 : forall X1 X2:term, auto___def_72 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2845 : forall X1 X2 X3:term, auto___def_72 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2846 : forall X1 X2:term, auto___def_72 (cons X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2847 : auto___def_72 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2848 : auto___def_72 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2849 : forall X1 X2:term, auto___def_72 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2850 : auto___def_72 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2851 : auto___def_72 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2852 : forall X1 X2 X3 X4 X5:term, auto___def_72 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2853 : forall X1 X2:term, auto___def_72 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2854 : forall X1 X2 X3 X4 X5:term, auto___def_72 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2855 : forall X1 X2:term, auto___def_72 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2856 : forall X1 X2:term, auto___def_72 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2857 : auto___def_72 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2858 : forall X1 X2 X3 X4 X5:term, auto___def_72 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2859 : forall X1 X2 X3 X4 X5:term, auto___def_72 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2860 : forall X1 X2 X3 X4 X5:term, auto___def_72 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2861 : forall X1 X2:term, auto___def_72 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2862 : auto___def_72 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2863 : forall X1 X2:term, auto___def_72 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2864 : forall X1 X2 X3 X4 X5:term, auto___def_72 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2865 : forall X2:term, auto___def_72 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_72_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2851  H).
   intro H. elim (rem_2850  H).
  intros X1 X2. intro H. elim (rem_2846 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2861 X1 X2 H).
   intro H. elim (rem_2843  H).
  intros X1 X2. intro H. elim (rem_2863 X1 X2 H).
  exact (rem_2840 epsilon_m__def_72_pknows_current ).
  intros X1 X2. intro H. elim (rem_2856 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2849 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2858 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2852 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2857  H).
   intro H. elim (rem_2862  H).
  intros X1. intro H. elim (rem_2841 X1 H).
   intro H. elim (rem_2848  H).
  intros X1 X2 X3. intro H. elim (rem_2845 X1 X2 X3 H).
   intro H. elim (rem_2847  H).
  intros X1 X2. intro H. elim (rem_2853 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2844 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2864 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2859 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2855 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2842 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2854 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2860 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2866 : (forall X:term, auto___def_70 X -> auto_knows_current X)
    -> forall X2:term, auto___def_72 X2 -> auto_knows_current X2. (* Cut history. *)
Proof.  intros epsilon_m__def_70_pknows_current. exact (rem_2865).
Defined.

Remark rem_2867 : (forall X:term, auto___def_70 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros epsilon_m__def_70_pknows_current. intros X1 X2.
  cut (auto___def_72 X2 -> auto_knows_current X2). tauto. exact (rem_2866 epsilon_m__def_70_pknows_current X2).
Defined.

Remark rem_2868 : (forall X:term, auto___def_70 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros epsilon_m__def_70_pknows_current. intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2836 epsilon_m__def_70_pknows_current X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2867 epsilon_m__def_70_pknows_current X1 X2);  assumption.
  tauto.
Defined.

Remark rem_2869 : (forall X:term, auto___def_70 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_71 X1 -> auto___def_72 X2 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros epsilon_m__def_70_pknows_current. intros X1 X2. intros A1 A2.
  case (rem_2868 epsilon_m__def_70_pknows_current X1 X2 A1 A2). clear  epsilon_m__def_70_pknows_current A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  epsilon_m__def_70_pknows_current A1 A2. tauto.
Defined.

Remark rem_2870 : forall X1 X2:term, auto___def_70 (cons X1 X2) -> or_1
    (auto___def_71 X1 /\ auto___def_72 X2)
.
Proof.
  intros. inversion H.
  intros. apply or_1_intro_1; tauto.
Qed.

Remark rem_2871 : (forall X:term, auto___def_70 X -> auto_knows_current X)
    -> forall X1 X2:term, auto___def_70 (cons X1 X2) -> auto_knows_current (cons X1 X2). (* Eliminate negative atom. *)
Proof.
  intros epsilon_m__def_70_pknows_current. intros X1 X2. intro H. intros.
  elim (rem_2870 X1 X2 H);  intros.
  apply (rem_2869 epsilon_m__def_70_pknows_current X1 X2);  tauto.
Defined.

Remark rem_2872 : forall X1:term, auto___def_70 (s X1) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2873 : forall X1 X2:term, auto___def_70 (ya_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2874 : auto___def_70 nil -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2875 : auto___def_70 i -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2876 : forall X1 X2:term, auto___def_70 (xa_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2877 : forall X1 X2 X3:term, auto___def_70 (session_old X1 X2 X3) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2878 : auto___def_70 sym -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2879 : auto___def_70 server -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2880 : forall X1 X2:term, auto___def_70 (noncea_old X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2881 : auto___def_70 bob -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2882 : auto___def_70 alice -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2883 : forall X1 X2 X3 X4 X5:term, auto___def_70 (nonceb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2884 : forall X1 X2:term, auto___def_70 (xa_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2885 : forall X1 X2 X3 X4 X5:term, auto___def_70 (yb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2886 : forall X1 X2:term, auto___def_70 (ya_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2887 : forall X1 X2:term, auto___def_70 (noncea_current X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2888 : auto___def_70 prv -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2889 : forall X1 X2 X3 X4 X5:term, auto___def_70 (nonceb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2890 : forall X1 X2 X3 X4 X5:term, auto___def_70 (xb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2891 : forall X1 X2 X3 X4 X5:term, auto___def_70 (yb_old X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2892 : forall X1 X2:term, auto___def_70 (crypt X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2893 : auto___def_70 pub -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2894 : forall X1 X2:term, auto___def_70 (key X1 X2) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2895 : forall X1 X2 X3 X4 X5:term, auto___def_70 (xb_current X1 X2 X3 X4 X5) -> or_0.
Proof.
  intros. inversion H.
Qed.

Remark rem_2896 : forall X2:term, auto___def_70 X2 -> auto_knows_current X2. (* Induct. *)
Proof.
  fix epsilon_m__def_70_pknows_current 1.
  intro X. case X.
   intro H. elim (rem_2882  H).
   intro H. elim (rem_2881  H).
  intros X1 X2;  exact (rem_2871 epsilon_m__def_70_pknows_current X1 X2).
  intros X1 X2. intro H. elim (rem_2892 X1 X2 H).
   intro H. elim (rem_2875  H).
  intros X1 X2. intro H. elim (rem_2894 X1 X2 H).
   intro H. elim (rem_2874  H).
  intros X1 X2. intro H. elim (rem_2887 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2880 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2889 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2883 X1 X2 X3 X4 X5 H).
   intro H. elim (rem_2888  H).
   intro H. elim (rem_2893  H).
  intros X1. intro H. elim (rem_2872 X1 H).
   intro H. elim (rem_2879  H).
  intros X1 X2 X3. intro H. elim (rem_2877 X1 X2 X3 H).
   intro H. elim (rem_2878  H).
  intros X1 X2. intro H. elim (rem_2884 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2876 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2895 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2890 X1 X2 X3 X4 X5 H).
  intros X1 X2. intro H. elim (rem_2886 X1 X2 H).
  intros X1 X2. intro H. elim (rem_2873 X1 X2 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2885 X1 X2 X3 X4 X5 H).
  intros X1 X2 X3 X4 X5. intro H. elim (rem_2891 X1 X2 X3 X4 X5 H).
Qed.

Remark rem_2897 : forall X1 X2:term, auto___def_70 X2 -> auto___type_12 X1 -> auto_knows_current X2. (* Subsumption by simpler clause. *)
Proof.
  intros X1 X2.
  cut (auto___def_70 X2 -> auto_knows_current X2). tauto. exact (rem_2896 X2).
Qed.

Remark rem_2898 : forall X1 X2:term, auto___def_70 X2 -> auto___type_12 X1 -> (auto_knows_current X1 /\ auto_knows_current X2) \/ False. (* Distribute disjunctions over conjunctions. *)
Proof.
  intros X1 X2. intros A1 A2.
  cut (auto_knows_current X1). 2:apply (rem_2801 X1 X2);  assumption.
  cut (auto_knows_current X2). 2:apply (rem_2897 X1 X2);  assumption.
  tauto.
Qed.

Remark rem_2899 : forall X1 X2:term, auto___def_70 X2 -> auto___type_12 X1 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2898 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2900 : forall X1 X2:term, auto_knows_old X2 -> auto_knows_old X1 -> auto_knows_old (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2267 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_old_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

Remark rem_2901 : forall X1 X2:term, auto_knows_current X2 -> auto_knows_current X1 -> auto_knows_current (cons X1 X2). (* Deduce positive atom. *)
Proof.
  intros X1 X2. intros A1 A2.
  case (rem_2427 X1 X2 A1 A2). clear  A1 A2. intros. apply trans_knows_current_cons_1;  tauto.
 clear  A1 A2. tauto.
Qed.

(* [trnp] Proofs of translated source clauses. *)


Lemma lem_intruder_knows_yb_as_seen_by_bob : forall Xa Xb Ya Yb:term, auto_knows_current Yb -> auto_bob_data_current bob Xb Yb Xa Ya -> auto___query__intruder_knows_yb_as_seen_by_bob.
Proof.
   intros Xa Xb Ya Yb. intros H1 H2.
  exact (rem_2271 Yb Xb Xa Ya
          H2
          H1).
Qed.

Lemma lem_intruder_knows_ya_as_seen_by_bob : forall Xa Xb Ya Yb:term, auto_knows_current Ya -> auto_bob_data_current bob Xb Yb Xa Ya -> auto___query__intruder_knows_ya_as_seen_by_bob.
Proof.
   intros Xa Xb Ya Yb. intros H1 H2.
  exact (rem_1867 Ya Xb Yb Xa
          H2
          H1).
Qed.

Lemma lem_intruder_knows_yb_as_seen_by_alice : forall Xa Xb Ya Yb:term, auto_knows_current Yb -> auto_alice_data_current alice Xa Ya Xb Yb -> auto___query__intruder_knows_yb_as_seen_by_alice.
Proof.
   intros Xa Xb Ya Yb. intros H1 H2.
  exact (rem_2789 Yb Xa Ya Xb
          H2
          H1).
Qed.

Lemma lem_intruder_knows_ya_as_seen_by_alice : forall Xa Xb Ya Yb:term, auto_knows_current Ya -> auto_alice_data_current alice Xa Ya Xb Yb -> auto___query__intruder_knows_ya_as_seen_by_alice.
Proof.
   intros Xa Xb Ya Yb. intros H1 H2.
  exact (rem_2468 Ya Xa Xb Yb
          H2
          H1).
Qed.

Lemma lem_define_bob_data_current : forall _big_a _big_b _big_na Xa Ya:term, auto_knows_current (cons _big_a (cons (crypt (cons _big_b (cons (nonceb_current _big_a _big_b _big_na Xa Ya) nil)) (key prv _big_a)) nil)) -> auto_knows_current (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) -> auto_bob_data_current _big_b (xb_current _big_a _big_b _big_na Xa Ya) (yb_current _big_a _big_b _big_na Xa Ya) Xa Ya.
Proof.
   intros _big_a _big_b _big_na Xa Ya. intros H1 H2.
  exact (rem_2611 _big_b (xb_current _big_a _big_b _big_na Xa Ya) (yb_current _big_a _big_b _big_na Xa Ya) Xa Ya
          (rem_1310 _big_a _big_b _big_na Xa Ya
            (rem_1587 _big_a _big_b Xa Ya _big_na
              H1
              H2))
          (rem_1214 Ya _big_a _big_b Xa _big_na
            (rem_1587 _big_a _big_b Xa Ya _big_na
              H1
              H2))
          (rem_1319 _big_a _big_b _big_na Xa Ya
            (rem_1587 _big_a _big_b Xa Ya _big_na
              H1
              H2))
          (rem_1210 Xa _big_a _big_b Ya _big_na
            (rem_1587 _big_a _big_b Xa Ya _big_na
              H1
              H2))
          (rem_69 _big_b _big_a Xa Ya _big_na
            (rem_1587 _big_a _big_b Xa Ya _big_na
              H1
              H2))).
Qed.

Lemma lem_define_alice_data_current : forall _big_a _big_b _big_nb Xb Yb:term, auto_knows_current (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_current _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) -> auto_alice_data_current _big_a (xa_current _big_a _big_b) (ya_current _big_a _big_b) Xb Yb.
Proof.
   intros _big_a _big_b _big_nb Xb Yb. intros H1.
  exact (rem_2283 _big_a (xa_current _big_a _big_b) (ya_current _big_a _big_b) Xb Yb
          (rem_799 _big_a _big_b _big_nb Yb Xb
            (rem_365 _big_a _big_b _big_nb Yb Xb
              H1))
          (rem_527 Yb _big_a _big_b _big_nb Xb
            (rem_365 _big_a _big_b _big_nb Yb Xb
              H1))
          (rem_1201 _big_a _big_b _big_nb Yb Xb
            (rem_365 _big_a _big_b _big_nb Yb Xb
              H1))
          (rem_1378 Xb _big_a _big_b _big_nb Yb
            (rem_365 _big_a _big_b _big_nb Yb Xb
              H1))
          (rem_460 _big_a _big_b _big_nb Yb Xb
            (rem_365 _big_a _big_b _big_nb Yb Xb
              H1))).
Qed.

Lemma lem_message3_current : forall _big_a _big_b _big_nb Xb Yb:term, auto_knows_current (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_current _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) -> auto_knows_current (cons _big_a (cons (crypt (cons _big_b _big_nb) (key prv _big_a)) nil)).
Proof.
   intros _big_a _big_b _big_nb Xb Yb. intros H1.
  exact (rem_2421 _big_a (cons (crypt (cons _big_b _big_nb) (key prv _big_a)) nil)
          (rem_1752 (crypt (cons _big_b _big_nb) (key prv _big_a)) nil
            rem_1202
            (rem_1190 (cons _big_b _big_nb) (key prv _big_a)
              (rem_534 prv _big_a
                (rem_460 _big_a _big_b _big_nb Yb Xb
                  (rem_365 _big_a _big_b _big_nb Yb Xb
                    H1))
                rem_467)
              (rem_1735 _big_b _big_nb _big_a Yb Xb
                (rem_365 _big_a _big_b _big_nb Yb Xb
                  H1))))
          (rem_460 _big_a _big_b _big_nb Yb Xb
            (rem_365 _big_a _big_b _big_nb Yb Xb
              H1))).
Qed.

Lemma lem_message2_current : forall _big_a _big_b _big_na Xa Ya:term, auto_knows_current (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) -> auto_knows_current (cons _big_b (cons (crypt (cons (nonceb_current _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_current _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_current _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))) (key prv _big_b)) nil)).
Proof.
   intros _big_a _big_b _big_na Xa Ya. intros H1.
  exact (rem_2899 _big_b (cons (crypt (cons (nonceb_current _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_current _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_current _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))) (key prv _big_b)) nil)
          (rem_1177 (crypt (cons (nonceb_current _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_current _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_current _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))) (key prv _big_b)) nil
            rem_1320
            (rem_1297 (cons (nonceb_current _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_current _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_current _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))) (key prv _big_b)
              (rem_1183 prv _big_b
                (rem_1725 _big_b _big_a Xa Ya _big_na
                  (rem_1143 _big_a _big_b Xa Ya _big_na
                    H1))
                rem_1379)
              (rem_1400 (nonceb_current _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_current _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_current _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))
                (rem_386 _big_a (cons _big_na (cons (xb_current _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_current _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil)))
                  (rem_439 _big_na (cons (xb_current _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_current _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))
                    (rem_806 (xb_current _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_current _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil)
                      (rem_670 (crypt (yb_current _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil
                        rem_1320
                        (rem_40 (yb_current _big_a _big_b _big_na Xa Ya) (key pub _big_a)
                          (rem_1290 pub _big_a
                            (rem_1619 _big_a _big_b Xa Ya _big_na
                              (rem_1143 _big_a _big_b Xa Ya _big_na
                                H1))
                            rem_1213)
                          (rem_758 _big_a _big_b _big_na Xa Ya
                            (rem_1143 _big_a _big_b Xa Ya _big_na
                              H1))))
                      (rem_1318 _big_a _big_b _big_na Xa Ya
                        (rem_1143 _big_a _big_b Xa Ya _big_na
                          H1)))
                    (rem_1707 _big_na _big_a _big_b Xa Ya
                      (rem_1143 _big_a _big_b Xa Ya _big_na
                        H1)))
                  (rem_1619 _big_a _big_b Xa Ya _big_na
                    (rem_1143 _big_a _big_b Xa Ya _big_na
                      H1)))
                (rem_1219 _big_a _big_b _big_na Xa Ya
                  (rem_1143 _big_a _big_b Xa Ya _big_na
                    H1)))))
          (rem_1725 _big_b _big_a Xa Ya _big_na
            (rem_1143 _big_a _big_b Xa Ya _big_na
              H1))).
Qed.

Lemma lem_message1_current : forall _big_a _big_b:term, auto_agent _big_b -> auto_agent _big_a -> auto_knows_current (cons _big_a (cons (crypt (cons (noncea_current _big_a _big_b) (cons _big_b (cons (xa_current _big_a _big_b) (cons (crypt (ya_current _big_a _big_b) (key pub _big_b)) nil)))) (key prv _big_a)) nil)).
Proof.
   intros _big_a _big_b. intros H1 H2.
  exact (rem_2221 _big_a (cons (crypt (cons (noncea_current _big_a _big_b) (cons _big_b (cons (xa_current _big_a _big_b) (cons (crypt (ya_current _big_a _big_b) (key pub _big_b)) nil)))) (key prv _big_a)) nil)
          (rem_1303 (crypt (cons (noncea_current _big_a _big_b) (cons _big_b (cons (xa_current _big_a _big_b) (cons (crypt (ya_current _big_a _big_b) (key pub _big_b)) nil)))) (key prv _big_a)) nil
            rem_664
            (rem_985 (cons (noncea_current _big_a _big_b) (cons _big_b (cons (xa_current _big_a _big_b) (cons (crypt (ya_current _big_a _big_b) (key pub _big_b)) nil)))) (key prv _big_a)
              (rem_61 prv _big_a
                H2
                rem_1191)
              (rem_446 (noncea_current _big_a _big_b) (cons _big_b (cons (xa_current _big_a _big_b) (cons (crypt (ya_current _big_a _big_b) (key pub _big_b)) nil)))
                (rem_466 _big_b (cons (xa_current _big_a _big_b) (cons (crypt (ya_current _big_a _big_b) (key pub _big_b)) nil))
                  (rem_54 (xa_current _big_a _big_b) (cons (crypt (ya_current _big_a _big_b) (key pub _big_b)) nil)
                    (rem_1150 (crypt (ya_current _big_a _big_b) (key pub _big_b)) nil
                      rem_664
                      (rem_820 (ya_current _big_a _big_b) (key pub _big_b)
                        (rem_1225 pub _big_b
                          H1
                          rem_1710)
                        (rem_993 _big_a _big_b
                          H1
                          H2)))
                    (rem_374 _big_a _big_b
                      H1
                      H2))
                  (rem_104 _big_b
                    H1))
                (rem_994 _big_a _big_b
                  H1
                  H2))))
          (rem_569 _big_a
            H2)).
Qed.

Lemma lem_intruder_can_compute_predecessors_current : forall _big_m:term, auto_knows_current (s _big_m) -> auto_knows_current _big_m.
Proof.
   intros _big_m. intros H1.
  exact (rem_2424 _big_m
          H1).
Qed.

Lemma lem_intruder_can_compute_successors_current : forall _big_m:term, auto_knows_current _big_m -> auto_knows_current (s _big_m).
Proof.
   intros _big_m. intros H1.
  exact (rem_2614 _big_m
          H1).
Qed.

Lemma lem_intruder_can_decrypt_if_has_symmetric_key_current : forall _big_m X:term, auto_knows_current (crypt _big_m (key sym X)) -> auto_knows_current (key sym X) -> auto_knows_current _big_m.
Proof.
   intros _big_m X. intros H1 H2.
  exact (rem_1794 _big_m X
          (rem_789 _big_m X
            H1)
          (rem_1208 X
            H2)).
Qed.

Lemma lem_intruder_can_decrypt_if_has_public_key_current : forall _big_k _big_m:term, auto_knows_current (crypt _big_m (key prv _big_k)) -> auto_knows_current (key pub _big_k) -> auto_knows_current _big_m.
Proof.
   intros _big_k _big_m. intros H1 H2.
  exact (rem_2579 _big_m _big_k
          (rem_1787 _big_k _big_m
            H1)
          (rem_1743 _big_k
            H2)).
Qed.

Lemma lem_intruder_can_decrypt_if_has_private_key_current : forall _big_k _big_m:term, auto_knows_current (crypt _big_m (key pub _big_k)) -> auto_knows_current (key prv _big_k) -> auto_knows_current _big_m.
Proof.
   intros _big_k _big_m. intros H1 H2.
  exact (rem_2627 _big_m _big_k
          (rem_1272 _big_k _big_m
            H1)
          (rem_1160 _big_k
            H2)).
Qed.

Lemma lem_intruder_can_encrypt_current : forall _big_k _big_m:term, auto_knows_current _big_m -> auto_knows_current _big_k -> auto_knows_current (crypt _big_m _big_k).
Proof.
   intros _big_k _big_m. intros H1 H2.
  exact (rem_2428 _big_m _big_k
          H2
          H1).
Qed.

Lemma lem_intruder_can_build_pairs_current : forall _big_m1 _big_m2:term, auto_knows_current _big_m1 -> auto_knows_current _big_m2 -> auto_knows_current (cons _big_m1 _big_m2).
Proof.
   intros _big_m1 _big_m2. intros H1 H2.
  exact (rem_2901 _big_m1 _big_m2
          H2
          H1).
Qed.

Lemma lem_intruder_can_take_second_components_current : forall _big_m1 _big_m2:term, auto_knows_current (cons _big_m1 _big_m2) -> auto_knows_current _big_m2.
Proof.
   intros _big_m1 _big_m2. intros H1.
  exact (rem_2286 _big_m2 _big_m1
          H1).
Qed.

Lemma lem_intruder_can_take_first_components_current : forall _big_m1 _big_m2:term, auto_knows_current (cons _big_m1 _big_m2) -> auto_knows_current _big_m1.
Proof.
   intros _big_m1 _big_m2. intros H1.
  exact (rem_2619 _big_m1 _big_m2
          H1).
Qed.

Lemma lem_intruder_knows_nil_current : auto_knows_current nil.
Proof.
  
  exact rem_2429.
Qed.

Lemma lem_intruder_knows_all_previous_yb : forall _big_a _big_b _big_na Xa Ya:term, auto_knows_current (yb_old _big_a _big_b _big_na Xa Ya).
Proof.
   intros _big_a _big_b _big_na Xa Ya.
  exact (rem_1790 _big_a _big_b _big_na Xa Ya).
Qed.

Lemma lem_intruder_knows_all_previous_xb : forall _big_a _big_b _big_na Xa Ya:term, auto_knows_current (xb_old _big_a _big_b _big_na Xa Ya).
Proof.
   intros _big_a _big_b _big_na Xa Ya.
  exact (rem_2628 _big_a _big_b _big_na Xa Ya).
Qed.

Lemma lem_intruder_knows_all_previous_ya : forall _big_a _big_b:term, auto_knows_current (ya_old _big_a _big_b).
Proof.
   intros _big_a _big_b.
  exact (rem_2284 _big_a _big_b).
Qed.

Lemma lem_intruder_knows_all_previous_xa : forall _big_a _big_b:term, auto_knows_current (xa_old _big_a _big_b).
Proof.
   intros _big_a _big_b.
  exact (rem_2612 _big_a _big_b).
Qed.

Lemma lem_intruder_knows_all_previous_nonceb : forall _big_a _big_b _big_na Xa Ya:term, auto_knows_current (nonceb_old _big_a _big_b _big_na Xa Ya).
Proof.
   intros _big_a _big_b _big_na Xa Ya.
  exact (rem_2790 _big_a _big_b _big_na Xa Ya).
Qed.

Lemma lem_intruder_knows_all_previous_noncea : forall _big_a _big_b:term, auto_knows_current (noncea_old _big_a _big_b).
Proof.
   intros _big_a _big_b.
  exact (rem_2713 _big_a _big_b).
Qed.

Lemma lem_intruder_knows_all_previous_session_keys : forall _big_a _big_b _big_na:term, auto_knows_current (key sym (session_old _big_a _big_b _big_na)).
Proof.
   intros _big_a _big_b _big_na.
  exact (rem_2625 sym (session_old _big_a _big_b _big_na)
          (rem_1144 _big_a _big_b _big_na)
          rem_1151).
Qed.

Lemma lem_intruder_remembers : forall _big_m:term, auto_knows_old _big_m -> auto_knows_current _big_m.
Proof.
   intros _big_m. intros H1.
  exact (rem_1863 _big_m
          H1).
Qed.

Lemma lem_define_bob_data_old : forall _big_a _big_b _big_na Xa Ya:term, auto_knows_old (cons _big_a (cons (crypt (cons _big_b (cons (nonceb_old _big_a _big_b _big_na Xa Ya) nil)) (key prv _big_a)) nil)) -> auto_knows_old (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) -> auto_bob_data_old _big_b (xb_old _big_a _big_b _big_na Xa Ya) (yb_old _big_a _big_b _big_na Xa Ya) Xa Ya.
Proof.
   intros _big_a _big_b _big_na Xa Ya. intros H1 H2.
  exact (rem_2433 _big_b (xb_old _big_a _big_b _big_na Xa Ya) (yb_old _big_a _big_b _big_na Xa Ya) Xa Ya
          (rem_1709 _big_a _big_b _big_na Xa Ya
            (rem_1212 _big_a _big_b Xa Ya _big_na
              H1
              H2))
          (rem_1745 Ya _big_a _big_b Xa _big_na
            (rem_1212 _big_a _big_b Xa Ya _big_na
              H1
              H2))
          (rem_791 _big_a _big_b _big_na Xa Ya
            (rem_1212 _big_a _big_b Xa Ya _big_na
              H1
              H2))
          (rem_947 Xa _big_a _big_b Ya _big_na
            (rem_1212 _big_a _big_b Xa Ya _big_na
              H1
              H2))
          (rem_468 _big_b _big_a Xa Ya _big_na
            (rem_1212 _big_a _big_b Xa Ya _big_na
              H1
              H2))).
Qed.

Lemma lem_define_alice_data_old : forall _big_a _big_b _big_nb Xb Yb:term, auto_knows_old (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_old _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) -> auto_alice_data_old _big_a (xa_old _big_a _big_b) (ya_old _big_a _big_b) Xb Yb.
Proof.
   intros _big_a _big_b _big_nb Xb Yb. intros H1.
  exact (rem_2225 _big_a (xa_old _big_a _big_b) (ya_old _big_a _big_b) Xb Yb
          (rem_2 _big_a _big_b _big_nb Yb Xb
            (rem_941 _big_a _big_b _big_nb Yb Xb
              H1))
          (rem_373 Yb _big_a _big_b _big_nb Xb
            (rem_941 _big_a _big_b _big_nb Yb Xb
              H1))
          (rem_1161 _big_a _big_b _big_nb Yb Xb
            (rem_941 _big_a _big_b _big_nb Yb Xb
              H1))
          (rem_62 Xb _big_a _big_b _big_nb Yb
            (rem_941 _big_a _big_b _big_nb Yb Xb
              H1))
          (rem_709 _big_a _big_b _big_nb Yb Xb
            (rem_941 _big_a _big_b _big_nb Yb Xb
              H1))).
Qed.

Lemma lem_message3_old : forall _big_a _big_b _big_nb Xb Yb:term, auto_knows_old (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_old _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) -> auto_knows_old (cons _big_a (cons (crypt (cons _big_b _big_nb) (key prv _big_a)) nil)).
Proof.
   intros _big_a _big_b _big_nb Xb Yb. intros H1.
  exact (rem_2003 _big_a (cons (crypt (cons _big_b _big_nb) (key prv _big_a)) nil)
          (rem_1407 (crypt (cons _big_b _big_nb) (key prv _big_a)) nil
            rem_1393
            (rem_1168 (cons _big_b _big_nb) (key prv _big_a)
              (rem_1198 prv _big_a
                (rem_709 _big_a _big_b _big_nb Yb Xb
                  (rem_941 _big_a _big_b _big_nb Yb Xb
                    H1))
                rem_1708)
              (rem_1006 _big_b _big_nb _big_a Yb Xb
                (rem_941 _big_a _big_b _big_nb Yb Xb
                  H1))))
          (rem_709 _big_a _big_b _big_nb Yb Xb
            (rem_941 _big_a _big_b _big_nb Yb Xb
              H1))).
Qed.

Lemma lem_message2_old : forall _big_a _big_b _big_na Xa Ya:term, auto_knows_old (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) -> auto_knows_old (cons _big_b (cons (crypt (cons (nonceb_old _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_old _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_old _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))) (key prv _big_b)) nil)).
Proof.
   intros _big_a _big_b _big_na Xa Ya. intros H1.
  exact (rem_2112 _big_b (cons (crypt (cons (nonceb_old _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_old _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_old _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))) (key prv _big_b)) nil)
          (rem_9 (crypt (cons (nonceb_old _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_old _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_old _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))) (key prv _big_b)) nil
            rem_433
            (rem_381 (cons (nonceb_old _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_old _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_old _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))) (key prv _big_b)
              (rem_1309 prv _big_b
                (rem_1392 _big_b _big_a Xa Ya _big_na
                  (rem_663 _big_a _big_b Xa Ya _big_na
                    H1))
                rem_11)
              (rem_541 (nonceb_old _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_old _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_old _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))
                (rem_1156 _big_a (cons _big_na (cons (xb_old _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_old _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil)))
                  (rem_1661 _big_na (cons (xb_old _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_old _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))
                    (rem_1594 (xb_old _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_old _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil)
                      (rem_1741 (crypt (yb_old _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil
                        rem_433
                        (rem_992 (yb_old _big_a _big_b _big_na Xa Ya) (key pub _big_a)
                          (rem_47 pub _big_a
                            (rem_432 _big_a _big_b Xa Ya _big_na
                              (rem_663 _big_a _big_b Xa Ya _big_na
                                H1))
                            rem_814)
                          (rem_1313 _big_a _big_b _big_na Xa Ya
                            (rem_663 _big_a _big_b Xa Ya _big_na
                              H1))))
                      (rem_1171 _big_a _big_b _big_na Xa Ya
                        (rem_663 _big_a _big_b Xa Ya _big_na
                          H1)))
                    (rem_1655 _big_na _big_a _big_b Xa Ya
                      (rem_663 _big_a _big_b Xa Ya _big_na
                        H1)))
                  (rem_432 _big_a _big_b Xa Ya _big_na
                    (rem_663 _big_a _big_b Xa Ya _big_na
                      H1)))
                (rem_997 _big_a _big_b _big_na Xa Ya
                  (rem_663 _big_a _big_b Xa Ya _big_na
                    H1)))))
          (rem_1392 _big_b _big_a Xa Ya _big_na
            (rem_663 _big_a _big_b Xa Ya _big_na
              H1))).
Qed.

Lemma lem_message1_old : forall _big_a _big_b:term, auto_agent _big_b -> auto_agent _big_a -> auto_knows_old (cons _big_a (cons (crypt (cons (noncea_old _big_a _big_b) (cons _big_b (cons (xa_old _big_a _big_b) (cons (crypt (ya_old _big_a _big_b) (key pub _big_b)) nil)))) (key prv _big_a)) nil)).
Proof.
   intros _big_a _big_b. intros H1 H2.
  exact (rem_2712 _big_a (cons (crypt (cons (noncea_old _big_a _big_b) (cons _big_b (cons (xa_old _big_a _big_b) (cons (crypt (ya_old _big_a _big_b) (key pub _big_b)) nil)))) (key prv _big_a)) nil)
          (rem_1237 (crypt (cons (noncea_old _big_a _big_b) (cons _big_b (cons (xa_old _big_a _big_b) (cons (crypt (ya_old _big_a _big_b) (key pub _big_b)) nil)))) (key prv _big_a)) nil
            rem_664
            (rem_813 (cons (noncea_old _big_a _big_b) (cons _big_b (cons (xa_old _big_a _big_b) (cons (crypt (ya_old _big_a _big_b) (key pub _big_b)) nil)))) (key prv _big_a)
              (rem_61 prv _big_a
                H2
                rem_1191)
              (rem_393 (noncea_old _big_a _big_b) (cons _big_b (cons (xa_old _big_a _big_b) (cons (crypt (ya_old _big_a _big_b) (key pub _big_b)) nil)))
                (rem_946 _big_b (cons (xa_old _big_a _big_b) (cons (crypt (ya_old _big_a _big_b) (key pub _big_b)) nil))
                  (rem_372 (xa_old _big_a _big_b) (cons (crypt (ya_old _big_a _big_b) (key pub _big_b)) nil)
                    (rem_954 (crypt (ya_old _big_a _big_b) (key pub _big_b)) nil
                      rem_664
                      (rem_1231 (ya_old _big_a _big_b) (key pub _big_b)
                        (rem_1225 pub _big_b
                          H1
                          rem_1710)
                        (rem_1736 _big_a _big_b
                          H1
                          H2)))
                    (rem_955 _big_a _big_b
                      H1
                      H2))
                  (rem_104 _big_b
                    H1))
                (rem_67 _big_a _big_b
                  H1
                  H2))))
          (rem_569 _big_a
            H2)).
Qed.

Lemma lem_intruder_can_compute_predecessors_old : forall _big_m:term, auto_knows_old (s _big_m) -> auto_knows_old _big_m.
Proof.
   intros _big_m. intros H1.
  exact (rem_2615 _big_m
          H1).
Qed.

Lemma lem_intruder_can_compute_successors_old : forall _big_m:term, auto_knows_old _big_m -> auto_knows_old (s _big_m).
Proof.
   intros _big_m. intros H1.
  exact (rem_2617 _big_m
          H1).
Qed.

Lemma lem_intruder_can_decrypt_if_has_symmetric_key_old : forall _big_m X:term, auto_knows_old (crypt _big_m (key sym X)) -> auto_knows_old (key sym X) -> auto_knows_old _big_m.
Proof.
   intros _big_m X. intros H1 H2.
  exact (rem_1789 _big_m X
          (rem_33 _big_m X
            H1)
          (rem_1744 X
            H2)).
Qed.

Lemma lem_intruder_can_decrypt_if_has_public_key_old : forall _big_k _big_m:term, auto_knows_old (crypt _big_m (key prv _big_k)) -> auto_knows_old (key pub _big_k) -> auto_knows_old _big_m.
Proof.
   intros _big_k _big_m. intros H1 H2.
  exact (rem_2264 _big_m _big_k
          (rem_980 _big_k _big_m
            H1)
          (rem_1209 _big_k
            H2)).
Qed.

Lemma lem_intruder_can_decrypt_if_has_private_key_old : forall _big_k _big_m:term, auto_knows_old (crypt _big_m (key pub _big_k)) -> auto_knows_old (key prv _big_k) -> auto_knows_old _big_m.
Proof.
   intros _big_k _big_m. intros H1 H2.
  exact (rem_1869 _big_m _big_k
          (rem_1283 _big_k _big_m
            H1)
          (rem_1238 _big_k
            H2)).
Qed.

Lemma lem_intruder_can_encrypt_old : forall _big_k _big_m:term, auto_knows_old _big_m -> auto_knows_old _big_k -> auto_knows_old (crypt _big_m _big_k).
Proof.
   intros _big_k _big_m. intros H1 H2.
  exact (rem_2268 _big_m _big_k
          H2
          H1).
Qed.

Lemma lem_intruder_can_build_pairs_old : forall _big_m1 _big_m2:term, auto_knows_old _big_m1 -> auto_knows_old _big_m2 -> auto_knows_old (cons _big_m1 _big_m2).
Proof.
   intros _big_m1 _big_m2. intros H1 H2.
  exact (rem_2900 _big_m1 _big_m2
          H2
          H1).
Qed.

Lemma lem_intruder_can_take_second_components_old : forall _big_m1 _big_m2:term, auto_knows_old (cons _big_m1 _big_m2) -> auto_knows_old _big_m2.
Proof.
   intros _big_m1 _big_m2. intros H1.
  exact (rem_2422 _big_m2 _big_m1
          H1).
Qed.

Lemma lem_intruder_can_take_first_components_old : forall _big_m1 _big_m2:term, auto_knows_old (cons _big_m1 _big_m2) -> auto_knows_old _big_m1.
Proof.
   intros _big_m1 _big_m2. intros H1.
  exact (rem_1799 _big_m1 _big_m2
          H1).
Qed.

Lemma lem_intruder_knows_nil_old : auto_knows_old nil.
Proof.
  
  exact rem_2222.
Qed.

Lemma lem_intruder_agent : auto_agent i.
Proof.
  
  exact rem_1795.
Qed.

Lemma lem_server_agent : auto_agent server.
Proof.
  
  exact rem_2287.
Qed.

Lemma lem_bob_agent : auto_agent bob.
Proof.
  
  exact rem_2430.
Qed.

Lemma lem_alice_agent : auto_agent alice.
Proof.
  
  exact rem_2580.
Qed.


(* [srcc] Source clauses. *)

Inductive __query__intruder_knows_ya_as_seen_by_alice : Prop :=
    intruder_knows_ya_as_seen_by_alice : forall Xa Xb Ya Yb:term, knows_current Ya -> alice_data_current alice Xa Ya Xb Yb -> __query__intruder_knows_ya_as_seen_by_alice

with __query__intruder_knows_ya_as_seen_by_bob : Prop :=
    intruder_knows_ya_as_seen_by_bob : forall Xa Xb Ya Yb:term, knows_current Ya -> bob_data_current bob Xb Yb Xa Ya -> __query__intruder_knows_ya_as_seen_by_bob

with __query__intruder_knows_yb_as_seen_by_alice : Prop :=
    intruder_knows_yb_as_seen_by_alice : forall Xa Xb Ya Yb:term, knows_current Yb -> alice_data_current alice Xa Ya Xb Yb -> __query__intruder_knows_yb_as_seen_by_alice

with __query__intruder_knows_yb_as_seen_by_bob : Prop :=
    intruder_knows_yb_as_seen_by_bob : forall Xa Xb Ya Yb:term, knows_current Yb -> bob_data_current bob Xb Yb Xa Ya -> __query__intruder_knows_yb_as_seen_by_bob

with agent : term -> Prop :=
    alice_agent : agent alice
  | bob_agent : agent bob
  | intruder_agent : agent i
  | server_agent : agent server

with alice_data_current : term -> term -> term -> term -> term -> Prop :=
    define_alice_data_current : forall _big_a _big_b _big_nb Xb Yb:term, knows_current (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_current _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) -> alice_data_current _big_a (xa_current _big_a _big_b) (ya_current _big_a _big_b) Xb Yb

with alice_data_old : term -> term -> term -> term -> term -> Prop :=
    define_alice_data_old : forall _big_a _big_b _big_nb Xb Yb:term, knows_old (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_old _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) -> alice_data_old _big_a (xa_old _big_a _big_b) (ya_old _big_a _big_b) Xb Yb

with bob_data_current : term -> term -> term -> term -> term -> Prop :=
    define_bob_data_current : forall _big_a _big_b _big_na Xa Ya:term, knows_current (cons _big_a (cons (crypt (cons _big_b (cons (nonceb_current _big_a _big_b _big_na Xa Ya) nil)) (key prv _big_a)) nil)) -> knows_current (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) -> bob_data_current _big_b (xb_current _big_a _big_b _big_na Xa Ya) (yb_current _big_a _big_b _big_na Xa Ya) Xa Ya

with bob_data_old : term -> term -> term -> term -> term -> Prop :=
    define_bob_data_old : forall _big_a _big_b _big_na Xa Ya:term, knows_old (cons _big_a (cons (crypt (cons _big_b (cons (nonceb_old _big_a _big_b _big_na Xa Ya) nil)) (key prv _big_a)) nil)) -> knows_old (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) -> bob_data_old _big_b (xb_old _big_a _big_b _big_na Xa Ya) (yb_old _big_a _big_b _big_na Xa Ya) Xa Ya

with knows_current : term -> Prop :=
    intruder_can_build_pairs_current : forall _big_m1 _big_m2:term, knows_current _big_m1 -> knows_current _big_m2 -> knows_current (cons _big_m1 _big_m2)
  | intruder_can_compute_predecessors_current : forall _big_m:term, knows_current (s _big_m) -> knows_current _big_m
  | intruder_can_compute_successors_current : forall _big_m:term, knows_current _big_m -> knows_current (s _big_m)
  | intruder_can_decrypt_if_has_private_key_current : forall _big_k _big_m:term, knows_current (crypt _big_m (key pub _big_k)) -> knows_current (key prv _big_k) -> knows_current _big_m
  | intruder_can_decrypt_if_has_public_key_current : forall _big_k _big_m:term, knows_current (crypt _big_m (key prv _big_k)) -> knows_current (key pub _big_k) -> knows_current _big_m
  | intruder_can_decrypt_if_has_symmetric_key_current : forall _big_m X:term, knows_current (crypt _big_m (key sym X)) -> knows_current (key sym X) -> knows_current _big_m
  | intruder_can_encrypt_current : forall _big_k _big_m:term, knows_current _big_m -> knows_current _big_k -> knows_current (crypt _big_m _big_k)
  | intruder_can_take_first_components_current : forall _big_m1 _big_m2:term, knows_current (cons _big_m1 _big_m2) -> knows_current _big_m1
  | intruder_can_take_second_components_current : forall _big_m1 _big_m2:term, knows_current (cons _big_m1 _big_m2) -> knows_current _big_m2
  | intruder_knows_all_previous_noncea : forall _big_a _big_b:term, knows_current (noncea_old _big_a _big_b)
  | intruder_knows_all_previous_nonceb : forall _big_a _big_b _big_na Xa Ya:term, knows_current (nonceb_old _big_a _big_b _big_na Xa Ya)
  | intruder_knows_all_previous_session_keys : forall _big_a _big_b _big_na:term, knows_current (key sym (session_old _big_a _big_b _big_na))
  | intruder_knows_all_previous_xa : forall _big_a _big_b:term, knows_current (xa_old _big_a _big_b)
  | intruder_knows_all_previous_xb : forall _big_a _big_b _big_na Xa Ya:term, knows_current (xb_old _big_a _big_b _big_na Xa Ya)
  | intruder_knows_all_previous_ya : forall _big_a _big_b:term, knows_current (ya_old _big_a _big_b)
  | intruder_knows_all_previous_yb : forall _big_a _big_b _big_na Xa Ya:term, knows_current (yb_old _big_a _big_b _big_na Xa Ya)
  | intruder_knows_nil_current : knows_current nil
  | intruder_remembers : forall _big_m:term, knows_old _big_m -> knows_current _big_m
  | message1_current : forall _big_a _big_b:term, agent _big_b -> agent _big_a -> knows_current (cons _big_a (cons (crypt (cons (noncea_current _big_a _big_b) (cons _big_b (cons (xa_current _big_a _big_b) (cons (crypt (ya_current _big_a _big_b) (key pub _big_b)) nil)))) (key prv _big_a)) nil))
  | message2_current : forall _big_a _big_b _big_na Xa Ya:term, knows_current (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) -> knows_current (cons _big_b (cons (crypt (cons (nonceb_current _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_current _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_current _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))) (key prv _big_b)) nil))
  | message3_current : forall _big_a _big_b _big_nb Xb Yb:term, knows_current (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_current _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) -> knows_current (cons _big_a (cons (crypt (cons _big_b _big_nb) (key prv _big_a)) nil))

with knows_old : term -> Prop :=
    intruder_can_build_pairs_old : forall _big_m1 _big_m2:term, knows_old _big_m1 -> knows_old _big_m2 -> knows_old (cons _big_m1 _big_m2)
  | intruder_can_compute_predecessors_old : forall _big_m:term, knows_old (s _big_m) -> knows_old _big_m
  | intruder_can_compute_successors_old : forall _big_m:term, knows_old _big_m -> knows_old (s _big_m)
  | intruder_can_decrypt_if_has_private_key_old : forall _big_k _big_m:term, knows_old (crypt _big_m (key pub _big_k)) -> knows_old (key prv _big_k) -> knows_old _big_m
  | intruder_can_decrypt_if_has_public_key_old : forall _big_k _big_m:term, knows_old (crypt _big_m (key prv _big_k)) -> knows_old (key pub _big_k) -> knows_old _big_m
  | intruder_can_decrypt_if_has_symmetric_key_old : forall _big_m X:term, knows_old (crypt _big_m (key sym X)) -> knows_old (key sym X) -> knows_old _big_m
  | intruder_can_encrypt_old : forall _big_k _big_m:term, knows_old _big_m -> knows_old _big_k -> knows_old (crypt _big_m _big_k)
  | intruder_can_take_first_components_old : forall _big_m1 _big_m2:term, knows_old (cons _big_m1 _big_m2) -> knows_old _big_m1
  | intruder_can_take_second_components_old : forall _big_m1 _big_m2:term, knows_old (cons _big_m1 _big_m2) -> knows_old _big_m2
  | intruder_knows_nil_old : knows_old nil
  | message1_old : forall _big_a _big_b:term, agent _big_b -> agent _big_a -> knows_old (cons _big_a (cons (crypt (cons (noncea_old _big_a _big_b) (cons _big_b (cons (xa_old _big_a _big_b) (cons (crypt (ya_old _big_a _big_b) (key pub _big_b)) nil)))) (key prv _big_a)) nil))
  | message2_old : forall _big_a _big_b _big_na Xa Ya:term, knows_old (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) -> knows_old (cons _big_b (cons (crypt (cons (nonceb_old _big_a _big_b _big_na Xa Ya) (cons _big_a (cons _big_na (cons (xb_old _big_a _big_b _big_na Xa Ya) (cons (crypt (yb_old _big_a _big_b _big_na Xa Ya) (key pub _big_a)) nil))))) (key prv _big_b)) nil))
  | message3_old : forall _big_a _big_b _big_nb Xb Yb:term, knows_old (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_old _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) -> knows_old (cons _big_a (cons (crypt (cons _big_b _big_nb) (key prv _big_a)) nil))
.

(* [srct] Translation from source clauses. *)

Definition translate_auto_agent_from_agent (x1 : term) (pi : agent x1) : auto_agent x1 :=
  match pi as pi in agent x1 return auto_agent x1 with
    (alice_agent) => 
      (lem_alice_agent)
  | (bob_agent) => 
      (lem_bob_agent)
  | (intruder_agent) => 
      (lem_intruder_agent)
  | (server_agent) => 
      (lem_server_agent)
  end
.
Fixpoint translate_auto_knows_old_from_knows_old (x1 : term) (pi : knows_old x1) {struct pi} : auto_knows_old x1 :=
  match pi as pi in knows_old x1 return auto_knows_old x1 with
    (intruder_can_build_pairs_old _big_m1 _big_m2 H1 H2) => 
      (lem_intruder_can_build_pairs_old _big_m1 _big_m2
        (translate_auto_knows_old_from_knows_old _big_m1 H1)
        (translate_auto_knows_old_from_knows_old _big_m2 H2))
  | (intruder_can_compute_predecessors_old _big_m H1) => 
      (lem_intruder_can_compute_predecessors_old _big_m
        (translate_auto_knows_old_from_knows_old (s _big_m) H1))
  | (intruder_can_compute_successors_old _big_m H1) => 
      (lem_intruder_can_compute_successors_old _big_m
        (translate_auto_knows_old_from_knows_old _big_m H1))
  | (intruder_can_decrypt_if_has_private_key_old _big_k _big_m H1 H2) => 
      (lem_intruder_can_decrypt_if_has_private_key_old _big_k _big_m
        (translate_auto_knows_old_from_knows_old (crypt _big_m (key pub _big_k)) H1)
        (translate_auto_knows_old_from_knows_old (key prv _big_k) H2))
  | (intruder_can_decrypt_if_has_public_key_old _big_k _big_m H1 H2) => 
      (lem_intruder_can_decrypt_if_has_public_key_old _big_k _big_m
        (translate_auto_knows_old_from_knows_old (crypt _big_m (key prv _big_k)) H1)
        (translate_auto_knows_old_from_knows_old (key pub _big_k) H2))
  | (intruder_can_decrypt_if_has_symmetric_key_old _big_m X H1 H2) => 
      (lem_intruder_can_decrypt_if_has_symmetric_key_old _big_m X
        (translate_auto_knows_old_from_knows_old (crypt _big_m (key sym X)) H1)
        (translate_auto_knows_old_from_knows_old (key sym X) H2))
  | (intruder_can_encrypt_old _big_k _big_m H1 H2) => 
      (lem_intruder_can_encrypt_old _big_k _big_m
        (translate_auto_knows_old_from_knows_old _big_m H1)
        (translate_auto_knows_old_from_knows_old _big_k H2))
  | (intruder_can_take_first_components_old _big_m1 _big_m2 H1) => 
      (lem_intruder_can_take_first_components_old _big_m1 _big_m2
        (translate_auto_knows_old_from_knows_old (cons _big_m1 _big_m2) H1))
  | (intruder_can_take_second_components_old _big_m1 _big_m2 H1) => 
      (lem_intruder_can_take_second_components_old _big_m1 _big_m2
        (translate_auto_knows_old_from_knows_old (cons _big_m1 _big_m2) H1))
  | (intruder_knows_nil_old) => 
      (lem_intruder_knows_nil_old)
  | (message1_old _big_a _big_b H1 H2) => 
      (lem_message1_old _big_a _big_b
        (translate_auto_agent_from_agent _big_b H1)
        (translate_auto_agent_from_agent _big_a H2))
  | (message2_old _big_a _big_b _big_na Xa Ya H1) => 
      (lem_message2_old _big_a _big_b _big_na Xa Ya
        (translate_auto_knows_old_from_knows_old (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) H1))
  | (message3_old _big_a _big_b _big_nb Xb Yb H1) => 
      (lem_message3_old _big_a _big_b _big_nb Xb Yb
        (translate_auto_knows_old_from_knows_old (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_old _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) H1))
  end
.
Fixpoint translate_auto_knows_current_from_knows_current (x1 : term) (pi : knows_current x1) {struct pi} : auto_knows_current x1 :=
  match pi as pi in knows_current x1 return auto_knows_current x1 with
    (intruder_can_build_pairs_current _big_m1 _big_m2 H1 H2) => 
      (lem_intruder_can_build_pairs_current _big_m1 _big_m2
        (translate_auto_knows_current_from_knows_current _big_m1 H1)
        (translate_auto_knows_current_from_knows_current _big_m2 H2))
  | (intruder_can_compute_predecessors_current _big_m H1) => 
      (lem_intruder_can_compute_predecessors_current _big_m
        (translate_auto_knows_current_from_knows_current (s _big_m) H1))
  | (intruder_can_compute_successors_current _big_m H1) => 
      (lem_intruder_can_compute_successors_current _big_m
        (translate_auto_knows_current_from_knows_current _big_m H1))
  | (intruder_can_decrypt_if_has_private_key_current _big_k _big_m H1 H2) => 
      (lem_intruder_can_decrypt_if_has_private_key_current _big_k _big_m
        (translate_auto_knows_current_from_knows_current (crypt _big_m (key pub _big_k)) H1)
        (translate_auto_knows_current_from_knows_current (key prv _big_k) H2))
  | (intruder_can_decrypt_if_has_public_key_current _big_k _big_m H1 H2) => 
      (lem_intruder_can_decrypt_if_has_public_key_current _big_k _big_m
        (translate_auto_knows_current_from_knows_current (crypt _big_m (key prv _big_k)) H1)
        (translate_auto_knows_current_from_knows_current (key pub _big_k) H2))
  | (intruder_can_decrypt_if_has_symmetric_key_current _big_m X H1 H2) => 
      (lem_intruder_can_decrypt_if_has_symmetric_key_current _big_m X
        (translate_auto_knows_current_from_knows_current (crypt _big_m (key sym X)) H1)
        (translate_auto_knows_current_from_knows_current (key sym X) H2))
  | (intruder_can_encrypt_current _big_k _big_m H1 H2) => 
      (lem_intruder_can_encrypt_current _big_k _big_m
        (translate_auto_knows_current_from_knows_current _big_m H1)
        (translate_auto_knows_current_from_knows_current _big_k H2))
  | (intruder_can_take_first_components_current _big_m1 _big_m2 H1) => 
      (lem_intruder_can_take_first_components_current _big_m1 _big_m2
        (translate_auto_knows_current_from_knows_current (cons _big_m1 _big_m2) H1))
  | (intruder_can_take_second_components_current _big_m1 _big_m2 H1) => 
      (lem_intruder_can_take_second_components_current _big_m1 _big_m2
        (translate_auto_knows_current_from_knows_current (cons _big_m1 _big_m2) H1))
  | (intruder_knows_all_previous_noncea _big_a _big_b) => 
      (lem_intruder_knows_all_previous_noncea _big_a _big_b)
  | (intruder_knows_all_previous_nonceb _big_a _big_b _big_na Xa Ya) => 
      (lem_intruder_knows_all_previous_nonceb _big_a _big_b _big_na Xa Ya)
  | (intruder_knows_all_previous_session_keys _big_a _big_b _big_na) => 
      (lem_intruder_knows_all_previous_session_keys _big_a _big_b _big_na)
  | (intruder_knows_all_previous_xa _big_a _big_b) => 
      (lem_intruder_knows_all_previous_xa _big_a _big_b)
  | (intruder_knows_all_previous_xb _big_a _big_b _big_na Xa Ya) => 
      (lem_intruder_knows_all_previous_xb _big_a _big_b _big_na Xa Ya)
  | (intruder_knows_all_previous_ya _big_a _big_b) => 
      (lem_intruder_knows_all_previous_ya _big_a _big_b)
  | (intruder_knows_all_previous_yb _big_a _big_b _big_na Xa Ya) => 
      (lem_intruder_knows_all_previous_yb _big_a _big_b _big_na Xa Ya)
  | (intruder_knows_nil_current) => 
      (lem_intruder_knows_nil_current)
  | (intruder_remembers _big_m H1) => 
      (lem_intruder_remembers _big_m
        (translate_auto_knows_old_from_knows_old _big_m H1))
  | (message1_current _big_a _big_b H1 H2) => 
      (lem_message1_current _big_a _big_b
        (translate_auto_agent_from_agent _big_b H1)
        (translate_auto_agent_from_agent _big_a H2))
  | (message2_current _big_a _big_b _big_na Xa Ya H1) => 
      (lem_message2_current _big_a _big_b _big_na Xa Ya
        (translate_auto_knows_current_from_knows_current (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) H1))
  | (message3_current _big_a _big_b _big_nb Xb Yb H1) => 
      (lem_message3_current _big_a _big_b _big_nb Xb Yb
        (translate_auto_knows_current_from_knows_current (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_current _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) H1))
  end
.
Definition translate_auto_bob_data_current_from_bob_data_current (x1 : term) (x2 : term) (x3 : term) (x4 : term) (x5 : term) (pi : bob_data_current x1 x2 x3 x4 x5) : auto_bob_data_current x1 x2 x3 x4 x5 :=
  match pi as pi in bob_data_current x1 x2 x3 x4 x5 return auto_bob_data_current x1 x2 x3 x4 x5 with
    (define_bob_data_current _big_a _big_b _big_na Xa Ya H1 H2) => 
      (lem_define_bob_data_current _big_a _big_b _big_na Xa Ya
        (translate_auto_knows_current_from_knows_current (cons _big_a (cons (crypt (cons _big_b (cons (nonceb_current _big_a _big_b _big_na Xa Ya) nil)) (key prv _big_a)) nil)) H1)
        (translate_auto_knows_current_from_knows_current (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) H2))
  end
.
Definition translate_auto___query__intruder_knows_ya_as_seen_by_bob_from___query__intruder_knows_ya_as_seen_by_bob (pi : __query__intruder_knows_ya_as_seen_by_bob) : auto___query__intruder_knows_ya_as_seen_by_bob :=
  match pi  with
    (intruder_knows_ya_as_seen_by_bob Xa Xb Ya Yb H1 H2) => 
      (lem_intruder_knows_ya_as_seen_by_bob Xa Xb Ya Yb
        (translate_auto_knows_current_from_knows_current Ya H1)
        (translate_auto_bob_data_current_from_bob_data_current bob Xb Yb Xa Ya H2))
  end
.
Definition translate_auto_bob_data_old_from_bob_data_old (x1 : term) (x2 : term) (x3 : term) (x4 : term) (x5 : term) (pi : bob_data_old x1 x2 x3 x4 x5) : auto_bob_data_old x1 x2 x3 x4 x5 :=
  match pi as pi in bob_data_old x1 x2 x3 x4 x5 return auto_bob_data_old x1 x2 x3 x4 x5 with
    (define_bob_data_old _big_a _big_b _big_na Xa Ya H1 H2) => 
      (lem_define_bob_data_old _big_a _big_b _big_na Xa Ya
        (translate_auto_knows_old_from_knows_old (cons _big_a (cons (crypt (cons _big_b (cons (nonceb_old _big_a _big_b _big_na Xa Ya) nil)) (key prv _big_a)) nil)) H1)
        (translate_auto_knows_old_from_knows_old (cons _big_a (cons (crypt (cons _big_na (cons _big_b (cons Xa (cons (crypt Ya (key pub _big_b)) nil)))) (key prv _big_a)) nil)) H2))
  end
.
Definition translate_auto_alice_data_current_from_alice_data_current (x1 : term) (x2 : term) (x3 : term) (x4 : term) (x5 : term) (pi : alice_data_current x1 x2 x3 x4 x5) : auto_alice_data_current x1 x2 x3 x4 x5 :=
  match pi as pi in alice_data_current x1 x2 x3 x4 x5 return auto_alice_data_current x1 x2 x3 x4 x5 with
    (define_alice_data_current _big_a _big_b _big_nb Xb Yb H1) => 
      (lem_define_alice_data_current _big_a _big_b _big_nb Xb Yb
        (translate_auto_knows_current_from_knows_current (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_current _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) H1))
  end
.
Definition translate_auto___query__intruder_knows_ya_as_seen_by_alice_from___query__intruder_knows_ya_as_seen_by_alice (pi : __query__intruder_knows_ya_as_seen_by_alice) : auto___query__intruder_knows_ya_as_seen_by_alice :=
  match pi  with
    (intruder_knows_ya_as_seen_by_alice Xa Xb Ya Yb H1 H2) => 
      (lem_intruder_knows_ya_as_seen_by_alice Xa Xb Ya Yb
        (translate_auto_knows_current_from_knows_current Ya H1)
        (translate_auto_alice_data_current_from_alice_data_current alice Xa Ya Xb Yb H2))
  end
.
Definition translate_auto___query__intruder_knows_yb_as_seen_by_bob_from___query__intruder_knows_yb_as_seen_by_bob (pi : __query__intruder_knows_yb_as_seen_by_bob) : auto___query__intruder_knows_yb_as_seen_by_bob :=
  match pi  with
    (intruder_knows_yb_as_seen_by_bob Xa Xb Ya Yb H1 H2) => 
      (lem_intruder_knows_yb_as_seen_by_bob Xa Xb Ya Yb
        (translate_auto_knows_current_from_knows_current Yb H1)
        (translate_auto_bob_data_current_from_bob_data_current bob Xb Yb Xa Ya H2))
  end
.
Definition translate_auto_alice_data_old_from_alice_data_old (x1 : term) (x2 : term) (x3 : term) (x4 : term) (x5 : term) (pi : alice_data_old x1 x2 x3 x4 x5) : auto_alice_data_old x1 x2 x3 x4 x5 :=
  match pi as pi in alice_data_old x1 x2 x3 x4 x5 return auto_alice_data_old x1 x2 x3 x4 x5 with
    (define_alice_data_old _big_a _big_b _big_nb Xb Yb H1) => 
      (lem_define_alice_data_old _big_a _big_b _big_nb Xb Yb
        (translate_auto_knows_old_from_knows_old (cons _big_b (cons (crypt (cons _big_nb (cons _big_a (cons (noncea_old _big_a _big_b) (cons Xb (cons (crypt Yb (key pub _big_a)) nil))))) (key prv _big_b)) nil)) H1))
  end
.
Definition translate_auto___query__intruder_knows_yb_as_seen_by_alice_from___query__intruder_knows_yb_as_seen_by_alice (pi : __query__intruder_knows_yb_as_seen_by_alice) : auto___query__intruder_knows_yb_as_seen_by_alice :=
  match pi  with
    (intruder_knows_yb_as_seen_by_alice Xa Xb Ya Yb H1 H2) => 
      (lem_intruder_knows_yb_as_seen_by_alice Xa Xb Ya Yb
        (translate_auto_knows_current_from_knows_current Yb H1)
        (translate_auto_alice_data_current_from_alice_data_current alice Xa Ya Xb Yb H2))
  end
.


(* [conp] Consistency proofs. *)

Theorem thm_intruder_knows_ya_as_seen_by_alice : ~__query__intruder_knows_ya_as_seen_by_alice.
Proof.
  unfold not. intro H.
  elim (translate_auto___query__intruder_knows_ya_as_seen_by_alice_from___query__intruder_knows_ya_as_seen_by_alice H).
Qed.

Theorem thm_intruder_knows_ya_as_seen_by_bob : ~__query__intruder_knows_ya_as_seen_by_bob.
Proof.
  unfold not. intro H.
  elim (translate_auto___query__intruder_knows_ya_as_seen_by_bob_from___query__intruder_knows_ya_as_seen_by_bob H).
Qed.

Theorem thm_intruder_knows_yb_as_seen_by_alice : ~__query__intruder_knows_yb_as_seen_by_alice.
Proof.
  unfold not. intro H.
  elim (translate_auto___query__intruder_knows_yb_as_seen_by_alice_from___query__intruder_knows_yb_as_seen_by_alice H).
Qed.

Theorem thm_intruder_knows_yb_as_seen_by_bob : ~__query__intruder_knows_yb_as_seen_by_bob.
Proof.
  unfold not. intro H.
  elim (translate_auto___query__intruder_knows_yb_as_seen_by_bob_from___query__intruder_knows_yb_as_seen_by_bob H).
Qed.

