(* auto2pl, definitions.
   Copyright (C) 2003 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.

   This file is part of h1.

   h1 is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   h1 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with h1; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*)

type definition = |[ arg : string,
		     cond : string ]|;
type definitions = string -m> definition;
type states = string -m> string set; (* map state name to set of predicates that they satisfy. *)
type tables = string -m> int * (string list -m> string);
(* map function symbols to arity and table from state name lists to state names. *)
    
type xmodel = definitions * states * tables;

exception XmlUnterminatedCommentEvt;
exception EOFEncounteredEvt;

