

% h1 example: Paulson's corrected version of the Yahalom protocol (2001).
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

% run 'cpp -P yahalom.p >yhl.p'

cnf(alice_agent,axiom,
    (agent(alice))).
cnf(bob_agent,axiom,
    (agent(bob))).
cnf(server_agent,axiom,
    (agent(server))).
cnf(intruder_agent,axiom,
    (agent(i))).
% h1 example: Paulson's corrected version of the Yahalom protocol (2001).
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_old,axiom,
  (knows_old(nil))).
cnf(intruder_can_take_first_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M1))).
cnf(intruder_can_take_second_components_old,axiom,
  (~knows_old(cons(M1,M2)) | knows_old(M2))).
cnf(intruder_can_build_pairs_old,axiom,
  (~knows_old(M2) | ~knows_old(M1) | knows_old(cons(M1,M2)))).
cnf(intruder_can_encrypt_old,axiom,
  (~knows_old(K) | ~knows_old(M) | knows_old(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_old,axiom,
  (~knows_old(key(prv,K)) | ~knows_old(crypt(M,key(pub,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_public_key_old,axiom,
  (~knows_old(key(pub,K)) | ~knows_old(crypt(M,key(prv,K))) | knows_old(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_old,axiom,
  (~knows_old(key(sym,X)) | ~knows_old(crypt(M,key(sym,X))) | knows_old(M))).
cnf(intruder_can_compute_successors_old,axiom,
  (~knows_old(M) | knows_old(s(M)))).
cnf(intruder_can_compute_predecessors_old,axiom,
  (~knows_old(s(M)) | knows_old(M))).
%
% Ajout des clauses du protocole
%
%
 % 1. A -> B : A, Na
cnf(message1_old,axiom,
  (~agent(A)
  | knows_old(cons(A,cons(noncea_old(A),nil))))).
  % 2. B -> S : B, Nb, {A, Na}_{Kbs}
cnf(message2_old,axiom,
  (~knows_old(cons(A,cons(Na,nil)))
  | ~agent(B)
  | knows_old(cons(B,cons(nonceb_old(A,B,Na),
          cons(crypt(cons(A,cons(Na,nil)),
                     key(sym,cons(B,cons(server,nil)))),
               nil)))))).
 % 3. S -> A : Nb, {B, Kab, Na}_Kas, {A, B, Kab, Nb}_Kbs
cnf(message3_old,axiom,
  (~knows_old(cons(B,cons(Nb,
          cons(crypt(cons(A,cons(Na,nil)),
                     key(sym,cons(B,cons(server,nil)))),
               nil))))
  | knows_old(cons(Nb,
          cons(crypt(cons(B,
                     cons(key(sym,session_old(A,B,Na,Nb)),
       cons(Na,nil))),
                     key(sym,cons(A,cons(server,nil)))),
          cons(crypt(cons(A,cons(B,
                     cons(key(sym,session_old(A,B,Na,Nb)),
       cons(Nb,nil)))),
       key(sym,cons(B,cons(server,nil)))),
               nil)))))).
 % 4. A -> B : {A, B, Kab, Nb}_Kbs, {Nb}_Kab
cnf(message4_old,axiom,
  (~knows_old(cons(Nb,
          cons(crypt(cons(B,cons(Kab,cons(noncea_old(A),nil))),
              key(sym,cons(A,cons(server,nil)))),
          cons(M,nil))))
  | knows_old(cons(M,
          cons(crypt(Nb,Kab),nil))))).
cnf(intruder_knows_all_agents_old,axiom,
  (~agent(X) | knows_old(X))).
cnf(intruder_knows_every_public_key_old,axiom,
  (knows_old(key(pub,X)))).
cnf(intruder_knows_own_private_key_old,axiom,
  (knows_old(key(prv,i)))).
cnf(define_alice_key_old,axiom,
  (~knows_old(cons(Nb,
          cons(crypt(cons(B,cons(Kab,cons(noncea_old(A),nil))),
              key(sym,cons(A,cons(server,nil)))),
          cons(M,nil))))
  | alice_key_old(A,Kab))).
cnf(define_bob_key_old,axiom,
   (~knows_old(cons(crypt(cons(A,cons(B,cons(Kab,cons(nonceb_old(A,B,Na),nil)))),
                      key(sym,cons(B,cons(server,nil)))),
           cons(crypt(nonceb_old(A,B,Na),Kab),
                nil)))
   | bob_key_old(B,Kab))).
cnf(intruder_remembers,axiom,
   (~knows_old(M) | knows_current(M))).
cnf(intruder_knows_all_previous_session_keys,axiom,
  (knows_current(key(sym,session_old(A,B,Na,Nb))))).
cnf(intruder_knows_all_previous_noncea,axiom,
    (knows_current(noncea_old(A)))).
cnf(intruder_knows_all_previous_nonceb,axiom,
    (knows_current(nonceb_old(A,B,Na)))).
% h1 example: Paulson's corrected version of the Yahalom protocol (2001).
% Copyright (C) 2008 Jean Goubault-Larrecq and LSV, CNRS UMR 8643 & ENS Cachan.
%
% This file is part of h1.
%
% h1 is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% h1 is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with h1; see the file COPYING. If not, write to
% the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
cnf(intruder_knows_nil_current,axiom,
  (knows_current(nil))).
cnf(intruder_can_take_first_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M1))).
cnf(intruder_can_take_second_components_current,axiom,
  (~knows_current(cons(M1,M2)) | knows_current(M2))).
cnf(intruder_can_build_pairs_current,axiom,
  (~knows_current(M2) | ~knows_current(M1) | knows_current(cons(M1,M2)))).
cnf(intruder_can_encrypt_current,axiom,
  (~knows_current(K) | ~knows_current(M) | knows_current(crypt(M,K)))).
cnf(intruder_can_decrypt_if_has_private_key_current,axiom,
  (~knows_current(key(prv,K)) | ~knows_current(crypt(M,key(pub,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_public_key_current,axiom,
  (~knows_current(key(pub,K)) | ~knows_current(crypt(M,key(prv,K))) | knows_current(M))).
cnf(intruder_can_decrypt_if_has_symmetric_key_current,axiom,
  (~knows_current(key(sym,X)) | ~knows_current(crypt(M,key(sym,X))) | knows_current(M))).
cnf(intruder_can_compute_successors_current,axiom,
  (~knows_current(M) | knows_current(s(M)))).
cnf(intruder_can_compute_predecessors_current,axiom,
  (~knows_current(s(M)) | knows_current(M))).
%
% Ajout des clauses du protocole
%
%
 % 1. A -> B : A, Na
cnf(message1_current,axiom,
  (~agent(A)
  | knows_current(cons(A,cons(noncea_current(A),nil))))).
  % 2. B -> S : B, Nb, {A, Na}_{Kbs}
cnf(message2_current,axiom,
  (~knows_current(cons(A,cons(Na,nil)))
  | ~agent(B)
  | knows_current(cons(B,cons(nonceb_current(A,B,Na),
          cons(crypt(cons(A,cons(Na,nil)),
                     key(sym,cons(B,cons(server,nil)))),
               nil)))))).
 % 3. S -> A : Nb, {B, Kab, Na}_Kas, {A, B, Kab, Nb}_Kbs
cnf(message3_current,axiom,
  (~knows_current(cons(B,cons(Nb,
          cons(crypt(cons(A,cons(Na,nil)),
                     key(sym,cons(B,cons(server,nil)))),
               nil))))
  | knows_current(cons(Nb,
          cons(crypt(cons(B,
                     cons(key(sym,session_current(A,B,Na,Nb)),
       cons(Na,nil))),
                     key(sym,cons(A,cons(server,nil)))),
          cons(crypt(cons(A,cons(B,
                     cons(key(sym,session_current(A,B,Na,Nb)),
       cons(Nb,nil)))),
       key(sym,cons(B,cons(server,nil)))),
               nil)))))).
 % 4. A -> B : {A, B, Kab, Nb}_Kbs, {Nb}_Kab
cnf(message4_current,axiom,
  (~knows_current(cons(Nb,
          cons(crypt(cons(B,cons(Kab,cons(noncea_current(A),nil))),
              key(sym,cons(A,cons(server,nil)))),
          cons(M,nil))))
  | knows_current(cons(M,
          cons(crypt(Nb,Kab),nil))))).
cnf(intruder_knows_all_agents_current,axiom,
  (~agent(X) | knows_current(X))).
cnf(intruder_knows_every_public_key_current,axiom,
  (knows_current(key(pub,X)))).
cnf(intruder_knows_own_private_key_current,axiom,
  (knows_current(key(prv,i)))).
cnf(define_alice_key_current,axiom,
  (~knows_current(cons(Nb,
          cons(crypt(cons(B,cons(Kab,cons(noncea_current(A),nil))),
              key(sym,cons(A,cons(server,nil)))),
          cons(M,nil))))
  | alice_key_current(A,Kab))).
cnf(define_bob_key_current,axiom,
   (~knows_current(cons(crypt(cons(A,cons(B,cons(Kab,cons(nonceb_current(A,B,Na),nil)))),
                      key(sym,cons(B,cons(server,nil)))),
           cons(crypt(nonceb_current(A,B,Na),Kab),
                nil)))
   | bob_key_current(B,Kab))).
cnf(intruder_knows_session_key_generated_by_server,axiom,
  (~knows_current(key(sym,session_current(alice,bob,Na,Nb))))).
cnf(intruder_knows_session_key_as_seen_by_alice,axiom,
  (~knows_current(Kab) | ~alice_key_current(alice,Kab))).
cnf(intruder_knows_session_key_as_seen_by_B,axiom,
  (~knows_current(Kab) | ~bob_key_current(bob,Kab))).
